/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal;

import com.ibm.etools.annotations.core.AnnotationsCoreConstants;
import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.JavaElementInfo;
import com.ibm.etools.annotations.core.internal.search.JavaSearchUtils;
import com.ibm.etools.annotations.core.internal.utils.AnnotationAttributePropertyFactory;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.spi.BasePropertyDescriptor;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;

public class AnnotationParser {
    public static final char NAME_SEPARATOR = '#';
    private ArrayList<AnnotationInfo> allAnnotationsInClass = null;
    private List<AnnotationInfo> allImpliedAnnotationsInClass = null;
    private Hashtable<IJavaElement, JavaElementInfo> javaEltpJavaElInfo = new Hashtable();

    @Deprecated
    public AnnotatedClassInfo getAllAnnotationsInClass(IJavaElement cu, int offset) {
        return this.getAnnotatedClassInfo(cu, offset, true);
    }

    public List<AnnotationInfo> getAllImpliedAnnotationsInClass() {
        return this.allImpliedAnnotationsInClass;
    }

    @Deprecated
    public AnnotatedClassInfo getAllAnnotationsInClass(IJavaElement cu, int offset, boolean forceReparse) {
        return this.getAnnotatedClassInfo(cu, offset, forceReparse);
    }

    public AnnotatedClassInfo getAnnotatedClassInfo(IJavaElement cu, int offset, boolean forceReparse) {
        if (this.allAnnotationsInClass == null || forceReparse) {
            this.javaEltpJavaElInfo.clear();
            this.parseAnnotations(cu, offset);
        }
        if (this.allAnnotationsInClass == null || this.allAnnotationsInClass.size() == 0) {
            return null;
        }
        AnnotatedClassInfo re = null;
        try {
            re = new AnnotatedClassInfo(cu);
            this.createJavaElementInfos(cu, re);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        if (re != null) {
            int r = 0;
            while (r < this.allAnnotationsInClass.size()) {
                AnnotationInfo ai = this.allAnnotationsInClass.get(r);
                if (ai != null) {
                    JavaElementInfo jeInfo;
                    IJavaElement jaEls;
                    IAnnotation annotation = ai.getAnnotation();
                    if (annotation != null) {
                        try {
                            ISourceRange isr = annotation.getSourceRange();
                            if (isr != null) {
                                int iStart = isr.getOffset();
                                int length = isr.getLength();
                                if (offset >= iStart && offset <= iStart + length) {
                                    ai.setDefaultInScope(true);
                                } else {
                                    ai.setDefaultInScope(false);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if ((jaEls = InternalUtils.getJavaElementForAnnotation(annotation)) != null && (jeInfo = this.javaEltpJavaElInfo.get(jaEls)) != null) {
                        jeInfo.getAnnotationInfoPG().addProperty((IPropertyDescriptor)ai);
                        ai.setJavaElementInfo(jeInfo);
                    }
                    InternalUtils.applyExternalCustomization(ai);
                }
                ++r;
            }
        }
        IJavaProject project = cu.getJavaProject();
        re.calculateAllImpliedAnnotations(project);
        return re;
    }

    private List<AnnotationInfo> parseAnnotations(IJavaElement je, int offSet) {
        this.allAnnotationsInClass = (ArrayList)this.parseAnnotationOnly(je, offSet);
        return this.allAnnotationsInClass;
    }

    public List<AnnotationInfo> parseAnnotationOnly(IJavaElement je, int offSet) {
        ArrayList<AnnotationInfo> result = new ArrayList<AnnotationInfo>();
        if (je == null) {
            return null;
        }
        Hashtable<String, String> resolvedNames = new Hashtable<String, String>();
        try {
            IJavaElement[] childs = null;
            if (je instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)je;
                childs = unit.getChildren();
            } else if (je instanceof IClassFile) {
                IClassFile unit = (IClassFile)je;
                childs = unit.getChildren();
            }
            if (childs != null && childs.length > 0) {
                this.addAnnotationInfosForJE(result, childs, resolvedNames);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void modifyAnnotation(ICompilationUnit cu, AnnotationInfo newAnnotationInfo) {
        this.modifyAnnotation(cu, newAnnotationInfo, false, false);
    }

    public synchronized void modifyAnnotation(ICompilationUnit cu, AnnotationInfo newAnnotationInfo, boolean commitChanges) {
        this.modifyAnnotation(cu, newAnnotationInfo, commitChanges, false);
    }

    public synchronized void modifyAnnotation(ICompilationUnit cu, AnnotationInfo newAnnotationInfo, boolean commitChanges, boolean performReconcile) {
        if (cu == null) {
            return;
        }
        try {
            IAnnotation annot;
            if (!cu.isConsistent()) {
                cu.makeConsistent(null);
            }
            if ((annot = newAnnotationInfo.getAnnotation()) == null) {
                return;
            }
            int iStart = annot.getSourceRange().getOffset();
            int iLength = annot.getSourceRange().getLength();
            IAnnotationAttributeProperty attribute = InternalUtils.getIncompleteAttribute(newAnnotationInfo);
            String annoString = newAnnotationInfo.annotToString();
            IBuffer buffer = cu.getBuffer();
            if (attribute != null) {
                char ch = buffer.getChar(iStart + iLength);
                while (ch == '=' || ch == ' ') {
                    ch = buffer.getChar(iStart + ++iLength);
                }
                if (annoString.endsWith(")")) {
                    annoString = annoString.substring(0, annoString.length() - 1);
                }
            }
            buffer.replace(iStart, iLength, annoString);
            if (commitChanges) {
                cu.commitWorkingCopy(true, null);
            } else if (performReconcile) {
                cu.reconcile(3, 7, null, null);
            }
            this.parseAnnotations((IJavaElement)cu, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeAnnotation(ICompilationUnit cu, AnnotationInfo newAnnotationInfo, boolean commitChanges) {
        this.removeAnnotation(cu, newAnnotationInfo, commitChanges, false);
    }

    public void removeAnnotation(ICompilationUnit cu, AnnotationInfo newAnnotationInfo, boolean commitChanges, boolean performReconcile) {
        if (cu == null) {
            return;
        }
        try {
            IAnnotation annot;
            if (this.allAnnotationsInClass == null) {
                this.parseAnnotations((IJavaElement)cu, 0);
            }
            if ((annot = newAnnotationInfo.getAnnotation()) == null) {
                return;
            }
            int iStart = annot.getSourceRange().getOffset();
            int iLength = annot.getSourceRange().getLength();
            Document doc = new Document(cu.getSource());
            IRegion rg = doc.getLineInformationOfOffset(annot.getSourceRange().getOffset());
            String resS = doc.get(rg.getOffset(), rg.getLength());
            String resS2 = doc.get(iStart, iLength);
            if (resS.trim().equals(resS2.trim())) {
                int lineOff = doc.getLineOfOffset(rg.getOffset());
                int nextLineOffset = doc.getLineOffset(lineOff + 1);
                cu.getBuffer().replace(rg.getOffset(), nextLineOffset - rg.getOffset(), "");
            } else {
                cu.getBuffer().replace(iStart, iLength, "");
            }
            if (commitChanges) {
                cu.commitWorkingCopy(true, null);
            } else if (performReconcile) {
                cu.reconcile(3, 7, null, null);
            }
            this.parseAnnotations((IJavaElement)cu, 0);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Deprecated
    public static List<IAnnotationAttributeProperty> getListOfDeclaredAttributeInfos(AnnotationInfo parent, IAnnotation ann, IType defType, IType resolvedType) {
        return AnnotationParser.getListOfDeclaredAttributeInfos(parent, ann, defType, resolvedType, null);
    }

    @Deprecated
    public static List<IAnnotationAttributeProperty> getListOfAllAttributeInfos(AnnotationInfo parent, IAnnotation ann, IType defType, IType resolvedType) {
        return AnnotationParser.getListOfAllAttributeInfos(parent, ann, defType, resolvedType, null);
    }

    public static List<IAnnotationAttributeProperty> getListOfDeclaredAttributeInfos(AnnotationInfo parent, IAnnotation ann, IType defType, IType resolvedType, Hashtable<String, String> resolvedNames) {
        ArrayList<IAnnotationAttributeProperty> result;
        block4: {
            result = new ArrayList<IAnnotationAttributeProperty>();
            try {
                IMemberValuePair[] members = ann.getMemberValuePairs();
                int g = 0;
                while (g < members.length) {
                    IAnnotationAttributeProperty ai = null;
                    ai = AnnotationAttributePropertyFactory.getAnnotationAttributeProperty(parent, members[g], defType, resolvedType, resolvedNames);
                    if (ai != null) {
                        result.add(ai);
                    }
                    ++g;
                }
            }
            catch (JavaModelException e) {
                IStatus stat = e.getStatus();
                if (!(stat instanceof IJavaModelStatus) || ((IJavaModelStatus)stat).getCode() == 969) break block4;
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IAnnotationAttributeProperty> getListOfAllAttributeInfos(AnnotationInfo parent, IAnnotation ann, IType defType, IType resolvedType, Hashtable<String, String> resolvedNames) {
        ArrayList<IAnnotationAttributeProperty> result = new ArrayList<IAnnotationAttributeProperty>();
        IAnnotation iAnnotation = ann;
        synchronized (iAnnotation) {
            try {
                IMethod[] members = defType.getMethods();
                int g = 0;
                while (g < members.length) {
                    IAnnotationAttributeProperty ai = null;
                    ai = AnnotationAttributePropertyFactory.getAnnotationAttributeProperty(parent, members[g], resolvedType, resolvedNames);
                    if (ai != null) {
                        result.add(ai);
                    }
                    ++g;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static AnnotationInfo getAnnotationInfo(IAnnotation ann, int offset) {
        AnnotationInfo anI = null;
        try {
            IPackageFragment ipf;
            IJavaElement jEl = ann.getParent();
            IType primType = InternalUtils.getPrimaryType(jEl);
            String sFullName = ann.getElementName();
            IType defType = null;
            String sPack = null;
            String sAnnName = null;
            String[] fullName = JavaSearchUtils.getInstance().resolveJavaElementName(ann.getElementName(), (IJavaElement)primType, AnnotationsCoreConstants.getBuildInAnnotations());
            if (fullName != null) {
                sPack = fullName[0];
                sAnnName = fullName[1];
                sFullName = new StringBuffer(fullName[0]).append(".").append(fullName[1]).toString();
            } else {
                sAnnName = sFullName;
            }
            if (sAnnName == null && sFullName != null) {
                sAnnName = sFullName;
            }
            if (sFullName != null) {
                defType = JavaSearchUtils.getInstance().findTypeDeclaration(sFullName, ann.getJavaProject(), true, null);
            }
            if ((sPack == null || sPack.isEmpty()) && defType != null && (ipf = defType.getPackageFragment()) != null) {
                sPack = ipf.getElementName();
            }
            anI = new AnnotationInfo(sAnnName, offset, ann);
            anI.setCategorizationKey(sPack);
            anI.setPackageName(sPack);
            AnnotationParser.buildAnnotationAttributes(anI, defType, primType, new Hashtable<String, String>(6));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return anI;
    }

    public AnnotationInfo buildAnnotationInfo(IAnnotation ann, int offset, Hashtable<String, String> resolvedNames) {
        AnnotationInfo anI = null;
        try {
            IPackageFragment ipf;
            IJavaElement jEl = ann.getParent();
            IType primType = InternalUtils.getPrimaryType(jEl);
            String sFullName = ann.getElementName();
            String sPack = null;
            String sAnnName = null;
            String name = null;
            if (resolvedNames != null) {
                name = resolvedNames.get(sFullName);
            }
            if (name != null) {
                int index = name.lastIndexOf(35);
                if (index != -1) {
                    sPack = name.substring(0, index);
                    sAnnName = name.substring(index + 1);
                    sFullName = new StringBuffer(sPack).append(".").append(sAnnName).toString();
                } else {
                    sAnnName = sFullName = name;
                }
            } else {
                String resolvedName;
                IJavaElement annParent = ann.getParent();
                String[] fullName = null;
                if (primType != null) {
                    fullName = JavaSearchUtils.getInstance().resolveJavaElementName(ann.getElementName(), (IJavaElement)primType, AnnotationsCoreConstants.getBuildInAnnotations());
                } else if (InternalUtils.isPackageInfoJava(annParent)) {
                    fullName = JavaSearchUtils.getInstance().resolveJavaElementName(ann.getElementName(), annParent, AnnotationsCoreConstants.getBuildInAnnotations());
                }
                if (fullName != null) {
                    sPack = fullName[0];
                    sAnnName = fullName[1];
                    resolvedName = new StringBuffer(fullName[0]).append('#').append(fullName[1]).toString();
                    sFullName = new StringBuffer(fullName[0]).append(".").append(fullName[1]).toString();
                } else {
                    resolvedName = sAnnName = sFullName;
                }
                if (resolvedNames != null) {
                    resolvedNames.put(ann.getElementName(), resolvedName);
                }
            }
            IType defType = null;
            if (sFullName != null) {
                defType = JavaSearchUtils.getInstance().findTypeDeclaration(sFullName, ann.getJavaProject(), true, null);
            }
            if ((sPack == null || sPack.isEmpty()) && defType != null && (ipf = defType.getPackageFragment()) != null) {
                sPack = ipf.getElementName();
            }
            anI = new AnnotationInfo(sAnnName, offset, ann);
            anI.setCategorizationKey(sPack);
            anI.setPackageName(sPack);
            AnnotationParser.buildAnnotationAttributes(anI, defType, primType, resolvedNames);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return anI;
    }

    public static void buildAnnotationAttributes(AnnotationInfo anI, IType defType, IType primType, Hashtable<String, String> resolvedNames) {
        IAnnotation ann = anI.getAnnotation();
        List<IAnnotationAttributeProperty> decList = AnnotationParser.getListOfDeclaredAttributeInfos(anI, ann, defType, primType, resolvedNames);
        anI.setDeclaredAttributes(decList);
        if (defType != null) {
            List<IAnnotationAttributeProperty> allList = AnnotationParser.getListOfAllAttributeInfos(anI, ann, defType, primType, resolvedNames);
            List<IAnnotationAttributeProperty> newAllList = AnnotationParser.purgeList(allList, decList);
            anI.setAllAttributes(newAllList);
        } else {
            anI.setAllAttributes(decList);
        }
        IAnnotationAttributeProperty attribute = InternalUtils.getIncompleteAttribute(anI);
        if (attribute != null) {
            List<IAnnotationAttributeProperty> attributes = anI.getAllAttributes();
            int i = 0;
            while (i < attributes.size()) {
                IAnnotationAttributeProperty attri = attributes.get(i);
                if (decList.indexOf(attri) == -1 && attri != attribute && attri instanceof BasePropertyDescriptor) {
                    ((BasePropertyDescriptor)attri).setEnabled(false);
                }
                ++i;
            }
        }
    }

    @Deprecated
    public void addAnnotationToCU(ICompilationUnit cu, AnnotationInfo info, IJavaElement el) {
        this.addAnnotationToCU(cu, info, el, false, false);
    }

    public void addAnnotationToCU(ICompilationUnit cu, AnnotationInfo info, IJavaElement el, boolean commitChanges, boolean performReconcile) {
        this.allAnnotationsInClass = null;
        if (cu == null || info == null || el == null) {
            return;
        }
        InternalUtils.addAnnotationToCU(cu, info.getName(), info.getPackageName(), info.annotToString(), el, commitChanges, performReconcile);
    }

    protected static List<IAnnotationAttributeProperty> purgeList(List<IAnnotationAttributeProperty> allAttrList, List<IAnnotationAttributeProperty> declaredAttrList) {
        String name;
        IAnnotationAttributeProperty ip;
        if (declaredAttrList == null || allAttrList == null) {
            return allAttrList;
        }
        ArrayList<IAnnotationAttributeProperty> res = new ArrayList<IAnnotationAttributeProperty>();
        Hashtable<String, IAnnotationAttributeProperty> hash = new Hashtable<String, IAnnotationAttributeProperty>();
        int i = 0;
        while (i < declaredAttrList.size()) {
            ip = declaredAttrList.get(i);
            name = ip.getName();
            hash.put(name, ip);
            ++i;
        }
        int j = 0;
        while (j < allAttrList.size()) {
            ip = allAttrList.get(j);
            name = ip.getName();
            IAnnotationAttributeProperty setIp = (IAnnotationAttributeProperty)hash.get(name);
            if (setIp != null) {
                res.add(setIp);
            } else {
                res.add(ip);
            }
            ++j;
        }
        return res;
    }

    private void createJavaElementInfos(IJavaElement cu, AnnotatedClassInfo aci) {
        if (cu != null) {
            try {
                IType[] types = null;
                IPackageDeclaration[] packageDecls = null;
                if (cu instanceof ICompilationUnit) {
                    types = ((ICompilationUnit)cu).getTypes();
                    packageDecls = ((ICompilationUnit)cu).getPackageDeclarations();
                } else if (cu instanceof IClassFile) {
                    types = new IType[]{((IClassFile)cu).getType()};
                }
                if (packageDecls != null) {
                    int t = 0;
                    while (t < packageDecls.length) {
                        IPackageDeclaration ipd = packageDecls[t];
                        try {
                            JavaElementInfo childNode = new JavaElementInfo((IJavaElement)ipd, aci.getJavaElementInfoPG());
                            childNode.setParentJavaElementInfo(aci);
                            this.javaEltpJavaElInfo.put((IJavaElement)ipd, childNode);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++t;
                    }
                }
                if (types != null) {
                    int i = 0;
                    while (i < types.length) {
                        JavaElementInfo jInf = this.createJavaElementInfos((IJavaElement)types[i], aci.getJavaElementInfoPG());
                        jInf.setParentJavaElementInfo(aci);
                        ++i;
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    private JavaElementInfo createJavaElementInfos(IJavaElement je, BasePropertyGroup bpg) {
        JavaElementInfo node = null;
        try {
            node = new JavaElementInfo(je, bpg);
            this.javaEltpJavaElInfo.put(je, node);
            if (je instanceof IMember) {
                if (je instanceof IMethod) {
                    ILocalVariable[] vars;
                    ILocalVariable[] iLocalVariableArray = vars = ((IMethod)je).getParameters();
                    int n = vars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILocalVariable var = iLocalVariableArray[n2];
                        JavaElementInfo childNode = this.createJavaElementInfos((IJavaElement)var, node.getJavaElementInfoPG());
                        if (childNode != null) {
                            childNode.setParentJavaElementInfo(node);
                        }
                        ++n2;
                    }
                } else {
                    IJavaElement[] children = ((IMember)je).getChildren();
                    if (children != null) {
                        IJavaElement[] iJavaElementArray = children;
                        int n = children.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IJavaElement child = iJavaElementArray[n3];
                            JavaElementInfo childNode = this.createJavaElementInfos(child, node.getJavaElementInfoPG());
                            if (childNode != null) {
                                childNode.setParentJavaElementInfo(node);
                            }
                            ++n3;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {}
        return node;
    }

    private void addAnnotationInfos(List<AnnotationInfo> infos, IAnnotatable an, Hashtable<String, String> resolvedJavaElements) {
        try {
            IAnnotation[] anns = an.getAnnotations();
            int i = 0;
            while (i < anns.length) {
                AnnotationInfo inf = this.buildAnnotationInfo(anns[i], 0, resolvedJavaElements);
                if (inf != null) {
                    infos.add(inf);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addAnnotationInfosForJE(List<AnnotationInfo> infos, IJavaElement[] meths, Hashtable<String, String> resolvedJavaElements) {
        try {
            int i = 0;
            while (i < meths.length) {
                IJavaElement[] children;
                IJavaElement meth = meths[i];
                if (meth instanceof IAnnotatable) {
                    this.addAnnotationInfos(infos, (IAnnotatable)meth, resolvedJavaElements);
                    if (meth instanceof IMethod) {
                        ILocalVariable[] vars = ((IMethod)meth).getParameters();
                        this.addAnnotationInfosForJE(infos, (IJavaElement[])vars, resolvedJavaElements);
                    }
                }
                if (meth instanceof IMember && (children = ((IMember)meth).getChildren()) != null && children.length > 0) {
                    this.addAnnotationInfosForJE(infos, children, resolvedJavaElements);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

