/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal;

import com.ibm.etools.annotations.core.api.AnnotationAttributeValueRetriever;
import com.ibm.etools.annotations.core.data.ImportsForAttributeValue;
import com.ibm.etools.annotations.core.internal.AnnotationAttributesElem;
import com.ibm.etools.annotations.core.internal.AnnotationConfigElem;
import com.ibm.etools.annotations.core.utils.AnnotationConstants;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;

public class AnnotationConfigInfo {
    private static AnnotationConfigInfo annoInfo_;
    private static ArrayList<AnnotationConfigElem> annoConfigurations_;
    private static Hashtable<String, ArrayList<AnnotationAttributesElem>> annoAttributesConfigurations_;
    private static ArrayList<String> scopeLists_;
    private ArrayList annoAttributes_;
    private static Hashtable<String, Object> annoTagClass_;
    private static Hashtable<String, Object> annoClassObjects_;

    public static AnnotationConfigInfo instance() {
        if (annoInfo_ == null) {
            annoInfo_ = new AnnotationConfigInfo();
            annoConfigurations_ = null;
        }
        return annoInfo_;
    }

    public void dumpAnnotationConfigElem(IConfigurationElement elm) {
        AnnotationConstants.debug(elm.getAttribute("tag"));
        AnnotationConstants.debug(elm.getAttribute("description"));
        AnnotationConstants.debug(elm.getAttribute("icon"));
        AnnotationConstants.debug(elm.getAttribute("category"));
    }

    public void dumpAnnotationConfigInfo(IConfigurationElement[] list) {
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            this.dumpAnnotationConfigElem(list[i]);
            ++i;
        }
    }

    private ArrayList getOnceOnlyAnnotationConfigFromExtensionPointInfo(ICompilationUnit cu, int offset) {
        annoAttributesConfigurations_ = new Hashtable();
        annoConfigurations_ = new ArrayList();
        annoTagClass_ = new Hashtable();
        annoClassObjects_ = new Hashtable();
        IConfigurationElement[] annoConfigExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.etools.annotations.ui.AnnotationConfigInfo");
        int i = 0;
        while (i < annoConfigExtensionPoints.length) {
            if ("annotation".equals(annoConfigExtensionPoints[i].getName())) {
                String aTag = annoConfigExtensionPoints[i].getAttribute("tag");
                String aDesc = annoConfigExtensionPoints[i].getAttribute("description");
                String aIcon = annoConfigExtensionPoints[i].getAttribute("icon");
                String aCat = annoConfigExtensionPoints[i].getAttribute("category");
                String aPackage = annoConfigExtensionPoints[i].getAttribute("package");
                if (annoConfigExtensionPoints[i].getChildren() != null) {
                    scopeLists_ = this.getAnnotationsScope(annoConfigExtensionPoints[i]);
                }
                AnnotationConfigElem elem = new AnnotationConfigElem(aCat, aTag, aIcon, aDesc, aPackage);
                if (scopeLists_ != null && scopeLists_.size() > 0) {
                    elem.setScopeList(scopeLists_);
                }
                String tagKey = elem.getTagKey();
                Object classObj = null;
                String aClassName = annoConfigExtensionPoints[i].getAttribute("className");
                if (aClassName != null && aClassName.length() > 0) {
                    try {
                        classObj = annoConfigExtensionPoints[i].createExecutableExtension("className");
                        annoTagClass_.put(tagKey, classObj);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    if (classObj != null) {
                        annoClassObjects_.put(aClassName, classObj);
                    }
                    if (annoConfigExtensionPoints[i].getChildren() != null) {
                        this.annoAttributes_ = AnnotationConfigInfo.getDefaultAttributes(classObj, aClassName, annoConfigExtensionPoints[i]);
                        if (this.annoAttributes_.size() > 0) {
                            annoAttributesConfigurations_.put(tagKey, this.annoAttributes_);
                            elem.setAnnoAttributes(this.annoAttributes_);
                            elem.setHasDefault(true);
                        }
                    }
                }
                annoConfigurations_.add(elem);
            }
            ++i;
        }
        return annoConfigurations_;
    }

    public static ArrayList getDefaultAttributes(Object classObj, String className, IConfigurationElement attributeNodes) {
        if (attributeNodes.getChildren() != null) {
            IConfigurationElement[] attributeElms = attributeNodes.getChildren("attributes");
            IConfigurationElement[] annoAttrs = attributeElms[0].getChildren();
            ArrayList<AnnotationAttributesElem> annoAttributes = new ArrayList<AnnotationAttributesElem>();
            if (annoAttrs != null && annoAttrs.length > 0) {
                int i = 0;
                while (i < annoAttrs.length) {
                    String aName = annoAttrs[i].getAttribute("name");
                    if (aName != null) {
                        AnnotationAttributesElem aAttr = new AnnotationAttributesElem(aName);
                        annoAttributes.add(aAttr);
                    }
                    ++i;
                }
            }
            AnnotationConstants.debug("annoAttributes=" + annoAttributes.size());
            return annoAttributes;
        }
        return new ArrayList();
    }

    private ArrayList getAnnotationsScope(IConfigurationElement annoScopeNodes) {
        IConfigurationElement[] scopeElms;
        ArrayList<String> scopes = new ArrayList<String>();
        if (annoScopeNodes.getChildren() != null && (scopeElms = annoScopeNodes.getChildren("scope")) != null && scopeElms.length > 0) {
            int i = 0;
            while (i < scopeElms.length) {
                String aName = scopeElms[i].getAttribute("name");
                if (aName != null) {
                    if (aName.equals("ALL")) {
                        scopes.add("CLASS");
                        scopes.add("FIELD");
                        scopes.add("METHOD");
                        scopes.add("INTERFACE");
                    } else {
                        scopes.add(aName.toUpperCase());
                    }
                }
                ++i;
            }
        }
        return scopes;
    }

    public ArrayList getAnnotationConfigFromExtensionPointInfo(ICompilationUnit cu, int offset) {
        if (annoConfigurations_ == null || annoConfigurations_.size() == 0) {
            annoConfigurations_ = this.getOnceOnlyAnnotationConfigFromExtensionPointInfo(cu, offset);
        }
        int k = 0;
        while (k < annoConfigurations_.size()) {
            AnnotationConfigElem confElem = annoConfigurations_.get(k);
            String tagKey = confElem.getTagKey();
            if (!annoTagClass_.isEmpty()) {
                Object classObj = annoTagClass_.get(tagKey);
                this.annoAttributes_ = annoAttributesConfigurations_.get(tagKey);
                if (classObj != null) {
                    this.annoAttributes_ = this.getDefaultValuesFromClass(classObj, tagKey, this.annoAttributes_, cu, offset);
                    if (this.annoAttributes_ != null && !this.annoAttributes_.isEmpty()) {
                        annoAttributesConfigurations_.put(tagKey, this.annoAttributes_);
                        confElem.setAnnotationAttributes(this.annoAttributes_);
                        confElem.setHasDefault(true);
                        boolean excludeAnno = ((AnnotationAttributeValueRetriever)classObj).shouldExclude(cu);
                        confElem.setExcluded(excludeAnno);
                    }
                }
            } else {
                confElem.setHasDefault(false);
            }
            ++k;
        }
        return annoConfigurations_;
    }

    public ArrayList<AnnotationConfigElem> getAnnotationConfigFromExtensionPointInfo() {
        if (annoConfigurations_ == null || annoConfigurations_.size() == 0) {
            annoConfigurations_ = this.getOnceOnlyAnnotationConfigFromExtensionPointInfo(null, 0);
        }
        return annoConfigurations_;
    }

    public ArrayList getDefaultValuesFromClass(Object classObj, String tagKey, ArrayList annoList, ICompilationUnit cu, int offset) {
        if (annoList != null && annoList.size() > 0) {
            ArrayList<AnnotationAttributesElem> annoAttributes = new ArrayList<AnnotationAttributesElem>();
            int i = 0;
            while (i < annoList.size()) {
                AnnotationAttributesElem annoElm = (AnnotationAttributesElem)annoList.get(i);
                String aName = annoElm.getAttrName();
                Object aDefVal = ((AnnotationAttributeValueRetriever)classObj).getAttributeValue(tagKey, aName, cu, offset);
                if (aDefVal != null) {
                    if (aDefVal instanceof ImportsForAttributeValue) {
                        annoElm.setDefaultValueAsString(((ImportsForAttributeValue)aDefVal).getAttributeValues());
                        annoElm.setImports_(((ImportsForAttributeValue)aDefVal).getImportStatement());
                        annoAttributes.add(annoElm);
                    } else {
                        annoElm.setDefaultValueAsString(aDefVal);
                        annoAttributes.add(annoElm);
                    }
                }
                ++i;
            }
            return annoAttributes;
        }
        return null;
    }

    public int getAnnotationNo() {
        return annoConfigurations_.size();
    }
}

