/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal;

import com.ibm.etools.annotations.core.api.AnnotationOverrideHandler;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.AnnotationOverrideInfo;
import com.ibm.etools.annotations.core.utils.AnnotationConstants;
import com.ibm.etools.annotations.core.utils.AnnotationOverrideHelper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;

public class AnnotationConfigDDOverrideInfo {
    private static AnnotationConfigDDOverrideInfo ddInfo_ = null;
    private static String overrideID_;
    private static Hashtable<String, String> pkgDDId_;
    private static Hashtable<String, String> annoDDId_;
    private static Hashtable<String, Object> annoDDTagClass_;
    private static Hashtable<String, Object> annoDDClassObjects_;
    private static Hashtable<String, String> annoDDDesc_;
    private static Hashtable<String, Boolean> annoDDHover_;
    private static Hashtable<String, String> annoOverrideFiles_;

    public static AnnotationConfigDDOverrideInfo instance() {
        if (ddInfo_ == null) {
            ddInfo_ = new AnnotationConfigDDOverrideInfo();
        }
        AnnotationConstants.debug("instance :AnnotationConfigDDOverrideInfo()" + ddInfo_);
        return ddInfo_;
    }

    public AnnotationConfigDDOverrideInfo() {
        AnnotationConstants.debug("constructor: AnnotationConfigDDOverrideInfo()");
        annoDDTagClass_ = new Hashtable();
        annoDDClassObjects_ = new Hashtable();
        annoDDDesc_ = new Hashtable();
        annoDDId_ = new Hashtable();
        annoOverrideFiles_ = new Hashtable();
        pkgDDId_ = new Hashtable();
        annoDDHover_ = new Hashtable();
        this.loadExtensionData();
    }

    /*
     * Unable to fully structure code
     */
    private void loadExtensionData() {
        annoConfigExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.j2c.codegen.AnnotationOverrideHandler");
        AnnotationConstants.debug("get Only once...configlength=" + annoConfigExtensionPoints.length);
        i = 0;
        while (i < annoConfigExtensionPoints.length) {
            block10: {
                AnnotationConstants.debug("i:" + i + ":" + annoConfigExtensionPoints[i].getName());
                if (!"overrideAnnotations".equals(annoConfigExtensionPoints[i].getName()) || (AnnotationConfigDDOverrideInfo.overrideID_ = annoConfigExtensionPoints[i].getAttribute("overrideIndicatorId")) == null) break block10;
                aDesc = annoConfigExtensionPoints[i].getAttribute("description");
                enableHoverText = annoConfigExtensionPoints[i].getAttribute("enableHover");
                AnnotationConstants.debug("overrideID=" + AnnotationConfigDDOverrideInfo.overrideID_ + "aDesc=" + aDesc + ":" + enableHoverText);
                AnnotationConfigDDOverrideInfo.annoDDDesc_.put(AnnotationConfigDDOverrideInfo.overrideID_, aDesc);
                if (enableHoverText != null && enableHoverText.equalsIgnoreCase("true")) {
                    AnnotationConfigDDOverrideInfo.annoDDHover_.put(AnnotationConfigDDOverrideInfo.overrideID_, true);
                    AnnotationConstants.debug(String.valueOf(AnnotationConfigDDOverrideInfo.overrideID_) + ":true");
                } else {
                    AnnotationConfigDDOverrideInfo.annoDDHover_.put(AnnotationConfigDDOverrideInfo.overrideID_, false);
                    AnnotationConstants.debug(String.valueOf(AnnotationConfigDDOverrideInfo.overrideID_) + ":false");
                }
                classObj = null;
                aClassName = annoConfigExtensionPoints[i].getAttribute("className");
                try {
                    classObj = annoConfigExtensionPoints[i].createExecutableExtension("className");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (classObj != null) {
                    AnnotationConfigDDOverrideInfo.annoDDClassObjects_.put(aClassName, classObj);
                    AnnotationConfigDDOverrideInfo.annoDDTagClass_.put(AnnotationConfigDDOverrideInfo.overrideID_, classObj);
                }
                if ((tagInfo = annoConfigExtensionPoints[i].getChildren("tag")) == null) break block10;
                k = 0;
                while (k < tagInfo.length) {
                    block12: {
                        block11: {
                            aTagList = new ArrayList<String>();
                            aTag = tagInfo[k].getAttribute("name");
                            aPackage = tagInfo[k].getAttribute("package");
                            AnnotationConstants.debug("package=" + aPackage + " aTag=" + aTag);
                            if (aTag != null) break block11;
                            AnnotationConfigDDOverrideInfo.pkgDDId_.put(aPackage, AnnotationConfigDDOverrideInfo.overrideID_);
                            break block12;
                        }
                        index = aTag.indexOf(",");
                        if (index != -1) ** GOTO lbl54
                        aTagList.add(aTag);
                        break block12;
lbl-1000:
                        // 1 sources

                        {
                            firstTag = aTag.substring(0, index);
                            aTagList.add(firstTag);
                            aTag = aTag.substring(index + 1);
                            index = aTag.indexOf(",");
lbl54:
                            // 2 sources

                            ** while (index != -1)
                        }
lbl55:
                        // 1 sources

                        AnnotationConstants.debug(String.valueOf(index) + ":" + aTag);
                        aTagList.add(aTag);
                    }
                    k1 = 0;
                    while (k1 < aTagList.size()) {
                        aKey = new StringBuffer(aPackage);
                        aKey.append(".");
                        aKey.append((String)aTagList.get(k1));
                        tagKey = aKey.toString();
                        AnnotationConstants.debug("tagName=" + tagKey + "  description=" + aDesc + " overrideID=" + AnnotationConfigDDOverrideInfo.overrideID_);
                        if (aDesc != null && aDesc.length() > 0) {
                            AnnotationConfigDDOverrideInfo.annoDDId_.put(tagKey, AnnotationConfigDDOverrideInfo.overrideID_);
                        }
                        ++k1;
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    public boolean enableHover(String overrideId) {
        try {
            if (overrideId != null && annoDDHover_ != null) {
                return annoDDHover_.get(overrideId);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return false;
    }

    protected String getOverrideIndicatorID(IProject project, String tagKey) {
        if (tagKey != null && annoDDId_ != null) {
            return annoDDId_.get(tagKey);
        }
        return null;
    }

    protected String getOverrideIndicatorIDFromPK(IProject project, String pkgName) {
        return annoDDId_.get(pkgName);
    }

    public String getSourceOverride(String annotationName, IProject project) {
        try {
            String OvId = this.getOverrideIndicatorID(project, annotationName);
            if (OvId != null) {
                return annoOverrideFiles_.get(OvId);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return null;
    }

    public String getSourceOverride(String overrideId) {
        try {
            if (overrideId != null) {
                return annoOverrideFiles_.get(overrideId);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return null;
    }

    public String hasRegisterOverrideId(String pkName, String tagName) {
        AnnotationConstants.debug("hasRegisterOverrideId:pkName=" + pkName + ":annoname=" + tagName);
        String OvId1 = null;
        if (pkName != null) {
            OvId1 = pkgDDId_.get(pkName);
            AnnotationConstants.debug("hasRegisterOverrideId:override=" + OvId1);
            if (OvId1 == null) {
                String tagKey = AnnotationOverrideHelper.getFullyQualifiedTag(pkName, tagName);
                AnnotationConstants.debug("hasRegisterOverrideId:fully qualified tagKey=" + tagKey);
                OvId1 = annoDDId_.get(tagKey);
            }
        } else {
            if (tagName == null) {
                return null;
            }
            Enumeration<String> enumTag = annoDDId_.keys();
            while (enumTag.hasMoreElements()) {
                String fTag = enumTag.nextElement();
                AnnotationConstants.debug("tagName=" + tagName + "<?>:" + fTag);
                if (!fTag.contains(tagName)) continue;
                OvId1 = annoDDId_.get(fTag);
            }
            if (OvId1 == null) {
                Enumeration<String> enumPKG = pkgDDId_.keys();
                while (enumPKG.hasMoreElements()) {
                    String fPKG = enumPKG.nextElement();
                    if (!tagName.contains(fPKG)) continue;
                    OvId1 = pkgDDId_.get(fPKG);
                }
            }
        }
        AnnotationConstants.debug("found override=" + OvId1);
        return OvId1;
    }

    private Object getAnnoTagClass(String pkName, String tagName, IProject project) {
        try {
            String OvId1 = this.hasRegisterOverrideId(pkName, tagName);
            if (OvId1 != null) {
                return annoDDTagClass_.get(OvId1);
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public AnnotationOverrideInfo getOverrideValues(String pkName, String tagName, IProject project, String currentFileName, AnnotationInfo aInfo, int offset) {
        String OvId1;
        block8: {
            AnnotationConstants.debug("getOverrideValues pkName=" + pkName + " file=" + currentFileName + " tag=" + tagName + " offset=" + offset);
            OvId1 = this.hasRegisterOverrideId(pkName, tagName);
            if (OvId1 != null) break block8;
            return null;
        }
        try {
            Object classObj = this.getAnnoTagClass(pkName, tagName, project);
            AnnotationConstants.debug("classObj=" + classObj);
            if (classObj != null) {
                String tagKey = AnnotationOverrideHelper.getFullyQualifiedTag(pkName, tagName);
                if (tagKey != null) {
                    AnnotationOverrideInfo OverrideVals = ((AnnotationOverrideHandler)classObj).getOverrideValues(tagKey, project, currentFileName, aInfo, offset);
                    if (OverrideVals != null) {
                        String sourceOverrideFile = OverrideVals.getSourceOverride();
                        AnnotationConstants.debug(String.valueOf(OvId1) + ":file=" + sourceOverrideFile);
                        if (sourceOverrideFile != null) {
                            annoOverrideFiles_.put(OvId1, sourceOverrideFile);
                        }
                    }
                    return OverrideVals;
                }
            } else {
                AnnotationConstants.debug(String.valueOf(tagName) + ":Tag not registered in extensionPoint");
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return null;
    }

    public String getDescription(String pkName, String tagName, IProject project) {
        String OvId1;
        block5: {
            block4: {
                try {
                    OvId1 = this.hasRegisterOverrideId(pkName, tagName);
                    if (OvId1 != null) break block4;
                    return null;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    return null;
                }
            }
            if (annoDDDesc_ != null && !annoDDDesc_.isEmpty()) break block5;
            return null;
        }
        return annoDDDesc_.get(OvId1);
    }

    public String getOverrideValue(String pkName, String tagName, String attributeName, IProject project, String fileName, AnnotationInfo anoInfo, int offset) {
        AnnotationConstants.debug("getOverrideValue=" + pkName + ":" + tagName + ":" + attributeName);
        if ((tagName.equals("Stateless") || tagName.equals("MessageDriven") || tagName.equals("Stateful")) && attributeName.equals("name")) {
            return null;
        }
        AnnotationOverrideInfo overrideInfo = this.getOverrideValues(pkName, tagName, project, fileName, null, offset);
        if (overrideInfo == null) {
            return null;
        }
        String overrideVals = AnnotationOverrideHelper.getOverrideValue(overrideInfo, attributeName);
        return overrideVals;
    }
}

