/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal;

import com.ibm.etools.annotations.core.api.AnnotationAttributeValueRetriever;
import com.ibm.etools.annotations.core.api.ImpliedAnnotationAttributeValueRetriever;
import com.ibm.etools.annotations.core.internal.AnnotationAttributesElem;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.utils.AnnotationConstants;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;

public class AnnotationConfigAttributesInfo {
    private static AnnotationConfigAttributesInfo annoInfo_;
    private static Hashtable annoImpliedAttributesConfigurations_;
    private static ArrayList annoImpliedAttributes_;
    private static Hashtable<String, Object> annoImpliedTagClass_;
    private static Hashtable annoImpliedClassObjects_;

    public void dumpAnnotationConfigElem(IConfigurationElement elm) {
        try {
            AnnotationConstants.debug(elm.getAttribute("tag"));
            AnnotationConstants.debug(elm.getAttribute("package"));
        }
        catch (Exception exception) {}
    }

    public AnnotationConfigAttributesInfo instance() {
        if (annoInfo_ == null) {
            annoInfo_ = new AnnotationConfigAttributesInfo();
        } else {
            annoImpliedAttributes_ = null;
        }
        return annoInfo_;
    }

    public void dumpAnnotationConfigInfo(IConfigurationElement[] list) {
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            this.dumpAnnotationConfigElem(list[i]);
            ++i;
        }
    }

    private Hashtable getOnceOnlyImpliedAnnotationConfigFromExtensionPointInfo(String tagName) {
        annoImpliedAttributesConfigurations_ = new Hashtable();
        annoImpliedTagClass_ = new Hashtable();
        annoImpliedClassObjects_ = new Hashtable();
        IConfigurationElement[] annoConfigExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.j2c.codegen.AnnotationImpliedConfigAttributesInfo");
        int i = 0;
        while (i < annoConfigExtensionPoints.length) {
            if ("annotation".equals(annoConfigExtensionPoints[i].getName())) {
                String aTag = annoConfigExtensionPoints[i].getAttribute("tag");
                String aPackage = annoConfigExtensionPoints[i].getAttribute("package");
                StringBuffer aKey = new StringBuffer(aPackage);
                aKey.append(".");
                aKey.append(aTag);
                String tagKey = aKey.toString();
                AnnotationConstants.debug("tagName=" + tagKey);
                Object classObj = null;
                String aClassName = annoConfigExtensionPoints[i].getAttribute("className");
                if (aClassName != null && aClassName.length() > 0) {
                    try {
                        classObj = annoConfigExtensionPoints[i].createExecutableExtension("className");
                        if (classObj != null && tagKey != null && tagKey.length() > 0) {
                            annoImpliedTagClass_.put(tagKey, classObj);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    if (classObj != null) {
                        annoImpliedClassObjects_.put(aClassName, classObj);
                    }
                    if (annoConfigExtensionPoints[i].getChildren() != null && (annoImpliedAttributes_ = AnnotationConfigAttributesInfo.getDefaultAttributes(classObj, aClassName, annoConfigExtensionPoints[i])).size() > 0) {
                        annoImpliedAttributesConfigurations_.put(tagKey, annoImpliedAttributes_);
                    }
                }
            }
            ++i;
        }
        return annoImpliedAttributesConfigurations_;
    }

    public ArrayList getDefaultValuesFromClass(Object classObj, String tagKey, ArrayList annoList, ICompilationUnit cu, IJavaElement jcontext, int offset) {
        if (annoList != null && annoList.size() > 0) {
            ArrayList<AnnotationAttributesElem> annoAttributes = new ArrayList<AnnotationAttributesElem>();
            int i = 0;
            while (i < annoList.size()) {
                AnnotationAttributesElem annoElm = (AnnotationAttributesElem)annoList.get(i);
                String aName = annoElm.getAttrName();
                Object aDefVal = ((AnnotationAttributeValueRetriever)classObj).getAttributeValue(tagKey, aName, cu, offset);
                if (aDefVal != null) {
                    annoElm.setDefaultValueAsString(aDefVal);
                    annoAttributes.add(annoElm);
                }
                ++i;
            }
            return annoAttributes;
        }
        return null;
    }

    public static ArrayList getDefaultAttributes(Object classObj, String className, IConfigurationElement attributeNodes) {
        if (attributeNodes.getChildren() != null) {
            IConfigurationElement[] attributeElms = attributeNodes.getChildren("attributes");
            IConfigurationElement[] annoAttrs = attributeElms[0].getChildren();
            ArrayList<AnnotationAttributesElem> annoAttributes = new ArrayList<AnnotationAttributesElem>();
            if (annoAttrs != null && annoAttrs.length > 0) {
                int i = 0;
                while (i < annoAttrs.length) {
                    String aName = annoAttrs[i].getAttribute("name");
                    if (aName != null) {
                        AnnotationAttributesElem aAttr = new AnnotationAttributesElem(aName);
                        annoAttributes.add(aAttr);
                    }
                    ++i;
                }
            }
            AnnotationConstants.debug("annoAttributes=" + annoAttributes.size());
            return annoAttributes;
        }
        return new ArrayList();
    }

    public Object getAttributeValue(String tagName, String attributeName, ICompilationUnit compUnit, IJavaElement context, int offset) {
        try {
            Object aDefVal;
            Object classObj;
            if (annoImpliedAttributesConfigurations_ == null) {
                annoImpliedAttributesConfigurations_ = this.getOnceOnlyImpliedAnnotationConfigFromExtensionPointInfo(tagName);
            }
            if (annoImpliedAttributesConfigurations_ != null && annoImpliedAttributesConfigurations_.containsKey(tagName) && (classObj = annoImpliedTagClass_.get(tagName)) != null && (aDefVal = ((AnnotationAttributeValueRetriever)classObj).getAttributeValue(tagName, attributeName, compUnit, offset)) != null) {
                return aDefVal;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return null;
    }

    public Object getImpliedAttributeValue(String tagName, String attributeName, IAnnotatable annotatableJavaElement) {
        try {
            if (annoImpliedAttributesConfigurations_ == null) {
                annoImpliedAttributesConfigurations_ = this.getOnceOnlyImpliedAnnotationConfigFromExtensionPointInfo(tagName);
            }
            if (annoImpliedAttributesConfigurations_ != null && annoImpliedAttributesConfigurations_.containsKey(tagName)) {
                Object classObj;
                boolean isImplied = false;
                ArrayList ImpliedAttributesList = (ArrayList)annoImpliedAttributesConfigurations_.get(tagName);
                if (ImpliedAttributesList.size() > 0) {
                    int i = 0;
                    while (i < ImpliedAttributesList.size()) {
                        if (((AnnotationAttributesElem)ImpliedAttributesList.get(i)).getAttrName().equals(attributeName)) {
                            isImplied = true;
                        }
                        ++i;
                    }
                }
                if ((classObj = annoImpliedTagClass_.get(tagName)) != null) {
                    Object aDefVal = ((ImpliedAnnotationAttributeValueRetriever)classObj).getAttributeValue(tagName, attributeName, annotatableJavaElement);
                    if (aDefVal != null) {
                        return aDefVal;
                    }
                    if (isImplied) {
                        return null;
                    }
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return null;
    }

    public Object getImpliedAttributeValueNested(String tagName, String attributeName, IAnnotationAttributeProperty attribute, IAnnotation parentAnnotation) {
        try {
            if (annoImpliedAttributesConfigurations_ == null) {
                annoImpliedAttributesConfigurations_ = this.getOnceOnlyImpliedAnnotationConfigFromExtensionPointInfo(tagName);
            }
            if (annoImpliedAttributesConfigurations_ != null && annoImpliedAttributesConfigurations_.containsKey(tagName)) {
                Object classObj;
                boolean isImplied = false;
                ArrayList ImpliedAttributesList = (ArrayList)annoImpliedAttributesConfigurations_.get(tagName);
                if (ImpliedAttributesList.size() > 0) {
                    int i = 0;
                    while (i < ImpliedAttributesList.size()) {
                        if (((AnnotationAttributesElem)ImpliedAttributesList.get(i)).getAttrName().equals(attributeName)) {
                            isImplied = true;
                        }
                        ++i;
                    }
                }
                if ((classObj = annoImpliedTagClass_.get(tagName)) != null) {
                    Object aDefVal = ((ImpliedAnnotationAttributeValueRetriever)classObj).getAttributeValueNested(tagName, attributeName, attribute, parentAnnotation);
                    if (aDefVal != null) {
                        return aDefVal;
                    }
                    if (isImplied) {
                        return null;
                    }
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return null;
    }
}

