/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.data;

import com.ibm.etools.annotations.core.data.AttributeOverrideInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IAnnotation;

public class AnnotationOverrideInfo {
    private String overrideSourceFile;
    private String annotationName;
    private List<AttributeOverrideInfo> attributes = new ArrayList<AttributeOverrideInfo>();
    private IAnnotation annotationObject;
    private int offset;

    public AnnotationOverrideInfo() {
    }

    public AnnotationOverrideInfo(String srcOverride, String name) {
        this.annotationName = name;
        this.overrideSourceFile = srcOverride;
    }

    public AnnotationOverrideInfo(String name) {
        this.annotationName = name;
        this.overrideSourceFile = null;
    }

    public void setAnnotationName(String name) {
        this.annotationName = name;
    }

    public void setAnnotationObject(IAnnotation annotation) {
        this.annotationObject = annotation;
    }

    public IAnnotation getAnnotationObject() {
        return this.annotationObject;
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public String getSourceOverride() {
        return this.overrideSourceFile;
    }

    public void setSourceOverride(String src) {
        this.overrideSourceFile = src;
    }

    public void setAttributeOverrideInfo(AttributeOverrideInfo attr) {
        if (attr == null) {
            return;
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            boolean exists = false;
            List<AttributeOverrideInfo> lists = this.attributes;
            int k = 0;
            while (k < lists.size()) {
                AttributeOverrideInfo aInfo = lists.get(k);
                if (aInfo.getName().equals(attr.getName())) {
                    exists = true;
                    this.attributes.set(k, attr);
                }
                ++k;
            }
            if (!exists) {
                this.attributes.add(attr);
            }
        } else {
            this.attributes = new ArrayList<AttributeOverrideInfo>();
            this.attributes.add(attr);
        }
    }

    public List<AttributeOverrideInfo> getAttributeOverrideInfo() {
        return this.attributes;
    }

    public AttributeOverrideInfo getAttributeInfo(String attrName) {
        if (this.attributes != null && !this.attributes.isEmpty()) {
            int k = 0;
            while (k < this.attributes.size()) {
                AttributeOverrideInfo aOverInfo = this.attributes.get(k);
                if (aOverInfo != null && aOverInfo.getName().equals(attrName)) {
                    return aOverInfo;
                }
                ++k;
            }
            return null;
        }
        return null;
    }

    public String getAllAttributeOverrideValuesAsString() {
        if (this.attributes != null && !this.attributes.isEmpty() && this.attributes.size() > 0) {
            StringBuffer myBuf = new StringBuffer();
            myBuf.append("(");
            int k = 0;
            while (k < this.attributes.size()) {
                AttributeOverrideInfo aOverInfo = this.attributes.get(k);
                if (aOverInfo != null && (aOverInfo.isDeclared() || aOverInfo.isImplied())) {
                    myBuf.append(aOverInfo.getName());
                    myBuf.append("=");
                    myBuf.append(aOverInfo.getValue());
                    myBuf.append(" ");
                }
                ++k;
            }
            myBuf.append(")");
            return myBuf.toString();
        }
        return "";
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }
}

