/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.data;

import com.ibm.etools.annotations.core.data.JavaElementInfo;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.properties.SingleValueArgumentProperty;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.spi.BaseMultiValuedProperty;
import com.ibm.propertygroup.spi.BaseProperty;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.spi.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;

public class AnnotationInfo
extends BaseProperty {
    private String packageName;
    private List<IAnnotationAttributeProperty> declaredAttributes = new ArrayList<IAnnotationAttributeProperty>(6);
    private List<IAnnotationAttributeProperty> allAttributes = new ArrayList<IAnnotationAttributeProperty>(6);
    private List scope;
    private int offset;
    private boolean defaultInScope = false;
    private String categorizationKey;
    private IAnnotation annotation;
    private boolean modifyModelOnly_ = false;
    private boolean isImpliedAnnotation_;
    private boolean hasDDOverride_;
    private boolean isPackageAnnotation_ = false;
    private IJavaElement javaElm;
    private Object parentElementInfo_;
    private Object reservedUse;
    private boolean isParameterScopedAnnotation_ = false;

    public AnnotationInfo(String name, int offset, IAnnotation ann) throws CoreException {
        super(name, name, name, null);
        this.annotation = ann;
        this.isImpliedAnnotation_ = false;
        this.hasDDOverride_ = false;
        if (ann != null) {
            IJavaElement parent = ann.getParent();
            if (parent instanceof ILocalVariable && ann.getParent().getParent() instanceof IMethod) {
                this.isParameterScopedAnnotation_ = true;
            }
            if (InternalUtils.isPackageInfoJava(parent)) {
                this.isPackageAnnotation_ = true;
            }
        }
    }

    public void setAnnotation(IAnnotation obj) {
        this.annotation = obj;
    }

    @Deprecated
    public IJavaElement getJavaElem() {
        return this.javaElm;
    }

    @Deprecated
    public void setJavaElement(IJavaElement elm) {
        this.javaElm = elm;
    }

    public void setJavaElementInfo(JavaElementInfo elm) {
        this.parentElementInfo_ = elm;
    }

    public JavaElementInfo getParentJavaElementInfo() {
        return this.parentElementInfo_ instanceof JavaElementInfo ? (JavaElementInfo)((Object)this.parentElementInfo_) : null;
    }

    public void setParentElementInfo(Object parentInfo) {
        this.parentElementInfo_ = parentInfo;
    }

    public Object getParentElementInfo() {
        return this.parentElementInfo_;
    }

    public String getName() {
        return this.name;
    }

    public String getAnnotationName() {
        int index = this.name.lastIndexOf(46);
        if (index > 0) {
            return this.name.substring(index + 1, this.name.length());
        }
        return this.name;
    }

    public List<IAnnotationAttributeProperty> getDeclaredAttributes() {
        return this.declaredAttributes;
    }

    public boolean isImpliedAnnotation() {
        return this.isImpliedAnnotation_;
    }

    public void setIsImpliedAnnotation(boolean flag) {
        this.isImpliedAnnotation_ = flag;
    }

    public boolean hasDDOverride() {
        return this.hasDDOverride_;
    }

    public void setHasDDOverride(boolean flag) {
        this.hasDDOverride_ = flag;
    }

    public IAnnotationAttributeProperty getDeclaredAttribute(String attributeName) {
        List<IAnnotationAttributeProperty> lst = this.getDeclaredAttributes();
        if (lst != null) {
            for (IAnnotationAttributeProperty iap : lst) {
                if (!iap.getDisplayName().equals(attributeName)) continue;
                return iap;
            }
        }
        return null;
    }

    public IAnnotationAttributeProperty getAttribute(String attributeName) {
        List<IAnnotationAttributeProperty> lst = this.getAllAttributes();
        if (lst != null) {
            for (IAnnotationAttributeProperty iap : lst) {
                if (!iap.getDisplayName().equals(attributeName)) continue;
                return iap;
            }
        }
        return null;
    }

    public void setDeclaredAttributes(List<IAnnotationAttributeProperty> declaredAttributes) {
        this.declaredAttributes = declaredAttributes;
    }

    public List<IAnnotationAttributeProperty> getAllAttributes() {
        return this.allAttributes;
    }

    public void setAllAttributes(List<IAnnotationAttributeProperty> allAttributes) {
        this.allAttributes = allAttributes;
    }

    public List getScopes() {
        return this.scope;
    }

    public void setScopes(List scope) {
        this.scope = scope;
    }

    public int getOffset() {
        IAnnotation an = this.getAnnotation();
        if (an != null) {
            try {
                return an.getSourceRange().getOffset();
            }
            catch (Exception exception) {}
        }
        return this.offset;
    }

    public void setDefaultInScope(boolean def) {
        this.defaultInScope = def;
    }

    public boolean isDefaultInScope() {
        return this.defaultInScope;
    }

    public String getCategorizationKey() {
        return this.categorizationKey;
    }

    public void setCategorizationKey(String categorizationKey) {
        this.categorizationKey = categorizationKey;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public IAnnotation getAnnotation() {
        return this.annotation;
    }

    public String annotToString() {
        StringBuffer res = new StringBuffer("@").append(this.getAnnotationName());
        List<IAnnotationAttributeProperty> declaredAt = this.getDeclaredAttributes();
        int count = 0;
        int i = 0;
        while (i < declaredAt.size()) {
            IAnnotationAttributeProperty aT = declaredAt.get(i);
            if (aT instanceof SingleValueArgumentProperty && PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)aT) && ((ISingleValuedProperty)aT).getValue() == null && "com.ibm.etools.annotations.ui.javaClassProperty".equals(aT.getID())) {
                aT.setDeclared(false);
                declaredAt.remove(i--);
            } else {
                if (count == 0) {
                    res.append("(");
                } else {
                    res.append(", ");
                }
                ++count;
                res.append(aT.getDisplayName()).append("=").append(aT.toCUString());
            }
            ++i;
        }
        if (count != 0) {
            res.append(")");
        }
        return res.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(AnnotationInfo newA) {
        if (newA == null) {
            return false;
        }
        boolean res = true;
        try {
            Object ob2;
            if (!this.name.equals(newA.getName())) {
                return false;
            }
            if (this.getDeclaredAttributes().size() != newA.getDeclaredAttributes().size()) {
                return false;
            }
            List<IAnnotationAttributeProperty> lst1 = this.getDeclaredAttributes();
            Iterator<IAnnotationAttributeProperty> iterator = lst1.iterator();
            while (true) {
                String st2;
                String st1;
                if (!iterator.hasNext()) {
                    String s1 = AnnotationUtils.getNameOfParentJavaElement(this);
                    String s2 = AnnotationUtils.getNameOfParentJavaElement(newA);
                    if (s1 != null && s2 != null && s1.equals(s2)) return res;
                    if (s1 != null || s2 != null) {
                        return false;
                    }
                    break;
                }
                IAnnotationAttributeProperty aap1 = iterator.next();
                IAnnotationAttributeProperty aap2 = newA.getDeclaredAttribute(aap1.getDisplayName());
                if (aap2 == null) {
                    return false;
                }
                if (aap1 instanceof BaseSingleValuedProperty) {
                    st1 = ((BaseSingleValuedProperty)aap1).getValueAsString();
                    st2 = ((BaseSingleValuedProperty)aap2).getValueAsString();
                    if (st1 != null && st1.equals(st2)) continue;
                    return false;
                }
                if (aap1 instanceof BaseMultiValuedProperty && !(st1 = aap1.toCUString()).equals(st2 = aap2.toCUString())) return false;
            }
            Object ob = this.getParentElementInfo();
            if (ob == (ob2 = newA.getParentElementInfo())) return res;
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean modifyModelOnly() {
        return this.modifyModelOnly_;
    }

    public void modifyModelOnly(boolean only) {
        this.modifyModelOnly_ = only;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    public void unSet() {
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setReserved(Object alist) {
        this.reservedUse = alist;
    }

    public Object getReserved() {
        return this.reservedUse;
    }

    public String getFullyQualifiedName() {
        String pack = this.getPackageName();
        if (pack != null) {
            StringBuffer sb = new StringBuffer(pack);
            sb.append(".").append(this.getName());
            return sb.toString();
        }
        return this.getName();
    }

    public String toString() {
        return new StringBuffer("Annotation: ").append(this.getFullyQualifiedName()).toString();
    }

    public boolean isPackageAnnotation() {
        return this.isPackageAnnotation_;
    }

    public boolean isParameterScopedAnnotation() {
        return this.isParameterScopedAnnotation_;
    }
}

