/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.data;

import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.internal.AnnotatedProjectInitializationJob;
import com.ibm.etools.annotations.core.internal.jobs.AnnotationJobManager;
import com.ibm.etools.annotations.core.internal.jobs.AnnotationModelUpdateJob;
import com.ibm.etools.annotations.core.internal.jobs.AnnotationModelUpdateJobManager;
import com.ibm.etools.annotations.core.internal.search.InitializationUtils;
import com.ibm.etools.annotations.core.internal.search.JavaSearchUtils;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public class AnnotatedProjectInfo
extends BasePropertyGroup
implements IElementChangedListener {
    private Hashtable<String, AnnotatedClassInfo> encounteredAnnotatedClasses;
    private boolean isInitialized = false;
    private String[] annotationList_;
    private boolean isUpdating_ = false;
    private AnnotatedProjectInitializationJob initJob_ = null;
    protected AnnotatedProjectInfoUpdateJobManager updateManager_ = new AnnotatedProjectInfoUpdateJobManager();
    private int PROJECT_UPDATED = 2;
    private int CHANGE_HANDLED = 1;
    private int CHANGE_IGNORED = 0;

    @Deprecated
    public AnnotatedProjectInfo(IProject pr) throws CoreException {
        this(pr, null, false, null);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public AnnotatedProjectInfo(IProject pr, IProgressMonitor monitor) throws CoreException {
        this(pr, null, false, monitor);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    protected AnnotatedProjectInfo(IProject pr, boolean initInBackgroundThread, IProgressMonitor monitor) throws CoreException {
        this(pr, null, initInBackgroundThread, monitor);
    }

    protected AnnotatedProjectInfo(IProject pr, String[] annotationNames, boolean initInBackgroundThread, IProgressMonitor monitor) throws CoreException {
        super(pr.getName(), pr.getName(), pr.getName());
        this.encounteredAnnotatedClasses = new Hashtable();
        this.annotationList_ = annotationNames;
        this.init(pr, initInBackgroundThread, monitor);
    }

    public void connectElementChangedListener(boolean connect) {
        if (connect) {
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        } else {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }
    }

    private void init(IProject pr, boolean initInBackground, IProgressMonitor monitor) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)pr);
        if (!javaProject.isOpen()) {
            try {
                javaProject.open(monitor);
            }
            catch (Exception exception) {}
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (initInBackground) {
            this.isInitialized = false;
            if (this.initJob_ == null) {
                this.initJob_ = new AnnotatedProjectInitializationJob(this, javaProject, this.annotationList_);
                this.initJob_.addJobChangeListener(new InitJobListener());
                AnnotationJobManager.getInstance().startJob(this.initJob_);
            }
        } else {
            InitializationUtils.initializeAnnotatedProjectInfoForAnnotations(this, javaProject, this.annotationList_, monitor);
            this.isInitialized = true;
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.connectElementChangedListener(true);
    }

    public AnnotatedProjectInitializationJob getInitializationJob() {
        return this.initJob_;
    }

    public void addAnnotatedClassInfo(AnnotatedClassInfo aci) {
        if (aci != null && !this.encounteredAnnotatedClasses.contains((Object)aci)) {
            String resName = InternalUtils.getFullUniqueNameForCU(aci.getJavaElement());
            this.addProperty((IPropertyDescriptor)aci);
            this.encounteredAnnotatedClasses.put(resName, aci);
        }
    }

    public AnnotatedClassInfo[] getAnnotatedClassInfos() {
        IPropertyDescriptor[] pDes;
        if (this.isUpdating_) {
            this.waitForModelUpdating();
        }
        if ((pDes = this.getProperties()) == null) {
            return null;
        }
        AnnotatedClassInfo[] acls = new AnnotatedClassInfo[pDes.length];
        int i = 0;
        while (i < pDes.length) {
            acls[i] = (AnnotatedClassInfo)pDes[i];
            ++i;
        }
        return acls;
    }

    private boolean waitForInit() {
        int preventInfLoopCount = 0;
        while (!this.isInitialized()) {
            try {
                Thread.sleep(200L);
                if (preventInfLoopCount > 250) {
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            ++preventInfLoopCount;
        }
        return true;
    }

    private int handleDelta(IJavaElementDelta delta) {
        block41: {
            final IJavaElement el = delta.getElement();
            int type = el.getElementType();
            if (el == null || el.getJavaProject() == null || this.getName() == null) {
                return this.CHANGE_IGNORED;
            }
            if (!el.getJavaProject().getProject().getName().equals(this.getName())) {
                return this.CHANGE_IGNORED;
            }
            int rr = delta.getKind();
            if (type == 2) {
                try {
                    if (rr == 2 || (delta.getFlags() & 0x400) != 0) {
                        this.connectElementChangedListener(false);
                        this.updateManager_.performModelUpdate(new AnnotationModelUpdateJob(1, (IPropertyDescriptor)this){

                            protected IStatus run(IProgressMonitor monitor) {
                                AnnotatedProjectInfo.this.removeAllAnnotatedClassInfo(null);
                                return Status.OK_STATUS;
                            }
                        });
                        return this.PROJECT_UPDATED;
                    }
                    if ((delta.getFlags() & 0x200) != 0 || rr == 1) {
                        this.init(((IJavaProject)el).getProject(), true, null);
                        return this.PROJECT_UPDATED;
                    }
                    if (rr != 4) break block41;
                    if ((delta.getFlags() & 0x20000) != 0) {
                        this.waitForInit();
                        this.updateManager_.cancelAllJobs();
                        this.init(((IJavaProject)el).getProject(), true, null);
                        return this.PROJECT_UPDATED;
                    }
                    if ((delta.getFlags() & 0x200000) != 0 && (delta.getFlags() & 8) != 0) {
                        IVMInstall vmInstall;
                        IJavaElementDelta[] children = delta.getAffectedChildren();
                        IJavaProject jp = (IJavaProject)el;
                        if (jp != null && jp.exists() && (vmInstall = JavaRuntime.getVMInstall((IJavaProject)jp)) != null) {
                            File vmInstallLocation = vmInstall.getInstallLocation();
                            String vmInstallLocationStringPath = vmInstallLocation.getCanonicalPath();
                            Path vmInstallLocationPath = new Path(vmInstallLocationStringPath);
                            IJavaElementDelta[] iJavaElementDeltaArray = children;
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                                int kind = child.getKind();
                                if ((kind == 1 || kind == 4 && (child.getFlags() & 0x40) != 0) && child.getElement().getElementType() == 3) {
                                    IPackageFragmentRoot pfr = (IPackageFragmentRoot)child.getElement();
                                    if (pfr.isArchive() && vmInstallLocationPath.isPrefixOf(pfr.getPath())) {
                                        this.waitForInit();
                                        this.updateManager_.cancelAllJobs();
                                        this.init(((IJavaProject)el).getProject(), true, null);
                                        return this.PROJECT_UPDATED;
                                    }
                                } else {
                                    return this.CHANGE_IGNORED;
                                }
                                ++n2;
                            }
                        }
                    } else {
                        IResourceDelta[] deltas = delta.getResourceDeltas();
                        final int[] returnValue = new int[]{this.CHANGE_IGNORED};
                        if (deltas != null) {
                            final IJavaProject jp = (IJavaProject)el;
                            final IPath outputLocation = jp.getOutputLocation();
                            final AnnotatedProjectInfo model = this;
                            IResourceDelta[] iResourceDeltaArray = deltas;
                            int n = deltas.length;
                            int n3 = 0;
                            while (n3 < n) {
                                IResourceDelta rd = iResourceDeltaArray[n3];
                                IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                                    public boolean visit(IResourceDelta delta) throws CoreException {
                                        IPackageFragmentRoot pfr;
                                        IResource res;
                                        if (delta.getKind() == 2 && (res = delta.getResource()) != null && res.getType() == 1 && (outputLocation == null || !outputLocation.isPrefixOf(res.getFullPath())) && (pfr = jp.findPackageFragmentRoot(res.getLocation().makeAbsolute())) != null && pfr.isArchive()) {
                                            AnnotatedProjectInfo.this.updateManager_.performModelUpdate(new AnnotationModelUpdateJob(1, (IPropertyDescriptor)model){

                                                protected IStatus run(IProgressMonitor monitor) {
                                                    AnnotatedProjectInfo.this.removePackageFragmentRoot(pfr, null);
                                                    return Status.OK_STATUS;
                                                }
                                            });
                                            returnValue[0] = AnnotatedProjectInfo.this.PROJECT_UPDATED;
                                        }
                                        return true;
                                    }
                                };
                                rd.accept(visitor);
                                ++n3;
                            }
                        }
                        if (returnValue[0] == this.PROJECT_UPDATED) {
                            return this.PROJECT_UPDATED;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type == 3) {
                try {
                    if (rr == 2 || rr == 4 && (delta.getFlags() & 0x80) != 0) {
                        this.updateManager_.performModelUpdate(new AnnotationModelUpdateJob(1, (IPropertyDescriptor)this){

                            protected IStatus run(IProgressMonitor monitor) {
                                AnnotatedProjectInfo.this.removePackageFragmentRoot((IPackageFragmentRoot)el, null);
                                return Status.OK_STATUS;
                            }
                        });
                        return this.CHANGE_HANDLED;
                    }
                    if (rr == 1 || rr == 4 && (delta.getFlags() & 0x40) != 0) {
                        this.updateManager_.performModelUpdate(new AnnotationModelUpdateJob(1, (IPropertyDescriptor)this){

                            protected IStatus run(IProgressMonitor monitor) {
                                AnnotatedProjectInfo.this.addJavaElement(el, null);
                                return Status.OK_STATUS;
                            }
                        });
                        return this.CHANGE_HANDLED;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type == 4) {
                if (rr == 2) {
                    this.updateManager_.performModelUpdate(new AnnotationModelUpdateJob(1, (IPropertyDescriptor)this){

                        protected IStatus run(IProgressMonitor monitor) {
                            AnnotatedProjectInfo.this.removePackageFragment((IPackageFragment)el, null, null);
                            return Status.OK_STATUS;
                        }
                    });
                    return this.CHANGE_HANDLED;
                }
                if (rr == 1) {
                    this.updateManager_.performModelUpdate(new AnnotationModelUpdateJob(1, (IPropertyDescriptor)this){

                        protected IStatus run(IProgressMonitor monitor) {
                            AnnotatedProjectInfo.this.addJavaElement(el, null);
                            return Status.OK_STATUS;
                        }
                    });
                    return this.CHANGE_HANDLED;
                }
            } else if (type == 5 || type == 6) {
                try {
                    String resName;
                    if (rr == 2) {
                        boolean canBeRemoved = false;
                        final String name = InternalUtils.getFullUniqueNameForCU(el);
                        if (type == 5) {
                            ICompilationUnit icu = (ICompilationUnit)el;
                            if (icu.isWorkingCopy()) {
                                IJavaElement cu;
                                AnnotatedClassInfo aci = this.encounteredAnnotatedClasses.get(name);
                                if (aci != null && icu == (cu = aci.getJavaElementForThisClass())) {
                                    canBeRemoved = true;
                                }
                            } else {
                                canBeRemoved = true;
                            }
                        } else {
                            canBeRemoved = true;
                        }
                        if (canBeRemoved) {
                            this.updateManager_.performModelUpdate(new AnnotationModelUpdateJob(1, (IPropertyDescriptor)this){

                                protected IStatus run(IProgressMonitor monitor) {
                                    AnnotatedProjectInfo.this.removeAnnotatedClassInfo(name);
                                    return Status.OK_STATUS;
                                }
                            });
                            return this.CHANGE_HANDLED;
                        }
                    } else if (el.exists() && this.encounteredAnnotatedClasses.get(resName = InternalUtils.getFullUniqueNameForCU(el)) == null) {
                        this.updateManager_.performModelUpdate(new AnnotationModelUpdateJob(1, (IPropertyDescriptor)this){

                            protected IStatus run(IProgressMonitor monitor) {
                                AnnotatedProjectInfo.this.addType((ITypeRoot)el);
                                return Status.OK_STATUS;
                            }
                        });
                        return this.CHANGE_HANDLED;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.CHANGE_IGNORED;
    }

    private void removePackageFragmentRoot(IPackageFragmentRoot ipfr, IProgressMonitor monitor) {
        block8: {
            try {
                if (!InternalUtils.isValidJARFile(ipfr)) break block8;
                if (ipfr.exists()) {
                    try {
                        IJavaElement[] elements;
                        IJavaElement[] iJavaElementArray = elements = ipfr.getChildren();
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IJavaElement je = iJavaElementArray[n2];
                            if (monitor == null || !monitor.isCanceled()) {
                                if (je.getElementType() == 4) {
                                    this.removePackageFragment((IPackageFragment)je, ipfr.getPath(), monitor);
                                }
                                ++n2;
                                continue;
                            }
                            break block8;
                        }
                        break block8;
                    }
                    catch (Exception exception) {
                        this.clearRemovedAnnotatedClassInfo(monitor);
                    }
                    break block8;
                }
                this.clearRemovedAnnotatedClassInfo(monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void removePackageFragment(IPackageFragment ipf, IPath jarPath, IProgressMonitor monitor) {
        String startName = new StringBuffer(this.getName()).append(".").append(ipf.getElementName()).toString();
        Enumeration<String> e1 = this.encounteredAnnotatedClasses.keys();
        ArrayList<AnnotatedClassInfo> lst = new ArrayList<AnnotatedClassInfo>();
        while (e1.hasMoreElements()) {
            if (monitor != null && monitor.isCanceled()) {
                lst.clear();
                break;
            }
            String key = e1.nextElement();
            if (!key.startsWith(startName)) continue;
            lst.add(this.encounteredAnnotatedClasses.get(key));
        }
        for (AnnotatedClassInfo aciToRemove : lst) {
            if (monitor != null && monitor.isCanceled()) break;
            if (jarPath == null) {
                this.removeAnnotatedClassInfo(aciToRemove);
                continue;
            }
            IJavaElement je = aciToRemove.getJavaElementForThisClass().getAncestor(3);
            if (je == null || !jarPath.equals((Object)je.getPath())) continue;
            this.removeAnnotatedClassInfo(aciToRemove);
        }
    }

    private void addJavaElement(IJavaElement ije, IProgressMonitor monitor) {
        List<IJavaElement> classes = JavaSearchUtils.getInstance().findAnnotationDeclarations2(ije, this.annotationList_, monitor);
        if (classes != null) {
            for (IJavaElement clazz : classes) {
                if (monitor != null && monitor.isCanceled()) break;
                int type = clazz.getElementType();
                if (type != 6 && type != 5) continue;
                this.addType((ITypeRoot)clazz);
            }
        }
    }

    private int addType(ITypeRoot typeRoot) {
        AnnotatedClassInfo aci;
        String resName;
        if (typeRoot.exists() && this.encounteredAnnotatedClasses.get(resName = InternalUtils.getFullUniqueNameForCU((IJavaElement)typeRoot)) == null && (this.annotationList_ == null || this.annotationList_.length < 1 || JavaSearchUtils.getInstance().checkAnnotationForClass((IJavaElement)typeRoot, this.annotationList_)) && (aci = AnnotationUtils.getAnnotatedClassInfo((IJavaElement)typeRoot)) != null) {
            if (this.annotationList_ != null && this.annotationList_.length > 0) {
                aci.makeSourceListener();
            }
            this.encounteredAnnotatedClasses.put(resName, aci);
            this.addProperty((IPropertyDescriptor)aci);
            return this.CHANGE_HANDLED;
        }
        return this.CHANGE_IGNORED;
    }

    private int elementDeltaVisitor(IJavaElementDelta delta) {
        if (delta == null) {
            return this.CHANGE_IGNORED;
        }
        if (this.handleDelta(delta) == this.PROJECT_UPDATED) {
            return this.PROJECT_UPDATED;
        }
        int i = 0;
        while (i < delta.getAffectedChildren().length) {
            IJavaElementDelta delt = delta.getAffectedChildren()[i];
            if (this.elementDeltaVisitor(delt) == this.PROJECT_UPDATED) {
                return this.PROJECT_UPDATED;
            }
            ++i;
        }
        return this.CHANGE_IGNORED;
    }

    private int delegateToACIVisitor(IJavaElementDelta delta, ElementChangedEvent event) {
        int i = 0;
        while (i < delta.getAffectedChildren().length) {
            ICompilationUnit cu;
            IJavaElementDelta delt = delta.getAffectedChildren()[i];
            if (this.delegateToACIVisitor(delt, event) == this.PROJECT_UPDATED) {
                return this.PROJECT_UPDATED;
            }
            AnnotatedClassInfo aci = null;
            AnnotatedClassInfo[] acis = this.getAnnotatedClassInfos();
            IJavaElement elem = delt.getElement();
            if (elem instanceof JavaElement && (cu = ((JavaElement)elem).getCompilationUnit()) != null) {
                int j = 0;
                while (j < acis.length) {
                    if (acis[j].getJavaElement().equals(cu)) {
                        aci = acis[j];
                    }
                    ++j;
                }
            }
            if (aci != null) {
                aci.elementChanged(event);
                return this.PROJECT_UPDATED;
            }
            ++i;
        }
        return this.CHANGE_IGNORED;
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        int status = this.CHANGE_IGNORED;
        if (event.getType() == 1 && delta.getKind() == 4) {
            this.isUpdating_ = true;
            status = this.elementDeltaVisitor(delta);
            this.isUpdating_ = false;
        }
        if (status != this.PROJECT_UPDATED) {
            this.delegateToACIVisitor(delta, event);
        }
    }

    public AnnotatedClassInfo[] getAnnotatedClassInfos(String triggerAnnotationName) {
        ArrayList<AnnotatedClassInfo> res = new ArrayList<AnnotatedClassInfo>();
        AnnotatedClassInfo[] clIs = this.getAnnotatedClassInfos();
        int i = 0;
        while (i < clIs.length) {
            AnnotatedClassInfo clI = clIs[i];
            List<AnnotationInfo> lst = AnnotationUtils.getAnnotationInfosForJavaElementInfo(clI, false);
            int j = 0;
            while (j < lst.size()) {
                AnnotationInfo aI = lst.get(j);
                String sN = aI.getName();
                if (sN.equals(triggerAnnotationName)) {
                    res.add(clI);
                    break;
                }
                sN = String.valueOf(aI.getPackageName()) + "." + sN;
                if (sN.equals(triggerAnnotationName)) {
                    res.add(clI);
                    break;
                }
                ++j;
            }
            ++i;
        }
        AnnotatedClassInfo[] resAr = new AnnotatedClassInfo[res.size()];
        resAr = res.toArray(resAr);
        return resAr;
    }

    public List getAllAnnotationsForType(String name) {
        AnnotatedClassInfo[] clIs;
        AnnotatedClassInfo[] annotatedClassInfoArray = clIs = this.getAnnotatedClassInfos();
        int n = clIs.length;
        int n2 = 0;
        while (n2 < n) {
            String sFullName;
            AnnotatedClassInfo clI = annotatedClassInfoArray[n2];
            String sName = clI.getJavaElementForThisClass().getElementName();
            if (sName.endsWith(".java")) {
                sName = sName.substring(0, sName.length() - 5);
            } else if (sName.endsWith(".class")) {
                sName = sName.substring(0, sName.length() - 6);
            }
            String sPackName = "";
            try {
                IJavaElement jEl = clI.getJavaElementForThisClass();
                IPackageDeclaration[] ipd = null;
                if (jEl.getElementType() == 5) {
                    ipd = ((ICompilationUnit)jEl).getPackageDeclarations();
                    if (ipd != null && ipd.length > 0) {
                        sPackName = ipd[0].getElementName();
                    }
                } else if (jEl.getElementType() == 6) {
                    sPackName = ((IClassFile)jEl).getType().getPackageFragment().getElementName();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if ((sFullName = sPackName.isEmpty() ? sName : new StringBuffer(sPackName).append(".").append(sName).toString()).equals(name)) {
                return AnnotationUtils.getAnnotationInfosForJavaElementInfo(clI, false);
            }
            ++n2;
        }
        return new ArrayList();
    }

    @Deprecated
    public void removeAllAnnotatedClassInfo() {
        this.removeAllAnnotatedClassInfo(null);
    }

    public void removeAllAnnotatedClassInfo(IProgressMonitor monitor) {
        IPropertyDescriptor[] allACI;
        this.encounteredAnnotatedClasses.clear();
        IPropertyDescriptor[] iPropertyDescriptorArray = allACI = this.getProperties();
        int n = allACI.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor prop = iPropertyDescriptorArray[n2];
            if (monitor != null && monitor.isCanceled()) break;
            if (prop instanceof AnnotatedClassInfo) {
                this.removeAnnotatedClassInfo((AnnotatedClassInfo)prop);
            }
            ++n2;
        }
    }

    private void removeAnnotatedClassInfo(String resName) {
        AnnotatedClassInfo aci = this.encounteredAnnotatedClasses.get(resName);
        if (aci != null) {
            this.removeAnnotatedClassInfo(aci);
        }
    }

    private void clearRemovedAnnotatedClassInfo(IProgressMonitor monitor) {
        IPropertyDescriptor[] allACI;
        IPropertyDescriptor[] iPropertyDescriptorArray = allACI = this.getProperties();
        int n = allACI.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotatedClassInfo aci;
            IJavaElement clazz;
            IPropertyDescriptor prop = iPropertyDescriptorArray[n2];
            if (monitor != null && monitor.isCanceled()) break;
            if (prop instanceof AnnotatedClassInfo && (clazz = (aci = (AnnotatedClassInfo)prop).getJavaElementForThisClass()) != null && !clazz.exists()) {
                this.removeAnnotatedClassInfo(aci);
            }
            ++n2;
        }
    }

    private void removeAnnotatedClassInfo(AnnotatedClassInfo aci) {
        aci.removePropertyChangeListener((IPropertyChangeListener)this);
        aci.makeSourceListener(false);
        IJavaElement cu = aci.getJavaElementForThisClass();
        String resName = InternalUtils.getFullUniqueNameForCU(cu);
        this.encounteredAnnotatedClasses.remove(resName);
        try {
            this.remove((IPropertyDescriptor)aci);
        }
        catch (Exception e) {
            CodegenPlugin.log("Exception removing AnnotatedClassInfo", e);
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void waitForModelUpdating() {
        int loopCounter = 25;
        while (this.isUpdating_ && loopCounter > 0) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            --loopCounter;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Project: ");
        sb.append(this.getName()).append(", Annotated classes: ");
        AnnotatedClassInfo[] infos = this.getAnnotatedClassInfos();
        if (infos == null) {
            sb.append("0");
        } else {
            sb.append(infos.length);
        }
        return sb.toString();
    }

    protected class AnnotatedProjectInfoUpdateJobManager
    extends AnnotationModelUpdateJobManager {
        protected Job runningJob_;

        protected AnnotatedProjectInfoUpdateJobManager() {
        }

        protected void cancelAllJobs() {
            this.updateJobs_.clear();
            if (this.runningJob_ != null) {
                try {
                    this.runningJob_.join();
                    this.runningJob_.cancel();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        protected void runNextUpdateJob() {
            if (!this.updateJobs_.isEmpty()) {
                AnnotatedProjectInfo.this.waitForInit();
                if (!this.updateJobs_.isEmpty()) {
                    super.runNextUpdateJob();
                }
            }
        }

        @Override
        public void done(IJobChangeEvent event) {
            super.done(event);
            this.runningJob_ = null;
        }

        @Override
        public void scheduled(IJobChangeEvent event) {
            super.scheduled(event);
            this.runningJob_ = event.getJob();
        }
    }

    private class InitJobListener
    implements IJobChangeListener {
        private InitJobListener() {
        }

        public void done(IJobChangeEvent event) {
            AnnotatedProjectInfo.this.isInitialized = true;
            AnnotatedProjectInfo.this.initJob_ = null;
        }

        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
        }

        public void sleeping(IJobChangeEvent event) {
        }
    }
}

