/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.internal.codegen.inbound.apt;

import com.ibm.adapter.j2c.inbound.annotations.InboundAdapter;
import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.adapter.j2ca.spi.util.ProjectUtils;
import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.RoundCompleteEvent;
import com.sun.mirror.apt.RoundCompleteListener;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.apt.core.env.EclipseAnnotationProcessorEnvironment;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEdit;

public class InboundAdapterAnnotationsProcessorMirrorAPI
implements AnnotationProcessor,
RoundCompleteListener {
    private AnnotationProcessorEnvironment env;
    private IJavaProject javaProject;
    private Collection<? extends MethodDeclaration> localInterfaceClassMethods;
    private static Map<String, InboundAdapterArtifactsGenerationModel> sharedEJBsGenerationModelTable = new HashMap<String, InboundAdapterArtifactsGenerationModel>();
    private static Map<String, MessageDrivenTypeMetadata> messageDrivenTypeMetadataTable = new HashMap<String, MessageDrivenTypeMetadata>();
    private static Map<String, StatelessTypeMetadata> statelessTypeMetadataTable = new HashMap<String, StatelessTypeMetadata>();

    private AnnotationMirror getInboundAdapterAnnotation(Collection<AnnotationMirror> annotations) {
        boolean hasInboundAdapterAnnotation = false;
        boolean hasMessageDrivenAnnotation = false;
        AnnotationMirror inboundAdapterAnnotation = null;
        for (AnnotationMirror annotation : annotations) {
            AnnotationTypeDeclaration annotationType = annotation.getAnnotationType().getDeclaration();
            String annotationTypeName = annotationType.getQualifiedName();
            if ("com.ibm.adapter.j2c.inbound.annotations.InboundAdapter".equals(annotationTypeName)) {
                hasInboundAdapterAnnotation = true;
                inboundAdapterAnnotation = annotation;
                continue;
            }
            if (!"javax.ejb.MessageDriven".equals(annotationTypeName)) continue;
            hasMessageDrivenAnnotation = true;
        }
        if (hasInboundAdapterAnnotation && hasMessageDrivenAnnotation) {
            return inboundAdapterAnnotation;
        }
        return null;
    }

    private AnnotationMirror getLocalAnnotation(Collection<AnnotationMirror> annotations) {
        boolean hasLocalAnnotation = false;
        boolean hasStatelessAnnotation = false;
        AnnotationMirror localAnnotation = null;
        for (AnnotationMirror annotation : annotations) {
            AnnotationTypeDeclaration annotationType = annotation.getAnnotationType().getDeclaration();
            String annotationTypeName = annotationType.getQualifiedName();
            if ("javax.ejb.Local".equals(annotationTypeName)) {
                hasLocalAnnotation = true;
                localAnnotation = annotation;
                continue;
            }
            if (!"javax.ejb.Stateless".equals(annotationTypeName)) continue;
            hasStatelessAnnotation = true;
        }
        if (hasLocalAnnotation && hasStatelessAnnotation) {
            return localAnnotation;
        }
        return null;
    }

    private boolean hasSessionBeanReferenceAnnotation(Collection<AnnotationMirror> annotations) {
        for (AnnotationMirror annotation : annotations) {
            AnnotationTypeDeclaration annotationType = annotation.getAnnotationType().getDeclaration();
            String annotationTypeName = annotationType.getQualifiedName();
            if (!"javax.ejb.EJB".equals(annotationTypeName)) continue;
            return true;
        }
        return false;
    }

    private AnnotationMirror getInboundMethodBindingAnnotation(Collection<AnnotationMirror> annotations) {
        AnnotationMirror inboundMethodBindingAnnotation = null;
        for (AnnotationMirror annotation : annotations) {
            AnnotationTypeDeclaration annotationType = annotation.getAnnotationType().getDeclaration();
            String annotationTypeName = annotationType.getQualifiedName();
            if (!"com.ibm.adapter.j2c.inbound.annotations.InboundMethodBinding".equals(annotationTypeName)) continue;
            inboundMethodBindingAnnotation = annotation;
            break;
        }
        return inboundMethodBindingAnnotation;
    }

    private boolean isValidMethod(MethodDeclaration sessionBeanMethod) {
        StringBuffer sessionBeanMethodSignature = new StringBuffer();
        sessionBeanMethodSignature.append(sessionBeanMethod.getReturnType().toString());
        sessionBeanMethodSignature.append(sessionBeanMethod.getSimpleName());
        Collection inputs1 = sessionBeanMethod.getParameters();
        for (ParameterDeclaration input : inputs1) {
            sessionBeanMethodSignature.append(input.getType().toString());
        }
        Collection thrownTypes1 = sessionBeanMethod.getThrownTypes();
        for (ReferenceType referenceType : thrownTypes1) {
            sessionBeanMethodSignature.append(referenceType.toString());
        }
        for (MethodDeclaration methodDeclaration : this.localInterfaceClassMethods) {
            StringBuffer localInterfaceMethodSignature = new StringBuffer();
            localInterfaceMethodSignature.append(methodDeclaration.getReturnType().toString());
            localInterfaceMethodSignature.append(methodDeclaration.getSimpleName());
            Collection inputs2 = methodDeclaration.getParameters();
            for (ParameterDeclaration input : inputs2) {
                localInterfaceMethodSignature.append(input.getType().toString());
            }
            Collection thrownTypes2 = methodDeclaration.getThrownTypes();
            for (ReferenceType thrownType : thrownTypes2) {
                localInterfaceMethodSignature.append(thrownType.toString());
            }
            if (!sessionBeanMethodSignature.toString().equals(localInterfaceMethodSignature.toString())) continue;
            return true;
        }
        return false;
    }

    public InboundAdapterAnnotationsProcessorMirrorAPI(AnnotationProcessorEnvironment env) {
        this.env = env;
        this.javaProject = ((EclipseAnnotationProcessorEnvironment)env).getJavaProject();
    }

    public void process() {
        DeclarationVisitor messageDrivenVisitor = DeclarationVisitors.getSourceOrderDeclarationScanner((DeclarationVisitor)new EJBClassVisitor(), (DeclarationVisitor)DeclarationVisitors.NO_OP);
        for (TypeDeclaration typeDeclaration : this.env.getSpecifiedTypeDeclarations()) {
            typeDeclaration.accept(messageDrivenVisitor);
        }
    }

    public AnnotationProcessorEnvironment getEnvironment() {
        return this.env;
    }

    public void roundComplete(RoundCompleteEvent event) {
        if (event.getRoundState().finalRound()) {
            this.initializeInboundAdapterArtifactsGenerationModels();
            Collection<InboundAdapterArtifactsGenerationModel> generationModels = sharedEJBsGenerationModelTable.values();
            for (InboundAdapterArtifactsGenerationModel generationModel : generationModels) {
                this.generateMDBHelper(generationModel);
            }
        }
    }

    private void initializeInboundAdapterArtifactsGenerationModels() {
        HashMap<String, MessageDrivenTypeMetadata> mdbTable = new HashMap<String, MessageDrivenTypeMetadata>();
        Collection<MessageDrivenTypeMetadata> messageDrivenTypeMetadataValues = messageDrivenTypeMetadataTable.values();
        if (messageDrivenTypeMetadataValues.isEmpty()) {
            messageDrivenTypeMetadataValues = this.initializeMessageDrivenTypeMetadata();
        }
        for (MessageDrivenTypeMetadata messageDrivenTypeMetadata : messageDrivenTypeMetadataValues) {
            mdbTable.put(messageDrivenTypeMetadata.getLocalInterfaceClassName(), messageDrivenTypeMetadata);
        }
        Collection<StatelessTypeMetadata> statelessTypeMetadataValues = statelessTypeMetadataTable.values();
        if (statelessTypeMetadataValues.isEmpty()) {
            statelessTypeMetadataValues = this.initializeStatelessTypeMetadata();
        }
        for (StatelessTypeMetadata statelessTypeMetadata : statelessTypeMetadataValues) {
            MessageDrivenTypeMetadata messageDrivenTypeMetadata = (MessageDrivenTypeMetadata)mdbTable.get(statelessTypeMetadata.getLocalInterfaceClassName());
            InboundAdapterArtifactsGenerationModel generationModel = new InboundAdapterArtifactsGenerationModel();
            generationModel.setMessageDrivenTypeMetadata(messageDrivenTypeMetadata);
            generationModel.setStatelessTypeMetadata(statelessTypeMetadata);
            sharedEJBsGenerationModelTable.put(messageDrivenTypeMetadata.getMessageDrivenBeanClassName(), generationModel);
        }
    }

    private Collection<MessageDrivenTypeMetadata> initializeMessageDrivenTypeMetadata() {
        AnnotationTypeDeclaration typeDeclaration = (AnnotationTypeDeclaration)this.env.getTypeDeclaration(InboundAdapter.class.getName());
        Collection annotatedTypes = this.env.getDeclarationsAnnotatedWith(typeDeclaration);
        for (Declaration declaration : annotatedTypes) {
            Collection classAnnotations = declaration.getAnnotationMirrors();
            AnnotationMirror inboundAdapterAnnotation = this.getInboundAdapterAnnotation(classAnnotations);
            if (inboundAdapterAnnotation == null) continue;
            String messageDrivenBeanClassName = ((ClassDeclaration)declaration).getQualifiedName();
            MessageDrivenTypeMetadata messageDrivenTypeMetadata = new MessageDrivenTypeMetadata();
            messageDrivenTypeMetadata.setMessageDrivenBeanClassName(messageDrivenBeanClassName);
            Map valueMap = inboundAdapterAnnotation.getElementValues();
            if (valueMap.isEmpty()) {
                messageDrivenTypeMetadataTable.remove(messageDrivenBeanClassName);
                continue;
            }
            messageDrivenTypeMetadataTable.put(messageDrivenBeanClassName, messageDrivenTypeMetadata);
            Set valueSet = valueMap.entrySet();
            for (Map.Entry annotationKeyValue : valueSet) {
                if ("activationSpec".equals(((AnnotationTypeElementDeclaration)annotationKeyValue.getKey()).getSimpleName())) {
                    AnnotationValue activationSpecAnnotationTypeDeclaration = (AnnotationValue)annotationKeyValue.getValue();
                    AnnotationMirror activationSpecAnnotation = (AnnotationMirror)activationSpecAnnotationTypeDeclaration.getValue();
                    Map activationSpecMap = activationSpecAnnotation.getElementValues();
                    Set activationSpecSet = activationSpecMap.entrySet();
                    for (Map.Entry activationSpecKeyValue : activationSpecSet) {
                        if ("activationSpecClass".equals(((AnnotationTypeElementDeclaration)activationSpecKeyValue.getKey()).getSimpleName())) {
                            String activationSpecClassName = ((ClassDeclaration)((AnnotationValue)activationSpecKeyValue.getValue()).getValue()).getQualifiedName();
                            messageDrivenTypeMetadata.setActivationSpecClassName(activationSpecClassName);
                        }
                        if (!"jndiName".equals(((AnnotationTypeElementDeclaration)activationSpecKeyValue.getKey()).getSimpleName())) continue;
                        String activationSpecJNDIName = (String)((AnnotationValue)activationSpecKeyValue.getValue()).getValue();
                        messageDrivenTypeMetadata.setActivationSpecJNDIName(activationSpecJNDIName);
                    }
                }
                if (!"functionSelectorClass".equals(((AnnotationTypeElementDeclaration)annotationKeyValue.getKey()).getSimpleName())) continue;
                AnnotationValue functionSelectorClass = (AnnotationValue)annotationKeyValue.getValue();
                String functionSelectorClassName = ((ClassDeclaration)functionSelectorClass.getValue()).getQualifiedName();
                messageDrivenTypeMetadata.setFunctionSelectorClassName(functionSelectorClassName);
            }
            Collection fieldDeclarations = ((ClassDeclaration)declaration).getFields();
            for (FieldDeclaration fieldDeclaration : fieldDeclarations) {
                boolean hasEJBAnnotation;
                Collection fieldAnnotations = fieldDeclaration.getAnnotationMirrors();
                if (fieldAnnotations.isEmpty() || !(hasEJBAnnotation = this.hasSessionBeanReferenceAnnotation(fieldAnnotations))) continue;
                String referencedEJBClassName = fieldDeclaration.getType().toString();
                messageDrivenTypeMetadata.setLocalInterfaceClassName(referencedEJBClassName);
            }
        }
        return messageDrivenTypeMetadataTable.values();
    }

    private Collection<StatelessTypeMetadata> initializeStatelessTypeMetadata() {
        AnnotationTypeDeclaration typeDeclaration = (AnnotationTypeDeclaration)this.env.getTypeDeclaration("javax.ejb.Stateless");
        Collection annotatedTypes = this.env.getDeclarationsAnnotatedWith(typeDeclaration);
        for (Declaration declaration : annotatedTypes) {
            Collection classAnnotations = declaration.getAnnotationMirrors();
            AnnotationMirror localAnnotation = this.getLocalAnnotation(classAnnotations);
            if (localAnnotation == null) continue;
            String statelessSessionBeanClassName = ((ClassDeclaration)declaration).getQualifiedName();
            StatelessTypeMetadata statelessTypeMetadata = new StatelessTypeMetadata();
            statelessTypeMetadata.setStatelessSessionBeanClassName(statelessSessionBeanClassName);
            Map valueMap = localAnnotation.getElementValues();
            if (valueMap.isEmpty()) {
                statelessTypeMetadataTable.remove(statelessSessionBeanClassName);
                continue;
            }
            statelessTypeMetadataTable.put(statelessSessionBeanClassName, statelessTypeMetadata);
            Set valueSet = valueMap.entrySet();
            for (Map.Entry annotationKeyValue : valueSet) {
                if (!"value".equals(((AnnotationTypeElementDeclaration)annotationKeyValue.getKey()).getSimpleName())) continue;
                AnnotationValue localInterfaceAnnotation = (AnnotationValue)annotationKeyValue.getValue();
                InterfaceDeclaration localInterface = (InterfaceDeclaration)((AnnotationValue)((List)localInterfaceAnnotation.getValue()).get(0)).getValue();
                String localInterfaceClassName = localInterface.toString();
                statelessTypeMetadata.setLocalInterfaceClassName(localInterfaceClassName);
                this.localInterfaceClassMethods = localInterface.getMethods();
            }
            Collection methodDeclarations = ((ClassDeclaration)declaration).getMethods();
            for (MethodDeclaration methodDeclaration : methodDeclarations) {
                AnnotationMirror inboundMethodBindingAnnotation;
                boolean isValidMethod;
                Collection methodAnnotations = methodDeclaration.getAnnotationMirrors();
                if (methodAnnotations.isEmpty() || !(isValidMethod = this.isValidMethod(methodDeclaration)) || (inboundMethodBindingAnnotation = this.getInboundMethodBindingAnnotation(methodAnnotations)) == null) continue;
                String method = methodDeclaration.getSimpleName();
                String outputRecordClassName = null;
                TypeMirror returnType = methodDeclaration.getReturnType();
                if (!(returnType instanceof VoidType)) {
                    outputRecordClassName = returnType.toString();
                }
                String inputRecordClassName = null;
                Collection inputs = methodDeclaration.getParameters();
                if (!inputs.isEmpty()) {
                    for (ParameterDeclaration input : inputs) {
                        inputRecordClassName = input.getType().toString();
                    }
                }
                Map methodBindingMap = inboundMethodBindingAnnotation.getElementValues();
                Set methodBindingSet = methodBindingMap.entrySet();
                String nativeMethod = null;
                for (Map.Entry methodBindingAnnotationKeyValue : methodBindingSet) {
                    if (!"nativeMethod".equals(((AnnotationTypeElementDeclaration)methodBindingAnnotationKeyValue.getKey()).getSimpleName())) continue;
                    nativeMethod = (String)((AnnotationValue)methodBindingAnnotationKeyValue.getValue()).getValue();
                }
                statelessTypeMetadata.addMethodEntry(nativeMethod, method);
                statelessTypeMetadata.addInputRecordEntry(method, inputRecordClassName);
                if (outputRecordClassName == null) continue;
                statelessTypeMetadata.addOutputRecordEntry(method, outputRecordClassName);
            }
        }
        return statelessTypeMetadataTable.values();
    }

    private void generateMDBHelper(InboundAdapterArtifactsGenerationModel generationModel) {
        try {
            if (this.javaProject != null && this.javaProject.exists()) {
                String content = this.buildCompilationUnitContent(generationModel);
                this.createCompilationUnit(this.javaProject, String.valueOf(generationModel.getMessageDrivenTypeMetadata().getMessageDrivenBeanClassName()) + "Helper", content);
            }
        }
        catch (CoreException ce) {
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 4, ce.getLocalizedMessage(), (Throwable)ce);
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
        }
    }

    private String buildCompilationUnitContent(InboundAdapterArtifactsGenerationModel generationModel) {
        String method;
        StringBuffer stringBuffer = new StringBuffer();
        String NL = System.getProperties().getProperty("line.separator");
        String qualifiedClassName = generationModel.getMessageDrivenTypeMetadata().getMessageDrivenBeanClassName();
        String javaPackage = qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf("."));
        String className = String.valueOf(qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1)) + "Helper";
        stringBuffer.append("package " + javaPackage + ";" + NL);
        stringBuffer.append("import javax.annotation.Generated;" + NL + "import java.util.HashMap;" + NL + "import javax.resource.ResourceException;" + NL + "import commonj.connector.runtime.FunctionSelector;" + NL + "import commonj.connector.runtime.SelectorException;" + NL);
        Date time = Calendar.getInstance().getTime();
        String date = DateFormat.getDateTimeInstance(0, 0).format(time);
        stringBuffer.append("@Generated(comments=\"Do not edit the code below\",date=\"" + date + "\",value={\"\"})" + NL);
        stringBuffer.append(String.valueOf(NL) + "public class " + className + "{" + NL);
        stringBuffer.append("\tprivate static HashMap<String,String> methodNameTable = new HashMap<String,String>();");
        stringBuffer.append("\tprivate static HashMap<String,String> inputDataTable = new HashMap<String,String>();");
        if (!generationModel.getStatelessTypeMetadata().getOutputDataEntries().isEmpty()) {
            stringBuffer.append("\tprivate static HashMap<String, String> outputDataTable = new HashMap<String, String>();");
        }
        stringBuffer.append(String.valueOf(NL) + "\tpublic static void initialize() {" + NL);
        Set<Map.Entry<String, String>> methodMappings = generationModel.getStatelessTypeMetadata().getMethodNameEntries();
        for (Map.Entry<String, String> methodMapping : methodMappings) {
            String nativeMethod = methodMapping.getKey();
            method = methodMapping.getValue();
            stringBuffer.append("\t\tmethodNameTable.put(\"" + (String)nativeMethod + "\"," + "\"" + method + "\");" + NL);
        }
        Set<Map.Entry<String, String>> inputDataMappings = generationModel.getStatelessTypeMetadata().getInputDataEntries();
        for (Map.Entry entry : inputDataMappings) {
            method = (String)entry.getKey();
            String inputRecord = (String)entry.getValue();
            stringBuffer.append("\t\tinputDataTable.put(\"" + method + "\"," + "\"" + inputRecord + "\");" + NL);
        }
        if (!generationModel.getStatelessTypeMetadata().getOutputDataEntries().isEmpty()) {
            Set<Map.Entry<String, String>> set = generationModel.getStatelessTypeMetadata().getOutputDataEntries();
            for (Map.Entry<String, String> outputDataMapping : set) {
                String method2 = outputDataMapping.getKey();
                String outputRecord = outputDataMapping.getValue();
                stringBuffer.append("\t\toutputDataTable.put(\"" + method2 + "\"," + "\"" + outputRecord + "\");" + NL);
            }
        }
        stringBuffer.append("\t}" + NL);
        stringBuffer.append("\tpublic static void cleanup() {" + NL);
        stringBuffer.append("\t\tmethodNameTable.clear();" + NL);
        stringBuffer.append("\t\tinputDataTable.clear();" + NL);
        stringBuffer.append("\t}" + NL);
        stringBuffer.append(String.valueOf(NL) + "\tpublic static String getMethodName(Object[] inputs) throws ResourceException {" + NL);
        stringBuffer.append("\t\tString methodName = null;" + NL);
        stringBuffer.append("\t\ttry {" + NL);
        stringBuffer.append("\t\t\tFunctionSelector selector = new " + generationModel.getMessageDrivenTypeMetadata().getFunctionSelector() + "();" + NL);
        stringBuffer.append("\t\t\tString nativeMethodName = selector.generateEISFunctionName(inputs);" + NL);
        stringBuffer.append("\t\t\tif (nativeMethodName == null || nativeMethodName.trim().length() == 0)" + NL);
        stringBuffer.append("\t\t\t\tthrow new ResourceException(\"Native method name is invalid\");" + NL);
        stringBuffer.append("\t\t\tmethodName = methodNameTable.get(nativeMethodName);" + NL);
        stringBuffer.append("\t\t\tif (methodName == null || methodName.length() == 0)" + NL);
        stringBuffer.append("\t\t\t\tthrow new ResourceException(\"Can not find corresponding method name for target invocation\");" + NL);
        stringBuffer.append("\t\t} catch(SelectorException e) {" + NL);
        stringBuffer.append("\t\t\tResourceException resourceException = new ResourceException();" + NL);
        stringBuffer.append("\t\t\tresourceException.initCause(e);" + NL);
        stringBuffer.append("\t\t\tthrow resourceException;" + NL);
        stringBuffer.append("\t\t}" + NL);
        stringBuffer.append("\t\treturn methodName;" + NL);
        stringBuffer.append("\t}" + NL);
        stringBuffer.append(String.valueOf(NL) + "\tpublic static String getInputRecordName(String methodName) throws ResourceException {" + NL);
        stringBuffer.append("\t\tString inputRecordName = inputDataTable.get(methodName);" + NL);
        stringBuffer.append("\t\tif (inputRecordName == null || inputRecordName.trim().length() == 0)" + NL);
        stringBuffer.append("\t\t\tthrow new ResourceException(\"Can not find corresponding Java Bean Record name\");" + NL);
        stringBuffer.append("\t\treturn inputRecordName;" + NL);
        stringBuffer.append("\t}" + NL);
        if (!generationModel.getStatelessTypeMetadata().getOutputDataEntries().isEmpty()) {
            stringBuffer.append("\tpublic static String getOutputRecordName(String methodName) throws ResourceException {" + NL);
            stringBuffer.append("\t\tString outputRecordName = outputDataTable.get(methodName);" + NL);
            stringBuffer.append("\t\tif (outputRecordName == null || outputRecordName.trim().length() == 0)" + NL);
            stringBuffer.append("\t\t\tthrow new ResourceException(\"Can not find corresponding Java Bean Record name\");" + NL);
            stringBuffer.append("\t\treturn outputRecordName;" + NL);
            stringBuffer.append("\t}" + NL);
        }
        stringBuffer.append("}" + NL);
        return stringBuffer.toString();
    }

    private ICompilationUnit createCompilationUnit(IJavaProject project, String qualifiedClassName, String content) throws CoreException {
        if (project == null || qualifiedClassName == null) {
            return null;
        }
        ICompilationUnit unit = null;
        try {
            IType type = project.findType(qualifiedClassName);
            if (type != null && type.getJavaProject() == project) {
                unit = type.getCompilationUnit();
                unit.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            IPackageFragmentRoot pkgRoot = ProjectUtils.getSourcePackage((IJavaProject)project);
            String packageName = qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf("."));
            String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1);
            IPackageFragment pkgFragment = pkgRoot.createPackageFragment(packageName, false, null);
            Document document = new Document(content);
            Map options = project.getOptions(true);
            options.put("org.eclipse.jdt.core.formatter.comment.format_javadoc_comments", "true");
            options.put("org.eclipse.jdt.core.formatter.comment.format_header", "false");
            CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)options);
            TextEdit textEdit = codeFormatter.format(8, document.get(), 0, document.get().length(), 0, null);
            if (textEdit != null) {
                textEdit.apply((IDocument)document);
            }
            unit = pkgFragment.createCompilationUnit(String.valueOf(className) + ".java", document.get(), true, (IProgressMonitor)new NullProgressMonitor());
            unit.save((IProgressMonitor)new NullProgressMonitor(), true);
        }
        catch (Exception e) {
            String message = NLS.bind((String)"ERR_CANNOT_CREATE_COMPILATION_UNIT", (Object)qualifiedClassName, (Object)project.getProject().getName());
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        return unit;
    }

    private class CommonInboundAdapterMetadata {
        protected String localInterfaceClassName;

        private CommonInboundAdapterMetadata() {
        }

        public String getLocalInterfaceClassName() {
            return this.localInterfaceClassName;
        }

        public void setLocalInterfaceClassName(String localInterfaceClassName) {
            this.localInterfaceClassName = localInterfaceClassName;
        }
    }

    private class EJBClassVisitor
    extends SimpleDeclarationVisitor {
        private boolean hasMessageDrivenTypeValidAnnotations;
        private boolean hasStatelessTypeValidAnnotations;

        private EJBClassVisitor() {
        }

        public void visitClassDeclaration(ClassDeclaration classDeclaration) {
            Collection annotations = classDeclaration.getAnnotationMirrors();
            if (!annotations.isEmpty()) {
                this.hasMessageDrivenTypeValidAnnotations = false;
                this.hasStatelessTypeValidAnnotations = false;
                AnnotationMirror inboundAdapterAnnotation = InboundAdapterAnnotationsProcessorMirrorAPI.this.getInboundAdapterAnnotation(annotations);
                if (inboundAdapterAnnotation != null) {
                    String messageDrivenBeanClassName = classDeclaration.getQualifiedName();
                    MessageDrivenTypeMetadata messageDrivenTypeMetadata = null;
                    if (!messageDrivenTypeMetadataTable.containsKey(messageDrivenBeanClassName)) {
                        messageDrivenTypeMetadata = new MessageDrivenTypeMetadata();
                        messageDrivenTypeMetadata.setMessageDrivenBeanClassName(messageDrivenBeanClassName);
                        messageDrivenTypeMetadataTable.put(messageDrivenBeanClassName, messageDrivenTypeMetadata);
                    } else {
                        messageDrivenTypeMetadata = (MessageDrivenTypeMetadata)messageDrivenTypeMetadataTable.get(messageDrivenBeanClassName);
                    }
                    Map valueMap = inboundAdapterAnnotation.getElementValues();
                    if (valueMap.isEmpty()) {
                        messageDrivenTypeMetadataTable.remove(messageDrivenBeanClassName);
                        return;
                    }
                    this.hasMessageDrivenTypeValidAnnotations = true;
                    Set valueSet = valueMap.entrySet();
                    for (Map.Entry annotationKeyValue : valueSet) {
                        if ("activationSpec".equals(((AnnotationTypeElementDeclaration)annotationKeyValue.getKey()).getSimpleName())) {
                            AnnotationValue activationSpecAnnotationTypeDeclaration = (AnnotationValue)annotationKeyValue.getValue();
                            AnnotationMirror activationSpecAnnotation = (AnnotationMirror)activationSpecAnnotationTypeDeclaration.getValue();
                            Map activationSpecMap = activationSpecAnnotation.getElementValues();
                            Set activationSpecSet = activationSpecMap.entrySet();
                            for (Map.Entry activationSpecKeyValue : activationSpecSet) {
                                if ("activationSpecClass".equals(((AnnotationTypeElementDeclaration)activationSpecKeyValue.getKey()).getSimpleName())) {
                                    String activationSpecClassName = ((ClassDeclaration)((AnnotationValue)activationSpecKeyValue.getValue()).getValue()).getQualifiedName();
                                    messageDrivenTypeMetadata.setActivationSpecClassName(activationSpecClassName);
                                }
                                if (!"jndiName".equals(((AnnotationTypeElementDeclaration)activationSpecKeyValue.getKey()).getSimpleName())) continue;
                                String activationSpecJNDIName = (String)((AnnotationValue)activationSpecKeyValue.getValue()).getValue();
                                messageDrivenTypeMetadata.setActivationSpecJNDIName(activationSpecJNDIName);
                            }
                        }
                        if (!"functionSelectorClass".equals(((AnnotationTypeElementDeclaration)annotationKeyValue.getKey()).getSimpleName())) continue;
                        AnnotationValue functionSelectorClass = (AnnotationValue)annotationKeyValue.getValue();
                        String functionSelectorClassName = ((ClassDeclaration)functionSelectorClass.getValue()).getQualifiedName();
                        messageDrivenTypeMetadata.setFunctionSelectorClassName(functionSelectorClassName);
                    }
                    return;
                }
                AnnotationMirror localAnnotation = InboundAdapterAnnotationsProcessorMirrorAPI.this.getLocalAnnotation(annotations);
                if (localAnnotation != null) {
                    String statelessSessionBeanClassName = classDeclaration.getQualifiedName();
                    StatelessTypeMetadata statelessTypeMetadata = null;
                    if (!statelessTypeMetadataTable.containsKey(statelessSessionBeanClassName)) {
                        statelessTypeMetadata = new StatelessTypeMetadata();
                        statelessTypeMetadata.setStatelessSessionBeanClassName(statelessSessionBeanClassName);
                        statelessTypeMetadataTable.put(statelessSessionBeanClassName, statelessTypeMetadata);
                    } else {
                        statelessTypeMetadata = (StatelessTypeMetadata)statelessTypeMetadataTable.get(statelessSessionBeanClassName);
                    }
                    Map valueMap = localAnnotation.getElementValues();
                    if (valueMap.isEmpty()) {
                        statelessTypeMetadataTable.remove(statelessSessionBeanClassName);
                        return;
                    }
                    this.hasStatelessTypeValidAnnotations = true;
                    Set valueSet = valueMap.entrySet();
                    for (Map.Entry annotationKeyValue : valueSet) {
                        if (!"value".equals(((AnnotationTypeElementDeclaration)annotationKeyValue.getKey()).getSimpleName())) continue;
                        AnnotationValue localInterfaceAnnotation = (AnnotationValue)annotationKeyValue.getValue();
                        InterfaceDeclaration localInterface = (InterfaceDeclaration)((AnnotationValue)((List)localInterfaceAnnotation.getValue()).get(0)).getValue();
                        String localInterfaceClassName = localInterface.toString();
                        statelessTypeMetadata.setLocalInterfaceClassName(localInterfaceClassName);
                        InboundAdapterAnnotationsProcessorMirrorAPI.this.localInterfaceClassMethods = localInterface.getMethods();
                    }
                }
            }
        }

        public void visitFieldDeclaration(FieldDeclaration fieldDeclaration) {
            boolean hasEJBAnnotation;
            Collection annotations;
            if (this.hasMessageDrivenTypeValidAnnotations && !(annotations = fieldDeclaration.getAnnotationMirrors()).isEmpty() && (hasEJBAnnotation = InboundAdapterAnnotationsProcessorMirrorAPI.this.hasSessionBeanReferenceAnnotation(annotations))) {
                String referencedEJBClassName = fieldDeclaration.getType().toString();
                MessageDrivenTypeMetadata messageDrivenTypeMetadata = (MessageDrivenTypeMetadata)messageDrivenTypeMetadataTable.get(fieldDeclaration.getDeclaringType().getQualifiedName());
                messageDrivenTypeMetadata.setLocalInterfaceClassName(referencedEJBClassName);
            }
        }

        public void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
            AnnotationMirror inboundMethodBindingAnnotation;
            boolean isValidMethod;
            Collection annotations;
            if (this.hasStatelessTypeValidAnnotations && !(annotations = methodDeclaration.getAnnotationMirrors()).isEmpty() && (isValidMethod = InboundAdapterAnnotationsProcessorMirrorAPI.this.isValidMethod(methodDeclaration)) && (inboundMethodBindingAnnotation = InboundAdapterAnnotationsProcessorMirrorAPI.this.getInboundMethodBindingAnnotation(annotations)) != null) {
                String method = methodDeclaration.getSimpleName();
                String outputRecordClassName = null;
                TypeMirror returnType = methodDeclaration.getReturnType();
                if (!(returnType instanceof VoidType)) {
                    outputRecordClassName = returnType.toString();
                }
                String inputRecordClassName = null;
                Collection inputs = methodDeclaration.getParameters();
                if (!inputs.isEmpty()) {
                    for (ParameterDeclaration input : inputs) {
                        inputRecordClassName = input.getType().toString();
                    }
                }
                Map methodBindingMap = inboundMethodBindingAnnotation.getElementValues();
                Set methodBindingSet = methodBindingMap.entrySet();
                String nativeMethod = null;
                for (Map.Entry methodBindingAnnotationKeyValue : methodBindingSet) {
                    if (!"nativeMethod".equals(((AnnotationTypeElementDeclaration)methodBindingAnnotationKeyValue.getKey()).getSimpleName())) continue;
                    nativeMethod = (String)((AnnotationValue)methodBindingAnnotationKeyValue.getValue()).getValue();
                }
                StatelessTypeMetadata statelessTypeMetadata = (StatelessTypeMetadata)statelessTypeMetadataTable.get(methodDeclaration.getDeclaringType().getQualifiedName());
                statelessTypeMetadata.addMethodEntry(nativeMethod, method);
                statelessTypeMetadata.addInputRecordEntry(method, inputRecordClassName);
                if (outputRecordClassName != null) {
                    statelessTypeMetadata.addOutputRecordEntry(method, outputRecordClassName);
                }
            }
        }
    }

    private class InboundAdapterArtifactsGenerationModel {
        private MessageDrivenTypeMetadata MessageDrivenTypeMetadata;
        private StatelessTypeMetadata statelessTypeMetadata;

        private InboundAdapterArtifactsGenerationModel() {
        }

        public MessageDrivenTypeMetadata getMessageDrivenTypeMetadata() {
            return this.MessageDrivenTypeMetadata;
        }

        public void setMessageDrivenTypeMetadata(MessageDrivenTypeMetadata messageDrivenTypeMetadata) {
            this.MessageDrivenTypeMetadata = messageDrivenTypeMetadata;
        }

        public StatelessTypeMetadata getStatelessTypeMetadata() {
            return this.statelessTypeMetadata;
        }

        public void setStatelessTypeMetadata(StatelessTypeMetadata statelessTypeMetadata) {
            this.statelessTypeMetadata = statelessTypeMetadata;
        }
    }

    private class MessageDrivenTypeMetadata
    extends CommonInboundAdapterMetadata {
        private String messageDrivenBeanClassName;
        private String functionSelectorClassName;
        private String activationSpecClassName;
        private String activationSpecJNDIName;
        private String authenticationAlias;

        private MessageDrivenTypeMetadata() {
        }

        public boolean hasCompleteMetadata() {
            return this.messageDrivenBeanClassName != null && this.functionSelectorClassName != null && this.localInterfaceClassName != null && this.activationSpecClassName != null && this.activationSpecJNDIName != null;
        }

        public String getMessageDrivenBeanClassName() {
            return this.messageDrivenBeanClassName;
        }

        public void setMessageDrivenBeanClassName(String messageDrivenBeanClassName) {
            this.messageDrivenBeanClassName = messageDrivenBeanClassName;
        }

        public String getFunctionSelector() {
            return this.functionSelectorClassName;
        }

        public void setFunctionSelectorClassName(String functionSelectorClassName) {
            this.functionSelectorClassName = functionSelectorClassName;
        }

        public String getActivationSpecClassName() {
            return this.activationSpecClassName;
        }

        public void setActivationSpecClassName(String activationSpecClassName) {
            this.activationSpecClassName = activationSpecClassName;
        }

        public String getActivationSpecJNDIName() {
            return this.activationSpecJNDIName;
        }

        public void setActivationSpecJNDIName(String activationSpecJNDIName) {
            this.activationSpecJNDIName = activationSpecJNDIName;
        }

        public String getAuthenticationAlias() {
            return this.authenticationAlias;
        }

        public void setAuthenticationAlias(String authenticationAlias) {
            this.authenticationAlias = authenticationAlias;
        }
    }

    private class StatelessTypeMetadata
    extends CommonInboundAdapterMetadata {
        private String statelessSessionBeanClassName;
        private Map<String, String> methodNameTable = new HashMap<String, String>();
        private Map<String, String> inputDataTable = new HashMap<String, String>();
        private Map<String, String> outputDataTable = new HashMap<String, String>();

        private StatelessTypeMetadata() {
        }

        public boolean hasCompleteMetadata() {
            return this.localInterfaceClassName != null && !this.methodNameTable.isEmpty();
        }

        public void addMethodEntry(String nativeMethod, String method) {
            this.methodNameTable.put(nativeMethod, method);
        }

        public Set<Map.Entry<String, String>> getMethodNameEntries() {
            return this.methodNameTable.entrySet();
        }

        public void addInputRecordEntry(String method, String inputRecord) {
            this.inputDataTable.put(method, inputRecord);
        }

        public Set<Map.Entry<String, String>> getInputDataEntries() {
            return this.inputDataTable.entrySet();
        }

        public void addOutputRecordEntry(String method, String outputRecord) {
            this.outputDataTable.put(method, outputRecord);
        }

        public Set<Map.Entry<String, String>> getOutputDataEntries() {
            return this.outputDataTable.entrySet();
        }

        public String getStatelessSessionBeanClassName() {
            return this.statelessSessionBeanClassName;
        }

        public void setStatelessSessionBeanClassName(String statelessSessionBeanClassName) {
            this.statelessSessionBeanClassName = statelessSessionBeanClassName;
        }
    }
}

