/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2c.edit;

import com.ibm.adapter.emd.extension.description.ParameterDescription;
import com.ibm.adapter.emd.extension.description.spi.DataDescription;
import com.ibm.adapter.emd.extension.description.spi.DataFile;
import com.ibm.adapter.emd.extension.description.spi.J2CParameterDescription;
import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.OutboundFunctionDescription;
import com.ibm.adapter.emd.extension.description.spi.OutboundServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.ServiceDescriptionFactory;
import com.ibm.adapter.emd.extension.discovery.spi.MetadataEdit;
import com.ibm.adapter.emd.extension.discovery.spi.ServiceDiscoveryFactory;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.util.QNameHelper;
import com.ibm.adapter.j2c.edit.InterfaceBindingJavaDocVisitor;
import com.ibm.adapter.j2c.edit.MethodBindingJavaDocVisitor;
import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.adapter.j2c.internal.MessageResource;
import com.ibm.adapter.j2ca.Connector;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.IResourceAdapterRegistry;
import com.ibm.adapter.j2ca.RegistryFactory;
import com.ibm.adapter.j2ca.internal.ResourceAdapterRegistry;
import com.ibm.adapter.j2ca.spi.util.ConnectorProjectHelper;
import com.ibm.adapter.j2ca.spi.util.ProjectUtils;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.description.FunctionDescription;
import commonj.connector.metadata.description.ServiceDescription;
import commonj.connector.metadata.discovery.connection.OutboundConnectionConfiguration;
import commonj.connector.metadata.discovery.connection.OutboundConnectionType;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import commonj.connector.metadata.discovery.properties.SingleValuedProperty;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.InteractionSpec;
import javax.resource.spi.ManagedConnectionFactory;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jface.text.Document;
import org.eclipse.jst.j2ee.jca.ConnectionDefinition;
import org.eclipse.jst.j2ee.jca.OutboundResourceAdapter;
import org.eclipse.osgi.util.NLS;

public class J2CJavaBeanEdit {
    private static final String MCF_DOCLET_TAG_NAME = "@j2c.managedConnectionFactory";
    private static final String MCF_PROPERTIES_DOCLET_TAG_NAME = "@j2c.managedConnectionFactory-property";
    private static final String CF_DOCLET_TAG_NAME = "@j2c.connectionFactory";
    private static final String INTERACTION_SPEC_DOCLET_TAG_NAME = "@j2c.interactionSpec";
    private static final String INTERACTION_SPEC_PROPERTIES_DOCLET_TAG_NAME = "@j2c.interactionSpec-property";
    private static final String INTERACTION_SPEC_RETURNPROPERTIES_DOCLET_TAG_NAME = "@j2c.interactionSpec-returnProperty";
    private static final String CONNECTION_SPEC_DOCLET_TAG_NAME = "@j2c.connectionSpec";
    private static final String CONNECTION_SPEC_PROPERTIES_DOCLET_TAG_NAME = "@j2c.connectionSpec-property";
    private static final String CCI_RECORD = "javax.resource.cci.Record";
    private static final String MFS_RECORD = "com.ibm.ims.mfs.emd.MFSSOARecord";
    private J2CServiceDescription serviceDescriptionWrapper;
    private OutboundServiceDescription outboundServiceDescription;
    private CompilationUnit astCU;
    private IJavaProject project;
    private String jndiLookupName;
    private String managedConnectionFactoryName;
    private String connectionSpecName;
    private IEnvironment environment;
    private String interfaceName;
    private IType interfaceDefinitionBinding;
    private IResourceAdapterDescriptor resourceAdapter;
    private HashMap exposedInputs = new HashMap();
    private HashMap exposedOutputs = new HashMap();
    private boolean MFSCase = false;

    public void initialize(IType interfaceDefinitionBinding, IEnvironment environment) {
        this.environment = environment;
        IProgressMonitor progressMonitor = this.environment.getProgressMonitor();
        String taskName = NLS.bind((String)MessageResource.DISP_PROG_MSG_CREATE_OUTBOUND_INTERFACE_DEFINITION, (Object)interfaceDefinitionBinding.getElementName());
        progressMonitor.beginTask(taskName, 4);
        try {
            this.interfaceDefinitionBinding = interfaceDefinitionBinding;
            this.project = interfaceDefinitionBinding.getJavaProject();
            this.interfaceName = interfaceDefinitionBinding.getSuperInterfaceNames()[0];
            ICompilationUnit cu = interfaceDefinitionBinding.getCompilationUnit();
            Document doc = new Document(cu.getSource());
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(true);
            parser.setSource(doc.get().toCharArray());
            this.astCU = (CompilationUnit)parser.createAST(null);
            this.jndiLookupName = this.get_CF_JNDIName(CF_DOCLET_TAG_NAME);
            this.managedConnectionFactoryName = this.get_MCF_CS_ClassName(MCF_DOCLET_TAG_NAME);
            this.connectionSpecName = this.get_MCF_CS_ClassName(CONNECTION_SPEC_DOCLET_TAG_NAME);
        }
        catch (JavaModelException e) {
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
        }
        progressMonitor.worked(4);
    }

    private IResourceAdapterDescriptor findMatchingResourceAdapter() throws BaseException {
        IProject[] connectorProjects = ConnectorProjectHelper.getAllConnectorProjects();
        boolean hasConnectorProjects = connectorProjects != null && connectorProjects.length >= 1;
        IResourceAdapterDescriptor descriptor = null;
        Connector connector = null;
        String mcf = null;
        boolean matchFound = false;
        if (hasConnectorProjects) {
            int i = 0;
            while (i < connectorProjects.length && !matchFound) {
                IResourceAdapterDescriptor raDescriptor = ResourceAdapterRegistry.getRegistry().getResourceAdapterForProject(connectorProjects[i]);
                if (raDescriptor != null) {
                    ConnectionDefinition def;
                    Iterator iter;
                    Object connectionDefinitions;
                    OutboundResourceAdapter outboundAdapter;
                    connector = raDescriptor.getConnector();
                    String specVersion = connector.getSpecVersion();
                    if ("1.0".equals(specVersion)) {
                        mcf = connector.getJca15Connector().getResourceAdapter().getManagedConnectionFactoryClass();
                        if (this.managedConnectionFactoryName.equals(mcf) && this.project.isOnClasspath((IResource)connectorProjects[i])) {
                            matchFound = true;
                            break;
                        }
                    } else if ("1.5".equals(specVersion)) {
                        outboundAdapter = connector.getJca15Connector().getResourceAdapter().getOutboundResourceAdapter();
                        if (outboundAdapter != null && (connectionDefinitions = outboundAdapter.getConnectionDefinitions()) != null) {
                            iter = connectionDefinitions.iterator();
                            while (iter.hasNext()) {
                                def = (ConnectionDefinition)iter.next();
                                mcf = def.getManagedConnectionFactoryClass();
                                if (!this.managedConnectionFactoryName.equals(mcf) || !this.project.isOnClasspath((IResource)connectorProjects[i])) continue;
                                matchFound = true;
                                break;
                            }
                        }
                    } else if ("1.6".equals(specVersion) && (outboundAdapter = connector.getJca16Connector().getResourceadapter().getOutboundResourceadapter()) != null && (connectionDefinitions = outboundAdapter.getConnectionDefinition()) != null) {
                        iter = connectionDefinitions.iterator();
                        while (iter.hasNext()) {
                            def = (org.eclipse.jst.javaee.jca.ConnectionDefinition)iter.next();
                            mcf = def.getManagedconnectionfactoryClass();
                            if (!this.managedConnectionFactoryName.equals(mcf) || !this.project.isOnClasspath((IResource)connectorProjects[i])) continue;
                            matchFound = true;
                            break;
                        }
                    }
                }
                ++i;
            }
        } else {
            String message = MessageResource.ERR_CONNECTOR_PROJECT_DOES_NOT_EXIST;
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, message, new Throwable(message));
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
            throw new BaseException((IStatus)status);
        }
        if (!matchFound) {
            String message = NLS.bind((String)MessageResource.ERR_CONNECTOR_MODULE_DOES_NOT_EXIST, (Object)connector.getDisplayName());
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, message, new Throwable(message));
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
            throw new BaseException((IStatus)status);
        }
        IResourceAdapterRegistry adapterRegistry = RegistryFactory.getFactory().getAPIResourceAdapterRegistry();
        descriptor = adapterRegistry.getResourceAdapters(connector.getDisplayName(), connector.getVersion(), connector.getVendorName())[0];
        return descriptor;
    }

    private String get_MCF_CS_ClassName(String tagName) {
        InterfaceBindingJavaDocVisitor visitor = new InterfaceBindingJavaDocVisitor(tagName);
        this.astCU.accept((ASTVisitor)visitor);
        List tags = visitor.getDoclets();
        if (tags.isEmpty()) {
            return null;
        }
        TagElement tag = (TagElement)tags.get(0);
        if (tag == null) {
            return null;
        }
        String classFragment = ((TextElement)tag.fragments().get(0)).getText().trim();
        return classFragment.substring("class=\"".length(), classFragment.length() - 1);
    }

    private String get_CF_JNDIName(String tagName) {
        InterfaceBindingJavaDocVisitor visitor = new InterfaceBindingJavaDocVisitor(tagName);
        this.astCU.accept((ASTVisitor)visitor);
        List tags = visitor.getDoclets();
        if (tags.isEmpty()) {
            return null;
        }
        TagElement tag = (TagElement)tags.get(0);
        if (tag == null) {
            return null;
        }
        String jndiNameFragment = ((TextElement)tag.fragments().get(0)).getText().trim();
        return jndiNameFragment.substring("jndi-name=\"".length(), jndiNameFragment.length() - 1);
    }

    private String get_IS_CS_ClassName(String[] tagName, String methodName) {
        MethodBindingJavaDocVisitor visitor = new MethodBindingJavaDocVisitor(tagName, methodName);
        this.astCU.accept((ASTVisitor)visitor);
        List tags = visitor.getDoclets();
        if (tags.isEmpty()) {
            return null;
        }
        TagElement tag = (TagElement)tags.get(0);
        if (tag == null) {
            return null;
        }
        String classFragment = ((TextElement)tag.fragments().get(0)).getText().trim();
        return classFragment.substring("class=\"".length(), classFragment.length() - 1);
    }

    private Map getMCFPropertiesMapping() {
        InterfaceBindingJavaDocVisitor visitor = new InterfaceBindingJavaDocVisitor(MCF_PROPERTIES_DOCLET_TAG_NAME);
        this.astCU.accept((ASTVisitor)visitor);
        List tags = visitor.getDoclets();
        if (tags.isEmpty()) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (TagElement tag : tags) {
            if (tag == null) continue;
            String fragment = ((TextElement)tag.fragments().get(0)).getText().trim();
            fragment = fragment.replaceAll("[ ]", "");
            String name = fragment.substring("name=\"".length(), fragment.indexOf("value") - 1);
            String value = fragment.substring(fragment.indexOf("value") + "value=\"".length(), fragment.length() - 1);
            properties.put(name, value);
        }
        return properties;
    }

    private List get_IS_CS_Properties(String methodName) {
        String[] methodTags = new String[]{INTERACTION_SPEC_PROPERTIES_DOCLET_TAG_NAME, CONNECTION_SPEC_PROPERTIES_DOCLET_TAG_NAME, INTERACTION_SPEC_RETURNPROPERTIES_DOCLET_TAG_NAME};
        MethodBindingJavaDocVisitor visitor = new MethodBindingJavaDocVisitor(methodTags, methodName);
        this.astCU.accept((ASTVisitor)visitor);
        List tags = visitor.getDoclets();
        if (tags.isEmpty()) {
            return null;
        }
        ArrayList<PropertyTag> properties = new ArrayList<PropertyTag>();
        for (TagElement tag : tags) {
            String fragment;
            if (tag == null) continue;
            String tokens = fragment = ((TextElement)tag.fragments().get(0)).getText().trim();
            StringTokenizer tokenizer = new StringTokenizer(tokens, " ");
            String token = tokenizer.nextToken();
            token = tokenizer.nextToken();
            token = token.substring(0, token.indexOf("="));
            fragment = fragment.replaceAll("[ ]", "");
            PropertyTag property = new PropertyTag();
            if (tag.toString().indexOf(INTERACTION_SPEC_PROPERTIES_DOCLET_TAG_NAME) >= 0) {
                property.type = property.INTERACTION_SPEC_PROPERTY;
            } else if (tag.toString().indexOf(CONNECTION_SPEC_PROPERTIES_DOCLET_TAG_NAME) >= 0) {
                property.type = property.CONNECTION_SPEC_PROPERTY;
            } else if (tag.toString().indexOf(INTERACTION_SPEC_RETURNPROPERTIES_DOCLET_TAG_NAME) >= 0) {
                property.type = property.INTERACTION_SPEC_PROPERTY;
            }
            String name = null;
            if ("value".equals(token)) {
                name = fragment.substring("name=\"".length(), fragment.indexOf("value") - 1);
                property.value = fragment.substring(fragment.indexOf("value") + "value=\"".length(), fragment.length() - 1);
            } else if ("argumentBinding".equals(token)) {
                name = fragment.substring("name=\"".length(), fragment.indexOf("argumentBinding") - 1);
                property.argumentBinding = fragment.substring(fragment.indexOf("argumentBinding") + "argumentBinding=\"".length(), fragment.length() - 1);
            } else if ("outputBinding".equals(token)) {
                name = fragment.substring("name=\"".length(), fragment.indexOf("outputBinding") - 1);
                property.outputBinding = fragment.substring(fragment.indexOf("outputBinding") + "outputBinding=\"".length(), fragment.length() - 1);
            }
            property.name = name;
            properties.add(property);
        }
        return properties;
    }

    private SingleValuedProperty findProperty(String name, PropertyGroup group) {
        if (group == null || name == null) {
            return null;
        }
        SingleValuedProperty property = null;
        commonj.connector.metadata.discovery.properties.PropertyDescriptor[] propertyDescriptors = group.getProperties();
        int i = 0;
        while (i < propertyDescriptors.length) {
            commonj.connector.metadata.discovery.properties.PropertyDescriptor descriptor = propertyDescriptors[i];
            if (descriptor instanceof PropertyGroup ? (property = this.findProperty(name, group = (PropertyGroup)descriptor)) != null : descriptor instanceof SingleValuedProperty && (property = (SingleValuedProperty)descriptor).getName().equalsIgnoreCase(name)) {
                return property;
            }
            ++i;
        }
        return null;
    }

    private List getBusinessMethodsNames() {
        ArrayList<String> methodNames = new ArrayList<String>();
        try {
            ITypeHierarchy hierarchy = this.interfaceDefinitionBinding.newSupertypeHierarchy(this.environment.getProgressMonitor());
            IType superInterface = hierarchy.getSuperInterfaces(this.interfaceDefinitionBinding)[0];
            IMethod[] methods = superInterface.getMethods();
            int i = 0;
            while (i < methods.length) {
                methodNames.add(methods[i].getElementName());
                ++i;
            }
        }
        catch (JavaModelException e) {
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
            e.printStackTrace();
        }
        return methodNames;
    }

    private boolean isImplementsCCIRecord(IType paramIType) {
        return this.isImplementsThisRecord(paramIType, CCI_RECORD);
    }

    private boolean isImplementsMFSRecord(IType paramIType) {
        return this.isImplementsThisRecord(paramIType, MFS_RECORD);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isImplementsThisRecord(IType paramIType, String recordString) {
        try {
            if (paramIType == null) {
                return false;
            }
            String[] interfaces1 = paramIType.getSuperInterfaceNames();
            if (interfaces1 != null) {
                int i = 0;
                while (i < interfaces1.length) {
                    String superType1 = interfaces1[i];
                    if (recordString.equals(superType1)) {
                        return true;
                    }
                    ++i;
                }
            }
            ITypeHierarchy hierarchy = paramIType.newTypeHierarchy(this.environment.getProgressMonitor());
            IType[] interfaces = hierarchy.getAllInterfaces();
            int i = 0;
            while (true) {
                if (i >= interfaces.length) {
                    return false;
                }
                IType superType = interfaces[i];
                if (recordString.equals(superType.getFullyQualifiedName())) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
            e.printStackTrace();
        }
        return false;
    }

    private DataDescription findDataBindingOutputfromWrapper(IType returnIType, ServiceDescriptionFactory serviceDescriptionFactory) {
        block12: {
            if (returnIType != null) {
                URI paramTypeURI = null;
                try {
                    IField[] fields = returnIType.getFields();
                    if (fields == null) break block12;
                    int i = 0;
                    while (i < fields.length) {
                        IType fieldIType;
                        IImportDeclaration[] imports;
                        IField declaringField = fields[i];
                        String fieldType = Signature.toString((String)declaringField.getTypeSignature());
                        declaringField.getElementName();
                        ICompilationUnit cu = declaringField.getCompilationUnit();
                        if (cu != null && (imports = cu.getImports()) != null) {
                            int k = 0;
                            while (k < imports.length) {
                                IImportDeclaration import1 = imports[k];
                                String importString = import1.getSource();
                                importString = importString.replaceFirst("import ", "");
                                if ((importString = importString.replace(";", "")).endsWith(fieldType)) {
                                    fieldType = importString;
                                    break;
                                }
                                ++k;
                            }
                        }
                        if (this.isImplementsCCIRecord(fieldIType = declaringField.getJavaProject().findType(fieldType))) {
                            IResource resource;
                            if (this.isImplementsMFSRecord(fieldIType)) {
                                this.MFSCase = true;
                            }
                            if ((resource = fieldIType.getResource()) != null) {
                                String location = resource.getFullPath().toString();
                                paramTypeURI = URI.createPlatformResourceURI((String)location);
                                DataFile dataFile = serviceDescriptionFactory.createDataFile();
                                try {
                                    dataFile.setLocation(new java.net.URI(URLEncoder.encode(paramTypeURI.toString(), "UTF-8")));
                                }
                                catch (UnsupportedEncodingException e) {
                                    Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                                    ILog logger = CodegenPlugin.getDefault().getLog();
                                    logger.log((IStatus)status);
                                    e.printStackTrace();
                                }
                                DataDescription dataDescription = serviceDescriptionFactory.createDataDescription();
                                dataDescription.addDataFile((commonj.connector.metadata.description.DataFile)dataFile);
                                dataDescription.setStyle(2);
                                String nsURI = fieldIType.getPackageFragment().getElementName();
                                String localPart = fieldIType.getElementName();
                                QName fieldTypeName = QNameHelper.createQName((String)nsURI, (String)localPart);
                                dataDescription.setName(fieldTypeName);
                                return dataDescription;
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        return null;
    }

    private void createOutboundFunctionDescriptionModel() {
        final IResourceAdapterDescriptor resourceAdapterDescriptor = this.resourceAdapter;
        final String connectionSpecName = this.connectionSpecName;
        this.astCU.accept(new ASTVisitor(true){

            public boolean visit(MethodDeclaration methodDecl) {
                String methodName = methodDecl.getName().getFullyQualifiedName();
                List methodNames = J2CJavaBeanEdit.this.getBusinessMethodsNames();
                boolean isBusinessMethod = methodNames.contains(methodName);
                if (isBusinessMethod && !methodDecl.isConstructor()) {
                    String[] isTag = new String[]{J2CJavaBeanEdit.INTERACTION_SPEC_DOCLET_TAG_NAME};
                    String interactionSpecName = J2CJavaBeanEdit.this.get_IS_CS_ClassName(isTag, methodName);
                    String connectionSpecClassName = null;
                    if (connectionSpecName == null) {
                        String[] csTag = new String[]{J2CJavaBeanEdit.CONNECTION_SPEC_DOCLET_TAG_NAME};
                        connectionSpecClassName = J2CJavaBeanEdit.this.get_IS_CS_ClassName(csTag, methodName);
                    } else {
                        connectionSpecClassName = connectionSpecName;
                    }
                    try {
                        ILog logger;
                        Status status;
                        ServiceDescriptionFactory serviceDescriptionFactory = ServiceDescriptionFactory.getFactory();
                        OutboundFunctionDescription outboundFunctionDescription = serviceDescriptionFactory.createOutboundFunctionDescription();
                        outboundFunctionDescription.setName(methodName);
                        Type returnType = methodDecl.getReturnType2();
                        if (returnType != null) {
                            returnType.resolveBinding();
                            if (!returnType.isPrimitiveType()) {
                                IType returnIType1 = J2CJavaBeanEdit.this.getIType(returnType);
                                if (J2CJavaBeanEdit.this.isImplementsMFSRecord(returnIType1)) {
                                    J2CJavaBeanEdit.this.MFSCase = true;
                                    if (J2CJavaBeanEdit.this.MFSCase) {
                                        J2CJavaBeanEdit.this.exposedOutputs.put("MFSFlow", "MFSFlow");
                                    }
                                    J2CJavaBeanEdit.this.serviceDescriptionWrapper.setFunctionExposedOutputs((Map)J2CJavaBeanEdit.this.exposedOutputs);
                                }
                                if (!J2CJavaBeanEdit.this.isImplementsCCIRecord(returnIType1)) {
                                    DataDescription dataDescription1 = J2CJavaBeanEdit.this.findDataBindingOutputfromWrapper(returnIType1, serviceDescriptionFactory);
                                    if (dataDescription1 != null) {
                                        outboundFunctionDescription.addParameterDescription((ParameterDescription)dataDescription1);
                                        ArrayList<String> outputContext = new ArrayList<String>();
                                        outputContext.add(returnIType1.getFullyQualifiedName());
                                        if (J2CJavaBeanEdit.this.MFSCase) {
                                            J2CJavaBeanEdit.this.exposedOutputs.put("MFSFlow", "MFSFlow");
                                        }
                                        J2CJavaBeanEdit.this.exposedOutputs.put(methodName, outputContext);
                                        J2CJavaBeanEdit.this.serviceDescriptionWrapper.setFunctionExposedOutputs((Map)J2CJavaBeanEdit.this.exposedOutputs);
                                    }
                                } else {
                                    URI returnTypeURI = J2CJavaBeanEdit.this.getDataTypeURI(returnType);
                                    DataFile dataFile = serviceDescriptionFactory.createDataFile();
                                    try {
                                        dataFile.setLocation(new java.net.URI(URLEncoder.encode(returnTypeURI.toString(), "UTF-8")));
                                    }
                                    catch (UnsupportedEncodingException e) {
                                        Status status2 = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                                        ILog logger2 = CodegenPlugin.getDefault().getLog();
                                        logger2.log((IStatus)status2);
                                    }
                                    DataDescription dataDescription = serviceDescriptionFactory.createDataDescription();
                                    dataDescription.addDataFile((commonj.connector.metadata.description.DataFile)dataFile);
                                    dataDescription.setStyle(2);
                                    IType returnIType = J2CJavaBeanEdit.this.getIType(returnType);
                                    String nsURI = returnIType.getPackageFragment().getElementName();
                                    String localPart = returnIType.getElementName();
                                    QName returnTypeName = QNameHelper.createQName((String)nsURI, (String)localPart);
                                    dataDescription.setName(returnTypeName);
                                    outboundFunctionDescription.addParameterDescription((ParameterDescription)dataDescription);
                                }
                            }
                        }
                        HashMap<String, Object> prametersMap = new HashMap<String, Object>();
                        List params = methodDecl.parameters();
                        if (params.size() >= 1) {
                            block11: for (SingleVariableDeclaration svd : params) {
                                Type paramType = svd.getType();
                                if (paramType.isPrimitiveType()) continue;
                                paramType.resolveBinding();
                                URI paramTypeURI = J2CJavaBeanEdit.this.getDataTypeURI(paramType);
                                if (paramTypeURI == null) continue;
                                IType paramIType = J2CJavaBeanEdit.this.getIType(paramType);
                                try {
                                    ITypeHierarchy hierarchy = paramIType.newTypeHierarchy(null);
                                    IType[] interfaces = hierarchy.getAllInterfaces();
                                    int i = 0;
                                    while (i < interfaces.length) {
                                        IType superType = interfaces[i];
                                        if (J2CJavaBeanEdit.CCI_RECORD.equals(superType.getFullyQualifiedName())) {
                                            DataFile dataFile = serviceDescriptionFactory.createDataFile();
                                            try {
                                                dataFile.setLocation(new java.net.URI(URLEncoder.encode(paramTypeURI.toString(), "UTF-8")));
                                            }
                                            catch (UnsupportedEncodingException e) {
                                                Status status3 = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                                                ILog logger3 = CodegenPlugin.getDefault().getLog();
                                                logger3.log((IStatus)status3);
                                            }
                                            DataDescription dataDescription = serviceDescriptionFactory.createDataDescription();
                                            dataDescription.addDataFile((commonj.connector.metadata.description.DataFile)dataFile);
                                            dataDescription.setStyle(1);
                                            String nsURI = paramIType.getPackageFragment().getElementName();
                                            String localPart = paramIType.getElementName();
                                            QName paramTypeName = QNameHelper.createQName((String)nsURI, (String)localPart);
                                            dataDescription.setName(paramTypeName);
                                            prametersMap.put(svd.getName().getFullyQualifiedName(), dataDescription);
                                            continue block11;
                                        }
                                        ++i;
                                    }
                                }
                                catch (JavaModelException e) {
                                    Status status4 = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                                    ILog logger4 = CodegenPlugin.getDefault().getLog();
                                    logger4.log((IStatus)status4);
                                }
                            }
                        }
                        Class isClazz = resourceAdapterDescriptor.getInteractionSpecClass(interactionSpecName);
                        Class csClazz = null;
                        if (connectionSpecName != null) {
                            csClazz = resourceAdapterDescriptor.getConnectionSpecClass(connectionSpecClassName);
                        }
                        InteractionSpec interactionSpec = null;
                        ConnectionSpec connectionSpec = null;
                        try {
                            if (isClazz != null) {
                                interactionSpec = (InteractionSpec)isClazz.newInstance();
                            }
                            if (csClazz != null) {
                                connectionSpec = (ConnectionSpec)csClazz.newInstance();
                            }
                        }
                        catch (InstantiationException e) {
                            status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                            logger = CodegenPlugin.getDefault().getLog();
                            logger.log((IStatus)status);
                        }
                        catch (IllegalAccessException e) {
                            status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                            logger = CodegenPlugin.getDefault().getLog();
                            logger.log((IStatus)status);
                        }
                        List methodProperties = J2CJavaBeanEdit.this.get_IS_CS_Properties(methodName);
                        ArrayList<J2CParameterDescription> list = new ArrayList<J2CParameterDescription>();
                        ArrayList<J2CParameterDescription> listo = new ArrayList<J2CParameterDescription>();
                        if (methodProperties != null) {
                            for (PropertyTag tag : methodProperties) {
                                Class propertyType;
                                J2CParameterDescription j2cParameter;
                                if (tag.value != null) {
                                    if (tag.type == tag.INTERACTION_SPEC_PROPERTY) {
                                        J2CJavaBeanEdit.this.setBeanProperty(interactionSpec, tag.name, tag.value);
                                        continue;
                                    }
                                    if (tag.type != tag.CONNECTION_SPEC_PROPERTY) continue;
                                    J2CJavaBeanEdit.this.setBeanProperty(connectionSpec, tag.name, tag.value);
                                    continue;
                                }
                                if (tag.argumentBinding != null) {
                                    j2cParameter = serviceDescriptionFactory.createJ2CParameterDescription();
                                    propertyType = null;
                                    if (tag.type == tag.INTERACTION_SPEC_PROPERTY) {
                                        j2cParameter.setParameterType(tag.INTERACTION_SPEC_PROPERTY);
                                        propertyType = J2CJavaBeanEdit.this.getBeanPropertyType(interactionSpec, tag.name);
                                    } else if (tag.type == tag.CONNECTION_SPEC_PROPERTY) {
                                        j2cParameter.setParameterType(tag.CONNECTION_SPEC_PROPERTY);
                                        propertyType = J2CJavaBeanEdit.this.getBeanPropertyType(connectionSpec, tag.name);
                                    }
                                    j2cParameter.setPropertyType(propertyType);
                                    j2cParameter.setStyle(1);
                                    j2cParameter.setParameterName(tag.argumentBinding);
                                    j2cParameter.setPropertyName(tag.name);
                                    prametersMap.put(j2cParameter.getParameterName(), j2cParameter);
                                    list.add(j2cParameter);
                                    continue;
                                }
                                if (tag.outputBinding == null) continue;
                                j2cParameter = serviceDescriptionFactory.createJ2CParameterDescription();
                                propertyType = null;
                                if (tag.type == tag.INTERACTION_SPEC_PROPERTY) {
                                    j2cParameter.setParameterType(tag.INTERACTION_SPEC_PROPERTY);
                                    propertyType = J2CJavaBeanEdit.this.getBeanPropertyType(interactionSpec, tag.name);
                                } else if (tag.type == tag.CONNECTION_SPEC_PROPERTY) {
                                    j2cParameter.setParameterType(tag.CONNECTION_SPEC_PROPERTY);
                                    propertyType = J2CJavaBeanEdit.this.getBeanPropertyType(connectionSpec, tag.name);
                                }
                                j2cParameter.setPropertyType(propertyType);
                                j2cParameter.setStyle(2);
                                j2cParameter.setParameterName(tag.outputBinding);
                                j2cParameter.setPropertyName(tag.name);
                                outboundFunctionDescription.addParameterDescription((ParameterDescription)j2cParameter);
                                listo.add(j2cParameter);
                            }
                        }
                        if (prametersMap.size() > 0) {
                            for (SingleVariableDeclaration svd : params) {
                                String paramName = svd.getName().getFullyQualifiedName();
                                com.ibm.adapter.emd.extension.description.spi.ParameterDescription parameter = (com.ibm.adapter.emd.extension.description.spi.ParameterDescription)prametersMap.get(paramName);
                                if (parameter == null) continue;
                                outboundFunctionDescription.addParameterDescription((ParameterDescription)parameter);
                            }
                        }
                        outboundFunctionDescription.setInteractionSpec(interactionSpec);
                        J2CJavaBeanEdit.this.outboundServiceDescription.addFunctionDescription((FunctionDescription)outboundFunctionDescription);
                    }
                    catch (URISyntaxException e) {
                        Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                        ILog logger = CodegenPlugin.getDefault().getLog();
                        logger.log((IStatus)status);
                    }
                }
                return false;
            }
        });
    }

    private IType getIType(Type astType) {
        if (astType.isPrimitiveType()) {
            return null;
        }
        String typeName = null;
        IType type = null;
        try {
            if (astType.isSimpleType()) {
                typeName = ((SimpleType)astType).getName().getFullyQualifiedName();
            } else if (astType.isQualifiedType()) {
                typeName = ((QualifiedType)astType).getName().getFullyQualifiedName();
            }
            type = this.project.findType(typeName);
            if (type == null) {
                type = this.getType(typeName, this.project);
            }
            if (type == null) {
                type = this.resolveTypeInAnotherProject(typeName);
            }
        }
        catch (JavaModelException e) {
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
        }
        return type;
    }

    private URI getDataTypeURI(Type astType) {
        IResource resource;
        if (astType.isPrimitiveType()) {
            return null;
        }
        IType type = this.getIType(astType);
        URI uri = null;
        if (type != null && (resource = type.getResource()) != null) {
            String location = resource.getFullPath().toString();
            uri = URI.createPlatformResourceURI((String)location);
        }
        return uri;
    }

    private IType resolveTypeInAnotherProject(String typeName) {
        IType type = null;
        try {
            String[] requiredProjects = this.project.getRequiredProjectNames();
            int i = 0;
            while (i < requiredProjects.length) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(requiredProjects[i]);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                type = javaProject.findType(typeName);
                if (type == null) {
                    type = this.getType(typeName, javaProject);
                }
                if (type == null) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (JavaModelException e) {
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
        }
        return type;
    }

    private IType getType(String typeName, IJavaProject project) {
        IType type = null;
        try {
            IPackageFragmentRoot srcPackage = ProjectUtils.getSourcePackage((IJavaProject)project);
            IJavaElement[] elements = srcPackage.getChildren();
            int i = 0;
            while (i < elements.length) {
                IPackageFragment fragment;
                if (!(elements[i] instanceof IPackageFragment) || (type = project.findType(String.valueOf((fragment = (IPackageFragment)elements[i]).getElementName()) + "." + typeName)) == null) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (JavaModelException e) {
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
        }
        return type;
    }

    public J2CServiceDescription getOutboundServiceDescriptionModel() {
        try {
            if (this.managedConnectionFactoryName != null) {
                if (this.resourceAdapter == null) {
                    this.resourceAdapter = this.findMatchingResourceAdapter();
                }
                OutboundServiceDescription outboundServiceDescription = ServiceDescriptionFactory.getFactory().createOutboundServiceDescription();
                outboundServiceDescription.setName(this.interfaceName);
                MetadataEdit metadataEdit = ServiceDiscoveryFactory.getFactory().createMetadataEdit(this.resourceAdapter);
                OutboundConnectionType connectionType = metadataEdit.getOutboundConnectionType(this.managedConnectionFactoryName);
                ManagedConnectionFactory mcfBean = connectionType.createOutboundConnectionBeans().getManagedConnectionFactoryJavaBean();
                Map mcfPropertiesMap = this.getMCFPropertiesMapping();
                if (mcfPropertiesMap != null && !mcfPropertiesMap.isEmpty()) {
                    Set entrySet = mcfPropertiesMap.entrySet();
                    for (Map.Entry entry : entrySet) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        this.setBeanProperty(mcfBean, key, value);
                    }
                }
                OutboundConnectionConfiguration outboundConnectionConfiguration = connectionType.createOutboundConnectionConfiguration();
                if (mcfPropertiesMap != null && !mcfPropertiesMap.isEmpty()) {
                    PropertyGroup mcfPG = outboundConnectionConfiguration.createManagedConnectionFactoryProperties();
                    connectionType.synchronizeFromManagedConnectionFactoryToPropertyGroup(mcfBean, mcfPG);
                    outboundConnectionConfiguration.applyManagedConnectionFactoryProperties(mcfPG);
                }
                outboundServiceDescription.setOutboundConnectionAdvancedConfiguration(outboundConnectionConfiguration);
                this.outboundServiceDescription = outboundServiceDescription;
                J2CServiceDescription j2cServiceDescription = ServiceDescriptionFactory.getFactory().createJ2CServiceDescription();
                j2cServiceDescription.setResourceAdapterDescriptor(this.resourceAdapter);
                j2cServiceDescription.setJNDILookupName(this.jndiLookupName);
                j2cServiceDescription.setServiceDescription((ServiceDescription)outboundServiceDescription);
                this.serviceDescriptionWrapper = j2cServiceDescription;
                this.createOutboundFunctionDescriptionModel();
            }
        }
        catch (BaseException e) {
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
        }
        catch (MetadataException e) {
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
        }
        return this.serviceDescriptionWrapper;
    }

    public String getJNDILookupName() {
        return this.jndiLookupName;
    }

    public void setManagedConnectionFactoryName(String managedConnectionFactoryName) {
        this.managedConnectionFactoryName = managedConnectionFactoryName;
    }

    public void setResourceAdapter(IResourceAdapterDescriptor resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    private Class<?> getPrimitiveTypeFromWrapper(Class<?> wrapperType) {
        if (wrapperType == Boolean.class) {
            return Boolean.TYPE;
        }
        if (wrapperType == Byte.class) {
            return Byte.TYPE;
        }
        if (wrapperType == Character.class) {
            return Character.TYPE;
        }
        if (wrapperType == Double.class) {
            return Double.TYPE;
        }
        if (wrapperType == Float.class) {
            return Float.TYPE;
        }
        if (wrapperType == Integer.class) {
            return Integer.TYPE;
        }
        if (wrapperType == Long.class) {
            return Long.TYPE;
        }
        return null;
    }

    private void setBeanProperty(Object bean, String tagName, String tagValue) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] beanProperties = beanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < beanProperties.length) {
                if (beanProperties[i].getReadMethod() != null && beanProperties[i].getWriteMethod() != null && beanProperties[i].getName().equals(tagName)) {
                    Object[] value = this.getParameterValue(beanProperties[i].getPropertyType().getName(), tagValue);
                    beanProperties[i].getWriteMethod().invoke(bean, value);
                    return;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
        }
    }

    private Object getRuntimeValue(Class<?> propertyType, String dataValue) {
        String javaTypeName = propertyType.getName();
        Object runtimeObject = null;
        Class<?>[] parameter = null;
        Object[] parameterValue = null;
        try {
            parameter = this.getParameterType(javaTypeName);
            Class<?> clazz = Class.forName(javaTypeName);
            Constructor<?> constructor = clazz.getConstructor(parameter);
            parameterValue = "java.lang.Character".equals(javaTypeName) ? new Object[]{new Character(dataValue.toCharArray()[0])} : new Object[]{dataValue};
            runtimeObject = constructor.newInstance(parameterValue);
        }
        catch (Exception e) {
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
        }
        return runtimeObject;
    }

    private Class<?> getBeanPropertyType(Object bean, String tagName) {
        block5: {
            if (bean != null) break block5;
            return null;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] beanProperties = beanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < beanProperties.length) {
                if (beanProperties[i].getReadMethod() != null && beanProperties[i].getWriteMethod() != null && beanProperties[i].getName().equals(tagName)) {
                    return beanProperties[i].getPropertyType();
                }
                ++i;
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            ILog logger = CodegenPlugin.getDefault().getLog();
            logger.log((IStatus)status);
        }
        return null;
    }

    private Class<?>[] getParameterType(String javaTypeName) {
        Class[] parameterType = null;
        if ("boolean".equals(javaTypeName)) {
            parameterType = new Class[]{Boolean.TYPE};
        } else if ("byte".equals(javaTypeName)) {
            parameterType = new Class[]{Byte.TYPE};
        } else if ("char".equals(javaTypeName)) {
            parameterType = new Class[]{Character.TYPE};
        } else if ("short".equals(javaTypeName)) {
            parameterType = new Class[]{Short.TYPE};
        } else if ("int".equals(javaTypeName)) {
            parameterType = new Class[]{Integer.TYPE};
        } else if ("long".equals(javaTypeName)) {
            parameterType = new Class[]{Long.TYPE};
        } else if ("float".equals(javaTypeName)) {
            parameterType = new Class[]{Float.TYPE};
        } else if ("double".equals(javaTypeName)) {
            parameterType = new Class[]{Double.TYPE};
        } else if ("java.lang.Boolean".equals(javaTypeName)) {
            parameterType = new Class[]{Boolean.class};
        } else if ("java.lang.Byte".equals(javaTypeName)) {
            parameterType = new Class[]{Byte.class};
        } else if ("java.lang.Character".equals(javaTypeName)) {
            parameterType = new Class[]{Character.class};
        } else if ("java.lang.Short".equals(javaTypeName)) {
            parameterType = new Class[]{Short.class};
        } else if ("java.lang.Integer".equals(javaTypeName)) {
            parameterType = new Class[]{Integer.class};
        } else if ("java.lang.Long".equals(javaTypeName)) {
            parameterType = new Class[]{Long.class};
        } else if ("java.lang.Float".equals(javaTypeName)) {
            parameterType = new Class[]{Float.class};
        } else if ("java.lang.Double".equals(javaTypeName)) {
            parameterType = new Class[]{Double.class};
        } else if ("java.lang.String".equals(javaTypeName)) {
            parameterType = new Class[]{String.class};
        }
        return parameterType;
    }

    private Object[] getParameterValue(String javaTypeName, String dataValue) {
        Object[] parameterValue = null;
        if ("boolean".equals(javaTypeName) || "java.lang.Boolean".equals(javaTypeName)) {
            parameterValue = new Object[]{new Boolean(dataValue)};
        } else if ("byte".equals(javaTypeName) || "java.lang.Byte".equals(javaTypeName)) {
            parameterValue = new Object[]{new Byte(dataValue)};
        } else if ("char".equals(javaTypeName)) {
            parameterValue = new Object[]{new Character(dataValue.charAt(0))};
        } else if ("short".equals(javaTypeName) || "java.lang.Short".equals(javaTypeName)) {
            parameterValue = new Object[]{new Short(dataValue)};
        } else if ("int".equals(javaTypeName) || "java.lang.Integer".equals(javaTypeName)) {
            parameterValue = new Object[]{new Integer(dataValue)};
        } else if ("long".equals(javaTypeName) || "java.lang.Long".equals(javaTypeName)) {
            parameterValue = new Object[]{new Long(dataValue)};
        } else if ("float".equals(javaTypeName) || "java.lang.Float".equals(javaTypeName)) {
            parameterValue = new Object[]{new Float(dataValue)};
        } else if ("double".equals(javaTypeName) || "java.lang.Double".equals(javaTypeName)) {
            parameterValue = new Object[]{new Double(dataValue)};
        } else if ("java.lang.Character".equals(javaTypeName)) {
            parameterValue = new Object[]{new Character(dataValue.toCharArray()[0])};
        } else if ("java.lang.String".equals(javaTypeName)) {
            parameterValue = new Object[]{new String(dataValue)};
        }
        return parameterValue;
    }

    private class PropertyTag {
        int CONNECTION_SPEC_PROPERTY = 0;
        int INTERACTION_SPEC_PROPERTY = 1;
        int type;
        String name;
        String value;
        String argumentBinding;
        String outputBinding;

        private PropertyTag() {
        }
    }
}

