/*
 * Decompiled with CFR 0.152.
 */
package lpg.lpgjavaruntime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import lpg.lpgjavaruntime.IntSegmentedTuple;
import lpg.lpgjavaruntime.ParseErrorCodes;
import lpg.lpgjavaruntime.PrsStream;
import lpg.lpgjavaruntime.TokenStream;

public class LexStream
implements TokenStream,
ParseErrorCodes {
    static final int DEFAULT_TAB = 1;
    private int index = -1;
    private int streamLength = 0;
    private char[] inputChars;
    private String fileName;
    private IntSegmentedTuple lineOffsets;
    private int tab = 1;
    private PrsStream prsStream;

    public LexStream() {
        this.lineOffsets = new IntSegmentedTuple(12);
        this.setLineOffset(-1);
    }

    public LexStream(int tab) {
        this();
        this.tab = tab;
    }

    public LexStream(String fileName) throws IOException {
        this(fileName, 1);
    }

    public LexStream(String fileName, int tab) throws IOException {
        this(tab);
        try {
            File f = new File(fileName);
            InputStreamReader in = new InputStreamReader(new FileInputStream(f));
            char[] buffer = new char[(int)f.length()];
            in.read(buffer, 0, buffer.length);
            this.initialize(buffer, fileName);
        }
        catch (Exception e) {
            IOException io = new IOException();
            System.err.println(e.getMessage());
            e.printStackTrace();
            throw io;
        }
    }

    public LexStream(char[] inputChars, String fileName) {
        this();
        this.initialize(inputChars, fileName);
    }

    public LexStream(IntSegmentedTuple lineOffsets, char[] inputChars, String fileName) {
        this.initialize(lineOffsets, inputChars, fileName);
    }

    public LexStream(char[] inputChars, String fileName, int tab) {
        this(tab);
        this.initialize(inputChars, fileName);
    }

    public LexStream(IntSegmentedTuple lineOffsets, char[] inputChars, String fileName, int tab) {
        this.tab = tab;
        this.initialize(lineOffsets, inputChars, fileName);
    }

    public void initialize(char[] inputChars, String fileName) {
        this.setInputChars(inputChars);
        this.setStreamLength(inputChars.length);
        this.setFileName(fileName);
        this.computeLineOffsets();
    }

    public void initialize(IntSegmentedTuple lineOffsets, char[] inputChars, String fileName) {
        this.lineOffsets = lineOffsets;
        this.setInputChars(inputChars);
        this.setStreamLength(inputChars.length);
        this.setFileName(fileName);
    }

    public void computeLineOffsets() {
        this.lineOffsets.reset();
        this.setLineOffset(-1);
        int i = 0;
        while (i < this.inputChars.length) {
            if (this.inputChars[i] == '\n') {
                this.setLineOffset(i);
            }
            ++i;
        }
    }

    public void setInputChars(char[] inputChars) {
        this.inputChars = inputChars;
        this.index = -1;
    }

    public char[] getInputChars() {
        return this.inputChars;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void setLineOffsets(IntSegmentedTuple lineOffsets) {
        this.lineOffsets = lineOffsets;
    }

    public IntSegmentedTuple getLineOffsets() {
        return this.lineOffsets;
    }

    public void setTab(int tab) {
        this.tab = tab;
    }

    public int getTab() {
        return this.tab;
    }

    public void setStreamIndex(int index) {
        this.index = index;
    }

    public int getStreamIndex() {
        return this.index;
    }

    public void setStreamLength(int streamLength) {
        this.streamLength = streamLength;
    }

    @Override
    public int getStreamLength() {
        return this.streamLength;
    }

    public void setLineOffset(int i) {
        this.lineOffsets.add(i);
    }

    public int getLineOffset(int i) {
        return this.lineOffsets.get(i);
    }

    public void setPrsStream(PrsStream prsStream) {
        this.prsStream = prsStream;
    }

    public PrsStream getPrsStream() {
        return this.prsStream;
    }

    public String[] orderedExportedSymbols() {
        return null;
    }

    public char getCharValue(int i) {
        return this.inputChars[i];
    }

    public int getLine() {
        return this.getLineCount();
    }

    public int getLineCount() {
        return this.lineOffsets.size() - 1;
    }

    public int getLineNumberOfCharAt(int i) {
        int index = this.lineOffsets.binarySearch(i);
        return index < 0 ? -index : (index == 0 ? 1 : index);
    }

    public int getColumnOfCharAt(int i) {
        int lineNo = this.getLineNumberOfCharAt(i);
        int start = this.lineOffsets.get(lineNo - 1);
        if (start + 1 >= this.streamLength) {
            return 1;
        }
        int k = start + 1;
        while (k < i) {
            if (this.inputChars[k] == '\t') {
                int offset = k - start - 1;
                start -= this.tab - 1 - offset % this.tab;
            }
            ++k;
        }
        return i - start;
    }

    void reportError(int i) {
        this.reportError(i, i);
    }

    @Override
    public int getToken() {
        this.index = this.getNext(this.index);
        return this.index;
    }

    @Override
    public int getToken(int end_token) {
        this.index = this.index < end_token ? this.getNext(this.index) : this.streamLength;
        return this.index;
    }

    @Override
    public int getKind(int i) {
        return 0;
    }

    int next(int i) {
        return this.getNext(i);
    }

    @Override
    public int getNext(int i) {
        return ++i < this.streamLength ? i : this.streamLength;
    }

    int previous(int i) {
        return this.getPrevious(i);
    }

    @Override
    public int getPrevious(int i) {
        return i <= 0 ? 0 : i - 1;
    }

    @Override
    public String getName(int i) {
        return i >= this.getStreamLength() ? "" : "" + this.getCharValue(i);
    }

    @Override
    public int peek() {
        return this.getNext(this.index);
    }

    @Override
    public void reset(int i) {
        this.index = i - 1;
    }

    @Override
    public void reset() {
        this.index = -1;
    }

    @Override
    public int badToken() {
        return 0;
    }

    @Override
    public int getLine(int i) {
        return this.getLineNumberOfCharAt(i);
    }

    @Override
    public int getColumn(int i) {
        return this.getColumnOfCharAt(i);
    }

    @Override
    public int getEndLine(int i) {
        return this.getLine(i);
    }

    @Override
    public int getEndColumn(int i) {
        return this.getColumnOfCharAt(i);
    }

    @Override
    public boolean afterEol(int i) {
        return i < 1 ? true : this.getLineNumberOfCharAt(i - 1) < this.getLineNumberOfCharAt(i);
    }

    @Override
    public void makeToken(int startLoc, int endLoc, int kind) {
        if (this.prsStream != null) {
            this.prsStream.makeToken(startLoc, endLoc, kind);
        } else {
            this.reportError(startLoc, endLoc);
        }
    }

    @Override
    public int getFirstErrorToken(int i) {
        return i;
    }

    @Override
    public int getLastErrorToken(int i) {
        return i;
    }

    @Override
    public int makeErrorToken(int firsttok, int lasttok, int errortok, int kind) {
        return 0;
    }

    @Override
    public void reportError(int i, String code) {
        this.reportError(i, i);
    }

    @Override
    public void reportError(int left_loc, int right_loc) {
        int end_loc;
        int errorCode = right_loc >= this.streamLength ? 10 : (left_loc == right_loc ? 0 : 11);
        int n = end_loc = left_loc == right_loc ? right_loc : right_loc - 1;
        String tokenText = errorCode == 10 ? "End-of-file " : (errorCode == 11 ? "\"" + new String(this.inputChars, left_loc, right_loc - left_loc) + "\" " : "\"" + this.getCharValue(left_loc) + "\" ");
        String locationInfo = this.getFileName() + ":" + this.getLineNumberOfCharAt(left_loc) + ":" + this.getColumnOfCharAt(left_loc) + ":" + this.getLineNumberOfCharAt(end_loc) + ":" + this.getColumnOfCharAt(end_loc) + ": ";
        this.reportError(errorCode, locationInfo, tokenText);
    }

    @Override
    public void reportError(int errorCode, String locationInfo, String tokenText) {
        System.out.println(locationInfo + tokenText + errorMsgText[errorCode]);
    }

    @Override
    public void reportError(int errorCode, String locationInfo, int leftToken, int rightToken, String tokenText) {
        System.out.println(locationInfo + tokenText + errorMsgText[errorCode]);
    }
}

