/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.testcase.model;

import java.util.ArrayList;
import java.util.List;

public class TestCaseNode {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String name;
    protected TestCaseNode parentNode;
    protected List<TestCaseNode> children;

    public TestCaseNode(String name, TestCaseNode parentNode) {
        this.name = name;
        this.parentNode = parentNode;
        this.children = new ArrayList<TestCaseNode>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TestCaseNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(TestCaseNode parent) {
        this.parentNode = parent;
    }

    public List<TestCaseNode> getChildren() {
        return this.children;
    }

    public void addChild(TestCaseNode child) {
        child.setParentNode(this);
        this.children.add(child);
    }

    public void addChildAfter(TestCaseNode afterThisChild, TestCaseNode child) {
        child.setParentNode(this);
        int indexToAddAfter = this.children.indexOf(afterThisChild);
        this.children.add(indexToAddAfter + 1, child);
    }

    public void addChildren(List<TestCaseNode> newChildren) {
        for (TestCaseNode tcn : newChildren) {
            this.addChild(tcn);
        }
    }

    public void removeChildNode(TestCaseNode child) {
        this.children.remove(child);
        child.setParentNode(null);
    }

    public void clearChildren() {
        this.children.clear();
    }

    public String toString() {
        return this.getName();
    }
}

