/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.testcase.model;

import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.im.ims.workbench.transaction.testcase.model.TestCaseNode;
import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import com.ibm.ims.transaction.messages.MessagePayloadManager;
import com.ibm.ims.transaction.model.FieldValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IOMessageNode
extends TestCaseNode {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int type;
    private MessageType messageType;
    private MessagePayloadManager mpm;

    public IOMessageNode(MessageType messageType, int type, MessagePayloadManager mpm, TestCaseNode parentNode) throws UnsupportedTypeConversion, IOException {
        super(messageType.getName(), parentNode);
        this.type = type;
        this.messageType = messageType;
        this.mpm = mpm;
    }

    public int getType() {
        return this.type;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public MessagePayloadManager getMessagePayloadManager() {
        return this.mpm;
    }

    public List<FieldValue> getFieldValueList(int segmentIx, boolean rebuildFieldList) throws UnsupportedTypeConversion, IOException, ConversionException {
        return this.mpm.getFieldValueList(segmentIx, rebuildFieldList);
    }

    public List<FieldValue> getAllFieldValueList() throws UnsupportedTypeConversion, IOException, ConversionException {
        ArrayList<FieldValue> retVal = new ArrayList<FieldValue>();
        int numSegments = this.mpm.getNumSegments();
        int i = 0;
        while (i < numSegments) {
            retVal.addAll(this.mpm.getFieldValueList(i, false));
            ++i;
        }
        return retVal;
    }

    public int getIndexOfSegment(SegmentType segType) {
        int retVal = -1;
        List segTypeList = this.messageType.getSegment();
        int i = 0;
        while (i < segTypeList.size()) {
            SegmentType currSegType = (SegmentType)segTypeList.get(i);
            if (currSegType == segType) {
                retVal = i;
                break;
            }
            ++i;
        }
        return retVal;
    }
}

