/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.model;

import com.ibm.im.ims.metadata.transaction.ApplicationDatatypeType;
import com.ibm.im.ims.metadata.transaction.DatatypeType;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.im.ims.transaction.controller.datastructure.DBDConstants;
import com.ibm.im.ims.transaction.model.utilities.ModelException;
import com.ibm.im.ims.workbench.transaction.model.FieldModel;
import com.ibm.im.ims.workbench.transaction.model.TranDataStructureModel;
import com.ibm.im.ims.workbench.transaction.model.TranDataStructuresFolder;
import com.ibm.im.ims.workbench.transaction.model.TranTreeObject;
import com.ibm.im.ims.workbench.transaction.model.TranTreeParent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TranSegmentModel
extends TranTreeParent {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SegmentType segment;
    private Vector<FieldModel> commonFieldList = null;

    public TranSegmentModel(String name, SegmentType segment, TranTreeParent parent) {
        super(name, parent);
        this.segment = segment;
    }

    public TranSegmentModel(String name, TranTreeParent parent) {
        super(name, parent);
    }

    public TranSegmentModel(TranSegmentModel another) {
        super(another);
        this.segment = new SegmentType(another.getSegment());
    }

    public SegmentType getSegment() {
        return this.segment;
    }

    public void deleteSegment() {
        this.segment = null;
    }

    @Override
    public void removeFields(String[] selectedFields) {
        super.removeFields(selectedFields);
        this.segment.removeFields(selectedFields);
    }

    public Vector<FieldModel> getFieldList() throws ModelException {
        Vector clonedFieldList = null;
        this.buildFieldList();
        clonedFieldList = (Vector)this.commonFieldList.clone();
        return clonedFieldList;
    }

    private void buildFieldList() throws ModelException {
        Vector<FieldType> fieldTypeList = this.getTopLevelFieldTypes();
        this.clearStartInfo(fieldTypeList);
        TranSegmentModel.updateFieldStartValues(fieldTypeList, null, false);
        this.commonFieldList = TranSegmentModel.buildOrderedFieldList(fieldTypeList, null);
    }

    public void updateSegmentStartValues() throws ModelException {
        Vector<FieldType> fieldTypeList = this.getTopLevelFieldTypes();
        this.clearStartInfo(fieldTypeList);
        TranSegmentModel.updateFieldStartValues(fieldTypeList, null, false);
    }

    public Vector<FieldType> getTopLevelFieldTypes() {
        Vector<FieldType> fieldTypeList = new Vector<FieldType>();
        TranDataStructuresFolder dsFolder = (TranDataStructuresFolder)this.getChildren()[0];
        TranTreeObject[] tranTreeObjectArray = dsFolder.getChildren();
        int n = tranTreeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TranTreeObject dsNode = tranTreeObjectArray[n2];
            fieldTypeList.add(((TranDataStructureModel)dsNode).getField());
            ++n2;
        }
        return fieldTypeList;
    }

    public static Vector<FieldModel> buildOrderedFieldList(List<FieldType> fieldList, FieldModel parentField) throws ModelException {
        Vector<FieldModel> retVal = new Vector<FieldModel>();
        Vector<FieldModel> firstLevelSubFields = new Vector<FieldModel>();
        for (FieldType fieldType : fieldList) {
            FieldModel field = new FieldModel(fieldType);
            field.setParentField(parentField);
            TranSegmentModel.addFieldInOrder(retVal, field);
            TranSegmentModel.addFieldInOrder(firstLevelSubFields, field);
        }
        if (parentField != null) {
            parentField.setChildFields(firstLevelSubFields);
        }
        int i = 0;
        while (i < retVal.size()) {
            FieldModel currField = retVal.get(i);
            if (currField.hasSubFields()) {
                Vector<FieldModel> subFields = TranSegmentModel.buildOrderedFieldList(currField.getFieldType().getField(), currField);
                int j = 0;
                while (j < subFields.size()) {
                    FieldModel subField = subFields.get(j);
                    retVal.insertElementAt(subField, ++i);
                    ++j;
                }
            }
            ++i;
        }
        return retVal;
    }

    public static void addFieldInOrder(Vector<FieldModel> fieldList, FieldModel newField) throws ModelException {
        String redefinedField = newField.getRedefines();
        String startAfter = newField.getStartAfter();
        if (redefinedField != null && !redefinedField.isEmpty()) {
            TranSegmentModel.addFieldAfter(fieldList, redefinedField, newField);
        } else if (startAfter != null && !startAfter.isEmpty()) {
            TranSegmentModel.addFieldAfter(fieldList, startAfter, newField);
        } else if (fieldList.isEmpty()) {
            fieldList.add(newField);
        } else {
            int startPos = newField.getStartOrRelstart();
            int i = 0;
            while (i < fieldList.size()) {
                int currFieldStart;
                FieldModel currField = fieldList.get(i);
                String currStartAfter = currField.getStartAfter();
                if ((currStartAfter == null || currStartAfter.isEmpty()) && startPos < (currFieldStart = currField.getStartOrRelstart())) {
                    fieldList.insertElementAt(newField, i);
                    return;
                }
                ++i;
            }
            fieldList.add(newField);
        }
    }

    private static void addFieldAfter(Vector<FieldModel> fieldList, String startAfter, FieldModel newField) throws ModelException {
        boolean startAfterFieldFound = false;
        int i = 0;
        while (i < fieldList.size()) {
            FieldModel currField = fieldList.get(i);
            if (startAfter.equals(currField.getName())) {
                String redefinesStr = currField.getRedefines();
                if (redefinesStr != null && !redefinesStr.isEmpty()) {
                    int j = i + 1;
                    while (j < fieldList.size()) {
                        FieldModel potentialRedefinesGroupMember = fieldList.get(j);
                        String potentialRedefinedName = potentialRedefinesGroupMember.getRedefines();
                        if (potentialRedefinedName == null || potentialRedefinedName.isEmpty() || j == fieldList.size() - 1) {
                            fieldList.insertElementAt(newField, j + 1);
                            startAfterFieldFound = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (startAfterFieldFound) break;
                fieldList.insertElementAt(newField, i + 1);
                startAfterFieldFound = true;
                break;
            }
            ++i;
        }
        if (!startAfterFieldFound) {
            throw new ModelException("Internal Error: While building field list the new field " + newField.getName() + " is supposed to start after " + startAfter + " , which was not found in the peer field list.");
        }
    }

    public static boolean updateFieldStartValues(List<FieldType> childFieldList, FieldType parentField, boolean dynBoundedStructureAbove) throws ModelException {
        DatatypeType dt;
        ApplicationDatatypeType adt;
        boolean inRelStartMode = false;
        boolean parentIsArray = false;
        boolean dynBoundedStructureHere = false;
        boolean dynBoundedStructureBelow = false;
        int prevFieldOrRedefinesGroupLength = 0;
        int totalSizeOfFields = 0;
        Iterator<FieldType> fieldIter = childFieldList.iterator();
        if (parentField != null && (adt = parentField.getApplicationDatatype()) != null && (dt = adt.getDatatype()) == DatatypeType.ARRAY) {
            parentIsArray = true;
        }
        if (parentIsArray || dynBoundedStructureAbove) {
            inRelStartMode = true;
        }
        if (inRelStartMode) {
            prevField = null;
            while (fieldIter.hasNext()) {
                List subFields;
                String currDependsField;
                currChildField = fieldIter.next();
                TranSegmentModel.updateEmptyStructOrArraySize(currChildField);
                if (dynBoundedStructureHere) {
                    if (TranSegmentModel.isRedefiningField(currChildField)) {
                        currChildField.setStartAfter(prevField.getStartAfter());
                        currChildField.setStartPos(null);
                        currChildField.setRelativeStart(null);
                    } else {
                        currChildField.setStartAfter(prevField.getName());
                        currChildField.setStartPos(null);
                        currChildField.setRelativeStart(null);
                    }
                } else if (TranSegmentModel.isRedefiningField(currChildField)) {
                    currChildField.setRelativeStart(prevField.getRelativeStart());
                    currChildField.setStartPos(null);
                    currChildField.setStartAfter(null);
                } else {
                    int relStart = 1;
                    if (prevField != null) {
                        relStart = prevField.getRelativeStart() + prevFieldOrRedefinesGroupLength;
                    }
                    currChildField.setRelativeStart(Integer.valueOf(relStart));
                    currChildField.setStartPos(null);
                    currChildField.setStartAfter(null);
                }
                if (!dynBoundedStructureHere && (currDependsField = currChildField.getDependsOn()) != null && !currDependsField.isEmpty()) {
                    dynBoundedStructureHere = true;
                }
                if ((subFields = currChildField.getField()) != null && subFields.size() > 0) {
                    boolean dynBoundedStructureBelowCurr = TranSegmentModel.updateFieldStartValues(subFields, currChildField, parentIsArray || dynBoundedStructureHere || dynBoundedStructureAbove);
                    if (!dynBoundedStructureBelow) {
                        dynBoundedStructureBelow = dynBoundedStructureBelowCurr;
                    }
                    if (dynBoundedStructureBelowCurr) {
                        dynBoundedStructureHere = true;
                    }
                }
                int currLength = TranSegmentModel.getLength(currChildField);
                if (TranSegmentModel.isRedefiningField(currChildField)) {
                    if (currLength > prevFieldOrRedefinesGroupLength) {
                        totalSizeOfFields += currLength - prevFieldOrRedefinesGroupLength;
                        prevFieldOrRedefinesGroupLength = currLength;
                    }
                } else {
                    prevFieldOrRedefinesGroupLength = currLength;
                    totalSizeOfFields += prevFieldOrRedefinesGroupLength;
                }
                prevField = currChildField;
            }
        } else {
            prevField = null;
            while (fieldIter.hasNext()) {
                List subFields;
                String dependsOnField;
                DatatypeType dt2;
                ApplicationDatatypeType adt2;
                currChildField = fieldIter.next();
                TranSegmentModel.updateEmptyStructOrArraySize(currChildField);
                Integer currFieldStart = currChildField.getStartPos();
                if (currFieldStart == null || currFieldStart == 0) {
                    Integer relStart = currChildField.getRelativeStart();
                    if (relStart != null && relStart > 0) {
                        if (parentField != null) {
                            currChildField.setStartPos(Integer.valueOf(parentField.getStartPos() + relStart - 1));
                            currChildField.setRelativeStart(null);
                            currChildField.setStartAfter(null);
                        } else {
                            currChildField.setStartPos(relStart);
                            currChildField.setRelativeStart(null);
                            currChildField.setStartAfter(null);
                        }
                    } else if (prevField == null) {
                        if (parentField != null) {
                            currChildField.setStartPos(parentField.getStartPos());
                            currChildField.setStartAfter(null);
                            currChildField.setRelativeStart(null);
                        } else {
                            currChildField.setStartPos(Integer.valueOf(1));
                            currChildField.setStartAfter(null);
                            currChildField.setRelativeStart(null);
                        }
                    } else if (dynBoundedStructureHere) {
                        if (TranSegmentModel.isRedefiningField(currChildField)) {
                            String prevStartAfterStr = prevField.getStartAfter();
                            if (prevStartAfterStr != null && !prevStartAfterStr.isEmpty()) {
                                currChildField.setStartAfter(prevStartAfterStr);
                                currChildField.setStartPos(null);
                                currChildField.setRelativeStart(null);
                            } else {
                                currChildField.setStartAfter(null);
                                currChildField.setStartPos(prevField.getStartPos());
                                currChildField.setRelativeStart(null);
                            }
                        } else {
                            String prevStartAfterStr = prevField.getStartAfter();
                            if (prevStartAfterStr != null && !prevStartAfterStr.isEmpty() || TranSegmentModel.isDynamic(prevField)) {
                                currChildField.setStartAfter(prevField.getName());
                                currChildField.setStartPos(null);
                                currChildField.setRelativeStart(null);
                            } else {
                                currChildField.setStartAfter(null);
                                currChildField.setStartPos(Integer.valueOf(prevField.getStartPos() + prevFieldOrRedefinesGroupLength));
                                currChildField.setRelativeStart(null);
                            }
                        }
                    } else if (TranSegmentModel.isRedefiningField(currChildField)) {
                        currChildField.setStartAfter(null);
                        currChildField.setStartPos(prevField.getStartPos());
                        currChildField.setRelativeStart(null);
                    } else {
                        currChildField.setStartAfter(null);
                        currChildField.setStartPos(Integer.valueOf(prevField.getStartPos() + prevFieldOrRedefinesGroupLength));
                        currChildField.setRelativeStart(null);
                    }
                }
                if (!dynBoundedStructureHere && (adt2 = currChildField.getApplicationDatatype()) != null && (dt2 = adt2.getDatatype()) == DatatypeType.ARRAY && (dependsOnField = currChildField.getDependsOn()) != null && !dependsOnField.isEmpty()) {
                    dynBoundedStructureHere = true;
                }
                if ((subFields = currChildField.getField()) != null && subFields.size() > 0) {
                    boolean dynBoundedStructureBelowCurr = TranSegmentModel.updateFieldStartValues(subFields, currChildField, parentIsArray || dynBoundedStructureHere || dynBoundedStructureAbove);
                    if (!dynBoundedStructureBelow) {
                        dynBoundedStructureBelow = dynBoundedStructureBelowCurr;
                    }
                    if (dynBoundedStructureBelowCurr) {
                        dynBoundedStructureHere = true;
                    }
                }
                int currLength = TranSegmentModel.getLength(currChildField);
                if (TranSegmentModel.isRedefiningField(currChildField)) {
                    if (currLength > prevFieldOrRedefinesGroupLength) {
                        totalSizeOfFields += currLength - prevFieldOrRedefinesGroupLength;
                        prevFieldOrRedefinesGroupLength = currLength;
                    }
                } else {
                    prevFieldOrRedefinesGroupLength = currLength;
                    totalSizeOfFields += prevFieldOrRedefinesGroupLength;
                }
                prevField = currChildField;
            }
        }
        if (parentField != null) {
            TranSegmentModel.setFieldSize(parentField, childFieldList, totalSizeOfFields);
        }
        return dynBoundedStructureHere || dynBoundedStructureBelow;
    }

    private static boolean isRedefiningField(FieldType field) {
        boolean retVal = false;
        String redefinedFieldStr = field.getRedefines();
        if (redefinedFieldStr != null && !redefinedFieldStr.isEmpty()) {
            retVal = true;
        }
        return retVal;
    }

    private static void updateEmptyStructOrArraySize(FieldType fieldType) {
        DatatypeType adtt;
        ApplicationDatatypeType adt = fieldType.getApplicationDatatype();
        if (adt != null && ((adtt = adt.getDatatype()) == DatatypeType.ARRAY || adtt == DatatypeType.STRUCT) && fieldType.getField().isEmpty()) {
            fieldType.setBytes(Integer.valueOf(0));
            fieldType.setMaxBytes(Integer.valueOf(0));
        }
    }

    private static int getLength(FieldType field) {
        int retVal = 0;
        Integer bytesInt = field.getBytes();
        if (bytesInt == null || bytesInt == 0) {
            Integer maxBytesInt = field.getMaxBytes();
            if (maxBytesInt != null) {
                retVal = maxBytesInt;
            }
        } else {
            retVal = bytesInt;
        }
        return retVal;
    }

    private static boolean isDynamic(FieldType field) {
        boolean retVal = false;
        Integer maxBytesInt = field.getMaxBytes();
        if (maxBytesInt != null && maxBytesInt > 0) {
            retVal = true;
        }
        return retVal;
    }

    private static void setFieldSize(FieldType parentField, List<FieldType> childFields, int sizeOfChildFieldList) throws ModelException {
        Integer parentMaxOccurs;
        boolean dynLengthChildExists = false;
        boolean parentIsDynArray = false;
        String parentDependsOn = parentField.getDependsOn();
        if (parentDependsOn != null && !parentDependsOn.isEmpty()) {
            parentIsDynArray = true;
        }
        if ((parentMaxOccurs = parentField.getMaxOccurs()) == null || parentMaxOccurs == 0) {
            parentMaxOccurs = 1;
        }
        int i = 0;
        while (i < childFields.size()) {
            FieldType currChild = childFields.get(i);
            Integer maxBytes = currChild.getMaxBytes();
            Integer bytes = currChild.getBytes();
            if (maxBytes != null && maxBytes > 0 && bytes != null && bytes == 0) {
                dynLengthChildExists = true;
                break;
            }
            ++i;
        }
        if (dynLengthChildExists || parentIsDynArray) {
            parentField.setMaxBytes(Integer.valueOf(sizeOfChildFieldList * parentMaxOccurs));
            parentField.setBytes(Integer.valueOf(0));
        } else {
            parentField.setBytes(Integer.valueOf(sizeOfChildFieldList * parentMaxOccurs));
            parentField.setMaxBytes(Integer.valueOf(0));
        }
    }

    public void clearStartInfo() throws ModelException {
        Vector<FieldType> fieldList = this.getTopLevelFieldTypes();
        int i = 0;
        while (i < fieldList.size()) {
            List children;
            FieldType currField = (FieldType)fieldList.get(i);
            String currStartAfter = currField.getStartAfter();
            if (currStartAfter != null && !currStartAfter.isEmpty()) {
                currField.setStartPos(null);
                currField.setRelativeStart(null);
                currField.setStartAfter(null);
            }
            if ((children = currField.getField()) != null && !children.isEmpty()) {
                this.clearStartInfo(children);
            }
            ++i;
        }
    }

    private void clearStartInfo(List<FieldType> fields) {
        int i = 0;
        while (i < fields.size()) {
            FieldType currField = fields.get(i);
            currField.setStartPos(null);
            currField.setRelativeStart(null);
            currField.setStartAfter(null);
            List children = currField.getField();
            if (children != null && !children.isEmpty()) {
                this.clearStartInfo(children);
            }
            ++i;
        }
    }

    public void replaceTopLevelField(FieldModel origField, FieldModel newField) throws ModelException {
        this.clearFieldList();
        Vector<FieldType> fieldList = this.getTopLevelFieldTypes();
        String startAfter = newField.getStartAfter();
        FieldType startAfterField = null;
        if (startAfter != null && !startAfter.isEmpty()) {
            startAfterField = TranSegmentModel.getFieldWithAlias(fieldList, startAfter);
        }
        boolean origFieldFound = false;
        int i = 0;
        while (i < fieldList.size()) {
            Object currObj = fieldList.get(i);
            if (currObj instanceof FieldType) {
                if (currObj == origField.getFieldType() && startAfterField == null) {
                    fieldList.remove(i);
                    fieldList.add(newField.getFieldType());
                    origFieldFound = true;
                    break;
                }
                if (startAfterField != null && startAfterField == currObj) {
                    fieldList.add(i + 1, newField.getFieldType());
                    origFieldFound = true;
                    break;
                }
            }
            ++i;
        }
        if (!origFieldFound) {
            fieldList.add(newField.getFieldType());
        }
    }

    public void clearFieldList() {
        if (this.commonFieldList != null) {
            this.commonFieldList.removeAllElements();
        }
        this.commonFieldList = null;
    }

    public static FieldType getFieldWithAlias(List<FieldType> fieldList, String alias) {
        FieldType retVal = null;
        int i = 0;
        while (i < fieldList.size()) {
            FieldType currField = fieldList.get(i);
            if (currField.getName().equals(alias)) {
                retVal = currField;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public void addField(FieldModel newField) throws ModelException {
        this.clearFieldList();
        FieldModel parentField = newField.getParentField();
        if (parentField == null) {
            this.addTopLevelField(newField);
        } else {
            this.addSubField(newField);
        }
    }

    private void addTopLevelField(FieldModel newField) {
        Vector<FieldType> fieldsList = this.getTopLevelFieldTypes();
        String startAfterField = newField.getStartAfter();
        int startPosInt = newField.getStartPos();
        if (startAfterField == null || startAfterField.isEmpty()) {
            if (newField.getAppDatatype() != null && startPosInt == 0) {
                newField.setStartPos(1);
            }
            newField.setStartAfter("");
            newField.setRelativeStart(0);
            fieldsList.add(newField.getFieldType());
        } else {
            int i = 0;
            while (i < fieldsList.size()) {
                FieldType currFieldType = (FieldType)fieldsList.get(i);
                if (startAfterField.equals(currFieldType.getName())) {
                    if (TranSegmentModel.objectAtIxIsLastFieldType(i, fieldsList)) {
                        fieldsList.add(i + 1, newField.getFieldType());
                    } else {
                        String redefinesFieldName = newField.getRedefines();
                        if (redefinesFieldName != null && !redefinesFieldName.isEmpty()) {
                            int j = i;
                            while (j < fieldsList.size()) {
                                currFieldType = (FieldType)fieldsList.get(j);
                                if (TranSegmentModel.objectAtIxIsLastFieldType(j, fieldsList)) {
                                    fieldsList.add(j + 1, newField.getFieldType());
                                    break;
                                }
                                if (redefinesFieldName.equals(currFieldType.getName())) {
                                    fieldsList.add(j + 1, newField.getFieldType());
                                    break;
                                }
                                ++j;
                            }
                        } else if (fieldsList.get(i + 1) instanceof FieldType) {
                            FieldType peekedNextPeerField = (FieldType)fieldsList.get(i + 1);
                            String nextFieldRedefinesField = peekedNextPeerField.getRedefines();
                            if (nextFieldRedefinesField == null || nextFieldRedefinesField.isEmpty()) {
                                fieldsList.add(i + 1, newField.getFieldType());
                            } else {
                                int j = i + 1;
                                while (j < fieldsList.size()) {
                                    if (fieldsList.get(j) instanceof FieldType) {
                                        FieldType potentialRedefinesGroupFieldType = (FieldType)fieldsList.get(j);
                                        String potentialRefinedName = potentialRedefinesGroupFieldType.getRedefines();
                                        if (potentialRefinedName == null || potentialRefinedName.isEmpty()) {
                                            fieldsList.add(j, newField.getFieldType());
                                            break;
                                        }
                                        if (TranSegmentModel.objectAtIxIsLastFieldType(j, fieldsList)) {
                                            fieldsList.add(j + 1, newField.getFieldType());
                                            break;
                                        }
                                    }
                                    ++j;
                                }
                            }
                        }
                    }
                    newField.setStartAfter("");
                    newField.setStartPos(0);
                    newField.setRelativeStart(0);
                    break;
                }
                ++i;
            }
        }
    }

    public static void addStartAfterFieldToPeerGroup(List<FieldType> peerFields, FieldModel newField) {
        String startAfterField = newField.getStartAfter();
        if (startAfterField.equals(DBDConstants.NONE.toString())) {
            newField.setStartAfter("");
            newField.setStartPos(0);
            newField.setRelativeStart(0);
            peerFields.add(0, newField.getFieldType());
        } else {
            int i = 0;
            while (i < peerFields.size()) {
                FieldType currFieldType = peerFields.get(i);
                if (startAfterField.equals(currFieldType.getName())) {
                    if (i + 1 == peerFields.size()) {
                        peerFields.add(i + 1, newField.getFieldType());
                    } else {
                        String redefinesFieldName = newField.getRedefines();
                        if (redefinesFieldName != null && !redefinesFieldName.isEmpty()) {
                            int j = i;
                            while (j < peerFields.size()) {
                                currFieldType = peerFields.get(j);
                                if (j + 1 == peerFields.size()) {
                                    peerFields.add(j + 1, newField.getFieldType());
                                    break;
                                }
                                if (redefinesFieldName.equals(currFieldType.getName())) {
                                    peerFields.add(j + 1, newField.getFieldType());
                                    break;
                                }
                                ++j;
                            }
                        } else {
                            FieldType peekedNextPeerField = peerFields.get(i + 1);
                            String nextFieldRedefinesField = peekedNextPeerField.getRedefines();
                            if (nextFieldRedefinesField == null || nextFieldRedefinesField.isEmpty()) {
                                peerFields.add(i + 1, newField.getFieldType());
                            } else {
                                int j = i + 1;
                                while (j < peerFields.size()) {
                                    if (peerFields.get(j) instanceof FieldType) {
                                        FieldType potentialRedefinesGroupFieldType = peerFields.get(j);
                                        String potentialRefinedName = potentialRedefinesGroupFieldType.getRedefines();
                                        if (potentialRefinedName == null || potentialRefinedName.isEmpty()) {
                                            peerFields.add(j, newField.getFieldType());
                                            break;
                                        }
                                        if (j == peerFields.size() - 1) {
                                            peerFields.add(j + 1, newField.getFieldType());
                                            break;
                                        }
                                    }
                                    ++j;
                                }
                            }
                        }
                    }
                    newField.setStartAfter("");
                    newField.setStartPos(0);
                    newField.setRelativeStart(0);
                    break;
                }
                ++i;
            }
        }
    }

    private void addSubField(FieldModel newField) {
        FieldModel parentField = newField.getParentField();
        Vector<FieldType> topLevelObjects = this.getTopLevelFieldTypes();
        int i = 0;
        while (i < topLevelObjects.size()) {
            FieldType currFieldType = (FieldType)topLevelObjects.get(i);
            if (parentField.getName().equals(currFieldType.getName())) {
                List peerFields = currFieldType.getField();
                String startAfterField = newField.getStartAfter();
                if (startAfterField == null || startAfterField.isEmpty()) {
                    newField.setStartAfter("");
                    newField.setStartPos(0);
                    newField.setRelativeStart(0);
                    peerFields.add(newField.getFieldType());
                    break;
                }
                TranSegmentModel.addStartAfterFieldToPeerGroup(peerFields, newField);
                TranSegmentModel.resetPeerGroupStartPositions(peerFields);
                break;
            }
            boolean parentFound = TranSegmentModel.addSubField(currFieldType.getField(), newField);
            if (parentFound) break;
            ++i;
        }
    }

    public static boolean addSubField(List<FieldType> subFields, FieldModel newField) {
        boolean parentFound = false;
        FieldModel parentField = newField.getParentField();
        int i = 0;
        while (i < subFields.size()) {
            FieldType currFieldType = subFields.get(i);
            if (parentField.getName().equals(currFieldType.getName())) {
                parentFound = true;
                List peerFields = currFieldType.getField();
                String startAfterField = newField.getStartAfter();
                if (startAfterField == null || startAfterField.isEmpty()) {
                    newField.setStartAfter("");
                    newField.setStartPos(0);
                    newField.setRelativeStart(0);
                    peerFields.add(newField.getFieldType());
                    break;
                }
                TranSegmentModel.addStartAfterFieldToPeerGroup(peerFields, newField);
                TranSegmentModel.resetPeerGroupStartPositions(peerFields);
                break;
            }
            parentFound = TranSegmentModel.addSubField(currFieldType.getField(), newField);
            if (parentFound) break;
            ++i;
        }
        return parentFound;
    }

    public static boolean objectAtIxIsLastFieldType(int index, List<FieldType> fields) {
        boolean retVal = true;
        if (index + 1 < fields.size()) {
            retVal = false;
        }
        return retVal;
    }

    public static void resetPeerGroupStartPositions(List<FieldType> peerFields) {
        int i = 0;
        while (i < peerFields.size()) {
            FieldType currFieldType = peerFields.get(i);
            currFieldType.setStartPos(Integer.valueOf(0));
            currFieldType.setStartAfter("");
            currFieldType.setRelativeStart(Integer.valueOf(0));
            ++i;
        }
    }

    public void removeField(FieldModel fieldModel) {
        Vector<FieldType> fieldTypeList = this.getTopLevelFieldTypes();
        TranSegmentModel.removeFieldType(fieldTypeList, fieldModel.getFieldType());
        this.clearFieldList();
    }

    public static boolean removeFieldType(List<FieldType> fieldList, FieldType fieldType) {
        boolean fieldFound = false;
        int i = 0;
        while (i < fieldList.size()) {
            FieldType currField = fieldList.get(i);
            if (currField == fieldType) {
                fieldList.remove(fieldType);
                fieldFound = true;
                break;
            }
            List subFields = currField.getField();
            if (subFields != null && subFields.size() > 0 && (fieldFound = TranSegmentModel.removeFieldType(subFields, fieldType))) break;
            ++i;
        }
        return fieldFound;
    }
}

