/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.model;

import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.workbench.transaction.model.TranSegmentsFolder;
import com.ibm.im.ims.workbench.transaction.model.TranTreeParent;

public class TranMessageModel
extends TranTreeParent {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int messageType;
    private MessageType message;
    private Transaction tran;

    public TranMessageModel(MessageType message, TranTreeParent parent, int type, Transaction tran) {
        super(message.getName(), parent);
        this.message = message;
        this.messageType = type;
        this.tran = tran;
    }

    public TranMessageModel(String name, TranTreeParent parent, int type) {
        super(name, parent);
        this.messageType = type;
    }

    public TranMessageModel(TranMessageModel another) {
        super(another);
        this.messageType = another.messageType;
        this.message = new MessageType(another.getMessage());
        this.tran = new Transaction(another.tran);
    }

    public MessageType getMessage() {
        return this.message;
    }

    public TranSegmentsFolder getSegFolder() {
        return (TranSegmentsFolder)this.getChildren()[0];
    }

    public int getMessageType() {
        return this.messageType;
    }

    public String getMessageName() {
        if (this.message != null) {
            return this.message.getName();
        }
        return null;
    }

    public String getMessageRemarks() {
        if (this.message != null) {
            return this.message.getRemarks();
        }
        return null;
    }

    public void deleteMessage() {
        this.message = null;
    }

    @Override
    public void removeFields(String[] selectedFields) {
        super.removeFields(selectedFields);
        this.message.removeFields(selectedFields);
        this.tran.removeFields(selectedFields);
    }
}

