/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.model;

import com.ibm.im.ims.metadata.transaction.AlignmentType;
import com.ibm.im.ims.metadata.transaction.ApplicationDatatypeType;
import com.ibm.im.ims.metadata.transaction.DatatypeType;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MarshallerType;
import com.ibm.im.ims.metadata.transaction.PhysicalDatatypeType;
import com.ibm.im.ims.metadata.transaction.YesnoType;
import com.ibm.im.ims.transaction.controller.datastructure.DBDConstants;
import com.ibm.im.ims.transaction.model.utilities.ModelException;
import com.ibm.im.ims.workbench.transaction.model.TranTreeObject;
import com.ibm.im.ims.workbench.transaction.model.TranTreeParent;
import java.util.List;
import java.util.Vector;

public class FieldModel
extends TranTreeObject {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private FieldModel parentField;
    private FieldType fieldType;
    private Vector<FieldModel> childFields;

    public FieldModel(FieldType field, TranTreeParent parentField) {
        super(field.getName(), parentField);
        this.fieldType = field;
    }

    public FieldModel(FieldType fieldType) {
        this(fieldType, null);
    }

    public FieldModel(String name, TranTreeParent parent) {
        super(name, parent);
        this.fieldType = new FieldType();
    }

    public FieldModel(FieldModel another) {
        super(another, true);
        this.fieldType = new FieldType(another.getFieldType());
        this.setParentField(another.getParentField());
    }

    public void removeField(String selectedField) {
        this.fieldType.removeField(selectedField);
    }

    @Override
    public String getName() {
        return this.fieldType.getName();
    }

    public void addField(FieldModel newField) throws ModelException {
        this.fieldType.getField().add(newField.getFieldType());
        this.clearFieldList();
    }

    public void clearFieldList() {
        if (this.childFields != null) {
            this.childFields.removeAllElements();
        }
        this.childFields = null;
    }

    public String getOriginalNameOrAlias() {
        String retVal = null;
        retVal = this.fieldType.getOriginalName();
        if (retVal == null || retVal.isEmpty()) {
            retVal = this.fieldType.getName();
        }
        return retVal;
    }

    @Override
    public void setName(String value) {
        this.fieldType.setName(value);
    }

    public String getOriginalName() {
        String retVal = this.fieldType.getOriginalName();
        if (retVal == null) {
            retVal = "";
            this.fieldType.setOriginalName(retVal);
        }
        return retVal;
    }

    public void setOriginalName(String value) {
        this.fieldType.setOriginalName(value);
    }

    public int getBytes() {
        Integer bytes = this.fieldType.getBytes();
        if (bytes == null) {
            bytes = 0;
            this.fieldType.setBytes(bytes);
        }
        return bytes;
    }

    public int getMaxBytes() {
        Integer maxBytes = this.fieldType.getMaxBytes();
        if (maxBytes == null) {
            maxBytes = 0;
            this.fieldType.setMaxBytes(maxBytes);
        }
        return maxBytes;
    }

    public void setBytes(int value) {
        this.fieldType.setBytes(Integer.valueOf(value));
    }

    public int getStartPos() {
        int retVal = 0;
        Integer startPos = this.fieldType.getStartPos();
        if (startPos != null) {
            retVal = startPos;
        }
        return retVal;
    }

    public int getStartOrRelstart() throws ModelException {
        int retVal = this.getStartPos();
        if (retVal == 0) {
            retVal = this.getRelativeStart();
        }
        return retVal;
    }

    public void setStartPos(int value) {
        this.fieldType.setStartPos(Integer.valueOf(value));
    }

    public void setEncoding(String value) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        marshaller.setEncoding(value);
    }

    public void setPhysicalDataType(DBDConstants value) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        if (value == DBDConstants.USER) {
            marshaller.setTypeConverter(null);
        } else if (value != null) {
            marshaller.setTypeConverter(PhysicalDatatypeType.fromValue((String)value.toString()));
        } else {
            marshaller.setTypeConverter(null);
        }
    }

    public DBDConstants getPhysicalDataType() {
        PhysicalDatatypeType physDatatype;
        DBDConstants retVal = null;
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller != null && (physDatatype = marshaller.getTypeConverter()) != null) {
            retVal = DBDConstants.fromValue(physDatatype.toString());
        }
        return retVal;
    }

    public String getEncoding() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller != null) {
            return marshaller.getEncoding();
        }
        return null;
    }

    public String getPattern() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller != null) {
            return marshaller.getPattern();
        }
        return null;
    }

    public String getDecimalPattern() {
        Object retVal = null;
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            return null;
        }
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            return null;
        }
        PhysicalDatatypeType physDataType = marshaller.getTypeConverter();
        if (physDataType != PhysicalDatatypeType.PACKEDDECIMAL && physDataType != PhysicalDatatypeType.ZONEDDECIMAL && physDataType != PhysicalDatatypeType.BINARY) {
            return null;
        }
        retVal = marshaller.getIsSigned() == YesnoType.Y ? "S" : "";
        Integer precision = adt.getPrecision();
        Integer scale = adt.getScale();
        if (precision == null || scale == null) {
            return null;
        }
        int numDigitsBeforeDecimal = precision - scale;
        int i = 0;
        while (i < numDigitsBeforeDecimal) {
            retVal = (String)retVal + "9";
            ++i;
        }
        retVal = (String)retVal + "V";
        i = 0;
        while (i < scale) {
            retVal = (String)retVal + "9";
            ++i;
        }
        return retVal;
    }

    public void setPattern(String value) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        marshaller.setPattern(value);
    }

    public void setPrecision(String value) {
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            adt = new ApplicationDatatypeType();
            this.fieldType.setApplicationDatatype(adt);
        }
        if (value == null) {
            adt.setPrecision(null);
        } else {
            adt.setPrecision(Integer.valueOf(value));
        }
    }

    public Integer getPrecision() {
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            return null;
        }
        return adt.getPrecision();
    }

    public Integer getScale() {
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            return null;
        }
        return adt.getScale();
    }

    public void setScale(String value) {
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            adt = new ApplicationDatatypeType();
            this.fieldType.setApplicationDatatype(adt);
        }
        if (value == null) {
            adt.setScale(null);
        } else {
            adt.setScale(Integer.valueOf(value));
        }
    }

    public void setIsSigned(String value) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        if (value == null) {
            marshaller.setIsSigned(null);
        } else {
            if (value.equalsIgnoreCase("YES")) {
                value = "Y";
            } else if (value.equalsIgnoreCase("NO")) {
                value = "N";
            }
            marshaller.setIsSigned(YesnoType.fromValue((String)value));
        }
    }

    public void removeMarshallerIfEmpty() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller != null) {
            YesnoType ynType = marshaller.getIsSigned();
            String userTypeConverterStr = marshaller.getUserTypeConverter();
            String pattern = marshaller.getPattern();
            String charEncoding = marshaller.getEncoding();
            AlignmentType alignment = marshaller.getAlignment();
            if (!(ynType != null || userTypeConverterStr != null && !userTypeConverterStr.isEmpty() || pattern != null && !pattern.isEmpty() || charEncoding != null && !charEncoding.isEmpty() || alignment != null)) {
                this.fieldType.setMarshaller(null);
            }
        }
    }

    public DBDConstants getIsSigned() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller != null) {
            YesnoType ynType = marshaller.getIsSigned();
            if (ynType == null) {
                return null;
            }
            return DBDConstants.valueOf(ynType.toString());
        }
        return null;
    }

    public void setPackeddecimalSubparms(String picString) {
        ApplicationDatatypeType adt;
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        int scale = 0;
        int index = -1;
        String expandedString = this.expandStringAndGetNumDigits(picString);
        index = expandedString.indexOf(86);
        if (index == -1) {
            index = expandedString.indexOf(118);
        }
        if (index != -1) {
            scale = expandedString.length() - index - 1;
        }
        if ((adt = this.fieldType.getApplicationDatatype()) == null) {
            adt = new ApplicationDatatypeType();
            this.fieldType.setApplicationDatatype(adt);
        }
        adt.setScale(Integer.valueOf(scale));
    }

    private int determineScale(String picString) {
        int scale = 0;
        int index = -1;
        String expandedString = this.expandStringAndGetNumDigits(picString);
        index = expandedString.indexOf(86);
        if (index == -1) {
            index = expandedString.indexOf(118);
        }
        if (index != -1) {
            scale = expandedString.length() - index - 1;
            return scale;
        }
        return scale;
    }

    private String expandStringAndGetNumDigits(String pictureString) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        StringBuffer expandedString = new StringBuffer();
        int startingIndex = -1;
        int index = 0;
        int expandCount = 0;
        char expandChar = '\u0000';
        if (pictureString.startsWith("S") || pictureString.startsWith("s")) {
            pictureString = pictureString.substring(1);
            marshaller.setIsSigned(YesnoType.Y);
        } else {
            marshaller.setIsSigned(YesnoType.N);
        }
        while ((index = pictureString.indexOf(40, startingIndex)) != -1) {
            expandedString.append(pictureString.substring(startingIndex + 1, index));
            startingIndex = pictureString.indexOf(41, index);
            expandChar = pictureString.charAt(index - 1);
            expandCount = Integer.parseInt(pictureString.substring(index + 1, startingIndex));
            int i = 0;
            while (i < expandCount - 1) {
                expandedString.append(expandChar);
                ++i;
            }
        }
        expandedString.append(pictureString.substring(startingIndex + 1, pictureString.length()));
        int count = 0;
        int length = expandedString.length();
        int i = 0;
        while (i < length) {
            if (String.valueOf(expandedString.charAt(i)).equals("9")) {
                ++count;
            }
            ++i;
        }
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            adt = new ApplicationDatatypeType();
            this.fieldType.setApplicationDatatype(adt);
        }
        adt.setPrecision(Integer.valueOf(count));
        return expandedString.toString();
    }

    public void setZoneddecimalSubparms(String picString) {
        int scale = this.determineScale(picString);
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            adt = new ApplicationDatatypeType();
            this.fieldType.setApplicationDatatype(adt);
        }
        adt.setScale(Integer.valueOf(scale));
    }

    public void setUserTypeConverer(String value) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        this.fieldType.getMarshaller().setUserTypeConverter(value);
    }

    public String getUserTypeConverter() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
        }
        return marshaller.getUserTypeConverter();
    }

    @Override
    public String toString() {
        return this.getOriginalName() + " aka " + this.getName();
    }

    public void setAppDatatype(DBDConstants value) {
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            adt = new ApplicationDatatypeType();
            this.fieldType.setApplicationDatatype(adt);
        }
        adt.setDatatype(DatatypeType.valueOf((String)value.toString()));
    }

    public DBDConstants getAppDatatype() {
        ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
        if (adt == null) {
            return null;
        }
        DatatypeType dt = adt.getDatatype();
        if (dt == null) {
            return null;
        }
        return DBDConstants.valueOf(dt.toString());
    }

    public void setMarshallerRemarks(String value) {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            this.fieldType.setMarshaller(marshaller);
        }
        marshaller.setRemarks(value);
    }

    public String getMarshallerRemarks() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
        }
        return marshaller.getRemarks();
    }

    public void setRemarks(String remarks) {
        if (remarks != "") {
            this.fieldType.setRemarks(remarks);
        }
    }

    public String getRemarks() {
        String retVal = this.fieldType.getRemarks();
        if (retVal == null) {
            retVal = "";
        }
        return retVal;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public MarshallerType getMarshaller() {
        return this.fieldType.getMarshaller();
    }

    public boolean isIMSField() {
        boolean retVal = true;
        String fieldNameStr = this.fieldType.getOriginalName();
        if (fieldNameStr == null || fieldNameStr.isEmpty()) {
            retVal = false;
        }
        return retVal;
    }

    public PhysicalDatatypeType getTypeConverter() {
        MarshallerType marshaller = this.fieldType.getMarshaller();
        if (marshaller != null) {
            return marshaller.getTypeConverter();
        }
        return null;
    }

    public void setRedefines(String redefines) {
        this.fieldType.setRedefines(redefines);
    }

    public String getRedefines() {
        return this.fieldType.getRedefines();
    }

    public void setMaxOccurs(Integer maxOccurs) {
        this.fieldType.setMaxOccurs(maxOccurs);
    }

    public Integer getMaxOccurs() {
        return this.fieldType.getMaxOccurs();
    }

    public void setMinOccurs(Integer minOccurs) {
        this.fieldType.setMinOccurs(minOccurs);
    }

    public Integer getMinOccurs() {
        return this.fieldType.getMinOccurs();
    }

    public void setDependsOn(String dependsOn) {
        this.fieldType.setDependsOn(dependsOn);
    }

    public String getDependsOn() {
        return this.fieldType.getDependsOn();
    }

    public void setRelativeStart(int relStart) {
        this.fieldType.setRelativeStart(Integer.valueOf(relStart));
    }

    public int getRelativeStart() {
        int retVal = 0;
        Integer relStart = this.fieldType.getRelativeStart();
        if (relStart != null) {
            retVal = relStart;
        }
        return retVal;
    }

    public void setStartAfter(String startAfter) {
        this.fieldType.setStartAfter(startAfter);
    }

    public String getStartAfter() {
        return this.fieldType.getStartAfter();
    }

    public void setMaxBytes(int maxBytes) {
        this.fieldType.setMaxBytes(Integer.valueOf(maxBytes));
    }

    public boolean hasSubFields() {
        boolean retVal = false;
        List fields = this.fieldType.getField();
        if (fields != null && !fields.isEmpty()) {
            retVal = true;
        }
        return retVal;
    }

    public Vector<FieldModel> getFieldList() throws ModelException {
        Vector<FieldModel> retVal = new Vector<FieldModel>();
        List fields = this.fieldType.getField();
        int i = 0;
        while (i < fields.size()) {
            FieldType currFieldType = (FieldType)fields.get(i);
            FieldModel newTranFieldModel = new FieldModel(currFieldType);
            retVal.add(newTranFieldModel);
            ++i;
        }
        return retVal;
    }

    public Vector<FieldModel> getFieldListUnOrdered() throws ModelException {
        Vector<FieldModel> retVal = new Vector<FieldModel>();
        List fields = this.fieldType.getField();
        int i = 0;
        while (i < fields.size()) {
            FieldType currFieldType = (FieldType)fields.get(i);
            FieldModel newTranFieldModel = new FieldModel(currFieldType);
            retVal.add(newTranFieldModel);
            ++i;
        }
        return retVal;
    }

    public void setParentField(FieldModel parentField) {
        this.parentField = parentField;
    }

    public FieldModel getParentField() {
        return this.parentField;
    }

    public Vector<FieldModel> getChildFields() {
        return this.childFields;
    }

    public void setChildFields(Vector<FieldModel> childFields) {
        this.childFields = childFields;
    }

    public void removeAllSubFields() {
        this.clearFieldList();
        this.fieldType.getField().clear();
    }
}

