/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.transaction.model.utilities;

import com.ibm.im.ims.transaction.model.utilities.TransactionModelPlugin;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class Utility {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Map imageCache;
    private static final int COMBO_HISTORY_LENGTH = 8;
    private static char[] specialChar;
    private static final String[] reservedSQLKeywords;

    static {
        specialChar = new char[]{'<', '>', '&', '\\', '/', '!', '%', '(', ')', '*', '|', '+', '-', ',', '.', ':', ';', '=', '?', '[', ']', '{', '}', '^', '`', '~', ' ', '\"', '\''};
        reservedSQLKeywords = new String[]{"ABORT", "ANALYZE", "AND", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AVG", "BEGIN", "BETWEEN", "BINARY", "BIT", "BOOLEAN", "BOTH", "BY", "CASCADE", "CAST", "CHAR", "CHARACTER", "CHECK", "CLOSE", "CLUSTER", "COLLATE", "COLUMN", "COMMIT", "CONSTRAINT", "COPY", "COUNT", "CREATE", "CROSS", "CURRENT", "CURSOR", "DECIMAL", "DECLARE", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DO", "DOUBLE", "DROP", "END", "EXECUTE", "EXISTS", "EXPLAIN", "EXTRACT", "EXTEND", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "IN", "INNER", "INSERT", "INT", "INTEGER", "INTERVAL", "INTO", "IS", "JOIN", "LAST", "LEADING", "LEFT", "LIKE", "LISTEN", "LOAD", "LOCAL", "LOCK", "MAX", "MIN", "MOVE", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEW", "NO", "NONE", "NOT", "NOTIFY", "NULL", "NUMERIC", "ON", "ONLY", "OR", "ORDER", "OUTER", "PARTIAL", "POSITION", "PRECISION", "PRIMARY", "PRIVILEGES", "PROCEDURE", "PUBLIC", "REAL", "REFERENCES", "RESET", "REVOKE", "RIGHT", "ROLLBACK", "ROW", "ROWS", "SELECT", "SET", "SETOF", "SHOW", "SMALLINT", "SUBSTRING", "SUM", "TABLE", "TO", "TRAILING", "TRANSACTION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNLISTEN", "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALUES", "VARCHAR", "VARYING", "VERBOSE", "VIEW", "WHERE", "WITH", "WORK"};
    }

    public static ImageDescriptor getImageDescriptor(String fileName) {
        ImageDescriptor img;
        if (imageCache == null) {
            imageCache = new HashMap();
        }
        if ((img = (ImageDescriptor)imageCache.get(fileName)) == null) {
            Bundle bundle = TransactionModelPlugin.getDefault().getBundle();
            Path iconPath = new Path("icons/" + fileName);
            URL url = FileLocator.find((Bundle)bundle, (IPath)iconPath, null);
            img = ImageDescriptor.createFromURL((URL)url);
            imageCache.put(fileName, img);
        }
        return img;
    }

    public static URL getURL(String path) {
        try {
            TransactionModelPlugin plugin = TransactionModelPlugin.getDefault();
            URL installURL = plugin.getBundle().getEntry(File.separator);
            URL url = FileLocator.resolve((URL)installURL);
            return new URL(url, path);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getTextWidth(Composite composite, int style, String label) {
        Text text = new Text(composite, style);
        text.setText(label);
        text.setFont(composite.getFont());
        int retVal = text.computeSize((int)-1, (int)-1).x;
        text.dispose();
        return retVal;
    }

    public static int getMaxSize(int[] labelSize) {
        Arrays.sort(labelSize);
        return labelSize[labelSize.length - 1];
    }

    public static String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        Utility.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    private static void addToHistory(List<String> history, String newEntry) {
        history.remove(newEntry);
        if (!newEntry.isEmpty()) {
            history.add(0, newEntry);
            if (history.size() > 8) {
                history.remove(8);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void deleteTempFile(IFile tempFile) {
        block3: {
            try {
                if (tempFile == null || !tempFile.exists()) break block3;
                tempFile.refreshLocal(1, null);
                tempFile.delete(true, null);
                break block3;
            }
            catch (CoreException v0) {
                System.gc();
                file = new File(tempFile.getLocation().toOSString());
                ** while (file.exists())
            }
lbl-1000:
            // 1 sources

            {
                file.delete();
                continue;
            }
        }
    }

    public static boolean hasReservedSQLKeywords(String text) {
        int i = 0;
        while (i < reservedSQLKeywords.length) {
            if (text.toUpperCase().equals(reservedSQLKeywords[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isValidName(String name) {
        Object invalidChars = "";
        char[] cArray = specialChar;
        int n = specialChar.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            invalidChars = (String)invalidChars + c;
            ++n2;
        }
        int i = 0;
        while (i < name.length()) {
            if (((String)invalidChars).contains(String.valueOf(name.charAt(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidPassphrase(String passphrase) {
        return passphrase.length() <= 100;
    }

    public static String removeFileExt(String fileName) {
        int marker = fileName.indexOf(".");
        if (marker > -1) {
            return fileName.substring(0, marker);
        }
        return fileName;
    }

    public static String getFileExt(String fileName) {
        int marker = fileName.indexOf(".");
        if (marker > -1) {
            return fileName.substring(marker, fileName.length());
        }
        return fileName;
    }

    public static boolean isStringNumeric(String text) {
        try {
            if (text.length() > 0) {
                Integer.parseInt(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isStringNumeric(String text, VerifyEvent event) {
        return Utility.isStringNumeric(Utility.getCurrentString(text, event) + event.text);
    }

    public static String getCurrentString(String string, VerifyEvent event) {
        if (event.character == '\b') {
            return string.substring(0, event.start) + string.substring(event.end) + event.text;
        }
        if (event.character == '\u007f' || String.valueOf(event.character).trim().length() > 0) {
            return (event.start > 0 ? string.substring(0, event.start) : "") + (event.end < string.length() ? string.substring(event.end) : "") + event.text;
        }
        return string;
    }

    public static String getInvalidRemarksCharacter(String remarks) {
        String retVal = null;
        if (remarks.indexOf("<") >= 0) {
            retVal = "<";
        } else if (remarks.indexOf(">") >= 0) {
            retVal = ">";
        } else if (remarks.indexOf("&") >= 0) {
            retVal = "&";
        } else if (remarks.indexOf(34) >= 0) {
            retVal = "\"";
        } else if (remarks.indexOf("'") >= 0) {
            retVal = "'";
        }
        return retVal;
    }

    public static String formatMessage(String inputMessage) {
        Object retVal = "";
        int maxLength = 37;
        if (inputMessage != null) {
            while (inputMessage.length() > 0) {
                int index = inputMessage.indexOf(" ");
                if (index >= 0) {
                    int currentLineLength = ((String)retVal).length() % maxLength;
                    String tempString = inputMessage.substring(0, index + 1);
                    retVal = (String)retVal + tempString;
                    if (tempString.indexOf("\n") < 0) {
                        if (tempString.length() >= maxLength) {
                            retVal = (String)retVal + "\n";
                        } else if (((String)retVal).length() % maxLength < currentLineLength) {
                            retVal = (String)retVal + "\n";
                        }
                    }
                    inputMessage = inputMessage.substring(index + 1);
                    continue;
                }
                retVal = (String)retVal + inputMessage;
                break;
            }
        }
        return retVal;
    }

    public static boolean hasSpecialChar(String text, boolean isExternalName) {
        int i = 0;
        while (i < specialChar.length) {
            if (text.indexOf(specialChar[i]) >= 0 || !isExternalName && text.indexOf("_") >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean allAttrsOnPage(String[] errorAttrs, String[] pageAttrs) {
        boolean retVal = true;
        int i = 0;
        while (i < errorAttrs.length) {
            String currErrorAttr = errorAttrs[i];
            boolean currErrorAttrExistsOnPage = false;
            int j = 0;
            while (j < pageAttrs.length) {
                String currPageAttr = pageAttrs[j];
                if (currErrorAttr.equals(currPageAttr)) {
                    currErrorAttrExistsOnPage = true;
                    break;
                }
                ++j;
            }
            if (!currErrorAttrExistsOnPage) {
                retVal = false;
                break;
            }
            ++i;
        }
        return retVal;
    }
}

