/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.transaction.model.utilities;

import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.metadata.trantoc.Trantoc;
import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.transaction.model.utilities.TrantocMap;
import java.math.BigInteger;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.CoreException;

public class TrantocMapManager {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static TrantocMapManager tocManager = null;
    private HashMap<String, TrantocMap> tocs = new HashMap();

    public TrantocMap getTrantocMap(String projectName) {
        return this.tocs.get(projectName);
    }

    public void putTrantocMap(String projectName, TrantocMap newTOC) {
        this.tocs.put(projectName, newTOC);
    }

    public static TrantocMapManager getSingletonInstance() {
        if (tocManager == null) {
            tocManager = new TrantocMapManager();
        }
        return tocManager;
    }

    public void clearAllMaps() {
        this.tocs.clear();
    }

    public static Transaction getTransaction(String projectName, BigInteger tranId) throws JAXBException, CoreException {
        String fileName = TrantocMapManager.getTransactionFileName(projectName, tranId);
        String tranName = fileName.substring(0, fileName.indexOf(".trn"));
        return ProjectTreeFileHelper.unmarshallTran(projectName, tranName);
    }

    public static String getTransactionFileName(String projectName, BigInteger tranId) throws JAXBException, CoreException {
        TrantocMapManager tmm = TrantocMapManager.getSingletonInstance();
        TrantocMap map = tmm.getTrantocMap(projectName);
        if (map == null) {
            map = TrantocMapManager.addTrantocMap(projectName);
        }
        String fileName = map.getTranFileName(tranId);
        return fileName;
    }

    public static TrantocMap addTrantocMap(String projectName) throws JAXBException, CoreException {
        TrantocMapManager mapMgr = TrantocMapManager.getSingletonInstance();
        Trantoc trantoc = ProjectTreeFileHelper.unmarshallTrantoc(projectName);
        TrantocMap map = new TrantocMap(trantoc);
        mapMgr.putTrantocMap(projectName, map);
        return map;
    }
}

