/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.transaction.model.utilities;

import com.ibm.im.ims.metadata.trantoc.TranMappingType;
import com.ibm.im.ims.metadata.trantoc.Trantoc;
import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.CoreException;

public class TrantocMap {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private HashMap<BigInteger, TranMappingType> tocById = new HashMap();
    private Trantoc trantoc;

    public TrantocMap(Trantoc trantoc) {
        this.trantoc = trantoc;
        List<TranMappingType> mappings = trantoc.getTranMapping();
        int i = 0;
        while (i < mappings.size()) {
            TranMappingType currMapping = mappings.get(i);
            this.tocById.put(currMapping.getTranId(), currMapping);
            ++i;
        }
    }

    private void addMapping(String projectName, BigInteger tranId, String tranFileName) throws JAXBException, CoreException {
        TranMappingType newMapping = new TranMappingType();
        newMapping.setTranId(tranId);
        newMapping.setFileName(tranFileName);
        this.trantoc.getTranMapping().add(newMapping);
        this.trantoc.setLastUsedTranId(tranId);
        this.tocById.put(tranId, newMapping);
    }

    public String getTranFileName(BigInteger tranId) {
        return this.tocById.get(tranId).getFileName();
    }

    public void newTranFileAdded(String projectName, BigInteger tranId, String newFileName) throws JAXBException, CoreException {
        TranMappingType mapping = this.tocById.get(tranId);
        if (mapping != null) {
            mapping.setFileName(newFileName);
        } else {
            this.addMapping(projectName, tranId, newFileName);
        }
        ProjectTreeFileHelper.marshallTrantoc(projectName, this.trantoc);
    }

    public void tranFileRemoved(String projectName, String newFileName) throws JAXBException, CoreException {
        List<TranMappingType> mappings = this.trantoc.getTranMapping();
        int i = 0;
        while (i < mappings.size()) {
            TranMappingType currMapping = mappings.get(i);
            if (currMapping.getFileName().equals(newFileName)) {
                mappings.remove(currMapping);
                this.tocById.remove(currMapping.getTranId());
                break;
            }
            ++i;
        }
        ProjectTreeFileHelper.marshallTrantoc(projectName, this.trantoc);
    }

    public Trantoc getTrantoc() {
        return this.trantoc;
    }
}

