/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.transaction.model.utilities;

import com.ibm.im.ims.metadata.message.overlay.InterfaceFieldType;
import com.ibm.im.ims.metadata.message.overlay.MessageInterfaceType;
import com.ibm.im.ims.metadata.message.overlay.ServiceInterface;
import com.ibm.im.ims.metadata.message.overlay.ServiceInterfaceSegmentType;
import com.ibm.im.ims.metadata.testcase.Testcase;
import com.ibm.im.ims.metadata.transaction.Message;
import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.ObjectFactory;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.metadata.trantoc.Trantoc;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ProjectTreeFileHelper {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public static final String CATALOG_PROJECT_NAME = "IMS_Explorer_Catalog_ReadOnly";
    public static final String TRANSACTION_META_EXTENTION = ".trn";
    public static final String TEST_CASE_EXTENTION = ".ttc";
    public static final String XML_EXTENTION = ".xml";
    public static final String JSON_TEST_CASE_EXTENTION = ".stc";
    public static final String SEGMENT_PAYLOAD_EXTENTION = ".segbin";
    public static final String TOP_TRANSACTION_FOLDER = "Transactions";
    public static final String ZCEE_SCHEMAS_FOLDER = "schemas";
    public static final String ZCEE_SERVICES_FOLDER = "services";
    public static final String ZCEE_SERVICE_ARTIFACTS_FOLDER = "serviceArtifacts";
    public static final String ZCEE_SCHEMAS_REQUEST_SUFFIX = "Request.json";
    public static final String ZCEE_SCHEMAS_RESPONSE_SUFFIX = "Response.json";
    public static final String SERVER_TRANSACTION_FOLDER = "Server Transactions";
    public static final String INPUT_MSG_FOLDER = "Input Messages";
    public static final String OUTPUT_MSG_FOLDER = "Output Messages";
    public static final String TOP_TESTCASE_FOLDER = "Test Cases";
    public static final String MESSAGE_FOLDER = "Messages";
    public static final String SEGMENT_FOLDER = "Segments";
    public static final String DATA_STRUCTURE_FOLDER = "Data Structures";
    public static final String TRANTOC_FILENAME = ".toc";
    public static final String TRAN_PROJ_NATURE = "com.ibm.im.ims.workbench.transaction.nature";
    public static final String GW_SERVICE_TRAN_PROJ_NATURE = "com.ibm.ims.zcee.transaction.nature";
    public static final String GW_SERVICE_PROJ_NATURE = "com.ibm.ims.zcee.service.nature";
    public static final String SERVICE_TEST_PROJ_NATURE = "com.ibm.ims.gw.ui.nature";
    private static JAXBContext tranContext = null;
    private static Marshaller tranMarshaller = null;
    private static JAXBContext serviceInterfaceContext = null;
    private static Marshaller serviceInterfaceMarshaller = null;
    private static Unmarshaller serviceInterfaceUnmarshaller = null;
    private static Unmarshaller tranUnmarshaller = null;
    private static JAXBContext testcaseContext = null;
    private static Marshaller testcaseMarshaller = null;
    private static Unmarshaller testcaseUnmarshaller = null;
    private static JAXBContext trantocContext = null;
    private static Marshaller trantocMarshaller = null;
    private static Unmarshaller trantocUnmarshaller = null;
    private static String testcaseMarshallerEncoding = "UTF-8";

    public static Trantoc createNewTranProject(String containerName) throws CoreException, JAXBException {
        Trantoc newTrantoc = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        logger.finest("root location: " + root.getRawLocation().toString());
        IProject project = root.getProject(containerName);
        if (!project.exists()) {
            IFolder testCaseFolder;
            NullProgressMonitor monitor = new NullProgressMonitor();
            project.create((IProgressMonitor)monitor);
            project.open((IProgressMonitor)monitor);
            newTrantoc = new Trantoc();
            newTrantoc.setLastUsedTranId(BigInteger.valueOf(0L));
            ProjectTreeFileHelper.marshallTrantoc(containerName, newTrantoc);
            String[] natures = new String[]{TRAN_PROJ_NATURE};
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(natures);
            project.setDescription(desc, (IProgressMonitor)monitor);
            IFolder transactionFolder = ProjectTreeFileHelper.getTransactionFolder(containerName);
            if (!transactionFolder.exists()) {
                transactionFolder.create(false, true, (IProgressMonitor)monitor);
            }
            if (!(testCaseFolder = ProjectTreeFileHelper.getTestCaseFolder(containerName)).exists()) {
                testCaseFolder.create(false, true, (IProgressMonitor)monitor);
            }
        }
        return newTrantoc;
    }

    public static void createNewzCEEServiceTranProject(String containerName) throws CoreException, JAXBException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        logger.finest("root location: " + root.getRawLocation().toString());
        IProject project = root.getProject(containerName);
        if (!project.exists()) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            project.create((IProgressMonitor)monitor);
            project.open((IProgressMonitor)monitor);
            String[] natures = new String[]{GW_SERVICE_TRAN_PROJ_NATURE};
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(natures);
            project.setDescription(desc, (IProgressMonitor)monitor);
        }
    }

    public static void createNewzCEEServiceProject(String containerName) throws CoreException, JAXBException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        logger.finest("root location: " + root.getRawLocation().toString());
        IProject project = root.getProject(containerName);
        if (!project.exists()) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            project.create((IProgressMonitor)monitor);
            project.open((IProgressMonitor)monitor);
            String[] natures = new String[]{GW_SERVICE_PROJ_NATURE};
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(natures);
            project.setDescription(desc, (IProgressMonitor)monitor);
        }
    }

    public static Transaction createNewTran(String projectName, String tranCode) {
        tranCode = tranCode.trim();
        Transaction newTran = new Transaction();
        newTran.setTranCode(tranCode);
        MessageType newMsg = new MessageType();
        newMsg.setName(tranCode + " - INPUT");
        newMsg.setId(BigInteger.valueOf(1L));
        SegmentType newSeg = new SegmentType();
        newSeg.setId(BigInteger.valueOf(1L));
        newMsg.getSegment().add(newSeg);
        newTran.getInputMessage().add(newMsg);
        MessageType newOutMsg = new MessageType();
        newOutMsg.setName(tranCode + " - OUTPUT");
        newOutMsg.setId(BigInteger.valueOf(2L));
        SegmentType newOutSeg = new SegmentType();
        newOutSeg.setId(BigInteger.valueOf(1L));
        newOutMsg.getSegment().add(newOutSeg);
        newTran.getOutputMessage().add(newOutMsg);
        return newTran;
    }

    public static boolean projectExists(String projectName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        logger.finest("root location: " + root.getRawLocation().toString());
        boolean retVal = false;
        try {
            IProject project = root.getProject(projectName);
            retVal = project.exists();
        }
        catch (Throwable e) {
            logger.finest(e.getMessage());
        }
        return retVal;
    }

    public static IProject getProject(String projectName) throws CoreException {
        IProject retVal = null;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        retVal = wsRoot.getProject(projectName);
        return retVal;
    }

    public static IFolder getTransactionFolder(String projectName) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder transFolder = project.getFolder(TOP_TRANSACTION_FOLDER);
        return transFolder;
    }

    public static IFolder getTestCaseFolder(String projectName) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder transFolder = project.getFolder(TOP_TESTCASE_FOLDER);
        return transFolder;
    }

    public static String[] getTestCaseFileNames(String projectName) throws CoreException {
        return ProjectTreeFileHelper.getTestCaseFileNames(projectName, true);
    }

    public static String[] getTestCaseFileNames(String projectName, boolean removeExtension) throws CoreException {
        IFolder tcFolder = ProjectTreeFileHelper.getTestCaseFolder(projectName);
        IResource[] members = tcFolder.members();
        ArrayList<String> retVal = new ArrayList<String>();
        int i = 0;
        while (i < members.length) {
            String ext = "." + members[i].getFileExtension();
            if (ext != null && ext.equals(TEST_CASE_EXTENTION)) {
                String fileName = members[i].getName();
                if (removeExtension) {
                    retVal.add(fileName.substring(0, fileName.length() - TEST_CASE_EXTENTION.length()));
                } else {
                    retVal.add(fileName);
                }
            }
            ++i;
        }
        return retVal.toArray(new String[retVal.size()]);
    }

    public static String[] getServiceTestCaseFileNames(String projectName, boolean removeExtension) throws CoreException {
        String[] retVal = new String[]{};
        if (ProjectTreeFileHelper.projectExists(projectName)) {
            IFolder tcFolder = ProjectTreeFileHelper.getTestCaseFolder(projectName);
            IResource[] members = tcFolder.members();
            retVal = new String[members.length];
            int i = 0;
            while (i < members.length) {
                String ext = "." + members[i].getFileExtension();
                if (ext != null && ext.equals(JSON_TEST_CASE_EXTENTION)) {
                    String fileName = members[i].getName();
                    retVal[i] = removeExtension ? fileName.substring(0, fileName.length() - 4) : fileName;
                }
                ++i;
            }
        }
        return retVal;
    }

    public static String[] getTransactionFileNames(String projectName) throws CoreException {
        IFolder tranFolder = ProjectTreeFileHelper.getTransactionFolder(projectName);
        IResource[] members = tranFolder.members();
        String[] retVal = new String[members.length];
        int i = 0;
        while (i < members.length) {
            String ext = members[i].getFileExtension();
            if (ext != null && ext.equals("trn")) {
                String fileName = members[i].getName();
                retVal[i] = fileName.substring(0, fileName.length() - 4);
            }
            ++i;
        }
        return retVal;
    }

    public static IFile getTransactionMetadataFile(String projectName, String tranName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder transFolder = project.getFolder(TOP_TRANSACTION_FOLDER);
        if (!transFolder.exists()) {
            transFolder.create(true, true, null);
        }
        IFile retVal = transFolder.getFile((IPath)new Path(tranName + TRANSACTION_META_EXTENTION));
        return retVal;
    }

    public static IProject getCatalogReadOnlyProject() throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(CATALOG_PROJECT_NAME);
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (!project.exists()) {
            project.create((IProgressMonitor)monitor);
        }
        project.open((IProgressMonitor)monitor);
        return project;
    }

    public static IFile getServerTransactionMetadataFile(String serverName, String tranName) throws CoreException {
        IFolder serverFolder;
        IProject project = ProjectTreeFileHelper.getCatalogReadOnlyProject();
        IFolder transFolder = project.getFolder(SERVER_TRANSACTION_FOLDER);
        if (!transFolder.exists()) {
            transFolder.create(true, true, null);
        }
        if (!(serverFolder = transFolder.getFolder(serverName)).exists()) {
            serverFolder.create(true, true, null);
        }
        IFile retVal = serverFolder.getFile((IPath)new Path(tranName + TRANSACTION_META_EXTENTION));
        return retVal;
    }

    public static void deleteServerTransactionMetadataFile(String serverName, String tranName) throws CoreException {
        IFile tranFile;
        IFolder serverFolder;
        IProject project = ProjectTreeFileHelper.getCatalogReadOnlyProject();
        IFolder transFolder = project.getFolder(SERVER_TRANSACTION_FOLDER);
        if (transFolder.exists() && (serverFolder = transFolder.getFolder(serverName)).exists() && (tranFile = serverFolder.getFile((IPath)new Path(tranName + TRANSACTION_META_EXTENTION))).exists()) {
            tranFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static IFile getTrantocMetadataFile(String projectName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFile retVal = project.getFile((IPath)new Path(TRANTOC_FILENAME));
        return retVal;
    }

    public static IFile getTestCaseMetadataFile(String projectName, String tcId) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder tcFolder = project.getFolder(TOP_TESTCASE_FOLDER);
        if (!tcFolder.exists()) {
            tcFolder.create(true, true, null);
        }
        IFile retVal = tcFolder.getFile((IPath)new Path(tcId + TEST_CASE_EXTENTION));
        return retVal;
    }

    public static IFile getJsonTestCaseMetadataFile(String projectName, String tcId) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder tcFolder = project.getFolder(TOP_TESTCASE_FOLDER);
        if (!tcFolder.exists()) {
            tcFolder.create(true, true, null);
        }
        IFile retVal = tcFolder.getFile((IPath)new Path(tcId + JSON_TEST_CASE_EXTENTION));
        return retVal;
    }

    public static IFile getSegmentBytesFile(String projectName, String fileName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFile retVal = project.getFile((IPath)new Path(fileName + SEGMENT_PAYLOAD_EXTENTION));
        return retVal;
    }

    public static HashMap<String, String> getAllProjectFromOS() {
        HashMap<String, String> projHash = new HashMap<String, String>();
        File root = Platform.getLocation().toFile();
        if (root.isDirectory()) {
            File[] fileArray = root.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    projHash.put(f.getName().toUpperCase(), f.getName());
                }
                ++n2;
            }
        }
        return projHash;
    }

    public static IProject getTransactionProject(String projectName) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (ProjectTreeFileHelper.hasTransNature(project) && project.getName().equals(projectName)) {
                return project;
            }
            ++i;
        }
        return null;
    }

    public static boolean hasTransNature(IProject iProject) {
        try {
            if (iProject != null && iProject.getNature(TRAN_PROJ_NATURE) != null) {
                return true;
            }
        }
        catch (CoreException e) {
            logger.throwing("com.ibm.im.ims.workbench.transaction.utilities.ProjectTreeFileHelper", "hasTransNature(IProject)", (Throwable)e);
            logger.error((Throwable)e);
        }
        return false;
    }

    public static ArrayList<String> getProjectList(String[] projectNature) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<String> projectNames = new ArrayList<String>();
        IResource[] resources = root.members();
        if (resources.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < resources.length) {
            try {
                IProject temp = (IProject)resources[i];
                boolean strCompare = Arrays.equals(temp.getDescription().getNatureIds(), projectNature);
                if (resources[i] instanceof IProject && strCompare) {
                    projectNames.add(temp.getName());
                }
            }
            catch (Throwable e) {
                logger.throwing("ProjectTreeFileHelper", "getProjectList(String[] projectNature)", e);
            }
            ++i;
        }
        return projectNames;
    }

    public static IFile marshallNewTran(String projectName, Transaction newTran, String newTranName) throws CoreException, IOException, JAXBException {
        IFile tranFile = null;
        if (newTran != null) {
            tranFile = ProjectTreeFileHelper.getTransactionMetadataFile(projectName, newTranName);
            ProjectTreeFileHelper.marshallTran(projectName, newTran, tranFile);
        }
        return tranFile;
    }

    public static void revealTranInProjectTree(IFile tranFile) {
        IViewPart part;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (part = page.findView("org.eclipse.ui.navigator.ProjectExplorer")) != null && part instanceof ISetSelectionTarget) {
            if (!page.isPartVisible((IWorkbenchPart)part)) {
                try {
                    page.showView("org.eclipse.ui.navigator.ProjectExplorer");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
            StructuredSelection selection = new StructuredSelection((Object)tranFile);
            ((ISetSelectionTarget)part).selectReveal((ISelection)selection);
        }
    }

    public static void launchTranEditor(IFile tranFile) throws PartInitException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            IDE.openEditor((IWorkbenchPage)page, (IFile)tranFile);
        }
    }

    public static MessageType getInputMessage(Transaction transaction, String messageName) {
        List messages = transaction.getInputMessage();
        int i = 0;
        while (i < messages.size()) {
            MessageType currentMessage = (MessageType)messages.get(i);
            if (messageName.equals(currentMessage.getName())) {
                return currentMessage;
            }
            ++i;
        }
        return null;
    }

    public static MessageType getOutputMessage(Transaction transaction, String messageName) {
        List messages = transaction.getOutputMessage();
        int i = 0;
        while (i < messages.size()) {
            MessageType currentMessage = (MessageType)messages.get(i);
            if (messageName.equals(currentMessage.getName())) {
                return currentMessage;
            }
            ++i;
        }
        return null;
    }

    public static Transaction unmarshallTran(String projectName, String serverName, String tranName) throws JAXBException, CoreException {
        tranName = tranName.trim();
        if (tranUnmarshaller == null) {
            if (tranContext == null) {
                tranContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.transaction", (ClassLoader)ObjectFactory.class.getClassLoader());
            }
            tranUnmarshaller = tranContext.createUnmarshaller();
        }
        InputStream is = projectName.equals(CATALOG_PROJECT_NAME) && serverName != null && !serverName.isEmpty() ? ProjectTreeFileHelper.getServerTransactionMetadataFile(serverName, tranName).getContents() : ProjectTreeFileHelper.getTransactionMetadataFile(projectName, tranName).getContents();
        Transaction tran = (Transaction)tranUnmarshaller.unmarshal(is);
        return tran;
    }

    public static Transaction unmarshallTran(String projectName, String tranName) throws JAXBException, CoreException {
        return ProjectTreeFileHelper.unmarshallTran(projectName, null, tranName);
    }

    public static Transaction unmarshallTran(InputStream is) throws JAXBException, CoreException {
        if (tranUnmarshaller == null) {
            if (tranContext == null) {
                tranContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.transaction", (ClassLoader)Transaction.class.getClassLoader());
            }
            tranUnmarshaller = tranContext.createUnmarshaller();
        }
        Transaction tran = (Transaction)tranUnmarshaller.unmarshal(is);
        return tran;
    }

    public static Testcase unmarshallTestcase(String projectName, String testcaseName) throws JAXBException, CoreException {
        if (testcaseUnmarshaller == null) {
            if (testcaseContext == null) {
                testcaseContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.testcase", (ClassLoader)Testcase.class.getClassLoader());
            }
            testcaseUnmarshaller = testcaseContext.createUnmarshaller();
        }
        InputStream is = ProjectTreeFileHelper.getTestCaseMetadataFile(projectName, testcaseName).getContents();
        Testcase testcase = (Testcase)testcaseUnmarshaller.unmarshal(is);
        return testcase;
    }

    public static void marshallTran(String projectName, Transaction tran, IFile tranMetaFile) throws JAXBException, CoreException {
        if (tranMarshaller == null) {
            if (tranContext == null) {
                tranContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.transaction", (ClassLoader)Transaction.class.getClassLoader());
            }
            tranMarshaller = tranContext.createMarshaller();
            tranMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        ByteArrayOutputStream tranOutputStream = new ByteArrayOutputStream();
        tranMarshaller.marshal((Object)tran, (OutputStream)tranOutputStream);
        ByteArrayInputStream tranInputStream = new ByteArrayInputStream(tranOutputStream.toByteArray());
        if (!tranMetaFile.exists()) {
            tranMetaFile.create((InputStream)tranInputStream, true, null);
        } else {
            tranMetaFile.setContents((InputStream)tranInputStream, true, true, null);
        }
    }

    private static IFile getzCEETranMsgFile(String projectName, String tranCode, String msgName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder transFolder = project.getFolder(tranCode);
        if (!transFolder.exists()) {
            transFolder.create(true, true, null);
        }
        IFile tranMetaFile = transFolder.getFile((IPath)new Path(msgName + XML_EXTENTION));
        return tranMetaFile;
    }

    public static void marshallzCEETranMsg(String projectName, String tranCode, Message msgToMarshal) throws JAXBException, CoreException {
        if (tranMarshaller == null) {
            if (tranContext == null) {
                tranContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.transaction");
            }
            tranMarshaller = tranContext.createMarshaller();
            tranMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        ByteArrayOutputStream tranMsgOutputStream = new ByteArrayOutputStream();
        tranMarshaller.marshal((Object)msgToMarshal, (OutputStream)tranMsgOutputStream);
        ByteArrayInputStream tranMsgInputStream = new ByteArrayInputStream(tranMsgOutputStream.toByteArray());
        IFile tranMetaFile = ProjectTreeFileHelper.getzCEETranMsgFile(projectName, tranCode, msgToMarshal.getMessageName());
        if (!tranMetaFile.exists()) {
            tranMetaFile.create((InputStream)tranMsgInputStream, true, null);
        } else {
            tranMetaFile.setContents((InputStream)tranMsgInputStream, true, true, null);
        }
    }

    public static Message unmarshallzCEETranMsg(String projectName, String tranCode, String msgName) throws JAXBException, CoreException {
        Message tranMsg = null;
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Message.class}).createUnmarshaller();
        IFile tranMsgFile = ProjectTreeFileHelper.getzCEETranMsgFile(projectName, tranCode, msgName);
        if (tranMsgFile.exists()) {
            InputStream is = tranMsgFile.getContents();
            tranMsg = (Message)unmarshaller.unmarshal(is);
        }
        return tranMsg;
    }

    public static void marshallzCEESchemas(String serviceName, String requestSchema, String responseSchema) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        logger.finest("root location: " + root.getRawLocation().toString());
        IProject project = root.getProject(serviceName);
        IFolder schemasFolder = project.getFolder(ZCEE_SCHEMAS_FOLDER);
        if (!schemasFolder.exists()) {
            schemasFolder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
        }
        IFile requestFile = schemasFolder.getFile((IPath)new Path(serviceName + ZCEE_SCHEMAS_REQUEST_SUFFIX));
        ByteArrayInputStream requestSchemaInputStream = new ByteArrayInputStream(requestSchema.getBytes());
        if (!requestFile.exists()) {
            requestFile.create((InputStream)requestSchemaInputStream, true, null);
        } else {
            requestFile.setContents((InputStream)requestSchemaInputStream, true, true, null);
        }
        IFile responseFile = schemasFolder.getFile((IPath)new Path(serviceName + ZCEE_SCHEMAS_RESPONSE_SUFFIX));
        ByteArrayInputStream responseSchemaInputStream = new ByteArrayInputStream(responseSchema.getBytes());
        if (!responseFile.exists()) {
            responseFile.create((InputStream)responseSchemaInputStream, true, null);
        } else {
            responseFile.setContents((InputStream)responseSchemaInputStream, true, true, null);
        }
    }

    public static void marshallzCEEManifest(String serviceName, byte[] bytes) throws JAXBException, CoreException {
        ByteArrayInputStream yamlInputStream = new ByteArrayInputStream(bytes);
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(serviceName);
        IFile yamlFile = project.getFile((IPath)new Path("manifest.yml"));
        if (!yamlFile.exists()) {
            yamlFile.create((InputStream)yamlInputStream, true, null);
        } else {
            yamlFile.setContents((InputStream)yamlInputStream, true, true, null);
        }
    }

    public static String marshallInterfaceToString(InterfaceFieldType interfaceRootField) throws JAXBException {
        if (serviceInterfaceMarshaller == null) {
            if (serviceInterfaceContext == null) {
                serviceInterfaceContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.message.overlay");
            }
            serviceInterfaceMarshaller = serviceInterfaceContext.createMarshaller();
            serviceInterfaceMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        MessageInterfaceType msgInterface = new MessageInterfaceType();
        ServiceInterfaceSegmentType segment = new ServiceInterfaceSegmentType();
        msgInterface.getSegment().add(segment);
        segment.getInterfaceField().add(interfaceRootField);
        ServiceInterface serviceInterface = new ServiceInterface();
        serviceInterface.setInterface(msgInterface);
        ByteArrayOutputStream interfaceOutputStream = new ByteArrayOutputStream();
        serviceInterfaceMarshaller.marshal((Object)serviceInterface, (OutputStream)interfaceOutputStream);
        return interfaceOutputStream.toString();
    }

    public static ServiceInterface unmarshallStringToInterface(String interfaceStr) throws JAXBException {
        if (serviceInterfaceUnmarshaller == null) {
            if (serviceInterfaceContext == null) {
                serviceInterfaceContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.message.overlay");
            }
            serviceInterfaceUnmarshaller = serviceInterfaceContext.createUnmarshaller();
        }
        ByteArrayInputStream is = new ByteArrayInputStream(interfaceStr.getBytes());
        ServiceInterface interfaceType = (ServiceInterface)serviceInterfaceUnmarshaller.unmarshal((InputStream)is);
        return interfaceType;
    }

    public static ServiceInterface unmarshallFileToInterface(File interfaceFile) throws JAXBException, FileNotFoundException {
        if (serviceInterfaceUnmarshaller == null) {
            if (serviceInterfaceContext == null) {
                serviceInterfaceContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.message.overlay");
            }
            serviceInterfaceUnmarshaller = serviceInterfaceContext.createUnmarshaller();
        }
        FileInputStream is = new FileInputStream(interfaceFile);
        ServiceInterface interfaceType = (ServiceInterface)serviceInterfaceUnmarshaller.unmarshal((InputStream)is);
        return interfaceType;
    }

    public static IFile marshallTranToReadOnlyProject(String serverName, Transaction tran) throws CoreException, JAXBException {
        IFile tranMetaFile = null;
        if (tran != null) {
            tranMetaFile = ProjectTreeFileHelper.getServerTransactionMetadataFile(serverName, tran.getTranCode());
        }
        if (tranMarshaller == null) {
            if (tranContext == null) {
                tranContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.transaction", (ClassLoader)Transaction.class.getClassLoader());
            }
            tranMarshaller = tranContext.createMarshaller();
            tranMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        ByteArrayOutputStream tranOutputStream = new ByteArrayOutputStream();
        tranMarshaller.marshal((Object)tran, (OutputStream)tranOutputStream);
        ByteArrayInputStream tranInputStream = new ByteArrayInputStream(tranOutputStream.toByteArray());
        if (!tranMetaFile.exists()) {
            tranMetaFile.create((InputStream)tranInputStream, true, null);
        } else {
            tranMetaFile.setContents((InputStream)tranInputStream, true, true, null);
        }
        return tranMetaFile;
    }

    public static IFile marshallTestcase(String projectName, Testcase testcase, String tcName) throws JAXBException, CoreException {
        if (testcaseMarshaller == null) {
            if (testcaseContext == null) {
                testcaseContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.testcase", (ClassLoader)Testcase.class.getClassLoader());
            }
            testcaseMarshaller = testcaseContext.createMarshaller();
            testcaseMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            testcaseMarshaller.setProperty("jaxb.encoding", (Object)testcaseMarshallerEncoding);
        }
        IFile testcaseMetaFile = ProjectTreeFileHelper.getTestCaseMetadataFile(projectName, tcName);
        ByteArrayOutputStream testcaseOutputStream = new ByteArrayOutputStream();
        testcaseMarshaller.marshal((Object)testcase, (OutputStream)testcaseOutputStream);
        ByteArrayInputStream testcaseInputStream = new ByteArrayInputStream(testcaseOutputStream.toByteArray());
        if (!testcaseMetaFile.exists()) {
            testcaseMetaFile.create((InputStream)testcaseInputStream, true, null);
        } else {
            testcaseMetaFile.setContents((InputStream)testcaseInputStream, true, true, null);
        }
        testcaseMetaFile.setCharset(testcaseMarshallerEncoding, (IProgressMonitor)new NullProgressMonitor());
        return testcaseMetaFile;
    }

    public static IFile marshallSegmentPayload(String projectName, byte[] payload, String fileName) throws JAXBException, CoreException {
        IFile payloadFile = ProjectTreeFileHelper.getSegmentBytesFile(projectName, fileName);
        ByteArrayInputStream payloadInputStream = new ByteArrayInputStream(payload);
        if (!payloadFile.exists()) {
            payloadFile.create((InputStream)payloadInputStream, true, null);
        } else {
            payloadFile.setContents((InputStream)payloadInputStream, true, true, null);
        }
        return payloadFile;
    }

    public static Trantoc unmarshallTrantoc(String projectName) throws JAXBException, CoreException {
        if (trantocUnmarshaller == null) {
            if (trantocContext == null) {
                trantocContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.trantoc", (ClassLoader)Trantoc.class.getClassLoader());
            }
            trantocUnmarshaller = trantocContext.createUnmarshaller();
        }
        InputStream is = ProjectTreeFileHelper.getTrantocMetadataFile(projectName).getContents();
        Trantoc tranToc = (Trantoc)trantocUnmarshaller.unmarshal(is);
        return tranToc;
    }

    public static IFile marshallTrantoc(String projectName, Trantoc trantoc) throws JAXBException, CoreException {
        if (trantocMarshaller == null) {
            if (trantocContext == null) {
                trantocContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.trantoc", (ClassLoader)Trantoc.class.getClassLoader());
            }
            trantocMarshaller = trantocContext.createMarshaller();
            trantocMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        IFile trantocMetaFile = ProjectTreeFileHelper.getTrantocMetadataFile(projectName);
        ByteArrayOutputStream trantocOutputStream = new ByteArrayOutputStream();
        trantocMarshaller.marshal((Object)trantoc, (OutputStream)trantocOutputStream);
        ByteArrayInputStream trantocInputStream = new ByteArrayInputStream(trantocOutputStream.toByteArray());
        if (!trantocMetaFile.exists()) {
            trantocMetaFile.create((InputStream)trantocInputStream, true, null);
        } else {
            trantocMetaFile.setContents((InputStream)trantocInputStream, true, true, null);
        }
        return trantocMetaFile;
    }

    public static void deleteProject(String containerName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(containerName);
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (!project.exists()) {
            project.delete(true, (IProgressMonitor)monitor);
        }
    }

    public static byte[] importFileToByteArray(File file) throws IOException {
        ByteArrayOutputStream baos = null;
        FileInputStream fis = null;
        try {
            byte[] buffer = new byte[4096];
            baos = new ByteArrayOutputStream();
            fis = new FileInputStream(file);
            int read = 0;
            while ((read = fis.read(buffer)) != -1) {
                baos.write(buffer, 0, read);
            }
        }
        finally {
            if (baos != null) {
                baos.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return baos.toByteArray();
    }

    public static String getCurrentDir() {
        String currentDir = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        return currentDir;
    }

    public static void createServiceTestProject(String containerName) throws CoreException, JAXBException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        logger.finest("root location: " + root.getRawLocation().toString());
        IProject project = root.getProject(containerName);
        if (!project.exists()) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            project.create((IProgressMonitor)monitor);
            project.open((IProgressMonitor)monitor);
            String[] natures = new String[]{SERVICE_TEST_PROJ_NATURE};
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(natures);
            project.setDescription(desc, (IProgressMonitor)monitor);
            IFolder testCaseFolder = ProjectTreeFileHelper.getTestCaseFolder(containerName);
            if (!testCaseFolder.exists()) {
                testCaseFolder.create(false, true, (IProgressMonitor)monitor);
            }
        }
    }
}

