/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.transaction.model.utilities;

import com.ibm.im.ims.metadata.transaction.ApplicationDatatypeType;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

class FieldTypeToolTip
extends ToolTip {
    private static Color infoBgColor = Display.getDefault().getSystemColor(29);
    private static Color infoFgColor = Display.getDefault().getSystemColor(28);
    private static Color redColor = Display.getDefault().getSystemColor(3);
    private static Color blueColor = Display.getDefault().getSystemColor(9);

    public FieldTypeToolTip(Control control) {
        super(control);
        this.setShift(new Point(15, 0));
    }

    protected Composite createToolTipContentArea(Event event, Composite content) {
        String redefines;
        String dependsOnPath;
        StyleRange styleRange;
        StyledText styledText;
        Composite composite = new Composite(content, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        composite.setBackground(infoBgColor);
        FieldType fieldType = (FieldType)this.getData(FieldType.class.getCanonicalName());
        if (fieldType == null) {
            return null;
        }
        String fieldPath = fieldType.getPath();
        if (fieldPath == null || fieldPath.isEmpty()) {
            fieldPath = fieldType.getName();
        }
        if (fieldPath != null && !fieldPath.isEmpty()) {
            Object datatypeStr = "";
            ApplicationDatatypeType datatype = fieldType.getApplicationDatatype();
            if (datatype != null && datatype.getDatatype() != null) {
                datatypeStr = " " + datatype.getDatatype().toString();
            }
            styledText = new StyledText(composite, 0);
            styledText.setText(fieldPath + (String)datatypeStr);
            styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = styledText.getText().length();
            styleRange.fontStyle = 0;
            styleRange.background = infoBgColor;
            styleRange.foreground = infoFgColor;
            styledText.setStyleRange(styleRange);
            if (datatypeStr != null && !((String)datatypeStr).isEmpty()) {
                styleRange = new StyleRange();
                styleRange.start = fieldPath.length();
                styleRange.length = ((String)datatypeStr).length();
                styleRange.fontStyle = 0;
                styleRange.background = infoBgColor;
                styleRange.foreground = blueColor;
                styledText.setStyleRange(styleRange);
            }
        }
        if ((dependsOnPath = fieldType.getDependsOnPath()) != null && !dependsOnPath.isEmpty()) {
            String dependsOnKW = "\t" + TranMessages.getLabel().getString("FLD_DEPENDS_ON") + "  ";
            styledText = new StyledText(composite, 0);
            styledText.setText(dependsOnKW + dependsOnPath);
            styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = dependsOnKW.length();
            styleRange.fontStyle = 0;
            styleRange.background = infoBgColor;
            styleRange.foreground = blueColor;
            styledText.setStyleRange(styleRange);
            styleRange = new StyleRange();
            styleRange.start = dependsOnKW.length();
            styleRange.length = dependsOnPath.length();
            styleRange.fontStyle = 0;
            styleRange.background = infoBgColor;
            styleRange.foreground = infoFgColor;
            styledText.setStyleRange(styleRange);
        }
        if ((redefines = fieldType.getRedefines()) != null && !redefines.isEmpty()) {
            String redefinesKW = "\t" + TranMessages.getLabel().getString("FLD_REDEFINES") + "  ";
            StyledText styledText2 = new StyledText(composite, 0);
            styledText2.setText(redefinesKW + redefines);
            StyleRange styleRange2 = new StyleRange();
            styleRange2.start = 0;
            styleRange2.length = redefinesKW.length();
            styleRange2.fontStyle = 0;
            styleRange2.background = infoBgColor;
            styleRange2.foreground = redColor;
            styledText2.setStyleRange(styleRange2);
            styleRange2 = new StyleRange();
            styleRange2.start = redefinesKW.length();
            styleRange2.length = redefines.length();
            styleRange2.fontStyle = 0;
            styleRange2.background = infoBgColor;
            styleRange2.foreground = infoFgColor;
            styledText2.setStyleRange(styleRange2);
        }
        return composite;
    }
}

