/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.transaction.controller.importmessage;

import com.ibm.im.ims.metadata.testcase.IoMessagePairType;
import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.transaction.model.utilities.TrantocMapManager;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.testcase.model.IOMessagePairNode;
import java.math.BigInteger;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TestcaseTransactionMessageController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IoMessagePairType ioMessagePairType;
    private String projectName;

    public TestcaseTransactionMessageController(IOMessagePairNode selectedIoMessageNode, String projectName) {
        IoMessagePairType selectedIoMessagePairType = selectedIoMessageNode.getMessagePair();
        this.ioMessagePairType = new IoMessagePairType();
        this.ioMessagePairType.setInputMessageId(selectedIoMessagePairType.getInputMessageId());
        this.ioMessagePairType.setOutputMessageId(selectedIoMessagePairType.getOutputMessageId());
        this.ioMessagePairType.setName(selectedIoMessagePairType.getName());
        this.ioMessagePairType.setTranId(selectedIoMessagePairType.getTranId());
        this.projectName = projectName;
    }

    public String getIoMessagePairName() {
        if (this.ioMessagePairType != null) {
            return this.ioMessagePairType.getName();
        }
        return null;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public BigInteger getTranId() {
        BigInteger retVal = null;
        if (this.ioMessagePairType != null) {
            retVal = this.ioMessagePairType.getTranId();
        }
        return retVal;
    }

    public void setTranId(String transactionName) throws JAXBException, CoreException {
        Transaction tran = ProjectTreeFileHelper.unmarshallTran(this.projectName, transactionName);
        if (transactionName != null && !transactionName.isEmpty() && tran != null) {
            BigInteger existingTranId = this.getTranId();
            BigInteger newTranId = tran.getId();
            if (!(existingTranId != null && existingTranId.equals(newTranId) || this.ioMessagePairType == null)) {
                this.ioMessagePairType.setTranId(newTranId);
                this.ioMessagePairType.setInputMessageId(null);
                this.ioMessagePairType.setOutputMessageId(null);
            }
        } else {
            Object[] inserts = new String[]{transactionName, this.projectName};
            Status status = new Status(4, "com.ibm.im.ims.workbench.transaction", 0, TranMessages.getError().getString("ITMW_ERR_TRANSACTION_NOT_FOUND", inserts), null);
            throw new CoreException((IStatus)status);
        }
    }

    public void setTranId(BigInteger newTranId) {
        if (this.ioMessagePairType != null) {
            this.ioMessagePairType.setTranId(newTranId);
        }
    }

    public Transaction retrieveTransaction() throws JAXBException, CoreException {
        BigInteger tranId = this.getTranId();
        Transaction retVal = null;
        if (tranId != null) {
            retVal = TrantocMapManager.getTransaction(this.projectName, tranId);
        }
        return retVal;
    }

    public String retrieveTransactionFileName() throws JAXBException, CoreException {
        BigInteger tranId = this.getTranId();
        String retVal = null;
        if (tranId != null) {
            retVal = TrantocMapManager.getTransactionFileName(this.projectName, tranId);
            retVal = retVal.substring(0, retVal.indexOf(".trn"));
        }
        return retVal;
    }

    public void setInputMessageId(String messageName) throws JAXBException, CoreException {
        Transaction tran = this.retrieveTransaction();
        if (tran != null && messageName != null && !messageName.isEmpty()) {
            BigInteger existingMsgId = this.getInputMessageId();
            BigInteger newMsgId = this.getInputMessageId(tran, messageName);
            if ((existingMsgId == null || newMsgId != null && !newMsgId.equals(existingMsgId)) && this.ioMessagePairType != null) {
                this.ioMessagePairType.setInputMessageId(newMsgId);
            }
        }
    }

    public void setInputMessageId(BigInteger newMessageId) {
        if (this.ioMessagePairType != null && !this.ioMessagePairType.getInputMessageId().equals(newMessageId)) {
            this.ioMessagePairType.setInputMessageId(newMessageId);
        }
    }

    private BigInteger getInputMessageId(Transaction tran, String messageName) {
        List messageList;
        if (tran != null && (messageList = tran.getInputMessage()) != null) {
            int i = 0;
            while (i < messageList.size()) {
                MessageType currentMessage = (MessageType)messageList.get(i);
                if (currentMessage.getName().equals(messageName)) {
                    return currentMessage.getId();
                }
                ++i;
            }
        }
        return null;
    }

    public BigInteger getInputMessageId() {
        BigInteger retVal = null;
        if (this.ioMessagePairType != null) {
            retVal = this.ioMessagePairType.getInputMessageId();
        }
        return retVal;
    }

    public void setOutputMessageId(String messageName) throws JAXBException, CoreException {
        Transaction tran = this.retrieveTransaction();
        if (tran != null && messageName != null && !messageName.isEmpty()) {
            BigInteger existingMsgId = this.getOutputMessageId();
            BigInteger newMsgId = this.getOutputMessageId(tran, messageName);
            if ((existingMsgId == null || newMsgId != null && !newMsgId.equals(existingMsgId)) && this.ioMessagePairType != null) {
                this.ioMessagePairType.setOutputMessageId(newMsgId);
            }
        }
    }

    public void setOutputMessageId(BigInteger newMessageId) {
        if (this.ioMessagePairType != null && !this.ioMessagePairType.getOutputMessageId().equals(newMessageId)) {
            this.ioMessagePairType.setOutputMessageId(newMessageId);
        }
    }

    private BigInteger getOutputMessageId(Transaction tran, String messageName) {
        List messageList;
        if (tran != null && (messageList = tran.getOutputMessage()) != null) {
            int i = 0;
            while (i < messageList.size()) {
                MessageType currentMessage = (MessageType)messageList.get(i);
                if (currentMessage.getName().equals(messageName)) {
                    return currentMessage.getId();
                }
                ++i;
            }
        }
        return null;
    }

    public BigInteger getOutputMessageId() {
        BigInteger retVal = null;
        if (this.ioMessagePairType != null) {
            retVal = this.ioMessagePairType.getOutputMessageId();
        }
        return retVal;
    }
}

