/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.transaction.controller.editor;

import com.ibm.im.ims.metadata.transaction.ApplicationDatatypeType;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MarshallerType;
import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.transaction.controller.datastructure.DataStructureSegmentAssociation;
import com.ibm.im.ims.transaction.controller.editor.TranEditorSegmentVisitor;
import com.ibm.im.ims.transaction.controller.editor.TranEditorUpdateFieldPathsVisitor;
import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.transaction.messages.TranModelMessages;
import com.ibm.im.ims.workbench.transaction.model.FieldModel;
import com.ibm.im.ims.workbench.transaction.model.TranDataStructureModel;
import com.ibm.im.ims.workbench.transaction.model.TranDataStructuresFolder;
import com.ibm.im.ims.workbench.transaction.model.TranMessageModel;
import com.ibm.im.ims.workbench.transaction.model.TranMessagesFolder;
import com.ibm.im.ims.workbench.transaction.model.TranModel;
import com.ibm.im.ims.workbench.transaction.model.TranSegmentModel;
import com.ibm.im.ims.workbench.transaction.model.TranSegmentsFolder;
import com.ibm.im.ims.workbench.transaction.model.TranTreeObject;
import com.ibm.im.ims.workbench.transaction.model.TranTreeParent;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.transaction.messages.walkers.FieldInfoPreservationVisitor;
import com.ibm.ims.transaction.messages.walkers.IMessageVisitor;
import com.ibm.ims.transaction.messages.walkers.MessageWalker;
import com.ibm.ims.transaction.messages.walkers.MessageWalkerException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class TranEditorController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private FieldType copiedfield = null;
    private String originalCopiedName;
    private TranModel invisibleRoot;
    private boolean isUnitTest;
    private HashMap<String, MessageType> createdMessages;
    private HashMap<String, MessageType> deletedMessages;
    private HashMap<String, MessageType> updatedMessages;

    public TranEditorController(Transaction tran, String projectName) throws MessageWalkerException {
        this.invisibleRoot = new TranModel(tran);
        Logger.getLogger(this.getClass().getSimpleName());
        this.isUnitTest = !projectName.equals("IMS_Explorer_Catalog_ReadOnly");
        this.createdMessages = new HashMap();
        this.deletedMessages = new HashMap();
        this.updatedMessages = new HashMap();
        this.populateTranTree(this.invisibleRoot);
    }

    public TranEditorController(Transaction tran, String projectName, String serverName) throws MessageWalkerException {
        this(tran, projectName);
    }

    public TranModel getClonedTran() throws MessageWalkerException {
        TranModel clonedTran = new TranModel(this.invisibleRoot);
        this.populateTranTree(clonedTran);
        return clonedTran;
    }

    public Transaction getTran() {
        return this.invisibleRoot.getTran();
    }

    public boolean isUnitTest() {
        return this.isUnitTest;
    }

    public void populateDataStructureAndFieldNodes(int segmentIx, TranDataStructuresFolder dsFolder) throws MessageWalkerException {
        dsFolder.removeAllChildren();
        TranSegmentModel segmentNode = (TranSegmentModel)dsFolder.getParent();
        TranEditorSegmentVisitor visitor = new TranEditorSegmentVisitor(dsFolder);
        new MessageWalker().accept((IMessageVisitor)visitor, segmentNode.getSegment());
    }

    public void populateSegmentNodes(List<SegmentType> segments, TranSegmentsFolder segFolder) throws MessageWalkerException {
        segFolder.removeAllChildren();
        int i = 0;
        while (i < segments.size()) {
            SegmentType currSeg = segments.get(i);
            TranSegmentModel currSegNode = new TranSegmentModel(TranMessages.getLabel().getString("TMME_SEGMENT") + " " + (i + 1), currSeg, segFolder);
            TranDataStructuresFolder currDsFolder = new TranDataStructuresFolder(TranMessages.getLabel().getString("TMME_DATASTRUCTURES"), currSegNode);
            segFolder.addChild(currSegNode);
            currSegNode.addChild(currDsFolder);
            currSegNode.setTranTreeParent(segFolder);
            this.populateDataStructureAndFieldNodes(i, currDsFolder);
            ++i;
        }
    }

    public void populateTranTree(TranModel tranModel) throws MessageWalkerException {
        TranMessagesFolder inputMessagesFolder = new TranMessagesFolder(TranMessages.getLabel().getString("TMME_INPUT_MESSAGES"), (TranTreeParent)tranModel, 0);
        List inputMessages = tranModel.getTran().getInputMessage();
        this.populateMessagesFolder(inputMessagesFolder, inputMessages, tranModel);
        TranMessagesFolder outputMessagesFolder = new TranMessagesFolder(TranMessages.getLabel().getString("TMME_OUTPUT_MESSAGES"), (TranTreeParent)tranModel, 1);
        List outputMessages = tranModel.getTran().getOutputMessage();
        this.populateMessagesFolder(outputMessagesFolder, outputMessages, tranModel);
        tranModel.addChild(inputMessagesFolder);
        tranModel.addChild(outputMessagesFolder);
    }

    private void populateMessagesFolder(TranMessagesFolder messagesFolder, List<MessageType> messages, TranModel tranModel) throws MessageWalkerException {
        int i = 0;
        while (i < messages.size()) {
            MessageType currMsg = messages.get(i);
            int messageType = messagesFolder.getMessageType();
            TranMessageModel currMsgNode = new TranMessageModel(currMsg, messagesFolder, messageType, tranModel.getTran());
            TranSegmentsFolder currSegFolder = new TranSegmentsFolder(TranMessages.getLabel().getString("TMME_SEGMENTS"), currMsgNode);
            messagesFolder.addChild(currMsgNode);
            currMsgNode.addChild(currSegFolder);
            this.populateSegmentNodes(currMsg.getSegment(), currSegFolder);
            ++i;
        }
    }

    public static long getNextAvailableMessageId(Transaction transaction) {
        long retVal = 0L;
        List inputMsgList = transaction.getInputMessage();
        for (MessageType messageType : inputMsgList) {
            long currId = messageType.getId().longValue();
            if (currId <= retVal) continue;
            retVal = currId;
        }
        List outputMsgList = transaction.getOutputMessage();
        for (MessageType messageType : outputMsgList) {
            long currId = messageType.getId().longValue();
            if (currId <= retVal) continue;
            retVal = currId;
        }
        return retVal + 1L;
    }

    public TranMessageModel addMessage(TranMessagesFolder msgFolder, String name, String remarks) {
        MessageType newMsg = new MessageType();
        newMsg.setName(name);
        newMsg.setRemarks(remarks);
        BigInteger msgId = BigInteger.valueOf(TranEditorController.getNextAvailableMessageId(this.invisibleRoot.getTran()));
        newMsg.setId(msgId);
        this.createdMessages.put(msgId.toString(), newMsg);
        int msgType = msgFolder.getMessageType();
        if (msgType == 0) {
            messageTypeList = this.invisibleRoot.getTran().getInputMessage();
            messageTypeList.add(newMsg);
        } else {
            messageTypeList = this.invisibleRoot.getTran().getOutputMessage();
            messageTypeList.add(newMsg);
        }
        TranMessageModel msgNode = msgFolder.getMessageType() == 0 ? new TranMessageModel(newMsg, msgFolder, 0, this.invisibleRoot.getTran()) : new TranMessageModel(newMsg, msgFolder, 1, this.invisibleRoot.getTran());
        TranSegmentsFolder segFolder = new TranSegmentsFolder(TranMessages.getLabel().getString("TMME_SEGMENTS"), msgNode);
        msgNode.addChild(segFolder);
        msgFolder.addChild(msgNode);
        SegmentType newSeg = new SegmentType();
        newSeg.setId(BigInteger.valueOf(1L));
        newMsg.getSegment().add(newSeg);
        TranSegmentModel currSegNode = new TranSegmentModel(TranMessages.getLabel().getString("TMME_SEGMENT") + " 1", newSeg, segFolder);
        TranDataStructuresFolder currDsFolder = new TranDataStructuresFolder(TranMessages.getLabel().getString("TMME_DATASTRUCTURES"), currSegNode);
        segFolder.addChild(currSegNode);
        currSegNode.addChild(currDsFolder);
        return msgNode;
    }

    private void updateMsgHashMaps(MessageType msg) {
        String msgId = msg.getId().toString();
        if (this.createdMessages.get(msgId) != null) {
            this.createdMessages.put(msgId, msg);
        } else {
            this.updatedMessages.put(msgId, msg);
        }
    }

    public void editMessage(TranMessageModel msgNode, String name, String remarks) {
        msgNode.setName(name);
        MessageType msg = msgNode.getMessage();
        msg.setName(name);
        msg.setRemarks(remarks);
        this.updateMsgHashMaps(msg);
    }

    public void editDataStructure(TranDataStructureModel dsNode, String name, String remarks) {
        dsNode.setName(name);
        dsNode.getField().setName(name);
        dsNode.getField().setRemarks(remarks);
        TranDataStructuresFolder dsFolder = (TranDataStructuresFolder)dsNode.getParent();
        TranSegmentModel segNode = (TranSegmentModel)dsFolder.getParent();
        TranSegmentsFolder segFolder = (TranSegmentsFolder)segNode.getParent();
        TranMessageModel msgNode = (TranMessageModel)segFolder.getParent();
        MessageType msg = msgNode.getMessage();
        try {
            new MessageWalker().accept((IMessageVisitor)new TranEditorUpdateFieldPathsVisitor(), dsNode.getField());
        }
        catch (MessageWalkerException e) {
            logger.error((Throwable)e);
        }
        this.updateMsgHashMaps(msg);
    }

    public void editField(FieldModel fieldNode, String name, String remarks) {
        fieldNode.setName(name);
        fieldNode.getFieldType().setName(name);
        fieldNode.getFieldType().setRemarks(remarks);
        TranDataStructureModel dsNode = (TranDataStructureModel)fieldNode.getParent();
        TranDataStructuresFolder dsFolder = (TranDataStructuresFolder)dsNode.getParent();
        TranSegmentModel segNode = (TranSegmentModel)dsFolder.getParent();
        TranSegmentsFolder segFolder = (TranSegmentsFolder)segNode.getParent();
        TranMessageModel msgNode = (TranMessageModel)segFolder.getParent();
        MessageType msg = msgNode.getMessage();
        try {
            new MessageWalker().accept((IMessageVisitor)new TranEditorUpdateFieldPathsVisitor(), dsNode.getField());
        }
        catch (MessageWalkerException e) {
            logger.error((Throwable)e);
        }
        this.updateMsgHashMaps(msg);
    }

    public List<TranDataStructureModel> getDataStructureNodes(TranMessageModel msgNode, int segId) {
        TranSegmentsFolder segFolder = (TranSegmentsFolder)msgNode.getChildren()[0];
        TranSegmentModel segNode = (TranSegmentModel)segFolder.getChildren()[segId - 1];
        TranDataStructuresFolder dsFolder = (TranDataStructuresFolder)segNode.getChildren()[0];
        TranTreeObject[] dsArray = dsFolder.getChildren();
        ArrayList<TranDataStructureModel> dsNodes = new ArrayList<TranDataStructureModel>();
        int i = 0;
        while (i < dsArray.length) {
            dsNodes.add((TranDataStructureModel)dsArray[i]);
            ++i;
        }
        return dsNodes;
    }

    public List<TranSegmentModel> getSegmentNodes(TranMessageModel msgNode) {
        TranSegmentsFolder segFolder = (TranSegmentsFolder)msgNode.getChildren()[0];
        TranTreeObject[] segArray = segFolder.getChildren();
        ArrayList<TranSegmentModel> segNodes = new ArrayList<TranSegmentModel>();
        int i = 0;
        while (i < segArray.length) {
            segNodes.add((TranSegmentModel)segArray[i]);
            ++i;
        }
        return segNodes;
    }

    public TranMessagesFolder getMessageFolder(int msgDirection) {
        TranTreeObject[] children = this.getInvisibleRoot().getChildren();
        return (TranMessagesFolder)children[msgDirection];
    }

    public TranMessageModel getMsgNode(String msgName, int msgDirection) {
        TranMessageModel retVal = null;
        List<TranMessageModel> msgNodes = this.getMessageNodes(msgDirection);
        for (TranMessageModel msgNode : msgNodes) {
            if (!msgNode.getMessage().getName().equals(msgName)) continue;
            retVal = msgNode;
            break;
        }
        return retVal;
    }

    public TranMessageModel getMsgNodeByName(String msgName) {
        TranMessageModel retVal = null;
        List<TranMessageModel> msgNodes = this.getMessageNodes(0);
        for (TranMessageModel msgNode : msgNodes) {
            if (!msgNode.getMessage().getName().equals(msgName)) continue;
            retVal = msgNode;
            break;
        }
        if (retVal == null) {
            msgNodes = this.getMessageNodes(1);
            for (TranMessageModel msgNode : msgNodes) {
                if (!msgNode.getMessage().getName().equals(msgName)) continue;
                retVal = msgNode;
                break;
            }
        }
        return retVal;
    }

    public List<TranMessageModel> getMessageNodes(int msgDirection) {
        TranMessagesFolder msgFolder = this.getMessageFolder(msgDirection);
        TranTreeObject[] msgs = msgFolder.getChildren();
        ArrayList<TranMessageModel> retVal = new ArrayList<TranMessageModel>(msgs.length);
        TranTreeObject[] tranTreeObjectArray = msgs;
        int n = msgs.length;
        int n2 = 0;
        while (n2 < n) {
            TranTreeObject tranTreeObject = tranTreeObjectArray[n2];
            retVal.add((TranMessageModel)tranTreeObject);
            ++n2;
        }
        return retVal;
    }

    public void removeMessage(TranMessageModel msgNode) {
        TranMessagesFolder msgFolder = (TranMessagesFolder)msgNode.getParent();
        int msgType = msgNode.getMessageType();
        List msgList = msgType == 0 ? this.invisibleRoot.getTran().getInputMessage() : this.invisibleRoot.getTran().getOutputMessage();
        MessageType msg = msgNode.getMessage();
        msgList.remove(msg);
        msgNode.deleteMessage();
        msgFolder.removeChild(msgNode);
        this.deletedMessages.put(msg.getId().toString(), msg);
    }

    public void removeSegment(TranSegmentModel segNode) {
        TranSegmentsFolder segFolder = (TranSegmentsFolder)segNode.getParent();
        TranMessageModel msgNode = (TranMessageModel)segFolder.getParent();
        MessageType message = msgNode.getMessage();
        List segmentList = message.getSegment();
        segmentList.remove(segNode.getSegment());
        segNode.deleteSegment();
        segFolder.removeChild(segNode);
        this.updateMsgHashMaps(message);
    }

    public void removeDataStructure(TranDataStructureModel dsNode) {
        TranTreeParent dsFolder = (TranTreeParent)dsNode.getParent();
        TranSegmentModel segNode = (TranSegmentModel)dsFolder.getParent();
        SegmentType seg = segNode.getSegment();
        List fieldList = seg.getField();
        fieldList.remove(dsNode.getField());
        dsNode.deleteField();
        dsFolder.removeChild(dsNode);
        TranSegmentsFolder segFolder = (TranSegmentsFolder)segNode.getParent();
        TranMessageModel msgNode = (TranMessageModel)segFolder.getParent();
        MessageType msg = msgNode.getMessage();
        this.updateMsgHashMaps(msg);
    }

    public boolean canMoveUp(TranTreeObject node) {
        TranTreeObject[] children = ((TranTreeParent)node.getParent()).getChildren();
        int index = -1;
        int i = 0;
        while (i < children.length) {
            if (children[i] == node) {
                index = i;
                break;
            }
            ++i;
        }
        return index > 0;
    }

    public boolean canMoveDown(TranTreeObject node) {
        TranTreeObject[] children = ((TranTreeParent)node.getParent()).getChildren();
        int index = -1;
        int i = 0;
        while (i < children.length) {
            if (children[i] == node) {
                index = i;
                break;
            }
            ++i;
        }
        return index + 1 < children.length;
    }

    public void copyDataStructure(TranDataStructureModel dsNode) {
        this.copiedfield = TranEditorController.cloneFieldType(dsNode.getField());
        this.originalCopiedName = this.copiedfield.getName();
    }

    public void reCopyDsForMultiplePastes() {
        this.copiedfield = TranEditorController.cloneFieldType(this.copiedfield);
        this.copiedfield.setName(this.originalCopiedName);
    }

    public boolean canPaste() {
        return this.copiedfield != null;
    }

    public void setCopiedFieldName(String newName) {
        this.copiedfield.setName(newName);
        try {
            new MessageWalker().accept((IMessageVisitor)new TranEditorUpdateFieldPathsVisitor(), this.copiedfield);
        }
        catch (MessageWalkerException e) {
            logger.error((Throwable)e);
        }
    }

    public String getCopiedFieldName() {
        return this.copiedfield.getName();
    }

    public Vector<String> getExistingDsNamesForImport(DataStructureSegmentAssociation dssa) {
        Vector<String> retVal = new Vector<String>();
        BigInteger msgId = dssa.messageId;
        TranDataStructuresFolder dsFolder = null;
        boolean isInput = dssa.messageName.indexOf(" **IN**") > 0;
        List messageTypes = this.invisibleRoot.getTran().getInputMessage();
        if (!isInput) {
            messageTypes = this.invisibleRoot.getTran().getOutputMessage();
        }
        for (MessageType mt : messageTypes) {
            if (!mt.getId().equals(msgId)) continue;
            for (SegmentType st : mt.getSegment()) {
                dsFolder = this.findDsFolderNode(msgId, st.getId(), isInput);
                if (dsFolder == null) continue;
                TranTreeObject[] dsNodes = dsFolder.getChildren();
                int i = 0;
                while (i < dsNodes.length) {
                    retVal.add(((TranDataStructureModel)dsNodes[i]).getName());
                    ++i;
                }
            }
        }
        return retVal;
    }

    public void preserveFieldInfoAndRemoveDs(DataStructureSegmentAssociation dssa) throws MessageWalkerException {
        BigInteger msgId = dssa.messageId;
        TranDataStructuresFolder dsFolder = null;
        boolean isInput = dssa.messageName.indexOf(" **IN**") > 0;
        List messageTypes = this.invisibleRoot.getTran().getInputMessage();
        if (!isInput) {
            messageTypes = this.invisibleRoot.getTran().getOutputMessage();
        }
        FieldType existingDsTopFieldType = null;
        for (MessageType mt : messageTypes) {
            if (!mt.getId().equals(msgId)) continue;
            block1: for (SegmentType st : mt.getSegment()) {
                dsFolder = this.findDsFolderNode(msgId, st.getId(), isInput);
                if (dsFolder == null) continue;
                TranTreeObject[] dsNodes = dsFolder.getChildren();
                int i = 0;
                while (i < dsNodes.length) {
                    String existingDsName = ((TranDataStructureModel)dsNodes[i]).getName();
                    if (existingDsName.equals(dssa.dataStructure.getName())) {
                        existingDsTopFieldType = ((TranDataStructureModel)dsNodes[i]).getField();
                        st.getField().remove(existingDsTopFieldType);
                        continue block1;
                    }
                    ++i;
                }
            }
        }
        if (existingDsTopFieldType != null) {
            MessageType tempExistingMsg = new MessageType();
            SegmentType tempExistingSeg = new SegmentType();
            tempExistingSeg.getField().add(existingDsTopFieldType);
            tempExistingMsg.getSegment().add(tempExistingSeg);
            FieldInfoPreservationVisitor visitor = new FieldInfoPreservationVisitor(existingDsTopFieldType, dssa.dataStructure);
            MessageWalker mw = new MessageWalker();
            mw.accept((IMessageVisitor)visitor, tempExistingMsg);
        }
    }

    public void renameDsForPaste(String collidedName, Vector<String> existingDsNames) {
        String startName = TranModelMessages.getLabel().getString("RND_COPY") + collidedName;
        int i = 2;
        String name = startName;
        while (this.nameCollision(name, existingDsNames)) {
            name = startName + i;
            ++i;
        }
        this.setCopiedFieldName(name);
    }

    public void renameDsForImport(String collidedName, Vector<String> existingDsNames, DataStructureSegmentAssociation dssa) {
        String startName = TranModelMessages.getLabel().getString("RND_COPY") + collidedName;
        int i = 2;
        String name = startName;
        while (this.nameCollision(name, existingDsNames)) {
            name = startName + i;
            ++i;
        }
        dssa.dataStructure.setName(name);
        try {
            new MessageWalker().accept((IMessageVisitor)new TranEditorUpdateFieldPathsVisitor(), dssa.dataStructure);
        }
        catch (MessageWalkerException e) {
            logger.error((Throwable)e);
        }
    }

    private boolean nameCollision(String name, Vector<String> existingDsNames) {
        boolean retVal = false;
        Iterator<String> iter = existingDsNames.iterator();
        while (iter.hasNext()) {
            if (!name.equalsIgnoreCase(iter.next())) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public void checkNameCollisionAmongImportDS(String possibleCollideName, Vector<DataStructureSegmentAssociation> importResult, int currPos) {
        Object[] dsArray = importResult.toArray();
        Vector<String> duplicateImportDsNames = null;
        DataStructureSegmentAssociation currDs = (DataStructureSegmentAssociation)dsArray[currPos];
        int i = 0;
        while (i < dsArray.length) {
            if (i != currPos) {
                DataStructureSegmentAssociation compareDs = (DataStructureSegmentAssociation)dsArray[i];
                if (currDs.dataStructure.getName().equalsIgnoreCase(compareDs.dataStructure.getName()) && currDs.messageId.equals(compareDs.messageId)) {
                    FieldType cloneFieldType;
                    String collidingName = compareDs.dataStructure.getName();
                    compareDs.dataStructure = cloneFieldType = TranEditorController.cloneFieldType(compareDs.dataStructure);
                    if (duplicateImportDsNames == null) {
                        duplicateImportDsNames = new Vector<String>();
                    }
                    if (!duplicateImportDsNames.contains(collidingName)) {
                        duplicateImportDsNames.add(collidingName);
                    }
                    Vector<String> allExistingDsNames = this.getExistingDsNamesForImport(compareDs);
                    allExistingDsNames.addAll(duplicateImportDsNames);
                    this.renameDsForImport(possibleCollideName, allExistingDsNames, compareDs);
                    duplicateImportDsNames.add(compareDs.dataStructure.getName());
                    if (compareDs.nameCollision) {
                        compareDs.nameCollision = false;
                    }
                }
            }
            ++i;
        }
    }

    public Vector<String> getExistingDsNamesForPaste(Object node) {
        Vector<String> retVal = new Vector<String>();
        TranTreeParent segFolder = null;
        if (node instanceof TranDataStructureModel) {
            TranDataStructuresFolder dsFolder = (TranDataStructuresFolder)((TranDataStructureModel)node).getParent();
            TranSegmentModel segNode = (TranSegmentModel)dsFolder.getParent();
            segFolder = (TranSegmentsFolder)segNode.getParent();
        } else if (node instanceof TranDataStructuresFolder) {
            TranSegmentModel segNode = (TranSegmentModel)((TranDataStructuresFolder)node).getParent();
            segFolder = (TranSegmentsFolder)segNode.getParent();
        }
        TranTreeObject[] segNodes = segFolder.getChildren();
        int i = 0;
        while (i < segNodes.length) {
            TranSegmentModel currSegNode = (TranSegmentModel)segNodes[i];
            TranDataStructuresFolder dsFolder = (TranDataStructuresFolder)currSegNode.getChildren()[0];
            TranTreeObject[] dsNodes = dsFolder.getChildren();
            int j = 0;
            while (j < dsNodes.length) {
                retVal.add(((TranDataStructureModel)dsNodes[j]).getName());
                ++j;
            }
            ++i;
        }
        return retVal;
    }

    public String checkNameCollisionForPaste(Object selectedNode) {
        String retVal = null;
        if (this.copiedfield != null) {
            String name1 = this.copiedfield.getName();
            TranTreeParent segFolder = null;
            if (selectedNode instanceof TranDataStructureModel) {
                TranDataStructuresFolder dsFolder = (TranDataStructuresFolder)((TranDataStructureModel)selectedNode).getParent();
                TranSegmentModel segNode = (TranSegmentModel)dsFolder.getParent();
                segFolder = (TranSegmentsFolder)segNode.getParent();
            } else if (selectedNode instanceof TranDataStructuresFolder) {
                TranSegmentModel segNode = (TranSegmentModel)((TranDataStructuresFolder)selectedNode).getParent();
                segFolder = (TranSegmentsFolder)segNode.getParent();
            }
            TranTreeObject[] segNodes = segFolder.getChildren();
            int i = 0;
            while (i < segNodes.length && retVal == null) {
                TranSegmentModel currSegNode = (TranSegmentModel)segNodes[i];
                TranDataStructuresFolder dsFolder = (TranDataStructuresFolder)currSegNode.getChildren()[0];
                TranTreeObject[] dsNodes = dsFolder.getChildren();
                int j = 0;
                while (j < dsNodes.length && retVal == null) {
                    String name2 = ((TranDataStructureModel)dsNodes[j]).getName();
                    if (name1.equalsIgnoreCase(name2)) {
                        retVal = name1;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return retVal;
    }

    public void pasteDataStructure(Object selectedNode) throws UnsupportedTypeConversion, IOException, ConversionException, MessageWalkerException {
        if (this.copiedfield != null) {
            TranMessageModel msgNode = null;
            TranSegmentsFolder segFolder = null;
            TranDataStructuresFolder dsFolder = null;
            TranTreeObject segNode = null;
            if (selectedNode instanceof TranDataStructureModel) {
                TranDataStructureModel dsNode = (TranDataStructureModel)selectedNode;
                dsFolder = (TranDataStructuresFolder)dsNode.getParent();
                TranDataStructureModel newDsNode = new TranDataStructureModel(this.copiedfield, (TranTreeParent)dsFolder);
                dsFolder.addChildAfter(dsNode, newDsNode);
                segNode = (TranSegmentModel)dsFolder.getParent();
                List fieldTypeList = ((TranSegmentModel)segNode).getSegment().getField();
                int afterIndex = fieldTypeList.indexOf(dsNode.getField());
                fieldTypeList.add(afterIndex + 1, this.copiedfield);
                this.populateDataStructureAndFieldNodes(0, dsFolder);
            } else if (selectedNode instanceof TranDataStructuresFolder) {
                dsFolder = (TranDataStructuresFolder)selectedNode;
                TranDataStructureModel newDsNode = new TranDataStructureModel(this.copiedfield, (TranTreeParent)dsFolder);
                dsFolder.addChild(newDsNode);
                segNode = (TranSegmentModel)dsFolder.getParent();
                List fieldTypeList = ((TranSegmentModel)segNode).getSegment().getField();
                fieldTypeList.add(this.copiedfield);
                this.populateDataStructureAndFieldNodes(0, dsFolder);
            }
            if (segNode != null) {
                segFolder = (TranSegmentsFolder)segNode.getParent();
                msgNode = (TranMessageModel)segFolder.getParent();
                MessageType msg = msgNode.getMessage();
                this.updateMsgHashMaps(msg);
            }
        }
    }

    public void moveUpSegment(TranSegmentModel segNode) {
        SegmentType segToMove;
        TranSegmentsFolder segFolder = (TranSegmentsFolder)segNode.getParent();
        TranMessageModel msgNode = (TranMessageModel)segFolder.getParent();
        MessageType msg = msgNode.getMessage();
        List segmentList = msg.getSegment();
        int currentIndex = segmentList.indexOf(segToMove = segNode.getSegment());
        if (currentIndex != 0) {
            segmentList.remove(segToMove);
            segmentList.add(currentIndex - 1, segToMove);
            TranTreeObject[] segNodeArray = segFolder.getChildren();
            TranTreeObject childToAddBefore = segNodeArray[currentIndex - 1];
            segFolder.removeChildFromArray(segNode);
            segFolder.addChildBefore(childToAddBefore, segNode);
            segNode.setName(TranMessages.getLabel().getString("TMME_SEGMENT") + currentIndex);
            childToAddBefore.setName(TranMessages.getLabel().getString("TMME_SEGMENT") + (currentIndex + 1));
            this.updateMsgHashMaps(msg);
        }
    }

    public void moveDownSegment(TranSegmentModel segNode) {
        TranSegmentsFolder segFolder = (TranSegmentsFolder)segNode.getParent();
        TranMessageModel msgNode = (TranMessageModel)segFolder.getParent();
        MessageType msg = msgNode.getMessage();
        List segmentList = msg.getSegment();
        int segmentListSize = segmentList.size();
        SegmentType segToMove = segNode.getSegment();
        int currentIndex = segmentList.indexOf(segToMove);
        if (currentIndex != segmentListSize - 1) {
            segmentList.remove(segToMove);
            segmentList.add(currentIndex + 1, segToMove);
            TranTreeObject[] segNodeArray = segFolder.getChildren();
            TranTreeObject childToAddAfter = segNodeArray[currentIndex + 1];
            segFolder.removeChildFromArray(segNode);
            segFolder.addChildAfter(childToAddAfter, segNode);
            segNode.setName(TranMessages.getLabel().getString("TMME_SEGMENT") + (currentIndex + 2));
            childToAddAfter.setName(TranMessages.getLabel().getString("TMME_SEGMENT") + (currentIndex + 1));
            this.updateMsgHashMaps(msg);
        }
    }

    public void moveUpDataStructure(TranDataStructureModel dsNode) {
        FieldType fieldToMove;
        TranDataStructuresFolder dsFolder = (TranDataStructuresFolder)dsNode.getParent();
        TranSegmentModel segNode = (TranSegmentModel)dsFolder.getParent();
        SegmentType segment = segNode.getSegment();
        List fieldList = segment.getField();
        int currentIndex = fieldList.indexOf(fieldToMove = dsNode.getField());
        if (currentIndex != 0) {
            fieldList.remove(fieldToMove);
            fieldList.add(currentIndex - 1, fieldToMove);
            TranTreeObject[] dsNodeArray = dsFolder.getChildren();
            TranTreeObject childToAddBefore = dsNodeArray[currentIndex - 1];
            dsFolder.removeChildFromArray(dsNode);
            dsFolder.addChildBefore(childToAddBefore, dsNode);
            TranSegmentsFolder segFolder = (TranSegmentsFolder)segNode.getParent();
            TranMessageModel msgNode = (TranMessageModel)segFolder.getParent();
            MessageType msg = msgNode.getMessage();
            this.updateMsgHashMaps(msg);
        }
    }

    public void moveDownDataStructure(TranDataStructureModel dsNode) {
        TranDataStructuresFolder dsFolder = (TranDataStructuresFolder)dsNode.getParent();
        TranSegmentModel segNode = (TranSegmentModel)dsFolder.getParent();
        SegmentType segment = segNode.getSegment();
        List fieldList = segment.getField();
        int fieldListSize = fieldList.size();
        FieldType fieldToMove = dsNode.getField();
        int currentIndex = fieldList.indexOf(fieldToMove);
        if (currentIndex != fieldListSize - 1) {
            fieldList.remove(fieldToMove);
            fieldList.add(currentIndex + 1, fieldToMove);
            TranTreeObject[] dsNodeArray = dsFolder.getChildren();
            TranTreeObject childToAddAfter = dsNodeArray[currentIndex + 1];
            dsFolder.removeChildFromArray(dsNode);
            dsFolder.addChildAfter(childToAddAfter, dsNode);
            TranSegmentsFolder segFolder = (TranSegmentsFolder)segNode.getParent();
            TranMessageModel msgNode = (TranMessageModel)segFolder.getParent();
            MessageType msg = msgNode.getMessage();
            this.updateMsgHashMaps(msg);
        }
    }

    public static long getNextAvailableSegmentId(MessageType msgType) {
        long retVal = 0L;
        List segments = msgType.getSegment();
        for (SegmentType segmentType : segments) {
            long currId = segmentType.getId().longValue();
            if (currId <= retVal) continue;
            retVal = currId;
        }
        return retVal + 1L;
    }

    public void addSegment(TranSegmentsFolder segFolder) {
        TranMessageModel msgNode = (TranMessageModel)segFolder.getParent();
        MessageType msg = msgNode.getMessage();
        List segments = msg.getSegment();
        SegmentType newSegment = new SegmentType();
        BigInteger msgId = BigInteger.valueOf(TranEditorController.getNextAvailableSegmentId(msg));
        newSegment.setId(msgId);
        segments.add(newSegment);
        this.updateMsgHashMaps(msg);
    }

    public void addSegment(TranMessageModel msgNode) {
        MessageType msg = msgNode.getMessage();
        List segments = msg.getSegment();
        SegmentType newSegment = new SegmentType();
        BigInteger msgId = BigInteger.valueOf(TranEditorController.getNextAvailableSegmentId(msg));
        newSegment.setId(msgId);
        segments.add(newSegment);
        this.updateMsgHashMaps(msg);
    }

    public TranDataStructuresFolder findDsFolderNode(BigInteger msgId, BigInteger segId, boolean isInput) {
        TranDataStructuresFolder retVal = null;
        TranTreeParent msgNode = null;
        TranMessagesFolder msgFolder = isInput ? (TranMessagesFolder)this.invisibleRoot.getChildren()[0] : (TranMessagesFolder)this.invisibleRoot.getChildren()[1];
        TranTreeObject[] msgNodes = msgFolder.getChildren();
        int i = 0;
        while (i < msgNodes.length) {
            TranMessageModel currMsg = (TranMessageModel)msgNodes[i];
            MessageType currMsgType = currMsg.getMessage();
            if (currMsgType.getId().equals(msgId)) {
                msgNode = currMsg;
                break;
            }
            ++i;
        }
        if (msgNode != null) {
            TranTreeParent segFolder = (TranTreeParent)msgNode.getChildren()[0];
            TranTreeObject[] segNodeList = segFolder.getChildren();
            int i2 = 0;
            while (i2 < segNodeList.length) {
                TranSegmentModel currSegNode = (TranSegmentModel)segNodeList[i2];
                if (currSegNode.getSegment().getId().equals(segId)) {
                    retVal = (TranDataStructuresFolder)currSegNode.getChildren()[0];
                    break;
                }
                ++i2;
            }
        }
        return retVal;
    }

    public List<TranDataStructuresFolder> findFirstDsFolderNodes() {
        TranSegmentModel currSegNode;
        TranTreeParent segFolder;
        TranTreeObject[] segNodeList;
        ArrayList<TranDataStructuresFolder> retVal = new ArrayList<TranDataStructuresFolder>();
        TranMessageModel msgNode = null;
        TranMessagesFolder msgFolder1 = (TranMessagesFolder)this.invisibleRoot.getChildren()[0];
        TranMessagesFolder msgFolder2 = (TranMessagesFolder)this.invisibleRoot.getChildren()[1];
        TranTreeObject[] msgNodes = msgFolder1.getChildren();
        if (msgNodes.length > 0 && (msgNode = (TranMessageModel)msgNodes[0]) != null && (segNodeList = (segFolder = (TranTreeParent)msgNode.getChildren()[0]).getChildren()).length > 0) {
            currSegNode = (TranSegmentModel)segNodeList[0];
            retVal.add((TranDataStructuresFolder)currSegNode.getChildren()[0]);
        }
        if ((msgNodes = msgFolder2.getChildren()).length > 0 && (msgNode = (TranMessageModel)msgNodes[0]) != null && (segNodeList = (segFolder = (TranTreeParent)msgNode.getChildren()[0]).getChildren()).length > 0) {
            currSegNode = (TranSegmentModel)segNodeList[0];
            retVal.add((TranDataStructuresFolder)currSegNode.getChildren()[0]);
        }
        return retVal;
    }

    public void addImportedDS(Vector<DataStructureSegmentAssociation> dssaList) throws UnsupportedTypeConversion, IOException, ConversionException, MessageWalkerException {
        HashMap<CallSite, segmentAndDsFolder> populateMap = new HashMap<CallSite, segmentAndDsFolder>();
        int i = 0;
        while (i < dssaList.size()) {
            DataStructureSegmentAssociation dssa = dssaList.get(i);
            FieldType dataStructure = dssa.dataStructure;
            BigInteger segId = dssa.segmentId;
            BigInteger msgId = dssa.messageId;
            SegmentType segmentType = null;
            TranTreeParent dsFolder = null;
            boolean found = false;
            boolean isInput = dssa.messageName.indexOf(" **IN**") > 0;
            List messageTypes = this.invisibleRoot.getTran().getInputMessage();
            if (!isInput) {
                messageTypes = this.invisibleRoot.getTran().getOutputMessage();
            }
            block1: for (MessageType mt : messageTypes) {
                if (found) break;
                if (!mt.getId().equals(msgId)) continue;
                for (SegmentType st : mt.getSegment()) {
                    if (!st.getId().equals(segId)) continue;
                    segmentType = st;
                    st.getField().add(dataStructure);
                    dsFolder = this.findDsFolderNode(msgId, segId, isInput);
                    found = true;
                    this.updateMsgHashMaps(mt);
                    continue block1;
                }
            }
            if (found) {
                dsFolder.removeAllChildren();
                String key = msgId.toString() + segId.toString();
                segmentAndDsFolder value = (segmentAndDsFolder)populateMap.get(key);
                if (value == null) {
                    populateMap.put((CallSite)((Object)key), new segmentAndDsFolder(segmentType, (TranDataStructuresFolder)dsFolder));
                }
            }
            ++i;
        }
        if (!populateMap.isEmpty()) {
            Object[] populateList = populateMap.values().toArray();
            int i2 = 0;
            while (i2 < populateList.length) {
                segmentAndDsFolder currItem = (segmentAndDsFolder)populateList[i2];
                TranSegmentModel segmentNode = (TranSegmentModel)currItem.dsFolder.getParent();
                TranSegmentsFolder segFolder = (TranSegmentsFolder)segmentNode.getParent();
                TranMessageModel msgNode = (TranMessageModel)segFolder.getParent();
                List segmentTypes = msgNode.getMessage().getSegment();
                int segmentIx = 0;
                int j = 0;
                while (j < segmentTypes.size()) {
                    SegmentType segmentType = (SegmentType)segmentTypes.get(j);
                    if (currItem.segType == segmentType) {
                        segmentIx = j;
                        break;
                    }
                    ++j;
                }
                this.populateDataStructureAndFieldNodes(segmentIx, currItem.dsFolder);
                ++i2;
            }
        }
    }

    public static MarshallerType cloneMarshallerType(MarshallerType fromMarshallerType) {
        MarshallerType toMarshallerType = new MarshallerType();
        toMarshallerType.setEncoding(fromMarshallerType.getEncoding());
        toMarshallerType.setIsNullable(fromMarshallerType.getIsNullable());
        toMarshallerType.setIsSigned(fromMarshallerType.getIsSigned());
        toMarshallerType.setIsSignLeading(fromMarshallerType.getIsSignLeading());
        toMarshallerType.setIsSignSeparate(fromMarshallerType.getIsSignSeparate());
        toMarshallerType.setIsDBCSOnly(fromMarshallerType.getIsDBCSOnly());
        toMarshallerType.setIsWCHAROnly(fromMarshallerType.getIsWCHAROnly());
        toMarshallerType.setIsNativeInteger(fromMarshallerType.getIsNativeInteger());
        toMarshallerType.setPattern(fromMarshallerType.getPattern());
        toMarshallerType.setUserTypeConverter(fromMarshallerType.getUserTypeConverter());
        toMarshallerType.setTypeConverter(fromMarshallerType.getTypeConverter());
        return toMarshallerType;
    }

    public static FieldType cloneFieldType(FieldType fromFieldType) {
        ApplicationDatatypeType fromAdt;
        FieldType toFieldType = new FieldType();
        toFieldType.setStartPos(fromFieldType.getStartPos());
        toFieldType.setRelativeStart(fromFieldType.getRelativeStart());
        toFieldType.setStartAfter(fromFieldType.getStartAfter());
        toFieldType.setBytes(fromFieldType.getBytes());
        toFieldType.setMaxBytes(fromFieldType.getMaxBytes());
        toFieldType.setRemarks(fromFieldType.getRemarks());
        MarshallerType marshaller = fromFieldType.getMarshaller();
        if (marshaller != null) {
            toFieldType.setMarshaller(TranEditorController.cloneMarshallerType(marshaller));
        }
        if ((fromAdt = fromFieldType.getApplicationDatatype()) != null) {
            ApplicationDatatypeType toAdt = new ApplicationDatatypeType();
            toAdt.setDatatype(fromAdt.getDatatype());
            toAdt.setPrecision(fromAdt.getPrecision());
            toAdt.setScale(fromAdt.getScale());
            toFieldType.setApplicationDatatype(toAdt);
        }
        Iterator subFieldIter = fromFieldType.getField().iterator();
        List toFieldTypeSubFieldList = toFieldType.getField();
        while (subFieldIter.hasNext()) {
            FieldType currSubField = (FieldType)subFieldIter.next();
            toFieldTypeSubFieldList.add(TranEditorController.cloneFieldType(currSubField));
        }
        toFieldType.setName(fromFieldType.getName());
        toFieldType.setOriginalName(fromFieldType.getOriginalName());
        toFieldType.setPath(fromFieldType.getPath());
        toFieldType.setDependsOn(fromFieldType.getDependsOn());
        toFieldType.setDependedOn(fromFieldType.isDependedOn());
        toFieldType.setDependsOnPath(fromFieldType.getDependsOnPath());
        toFieldType.setRedefines(fromFieldType.getRedefines());
        toFieldType.setMinOccurs(fromFieldType.getMinOccurs());
        toFieldType.setMaxOccurs(fromFieldType.getMaxOccurs());
        return toFieldType;
    }

    public void doSave(String projectName, IFile file) throws JAXBException, CoreException {
        ProjectTreeFileHelper.marshallTran(projectName, this.invisibleRoot.getTran(), file);
        this.createdMessages.clear();
        this.deletedMessages.clear();
        this.updatedMessages.clear();
    }

    public TranModel getInvisibleRoot() {
        return this.invisibleRoot;
    }

    public void setInvisibleRoot(TranModel another) throws MessageWalkerException {
        this.invisibleRoot = another;
        this.populateTranTree(this.invisibleRoot);
    }

    class segmentAndDsFolder {
        SegmentType segType;
        TranDataStructuresFolder dsFolder;

        segmentAndDsFolder(SegmentType segType, TranDataStructuresFolder dsFolder) {
            this.segType = segType;
            this.dsFolder = dsFolder;
        }
    }
}

