/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.transaction.controller.editor;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.im.ims.metadata.testcase.FieldValueType;
import com.ibm.im.ims.metadata.testcase.InteractionType;
import com.ibm.im.ims.metadata.testcase.IoMessagePairType;
import com.ibm.im.ims.metadata.testcase.Testcase;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.transaction.controller.editor.IconapiConnectionCache;
import com.ibm.im.ims.transaction.model.utilities.ClipBoard;
import com.ibm.im.ims.transaction.model.utilities.ImporterException;
import com.ibm.im.ims.transaction.model.utilities.PasswordMap;
import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.transaction.model.utilities.TrantocMapManager;
import com.ibm.im.ims.transaction.model.utilities.Utility;
import com.ibm.im.ims.workbench.transaction.connections.exceptions.ImsTmConnectionException;
import com.ibm.im.ims.workbench.transaction.connections.types.IImsTmConnection;
import com.ibm.im.ims.workbench.transaction.connections.utils.ImsTmConnectionUtil;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.testcase.model.DataStructureNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.FieldNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.IOMessageNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.IOMessagePairNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.JsonFieldNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.JsonMessageNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.SegmentNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.TestCaseFolderNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.TestCaseNode;
import com.ibm.ims.connect.ApiLoggingConfiguration;
import com.ibm.ims.connect.ApiProperties;
import com.ibm.ims.connect.Connection;
import com.ibm.ims.connect.ImsConnectApiException;
import com.ibm.ims.connect.ImsConnectCommunicationException;
import com.ibm.ims.connect.ImsConnectExecutionException;
import com.ibm.ims.connect.InputMessage;
import com.ibm.ims.connect.OutputMessage;
import com.ibm.ims.connect.TmInteraction;
import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.transaction.messages.MessagePayloadManager;
import com.ibm.ims.transaction.messages.walkers.MessageWalkerException;
import com.ibm.ims.transaction.model.FieldValue;
import com.ibm.ims.transaction.util.TraceWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class TestcaseEditorController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private String projectName;
    private String serverName;
    private String serverId;
    private String runConfigName;
    private Testcase testcase;
    private String testcaseFilename;
    private TestCaseNode invisibleRoot;
    private boolean outputDsContainsLLZZ = true;
    private boolean isRunConsole = false;
    private ImsConnectApiException connectApiException;
    private ImsConnectExecutionException connectApiExecutionException;
    private static final String newLine = System.getProperty("line.separator");
    private String traceFile;
    private boolean isUnitTest;
    private String serviceOutputMsgName;
    private boolean testcaseUpdated;
    private ConnectionProfile connectionProfile;
    public static final String ICON_SUFFIX = " (" + TranMessages.getLabel().getString("RCW_TRANSERVER") + ")";

    public TestcaseEditorController(String projectName, Testcase testcase, String traceFile) throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        this.testcase = testcase;
        this.projectName = projectName;
        this.traceFile = traceFile;
        this.isUnitTest = true;
        this.populateTestCase();
    }

    public TestcaseEditorController(String projectName, String traceFile) throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        this.projectName = projectName;
        this.traceFile = traceFile;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        this.isUnitTest = TestcaseEditorController.hasUnitTestProjectNature(project);
    }

    public static String[] getUnitTestProjects() {
        IProject[] projects;
        ArrayList<String> tProjects = new ArrayList<String>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (TestcaseEditorController.hasUnitTestProjectNature(iProject)) {
                tProjects.add(iProject.getName());
            }
            ++n2;
        }
        return tProjects.toArray(new String[0]);
    }

    public static String[] getServiceTestProjects() {
        IProject[] projects;
        ArrayList<String> tProjects = new ArrayList<String>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (TestcaseEditorController.hasServiceTestProjectNature(iProject)) {
                tProjects.add(iProject.getName());
            }
            ++n2;
        }
        return tProjects.toArray(new String[0]);
    }

    public static boolean hasServiceTestProjectNature(IProject iProject) {
        try {
            if (iProject != null && iProject.isOpen() && iProject.getNature("com.ibm.ims.gw.ui.nature") != null) {
                return true;
            }
        }
        catch (CoreException e) {
            logger.throwing(TestcaseEditorController.class.getName(), "", (Throwable)e);
            logger.error((Throwable)e);
        }
        return false;
    }

    public static boolean hasUnitTestProjectNature(IProject iProject) {
        try {
            if (iProject != null && iProject.isOpen() && iProject.getNature("com.ibm.im.ims.workbench.transaction.nature") != null) {
                return true;
            }
        }
        catch (CoreException e) {
            logger.throwing(TestcaseEditorController.class.getName(), "", (Throwable)e);
            logger.error((Throwable)e);
        }
        return false;
    }

    public void setTraceFile(String traceFile) {
        this.traceFile = traceFile;
    }

    public void setTestcase(String tcNameWithFileExtension) throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException, MessageWalkerException {
        this.testcaseFilename = Utility.removeFileExt(tcNameWithFileExtension);
        this.isUnitTest = true;
        this.testcase = ProjectTreeFileHelper.unmarshallTestcase(this.projectName, this.testcaseFilename);
        this.isRunConsole = true;
        this.populateTestCase();
        this.initIompIconsAndExpansionStates();
    }

    public void setTestcaseUpdated(boolean val) {
        this.testcaseUpdated = val;
    }

    public boolean isTestcaseUpdated() {
        return this.testcaseUpdated;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
        List connectionProfiles = ImsTmConnectionUtil.getConnectionProfiles();
        this.connectionProfile = connectionProfiles.stream().filter(p -> p.getId().equals(serverId)).findFirst().get();
    }

    public ConnectionProfile getConnectionProfile() {
        return this.connectionProfile;
    }

    public Vector<String> getIOMPNames() {
        Vector<String> retVal = null;
        List mps = this.testcase.getIoMessagePair();
        if (mps != null && !mps.isEmpty()) {
            retVal = new Vector<String>(mps.size());
            for (IoMessagePairType mp : mps) {
                retVal.add(mp.getName());
            }
        }
        return retVal;
    }

    public IOMessagePairNode getIompNode(TestCaseNode testCaseNode) {
        while (!(testCaseNode instanceof IOMessagePairNode)) {
            testCaseNode = testCaseNode.getParentNode();
        }
        return (IOMessagePairNode)testCaseNode;
    }

    private void initIompIconsAndExpansionStates() {
        List<TestCaseNode> iompList = this.invisibleRoot.getChildren().get(0).getChildren();
        if (iompList != null && iompList.size() > 0) {
            IOMessagePairNode firstIompNode = (IOMessagePairNode)iompList.get(0);
            firstIompNode.setState(1);
            firstIompNode.setInputMsgExpanded(true);
            firstIompNode.setOutputMsgExpanded(false);
            int i = 1;
            while (i < iompList.size()) {
                IOMessagePairNode currIompNode = (IOMessagePairNode)iompList.get(i);
                currIompNode.setState(2);
                currIompNode.setInputMsgExpanded(false);
                currIompNode.setOutputMsgExpanded(false);
                ++i;
            }
        }
    }

    public TestCaseNode getInvisibleRoot() {
        return this.invisibleRoot;
    }

    public Testcase getTestCase() {
        return this.testcase;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Transaction retrieveTransaction(BigInteger tranId) throws JAXBException, CoreException {
        return TrantocMapManager.getTransaction(this.projectName, tranId);
    }

    public MessageType retrieveInputMessage(Transaction tran, BigInteger msgId) throws JAXBException, CoreException {
        List messageList = tran.getInputMessage();
        for (MessageType message : messageList) {
            if (message.getId().intValue() != msgId.intValue()) continue;
            return message;
        }
        return null;
    }

    public MessageType retrieveOutputMessage(Transaction tran, BigInteger msgId) throws JAXBException, CoreException {
        MessageType retVal = null;
        List messageList = tran.getOutputMessage();
        for (MessageType message : messageList) {
            if (message.getId().intValue() != msgId.intValue()) continue;
            retVal = message;
            break;
        }
        return retVal;
    }

    public MessageType retrieveOutputMessage(Transaction tran, String msgName) throws JAXBException, CoreException {
        MessageType retVal = null;
        List messageList = tran.getOutputMessage();
        for (MessageType message : messageList) {
            if (!message.getName().equals(msgName)) continue;
            retVal = message;
            break;
        }
        return retVal;
    }

    public void populateTestCase() throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        this.invisibleRoot = new TestCaseNode("", null);
        if (this.testcase != null) {
            List ioMsgPairList = this.testcase.getIoMessagePair();
            TestCaseFolderNode topMessageUnitFolder = new TestCaseFolderNode(TranMessages.getLabel().getString("TCMLE_COLNAME_IOPAIR"), this.invisibleRoot);
            this.populateIoMessagePairNodes(topMessageUnitFolder, ioMsgPairList);
            this.invisibleRoot.addChild(topMessageUnitFolder);
        }
    }

    public JsonMessageNode getMsgNode(JsonFieldNode fieldNode) {
        JsonMessageNode retVal = null;
        retVal = (JsonMessageNode)fieldNode.getParentNode();
        return retVal;
    }

    public void populateIoMessagePairNodes(TestCaseFolderNode topMessageUnitFolder, List<IoMessagePairType> ioMsgPairList) throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        int i = 0;
        while (i < ioMsgPairList.size()) {
            IoMessagePairType currentMsgPair = ioMsgPairList.get(i);
            IOMessagePairNode ioMsgPairNode = new IOMessagePairNode(currentMsgPair, currentMsgPair.getName(), topMessageUnitFolder);
            topMessageUnitFolder.addChild(ioMsgPairNode);
            BigInteger tranId = currentMsgPair.getTranId();
            if (tranId != null) {
                Transaction tran = TrantocMapManager.getTransaction(this.projectName, tranId);
                ioMsgPairNode.setTran(tran);
                this.populateIoMessageNodes(ioMsgPairNode);
            }
            ++i;
        }
    }

    public void execIomp(IOMessagePairNode iomp) {
        TmInteraction tmInteraction = null;
        this.connectApiException = null;
        this.connectApiExecutionException = null;
        Object realServerName = null;
        IImsTmConnection connection = null;
        try {
            if (this.traceFile != null && !this.traceFile.isEmpty()) {
                ApiLoggingConfiguration apiLoggingConfig = new ApiLoggingConfiguration();
                apiLoggingConfig.configureApiLogging(this.traceFile, ApiProperties.TRACE_LEVEL_INTERNAL);
            }
            ConnectionProfile connectionProfile = null;
            if (ImsTmConnectionUtil.junitConn == null) {
                List connectionProfiles = ImsTmConnectionUtil.getConnectionProfiles();
                connectionProfile = connectionProfiles.stream().filter(p -> p.getId().equals(this.serverId)).findFirst().get();
            }
            if ((connection = ImsTmConnectionUtil.getConnection(connectionProfile, (boolean)true)) == null) {
                return;
            }
            try {
                tmInteraction = connection.createTmInteraction();
                connection.isConnected();
                String host = null;
                int port = -1;
                if (ImsTmConnectionUtil.junitConn == null) {
                    ConnectionConfiguration connConfig = connectionProfile.getConnectionConfiguration();
                    host = connConfig.getHost();
                    port = connConfig.getPort();
                } else {
                    host = ImsTmConnectionUtil.junitConn.host;
                    port = ImsTmConnectionUtil.junitConn.port;
                }
                this.initTmInteraction(iomp, tmInteraction, host, port);
                InputMessage inMsg = tmInteraction.getInputMessage();
                MessagePayloadManager inputMpm = iomp.getInputMessageNode().getMessagePayloadManager();
                int numSegments = inputMpm.getNumSegments();
                byte[][] byteArray = new byte[numSegments][];
                int i = 0;
                while (i < numSegments) {
                    byteArray[i] = inputMpm.getBytes(i);
                    ++i;
                }
                TraceWriter tw = null;
                if (logger.isLoggable(Level.FINEST)) {
                    tw = new TraceWriter();
                    int i2 = 0;
                    while (i2 < numSegments) {
                        tw.traceBuffer(byteArray[i2], 0, byteArray[i2].length, 1);
                        ++i2;
                    }
                }
                inMsg.setInputMessageData((byte[][])byteArray);
                connection.executeTmInteraction(tmInteraction);
                String mfsModname = tmInteraction.getMfsModname();
                OutputMessage outMsg = tmInteraction.getOutputMessage();
                if (logger.isLoggable(Level.FINER)) {
                    StringBuffer traceBuff = new StringBuffer();
                    traceBuff.append(newLine + "ackNakNeeded = [" + outMsg.isAckNakNeeded() + "]").append(newLine);
                    traceBuff.append("asyncOutputAvailable = [" + outMsg.isAsyncOutputAvailable() + "]").append(newLine);
                    traceBuff.append("inConversation = [" + outMsg.isInConversation() + "]").append(newLine);
                    traceBuff.append(outMsg.getImsConnectReturnCode() == 0 && outMsg.getImsConnectReasonCode() == 0 ? "\nInteraction was successful" : "\nInteraction failed (returned a non-zero return code and/or reason code)").append(newLine);
                    traceBuff.append("imsConnectReturnCode = [" + outMsg.getImsConnectReturnCode() + "]").append(newLine);
                    traceBuff.append("imsConnectReasonCode = [" + outMsg.getImsConnectReasonCode() + "]").append(newLine);
                    traceBuff.append("otmaReasonCode = [" + outMsg.getOtmaReasonCode() + "]").append(newLine);
                    traceBuff.append("otmaSenseCode = [" + outMsg.getOtmaSenseCode() + "]").append(newLine);
                    traceBuff.append("racfReturnCode = [" + outMsg.getRacfReturnCode() + "]").append(newLine);
                    traceBuff.append("mfsModname = [" + mfsModname + "]").append(newLine);
                    logger.finer(traceBuff.toString());
                }
                byte[][] tempOutbyteArray = outMsg.getDataAsArrayOfByteArrays();
                byte[][] outputByteArray = new byte[tempOutbyteArray.length][];
                int i3 = 0;
                while (i3 < tempOutbyteArray.length) {
                    outputByteArray[i3] = tempOutbyteArray[i3];
                    ++i3;
                }
                if (this.outputDsContainsLLZZ) {
                    i3 = 0;
                    while (i3 < outputByteArray.length) {
                        outputByteArray[i3] = this.prependLLZZ(outputByteArray[i3], outMsg, i3);
                        ++i3;
                    }
                }
                if (logger.isLoggable(Level.FINEST)) {
                    i3 = 0;
                    while (i3 < outputByteArray.length) {
                        tw.traceBuffer(outputByteArray[i3], 0, outputByteArray[i3].length, 2);
                        ++i3;
                    }
                }
                iomp.setOutputBytes(outputByteArray);
                this.populateIoMessageNodes(iomp);
                this.updateIompIconsAndExpansionState(iomp);
            }
            catch (ImsConnectApiException e) {
                String exceptionMsg = e.getMessage();
                if (e instanceof ImsConnectCommunicationException || exceptionMsg.contains("socket") || exceptionMsg.contains("EOFException")) {
                    HashMap<String, Connection> connectionCache = IconapiConnectionCache.getInstance();
                    connectionCache.remove(realServerName);
                }
                this.connectApiException = e;
            }
            catch (ImsConnectExecutionException e) {
                this.connectApiExecutionException = e;
            }
            catch (ImsTmConnectionException e) {
                if (e.getCause() instanceof ImsConnectApiException) {
                    this.connectApiException = (ImsConnectApiException)e.getCause();
                } else if (e.getCause() instanceof ImsConnectExecutionException) {
                    this.connectApiExecutionException = (ImsConnectExecutionException)e.getCause();
                }
            }
            catch (Throwable e) {
                logger.error(e);
            }
        }
        finally {
            if ((this.connectApiException != null || this.connectApiExecutionException != null) && connection != null) {
                String errorMsg;
                boolean isDisconnectException = false;
                if (this.connectApiException != null && ((errorMsg = this.connectApiException.getMessage()).contains("socket") || errorMsg.contains("EOFException"))) {
                    isDisconnectException = true;
                }
                if (this.connectApiExecutionException != null && ((errorMsg = this.connectApiExecutionException.getMessage()).contains("socket") || errorMsg.contains("EOFException"))) {
                    isDisconnectException = true;
                }
                if (isDisconnectException) {
                    connection.triggerDisconnect();
                }
            }
        }
    }

    private byte[] prependLLZZ(byte[] outputByteArray, OutputMessage outMsg, int ioareaIx) {
        byte[] llBytes = outMsg.getSegmentLl(ioareaIx);
        byte[] zzBytes = new byte[2];
        byte[] fullOutBytes = new byte[outputByteArray.length + 4];
        System.arraycopy(llBytes, 0, fullOutBytes, 0, 2);
        System.arraycopy(zzBytes, 0, fullOutBytes, 2, 2);
        System.arraycopy(outputByteArray, 0, fullOutBytes, 4, outputByteArray.length);
        return fullOutBytes;
    }

    private void initTmInteraction(IOMessagePairNode iomp, TmInteraction tmInteraction, String host, int port) throws ImsConnectApiException {
        InteractionType interaction = iomp.getMessagePair().getInteraction();
        this.outputDsContainsLLZZ = interaction.isOutputMessageDataSegmentsIncludeLlzz();
        StringBuffer sb = null;
        if (logger.isLoggable(Level.FINEST)) {
            sb = new StringBuffer("Interaction properties set by E4D: ").append(newLine);
        }
        byte ackNakProvider = interaction.getAckNakProvider();
        byte commitMode = interaction.getCommitMode();
        byte syncLevel = interaction.getSyncLevel();
        String codePage = interaction.getImsConnectCodepage();
        int iconTimeout = interaction.getImsConnectTimeout().intValue();
        String userMsgExitId = interaction.getImsConnectUserMessageExitIdentifier();
        String dataStoreName = interaction.getImsDatastoreName();
        Boolean inputIncludesLlZzTrancode = interaction.isInputMessageDataSegmentsIncludeLlzzAndTrancode();
        BigInteger interactionTimeout = interaction.getInteractionTimeout();
        String interactionTypeDescription = this.getApiConstant(interaction.getInteractionTypeDescription());
        String ltermOverrideName = interaction.getLtermOverrideName();
        Boolean purgeUndeliverableOutput = interaction.isPurgeUndeliverableOutput();
        String racfApplName = interaction.getRacfApplName();
        String racfGroupName = interaction.getRacfGroupName();
        String racfUserId = interaction.getRacfUserId();
        String rerouteName = interaction.getRerouteName();
        Boolean rerouteUndeliverableOutput = interaction.isRerouteUndeliverableOutput();
        Boolean isResponseIncludesLlll = interaction.isResponseIncludesLlll();
        String resumeTpipeAlternateClientId = interaction.getResumeTpipeAlternateClientId();
        BigInteger resumeTpipeProcessing = interaction.getResumeTpipeProcessing();
        Boolean isReturnMfsModname = interaction.isReturnMfsModname();
        String tranCode = iomp.getTran().getTranCode();
        tranCode = MessagePayloadManager.stringPad((String)tranCode, (char)' ', (int)8);
        int inputMessageOptions = 0;
        String mapKey = host + "_" + port + "_" + racfUserId;
        PasswordMap passwordMap = PasswordMap.getSingletonInstance();
        String racfPassword = passwordMap.getPasswordValues().get(mapKey);
        if (racfPassword == null) {
            racfPassword = "";
        }
        if (logger.isLoggable(Level.FINEST)) {
            sb.append("ackNakProvider: " + ackNakProvider).append(newLine);
            sb.append("commitMode: " + commitMode).append(newLine);
            sb.append("syncLevel: " + syncLevel).append(newLine);
            sb.append("codePage: " + codePage).append(newLine);
            sb.append("iconTimeout: " + iconTimeout).append(newLine);
            sb.append("userMsgExitId: " + userMsgExitId).append(newLine);
            sb.append("dataStoreName: " + dataStoreName).append(newLine);
            sb.append("inputIncludesLlZzTrancode: " + String.valueOf(inputIncludesLlZzTrancode)).append(newLine);
            sb.append("outputDsContainsLLZZ: " + this.outputDsContainsLLZZ).append(newLine);
            sb.append("interactionTimeout: " + String.valueOf(interactionTimeout)).append(newLine);
            sb.append("interactionTypeDescription: " + interactionTypeDescription).append(newLine);
            sb.append("ltermOverrideName: " + ltermOverrideName).append(newLine);
            sb.append("purgeUndeliverableOutput: " + String.valueOf(purgeUndeliverableOutput)).append(newLine);
            sb.append("racfApplName: " + racfApplName).append(newLine);
            sb.append("racfGroupName: " + racfGroupName).append(newLine);
            sb.append("racfUserId: " + racfUserId).append(newLine);
            if (racfPassword != null && racfPassword.length() > 0) {
                sb.append("racfPassword: length > 0").append(newLine);
            } else {
                sb.append("racfPassword: none provided").append(newLine);
            }
            sb.append("rerouteName: " + rerouteName).append(newLine);
            sb.append("rerouteUndeliverableOutput: " + String.valueOf(rerouteUndeliverableOutput)).append(newLine);
            sb.append("isResponseIncludesLlll: " + String.valueOf(isResponseIncludesLlll)).append(newLine);
            sb.append("resumeTpipeAlternateClientId: " + resumeTpipeAlternateClientId).append(newLine);
            sb.append("resumeTpipeProcessing: " + String.valueOf(resumeTpipeProcessing)).append(newLine);
            sb.append("isReturnMfsModname: " + String.valueOf(isReturnMfsModname)).append(newLine);
            sb.append("tranCode: " + tranCode).append(newLine);
            sb.append("inputMessageOptions: " + inputMessageOptions).append(newLine);
            sb.append("setCm0IgnorePurge(true)").append(newLine);
            logger.finest(sb.toString());
        }
        tmInteraction.setAckNakProvider(ackNakProvider);
        tmInteraction.setCommitMode(commitMode);
        tmInteraction.setSyncLevel(syncLevel);
        tmInteraction.setImsConnectCodepage(codePage);
        tmInteraction.setImsConnectTimeout(iconTimeout);
        tmInteraction.setImsConnectUserMessageExitIdentifier(userMsgExitId);
        tmInteraction.setImsDatastoreName(dataStoreName);
        tmInteraction.setInputMessageDataSegmentsIncludeLlzzAndTrancode(inputIncludesLlZzTrancode.booleanValue());
        tmInteraction.setInteractionTimeout(interactionTimeout.intValue());
        tmInteraction.setInteractionTypeDescription(interactionTypeDescription);
        tmInteraction.setLtermOverrideName(ltermOverrideName);
        tmInteraction.setPurgeUndeliverableOutput(purgeUndeliverableOutput.booleanValue());
        tmInteraction.setRacfApplName(racfApplName);
        tmInteraction.setRacfGroupName(racfGroupName);
        tmInteraction.setRacfPassword(racfPassword);
        tmInteraction.setRacfUserId(racfUserId);
        tmInteraction.setRerouteName(rerouteName);
        tmInteraction.setRerouteUndeliverableOutput(rerouteUndeliverableOutput.booleanValue());
        tmInteraction.setResponseIncludesLlll(isResponseIncludesLlll.booleanValue());
        tmInteraction.setResumeTpipeAlternateClientId(resumeTpipeAlternateClientId);
        tmInteraction.setResumeTpipeProcessing(resumeTpipeProcessing.intValue());
        tmInteraction.setReturnMfsModname(isReturnMfsModname.booleanValue());
        tmInteraction.setTrancode(tranCode);
        tmInteraction.setInputMessageOptions(inputMessageOptions);
        tmInteraction.setCm0IgnorePurge(true);
    }

    private String getApiConstant(String dynamicValue) {
        String retVal = null;
        retVal = dynamicValue.equals("ACK") ? "ACK" : (dynamicValue.equals("CANCELTIMER") ? "CANCELTIMER" : (dynamicValue.equals("ENDCONVERSATION") ? "ENDCONVERSATION" : (dynamicValue.equals("SENDONLYACK") ? "SENDONLYACK" : (dynamicValue.equals("NAK") ? "NAK" : (dynamicValue.equals("SENDONLYXCFORDDLV") ? "SENDONLYXCFORDDLV" : (dynamicValue.equals("RESUMETPIPE") ? "RESUMETPIPE" : (dynamicValue.equals("SENDONLY") ? "SENDONLY" : (dynamicValue.equals("RECEIVE") ? "RECEIVE" : "SENDRECV"))))))));
        return retVal;
    }

    private void updateIompIconsAndExpansionState(IOMessagePairNode iompThatJustRan) {
        List<TestCaseNode> iompList = this.invisibleRoot.getChildren().get(0).getChildren();
        boolean processedIompThatJustRan = false;
        if (iompList != null && iompList.size() > 0) {
            int i = 0;
            while (i < iompList.size()) {
                IOMessagePairNode currIompNode = (IOMessagePairNode)iompList.get(i);
                if (currIompNode == iompThatJustRan) {
                    processedIompThatJustRan = true;
                    currIompNode.setInputMsgExpanded(false);
                    currIompNode.setOutputMsgExpanded(true);
                    currIompNode.setState(0);
                    if (i < iompList.size() - 1) {
                        IOMessagePairNode nextIompNodeToRun = (IOMessagePairNode)iompList.get(i + 1);
                        nextIompNodeToRun.setInputMsgExpanded(true);
                        nextIompNodeToRun.setOutputMsgExpanded(false);
                        nextIompNodeToRun.setState(1);
                        ++i;
                    }
                } else if (processedIompThatJustRan) {
                    currIompNode.setInputMsgExpanded(false);
                    currIompNode.setOutputMsgExpanded(false);
                    currIompNode.setState(2);
                } else {
                    currIompNode.setInputMsgExpanded(false);
                    currIompNode.setOutputMsgExpanded(false);
                    currIompNode.setState(0);
                }
                ++i;
            }
        }
    }

    public void populateIoMessageNodes(IOMessagePairNode ioMsgPairNode) throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        this.populateIoMessageNodes(ioMsgPairNode, false);
    }

    public void populateIoMessageNodes(IOMessagePairNode ioMsgPairNode, boolean rebuildFieldList) throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        BigInteger tranId;
        Transaction tran = ioMsgPairNode.getTran();
        if (tran == null && (tranId = ioMsgPairNode.getTranId()) != null) {
            tran = TrantocMapManager.getTransaction(this.projectName, tranId);
            ioMsgPairNode.setTran(tran);
        }
        IoMessagePairType ioMsgPairType = ioMsgPairNode.getMessagePair();
        String codePage = ioMsgPairType.getInteraction().getImsConnectCodepage();
        BigInteger inputMsgId = ioMsgPairType.getInputMessageId();
        if (inputMsgId != null) {
            IOMessageNode inputMsgNode = ioMsgPairNode.getInputMessageNode();
            if (inputMsgNode == null) {
                MessageType inputMessageType = this.retrieveInputMessage(tran, inputMsgId);
                if (inputMessageType != null) {
                    MessagePayloadManager mpm = new MessagePayloadManager(tran, inputMessageType.getName(), 0, codePage);
                    List fieldValueTypeList = ioMsgPairNode.getMessagePair().getFieldValue();
                    int i = 0;
                    while (i < fieldValueTypeList.size()) {
                        FieldValueType currentFieldValueType = (FieldValueType)fieldValueTypeList.get(i);
                        mpm.setFieldValue(currentFieldValueType.getFieldName(), currentFieldValueType.getFieldValue());
                        ++i;
                    }
                    inputMsgNode = new IOMessageNode(inputMessageType, 0, mpm, ioMsgPairNode);
                    ioMsgPairNode.setInputMessageNode(inputMsgNode);
                    this.populateSegmentNodes(inputMsgNode, rebuildFieldList);
                }
            } else {
                this.updateSegmentNodes(inputMsgNode, rebuildFieldList);
            }
        }
        BigInteger outputMsgId = ioMsgPairType.getOutputMessageId();
        String currActiveOutMsgName = ioMsgPairNode.getCurrentActiveOutputMsg();
        if (outputMsgId != null || currActiveOutMsgName != null) {
            MessageType outputMessageType = null;
            if (currActiveOutMsgName == null) {
                outputMessageType = this.retrieveOutputMessage(tran, outputMsgId);
                currActiveOutMsgName = outputMessageType.getName();
            } else {
                outputMessageType = this.retrieveOutputMessage(tran, currActiveOutMsgName);
            }
            MessagePayloadManager mpm = new MessagePayloadManager(tran, outputMessageType.getName(), 1, codePage);
            byte[][] outBytes = ioMsgPairNode.getOutputBytes();
            if (outBytes != null) {
                int i = 0;
                while (i < outBytes.length) {
                    mpm.setBytes(i, outBytes[i]);
                    ++i;
                }
            }
            IOMessageNode outputMsgNode = new IOMessageNode(outputMessageType, 1, mpm, ioMsgPairNode);
            ioMsgPairNode.setOutputMessageNode(outputMsgNode);
            this.populateSegmentNodes(outputMsgNode, rebuildFieldList);
        }
    }

    public void populateSegmentNodes(IOMessageNode msgNode, boolean rebuildFieldList) throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        msgNode.clearChildren();
        MessageType msgType = msgNode.getMessageType();
        List segmentTypeList = msgType.getSegment();
        int segmentIx = 0;
        while (segmentIx < segmentTypeList.size()) {
            SegmentType currentSegmentType = (SegmentType)segmentTypeList.get(segmentIx);
            SegmentNode currentSegNode = new SegmentNode(currentSegmentType, TranMessages.getLabel().getString("TMME_SEGMENT") + " " + (segmentIx + 1), msgNode);
            msgNode.addChild(currentSegNode);
            this.populateDataStructureAndFieldNodes(currentSegNode, currentSegmentType.getField(), segmentIx, rebuildFieldList);
            ++segmentIx;
        }
    }

    public void updateSegmentNodes(IOMessageNode msgNode, boolean rebuildFieldList) throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        MessageType msgType = msgNode.getMessageType();
        List segmentTypeList = msgType.getSegment();
        List<TestCaseNode> existingSegNodeList = msgNode.getChildren();
        int i = 0;
        while (i < existingSegNodeList.size()) {
            SegmentType currentSegmentType = (SegmentType)segmentTypeList.get(i);
            SegmentNode currentSegNode = (SegmentNode)existingSegNodeList.get(i);
            currentSegNode.setSegmentType(currentSegmentType);
            if (msgNode.getType() == 0) {
                this.populateDataStructureAndFieldNodes(currentSegNode, currentSegmentType.getField(), i, rebuildFieldList);
            }
            if (this.isRunConsole && msgNode.getType() == 1) {
                this.populateDataStructureAndFieldNodes(currentSegNode, currentSegmentType.getField(), i, rebuildFieldList);
            }
            ++i;
        }
    }

    public void populateDataStructureAndFieldNodes(SegmentNode currentSegNode, List<FieldType> dsList, int segmentIx, boolean rebuildFieldList) throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        IOMessageNode msgNode = (IOMessageNode)currentSegNode.getParentNode();
        List<FieldValue> fieldValueList = msgNode.getFieldValueList(segmentIx, rebuildFieldList);
        int numDataStructures = dsList.size();
        int[] fieldValueIndexes = new int[numDataStructures];
        List<TestCaseNode> dsNodeList = currentSegNode.getChildren();
        if (dsNodeList.isEmpty()) {
            i = 0;
            while (i < numDataStructures) {
                currentDs = dsList.get(i);
                currDsName = currentDs.getName();
                currentDsNode = new DataStructureNode(currentDs, (TestCaseNode)currentSegNode);
                currentSegNode.addChild(currentDsNode);
                j = 0;
                if (i > 0) {
                    j = fieldValueIndexes[i - 1] + 1;
                }
                while (j < fieldValueList.size()) {
                    currFieldValue = fieldValueList.get(j);
                    if (currFieldValue.getFieldName().equals(currDsName)) {
                        fieldValueIndexes[i] = j;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < numDataStructures) {
                currentDs = dsList.get(i);
                currDsName = currentDs.getName();
                currentDsNode = (DataStructureNode)dsNodeList.get(i);
                currentDsNode.setFieldValue(null);
                currentDsNode.clearChildren();
                currentDsNode.setDataStructure(currentDs);
                j = 0;
                if (i > 0) {
                    j = fieldValueIndexes[i - 1] + 1;
                }
                while (j < fieldValueList.size()) {
                    currFieldValue = fieldValueList.get(j);
                    if (currFieldValue.getFieldName().equals(currDsName)) {
                        fieldValueIndexes[i] = j;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        List<TestCaseNode> dsNodes = currentSegNode.getChildren();
        int i = 0;
        while (i < numDataStructures) {
            DataStructureNode currDsNode = (DataStructureNode)dsNodes.get(i);
            currDsNode.setFieldValue(fieldValueList.get(fieldValueIndexes[i]));
            int indexOfFirstChild = fieldValueIndexes[i] + 1;
            int indexOfLastChild = i == fieldValueIndexes.length - 1 ? fieldValueList.size() - 1 : fieldValueIndexes[i + 1] - 1;
            int j = indexOfFirstChild;
            while (j <= indexOfLastChild) {
                FieldValue currFieldValue = fieldValueList.get(j);
                FieldNode currentFieldNode = new FieldNode(currFieldValue, (TestCaseNode)currDsNode);
                currDsNode.addChild(currentFieldNode);
                ++j;
            }
            ++i;
        }
    }

    public void editFieldValue(FieldNode fieldNode, String value) throws JAXBException, CoreException, NumberFormatException, UnsupportedTypeConversion, IOException, ConversionException {
        FieldValue fieldValue = fieldNode.getFieldValue();
        fieldValue.setFieldValue(value);
        DataStructureNode dsNode = (DataStructureNode)fieldNode.getParentNode();
        SegmentNode segmentNode = (SegmentNode)dsNode.getParentNode();
        IOMessageNode inputMsgNode = (IOMessageNode)segmentNode.getParentNode();
        inputMsgNode.getMessagePayloadManager().updateFieldValue(fieldValue.getFieldName(), value);
        if (fieldValue.getAssociatedField().isDependsonField()) {
            SegmentNode segNode = (SegmentNode)fieldNode.getParentNode().getParentNode();
            IOMessageNode msgNode = (IOMessageNode)segNode.getParentNode();
            this.populateIoMessageNodes((IOMessagePairNode)msgNode.getParentNode(), true);
        }
    }

    public void importSegmentPayload(SegmentNode segNode, byte[] payload) throws UnsupportedTypeConversion, IOException, ConversionException, JAXBException, CoreException, ImporterException {
        IOMessageNode msgNode = (IOMessageNode)segNode.getParentNode();
        MessageType msg = msgNode.getMessageType();
        List segmentList = msg.getSegment();
        SegmentType segToPopulate = segNode.getSegmentType();
        int segmentIx = segmentList.indexOf(segToPopulate);
        MessagePayloadManager mpm = msgNode.getMessagePayloadManager();
        int segLength = this.calcSegmentLength(segNode.getChildren());
        byte[] singleTestRecord = new byte[segLength];
        int startIx = 0;
        if (payload.length % segLength != 0) {
            Object[] inserts = new Object[]{payload.length, segLength};
            throw new ImporterException(TranMessages.getError().getString("TCMLE_INVALID_IMPORT_PAYLOAD_FILE", inserts), ImporterException.SEVERITY.SEVERE);
        }
        System.arraycopy(payload, startIx, singleTestRecord, 0, segLength);
        mpm.setBytes(segmentIx, singleTestRecord);
        this.populateIoMessageNodes((IOMessagePairNode)msgNode.getParentNode(), true);
        int numTestRecords = payload.length / segLength;
        IOMessagePairNode iompNode = this.getIompNode(segNode);
        TestCaseFolderNode testcaseFolder = (TestCaseFolderNode)iompNode.getParentNode();
        int i = 0;
        while (i < numTestRecords - 1) {
            IoMessagePairType newMsgPair = new IoMessagePairType();
            newMsgPair.setName(iompNode.getName() + "_" + (i + 2));
            List msgPairList = this.testcase.getIoMessagePair();
            msgPairList.add(newMsgPair);
            newMsgPair.setInteraction(iompNode.getMessagePair().getInteraction());
            IOMessagePairNode newMsgPairNode = new IOMessagePairNode(newMsgPair, newMsgPair.getName(), testcaseFolder);
            testcaseFolder.addChild(newMsgPairNode);
            newMsgPair.setTranId(iompNode.getMessagePair().getTranId());
            newMsgPair.setInputMessageId(iompNode.getInputMessageNode().getMessageType().getId());
            newMsgPairNode.setInputMessageNode(null);
            newMsgPair.setOutputMessageId(this.getOutputMsgId(iompNode));
            newMsgPairNode.setCurrentActiveOutputMsg(null);
            newMsgPairNode.setOutputMessageNode(null);
            this.populateIoMessageNodes(newMsgPairNode);
            msgNode = newMsgPairNode.getInputMessageNode();
            mpm = msgNode.getMessagePayloadManager();
            System.arraycopy(payload, startIx += segLength, singleTestRecord, 0, segLength);
            mpm.setBytes(segmentIx, singleTestRecord);
            this.populateIoMessageNodes(newMsgPairNode, true);
            ++i;
        }
    }

    private BigInteger getOutputMsgId(IOMessagePairNode iompNode) {
        BigInteger retVal = null;
        IOMessageNode ioMsgNode = iompNode.getOutputMessageNode();
        if (ioMsgNode != null) {
            ioMsgNode.getMessageType().getId();
        }
        return retVal;
    }

    private int calcSegmentLength(List<TestCaseNode> dsNodeList) {
        int retVal = 0;
        for (TestCaseNode currNode : dsNodeList) {
            DataStructureNode dsNode = (DataStructureNode)currNode;
            retVal += dsNode.getFieldValue().getSize().intValue();
        }
        return retVal;
    }

    public void doSave(String projectName) throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        this.updateJaxbFromMessagePayloadManager();
        ProjectTreeFileHelper.marshallTestcase(projectName, this.testcase, this.testcaseFilename);
    }

    public void updateJaxbFromMessagePayloadManager() throws UnsupportedTypeConversion, IOException, ConversionException {
        List<TestCaseNode> msgPairNodeList = this.invisibleRoot.getChildren().get(0).getChildren();
        int i = 0;
        while (i < msgPairNodeList.size()) {
            IOMessagePairNode currMsgPairNode = (IOMessagePairNode)msgPairNodeList.get(i);
            currMsgPairNode.rePopulateInputMsgFieldValueTypeList();
            ++i;
        }
    }

    public IOMessagePairNode addMessagePair(boolean noSelection, TestCaseNode node, String name, InteractionType interaction) {
        IOMessagePairNode retVal = null;
        if (noSelection) {
            IoMessagePairType newMsgPair = new IoMessagePairType();
            newMsgPair.setName(name);
            List msgPairList = this.testcase.getIoMessagePair();
            msgPairList.add(newMsgPair);
            newMsgPair.setInteraction(interaction);
            TestCaseFolderNode testcaseFolder = (TestCaseFolderNode)node;
            IOMessagePairNode newMsgPairNode = new IOMessagePairNode(newMsgPair, name, testcaseFolder);
            testcaseFolder.addChild(newMsgPairNode);
        } else {
            IOMessagePairNode msgPairNodeToAddAfter = (IOMessagePairNode)node;
            IoMessagePairType newMsgPair = new IoMessagePairType();
            newMsgPair.setName(name);
            newMsgPair.setInteraction(interaction);
            IoMessagePairType msgPairTypeToAddAfter = msgPairNodeToAddAfter.getMessagePair();
            List msgPairList = this.testcase.getIoMessagePair();
            int indexToAddAfter = msgPairList.indexOf(msgPairTypeToAddAfter);
            if (indexToAddAfter != -1) {
                msgPairList.add(indexToAddAfter + 1, newMsgPair);
                TestCaseFolderNode testcaseFolder = (TestCaseFolderNode)msgPairNodeToAddAfter.getParentNode();
                IOMessagePairNode newMsgPairNode = new IOMessagePairNode(newMsgPair, name, testcaseFolder);
                testcaseFolder.addChildAfter(msgPairNodeToAddAfter, newMsgPairNode);
                retVal = newMsgPairNode;
            }
        }
        return retVal;
    }

    public void editMessagePair(IOMessagePairNode msgPairNode, String name) {
        msgPairNode.getMessagePair().setName(name);
        msgPairNode.setName(name);
    }

    public boolean canMoveUp(IOMessagePairNode msgPairNode) {
        TestCaseFolderNode folder = (TestCaseFolderNode)msgPairNode.getParentNode();
        List<TestCaseNode> msgPairNodeList = folder.getChildren();
        int index = msgPairNodeList.indexOf(msgPairNode);
        return index > 0;
    }

    public boolean canMoveDown(IOMessagePairNode msgPairNode) {
        int listSize;
        TestCaseFolderNode folder = (TestCaseFolderNode)msgPairNode.getParentNode();
        List<TestCaseNode> msgPairNodeList = folder.getChildren();
        int index = msgPairNodeList.indexOf(msgPairNode);
        return index + 1 < (listSize = msgPairNodeList.size());
    }

    public void copyFieldValues(SegmentNode segNode) throws UnsupportedTypeConversion, IOException, ConversionException {
        IOMessageNode msgNode = (IOMessageNode)segNode.getParentNode();
        MessageType msgType = msgNode.getMessageType();
        List segmentTypeList = msgType.getSegment();
        SegmentType selectedSegmentType = segNode.getSegmentType();
        int selectedSegmentIndex = -1;
        int i = 0;
        while (i < segmentTypeList.size()) {
            if (segmentTypeList.get(i) == selectedSegmentType) {
                selectedSegmentIndex = i;
                break;
            }
            ++i;
        }
        List<FieldValue> fieldValuesToCopy = msgNode.getFieldValueList(selectedSegmentIndex, false);
        ClipBoard clipBoard = ClipBoard.getSingletonInstance();
        clipBoard.setFieldValues(fieldValuesToCopy);
    }

    public void copyInteraction(IOMessagePairNode iompNode) {
        InteractionType interaction = iompNode.getMessagePair().getInteraction();
        ClipBoard clipBoard = ClipBoard.getSingletonInstance();
        clipBoard.setInteraction(interaction);
    }

    public void pasteInteraction(IOMessagePairNode iompNode) {
        InteractionType pasteInteraction = iompNode.getMessagePair().getInteraction();
        ClipBoard clipBoard = ClipBoard.getSingletonInstance();
        InteractionType copiedInteraction = clipBoard.getInteraction();
        pasteInteraction.setAckNakProvider(copiedInteraction.getAckNakProvider());
        pasteInteraction.setCommitMode(copiedInteraction.getCommitMode());
        pasteInteraction.setImsConnectCodepage(copiedInteraction.getImsConnectCodepage());
        pasteInteraction.setImsConnectTimeout(copiedInteraction.getImsConnectTimeout());
        pasteInteraction.setImsConnectUserMessageExitIdentifier(copiedInteraction.getImsConnectUserMessageExitIdentifier());
        pasteInteraction.setImsDatastoreName(copiedInteraction.getImsDatastoreName());
        pasteInteraction.setInputMessageOptions(copiedInteraction.getInputMessageOptions());
        pasteInteraction.setInteractionTimeout(copiedInteraction.getInteractionTimeout());
        pasteInteraction.setInteractionTypeDescription(copiedInteraction.getInteractionTypeDescription());
        pasteInteraction.setLtermOverrideName(copiedInteraction.getLtermOverrideName());
        pasteInteraction.setName(copiedInteraction.getName());
        pasteInteraction.setRacfApplName(copiedInteraction.getRacfApplName());
        pasteInteraction.setRacfGroupName(copiedInteraction.getRacfGroupName());
        pasteInteraction.setRacfUserId(copiedInteraction.getRacfUserId());
        pasteInteraction.setRerouteName(copiedInteraction.getRerouteName());
        pasteInteraction.setResumeTpipeAlternateClientId(copiedInteraction.getResumeTpipeAlternateClientId());
        pasteInteraction.setResumeTpipeProcessing(copiedInteraction.getResumeTpipeProcessing());
        pasteInteraction.setSyncLevel(copiedInteraction.getSyncLevel());
        pasteInteraction.setInputMessageDataSegmentsIncludeLlzzAndTrancode(copiedInteraction.isInputMessageDataSegmentsIncludeLlzzAndTrancode());
        pasteInteraction.setOutputMessageDataSegmentsIncludeLlzz(copiedInteraction.isOutputMessageDataSegmentsIncludeLlzz());
        pasteInteraction.setPurgeUndeliverableOutput(copiedInteraction.isPurgeUndeliverableOutput());
        pasteInteraction.setRerouteUndeliverableOutput(copiedInteraction.isRerouteUndeliverableOutput());
        pasteInteraction.setResponseIncludesLlll(copiedInteraction.isResponseIncludesLlll());
        pasteInteraction.setReturnMfsModname(copiedInteraction.isReturnMfsModname());
    }

    public void pasteFieldValues(SegmentNode segNode) throws NumberFormatException, JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        String copiedValue;
        FieldNode currFieldNode;
        List<TestCaseNode> currDsNodeFieldNodeList;
        ClipBoard clipBoard = ClipBoard.getSingletonInstance();
        HashMap<String, String> copiedFieldValueMap = clipBoard.getCopiedFieldValues();
        List<TestCaseNode> dsNodeList = segNode.getChildren();
        ArrayList<TestCaseNode> allFieldNodesUnderSegment = new ArrayList<TestCaseNode>();
        int i = 0;
        while (i < dsNodeList.size()) {
            currDsNodeFieldNodeList = dsNodeList.get(i).getChildren();
            allFieldNodesUnderSegment.addAll(currDsNodeFieldNodeList);
            ++i;
        }
        i = 0;
        while (i < allFieldNodesUnderSegment.size()) {
            currFieldNode = (FieldNode)allFieldNodesUnderSegment.get(i);
            copiedValue = copiedFieldValueMap.get(currFieldNode.getName());
            if (copiedValue != null && currFieldNode.getFieldValue().getAssociatedField().isDependsonField() && !copiedValue.equals(currFieldNode.getFieldValue().getFieldValue())) {
                this.editFieldValue(currFieldNode, copiedValue);
            }
            ++i;
        }
        allFieldNodesUnderSegment.clear();
        i = 0;
        while (i < dsNodeList.size()) {
            currDsNodeFieldNodeList = dsNodeList.get(i).getChildren();
            allFieldNodesUnderSegment.addAll(currDsNodeFieldNodeList);
            ++i;
        }
        i = 0;
        while (i < allFieldNodesUnderSegment.size()) {
            currFieldNode = (FieldNode)allFieldNodesUnderSegment.get(i);
            copiedValue = copiedFieldValueMap.get(currFieldNode.getName());
            if (copiedValue != null) {
                currFieldNode.getFieldValue().setFieldValue(copiedValue);
            }
            ++i;
        }
    }

    public boolean canPasteFieldValues() {
        ClipBoard clipBoard = ClipBoard.getSingletonInstance();
        return clipBoard.canPasteFieldValues();
    }

    public boolean canPasteInteraction() {
        ClipBoard clipBoard = ClipBoard.getSingletonInstance();
        return clipBoard.canPasteInteraction();
    }

    public void moveUpMessagePair(IOMessagePairNode msgPairNode) {
        IoMessagePairType msgPairType = msgPairNode.getMessagePair();
        List msgPairTypeList = this.testcase.getIoMessagePair();
        int currentIndex = msgPairTypeList.indexOf(msgPairType);
        msgPairTypeList.remove(msgPairType);
        msgPairTypeList.add(currentIndex - 1, msgPairType);
        TestCaseFolderNode testcaseFolder = (TestCaseFolderNode)msgPairNode.getParentNode();
        List<TestCaseNode> msgPairNodeList = testcaseFolder.getChildren();
        msgPairNodeList.remove(msgPairNode);
        msgPairNodeList.add(currentIndex - 1, msgPairNode);
    }

    public void moveDownMessagePair(IOMessagePairNode msgPairNode) {
        IoMessagePairType msgPairType = msgPairNode.getMessagePair();
        List msgPairTypeList = this.testcase.getIoMessagePair();
        int currentIndex = msgPairTypeList.indexOf(msgPairType);
        msgPairTypeList.remove(msgPairType);
        msgPairTypeList.add(currentIndex + 1, msgPairType);
        TestCaseFolderNode testcaseFolder = (TestCaseFolderNode)msgPairNode.getParentNode();
        List<TestCaseNode> msgPairNodeList = testcaseFolder.getChildren();
        msgPairNodeList.remove(msgPairNode);
        msgPairNodeList.add(currentIndex + 1, msgPairNode);
    }

    public void removeMessagePair(IOMessagePairNode msgPairNode) {
        List msgPairList = this.testcase.getIoMessagePair();
        msgPairList.remove(msgPairNode.getMessagePair());
        TestCaseFolderNode testcaseFolder = (TestCaseFolderNode)msgPairNode.getParentNode();
        testcaseFolder.removeChildNode(msgPairNode);
    }

    public void removeMessage(IOMessageNode msgNode) {
        IOMessagePairNode msgPairNode = (IOMessagePairNode)msgNode.getParentNode();
        int msgType = msgNode.getType();
        IoMessagePairType messagePair = msgPairNode.getMessagePair();
        if (msgType == 0) {
            messagePair.setInputMessageId(null);
            msgPairNode.setInputMessageNode(null);
        } else {
            messagePair.setOutputMessageId(null);
            msgPairNode.setOutputMessageNode(null);
        }
    }

    public String getTestcaseFilename() {
        return this.testcaseFilename;
    }

    public void setTestcaseFilename(String testcaseFilename) {
        this.testcaseFilename = testcaseFilename;
    }

    public ImsConnectApiException getConnectApiException() {
        return this.connectApiException;
    }

    public ImsConnectExecutionException getConnectApiExecutionException() {
        return this.connectApiExecutionException;
    }

    public String getRunConfigName() {
        return this.runConfigName;
    }

    public void setRunConfigName(String runConfigName) {
        this.runConfigName = runConfigName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        this.isUnitTest = TestcaseEditorController.hasUnitTestProjectNature(project);
    }

    public boolean isUnitTest() {
        return this.isUnitTest;
    }

    public String getServiceOutputMsgName() {
        return this.serviceOutputMsgName;
    }
}

