/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.transaction.controller.editor;

import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.transaction.controller.datastructure.DBDConstants;
import com.ibm.im.ims.transaction.controller.editor.EditFieldController;
import com.ibm.im.ims.transaction.controller.editor.InvalidInputException;
import com.ibm.im.ims.transaction.controller.editor.TranEditorController;
import com.ibm.im.ims.transaction.model.utilities.ModelException;
import com.ibm.im.ims.workbench.transaction.model.FieldModel;
import com.ibm.im.ims.workbench.transaction.model.TranDataStructureModel;
import com.ibm.im.ims.workbench.transaction.model.TranDataStructuresFolder;
import com.ibm.im.ims.workbench.transaction.model.TranMessageModel;
import com.ibm.im.ims.workbench.transaction.model.TranMessagesFolder;
import com.ibm.im.ims.workbench.transaction.model.TranModel;
import com.ibm.im.ims.workbench.transaction.model.TranSegmentModel;
import com.ibm.im.ims.workbench.transaction.model.TranSegmentsFolder;
import com.ibm.im.ims.workbench.transaction.model.TranTreeObject;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.ims.transaction.messages.walkers.MessageWalkerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ManageFieldsController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<List<FieldModel>> redefinesGrpList;
    private static List<String> dependOnFieldDatatypes = Arrays.asList(DBDConstants.DECIMAL.toString(), DBDConstants.BYTE.toString(), DBDConstants.UBYTE.toString(), DBDConstants.SHORT.toString(), DBDConstants.USHORT.toString(), DBDConstants.INT.toString(), DBDConstants.UINT.toString(), DBDConstants.LONG.toString(), DBDConstants.ULONG.toString(), DBDConstants.PACKEDDECIMAL.toString(), DBDConstants.ZONEDDECIMAL.toString());
    private TranModel clonedInvisibleRoot;
    private boolean hasBeenEdited = false;
    private FieldModel origFieldBeingEdited;

    public ManageFieldsController(TranEditorController teController) throws MessageWalkerException {
        this.clonedInvisibleRoot = teController.getClonedTran();
    }

    public TranMessageModel getMsgNodeByName(String msgName) {
        TranMessageModel retVal = null;
        List<TranMessageModel> msgNodes = this.getMessageNodes(0);
        for (TranMessageModel msgNode : msgNodes) {
            if (!msgNode.getMessage().getName().equals(msgName)) continue;
            retVal = msgNode;
            break;
        }
        if (retVal == null) {
            msgNodes = this.getMessageNodes(1);
            for (TranMessageModel msgNode : msgNodes) {
                if (!msgNode.getMessage().getName().equals(msgName)) continue;
                retVal = msgNode;
                break;
            }
        }
        return retVal;
    }

    public TranMessageModel getMsgNodeById(int msgId) {
        TranMessageModel retVal = null;
        List<TranMessageModel> msgNodes = this.getMessageNodes(0);
        for (TranMessageModel msgNode : msgNodes) {
            if (msgNode.getMessage().getId().intValue() != msgId) continue;
            retVal = msgNode;
            break;
        }
        if (retVal == null) {
            msgNodes = this.getMessageNodes(1);
            for (TranMessageModel msgNode : msgNodes) {
                if (msgNode.getMessage().getId().intValue() != msgId) continue;
                retVal = msgNode;
                break;
            }
        }
        return retVal;
    }

    public List<TranMessageModel> getMessageNodes(int msgDirection) {
        TranMessagesFolder msgFolder = this.getMessageFolder(msgDirection);
        TranTreeObject[] msgs = msgFolder.getChildren();
        ArrayList<TranMessageModel> retVal = new ArrayList<TranMessageModel>(msgs.length);
        TranTreeObject[] tranTreeObjectArray = msgs;
        int n = msgs.length;
        int n2 = 0;
        while (n2 < n) {
            TranTreeObject tranTreeObject = tranTreeObjectArray[n2];
            retVal.add((TranMessageModel)tranTreeObject);
            ++n2;
        }
        return retVal;
    }

    public TranMessagesFolder getMessageFolder(int msgDirection) {
        TranTreeObject[] children = this.getClonedInvisibleRoot().getChildren();
        return (TranMessagesFolder)children[msgDirection];
    }

    public TranModel getClonedInvisibleRoot() {
        return this.clonedInvisibleRoot;
    }

    public List<TranDataStructureModel> getDataStructureNodes(TranMessageModel msgNode, int segId) {
        TranSegmentsFolder segFolder = (TranSegmentsFolder)msgNode.getChildren()[0];
        TranSegmentModel segNode = (TranSegmentModel)segFolder.getChildren()[segId - 1];
        TranDataStructuresFolder dsFolder = (TranDataStructuresFolder)segNode.getChildren()[0];
        TranTreeObject[] dsArray = dsFolder.getChildren();
        ArrayList<TranDataStructureModel> dsNodes = new ArrayList<TranDataStructureModel>();
        int i = 0;
        while (i < dsArray.length) {
            dsNodes.add((TranDataStructureModel)dsArray[i]);
            ++i;
        }
        return dsNodes;
    }

    public TranDataStructureModel getDataStructureModel(TranMessageModel msgNode, int segId, String dsName) {
        TranDataStructureModel retVal = null;
        List<TranDataStructureModel> dsNodes = this.getDataStructureNodes(msgNode, segId + 1);
        int i = 0;
        while (i < dsNodes.size()) {
            TranDataStructureModel ds = dsNodes.get(i);
            if (ds.getName().equals(dsName)) {
                retVal = ds;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public List<TranSegmentModel> getSegmentNodes(TranMessageModel msgNode) {
        TranSegmentsFolder segFolder = (TranSegmentsFolder)msgNode.getChildren()[0];
        TranTreeObject[] segArray = segFolder.getChildren();
        ArrayList<TranSegmentModel> segNodes = new ArrayList<TranSegmentModel>();
        int i = 0;
        while (i < segArray.length) {
            segNodes.add((TranSegmentModel)segArray[i]);
            ++i;
        }
        return segNodes;
    }

    public TranSegmentModel getSegmentNode(TranMessageModel msgNode, int segmentNumber) {
        TranSegmentsFolder segFolder = (TranSegmentsFolder)msgNode.getChildren()[0];
        TranTreeObject[] segArray = segFolder.getChildren();
        TranSegmentModel segNode = (TranSegmentModel)segArray[segmentNumber - 1];
        return segNode;
    }

    public TranSegmentModel getSegmentNode(String messageName, int segmentNumber) {
        TranMessageModel messageModel = this.getMsgNodeByName(messageName);
        return this.getSegmentNode(messageModel, segmentNumber);
    }

    public TranSegmentModel getSegmentNode(int messageId, int segmentId) {
        TranMessageModel messageModel = this.getMsgNodeById(messageId);
        return this.getSegmentNode(messageModel, segmentId);
    }

    public void removeFieldsFromClone(String[] selectedFields) {
        this.clonedInvisibleRoot.removeFields(selectedFields);
    }

    public String validateAndRemove(String[] selectedFields, String messageName, int segmentNumber) throws ModelException {
        String retVal = null;
        TranSegmentModel segment = this.getSegmentNode(messageName, segmentNumber);
        FieldModel fieldModel = null;
        int i = 0;
        while (i < selectedFields.length) {
            fieldModel = this.getFieldModel(messageName, segmentNumber, selectedFields[i]);
            if (fieldModel != null && this.validateFieldIsNotRedefined(selectedFields, fieldModel, segment) != null) {
                retVal = fieldModel.getName();
                break;
            }
            this.removeFromRedefineGroups(selectedFields[i]);
            ++i;
        }
        if (retVal == null) {
            this.removeFieldsFromClone(selectedFields);
        }
        return retVal;
    }

    public void removeFromRedefineGroups(String fieldName) {
        if (this.redefinesGrpList != null) {
            int i = 0;
            while (i < this.redefinesGrpList.size()) {
                List<FieldModel> redefineGroup = this.redefinesGrpList.get(i);
                if (redefineGroup != null) {
                    FieldModel redefinedField = null;
                    int j = 0;
                    while (j < redefineGroup.size()) {
                        redefinedField = redefineGroup.get(j);
                        if (fieldName.equals(redefinedField.getName())) {
                            redefineGroup.remove(redefinedField);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public InvalidInputException validateDependsOn(FieldModel clonedFieldModel, EditFieldController efController, Object newValue, TranSegmentModel segmentModel) throws ModelException {
        String dependsOnField;
        InvalidInputException retVal = null;
        if (!ManageFieldsController.canFieldBeDependedOn(clonedFieldModel, DBDConstants.fromValue((String)newValue)) && (dependsOnField = this.getDependsOnField(clonedFieldModel, segmentModel)) != null) {
            Object[] inserts = new Object[]{clonedFieldModel.getName(), dependsOnField};
            retVal = new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_25", inserts));
        }
        return retVal;
    }

    public InvalidInputException validateDependsOnAndAppDataType(FieldModel clonedFieldModel, Object newValue, TranSegmentModel segmentModel) throws ModelException {
        String dependsOnField;
        InvalidInputException retVal = null;
        Integer scale = Integer.valueOf((String)newValue);
        if (!ManageFieldsController.canFieldBeDependedOn(scale, clonedFieldModel.getAppDatatype()) && (dependsOnField = this.getDependsOnField(clonedFieldModel, segmentModel)) != null) {
            Object[] inserts = new Object[]{clonedFieldModel.getName(), dependsOnField};
            retVal = new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_25", inserts));
        }
        return retVal;
    }

    public void validateDependson(FieldModel currentFldModel) throws InvalidInputException {
        String dependsOnStr;
        DBDConstants adt = currentFldModel.getAppDatatype();
        if (adt == DBDConstants.ARRAY && (dependsOnStr = currentFldModel.getDependsOn()) != null && !dependsOnStr.isEmpty() && this.isRedefiningFld(currentFldModel)) {
            String[] attrs = new String[]{"DEPENDSON"};
            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_19"), attrs);
        }
    }

    private boolean isRedefiningFld(FieldModel currentFldModel) {
        if (currentFldModel != null) {
            if (currentFldModel.getRedefines() != null) {
                return true;
            }
            FieldModel parentFldModel = currentFldModel.getParentField();
            if (this.isRedefiningFld(parentFldModel)) {
                return true;
            }
        }
        return false;
    }

    public static boolean canFieldBeDependedOn(FieldModel fieldModel, DBDConstants dataType) {
        boolean retVal = dependOnFieldDatatypes.contains(dataType.name());
        Integer scale = fieldModel.getScale();
        if (retVal && dataType.equals((Object)DBDConstants.DECIMAL) && (scale == null || scale > 0)) {
            retVal = false;
        }
        return retVal;
    }

    public static boolean canFieldBeDependedOn(Integer scale, DBDConstants dataType) {
        boolean retVal = dependOnFieldDatatypes.contains(dataType.name());
        if (retVal && dataType.equals((Object)DBDConstants.DECIMAL) && (scale == null || scale > 0)) {
            retVal = false;
        }
        return retVal;
    }

    public String getOriginalFieldImsName() {
        String retVal = null;
        if (this.origFieldBeingEdited != null) {
            retVal = this.origFieldBeingEdited.getOriginalName();
        }
        return retVal;
    }

    private String getDependsOnField(FieldModel fieldModel, TranSegmentModel segmentModel) throws ModelException {
        String retVal = null;
        ArrayList<FieldModel> fieldList = this.getFreshFieldList(segmentModel);
        if (fieldList != null) {
            String fieldName = fieldModel.getName();
            for (FieldModel currentField : fieldList) {
                String currentFieldName = currentField.getName();
                String currentDependsOn = currentField.getDependsOn();
                if (currentFieldName.equals(fieldName) || currentDependsOn == null || !currentDependsOn.equals(fieldName)) continue;
                retVal = currentFieldName;
                break;
            }
        }
        return retVal;
    }

    public ArrayList<FieldModel> getFreshFieldList(String messageName, int segmentNumber) throws ModelException {
        TranMessageModel messageNode = this.getMsgNodeByName(messageName);
        TranSegmentModel segmentModel = this.getSegmentNode(messageNode, segmentNumber);
        return this.getFreshFieldList(segmentModel);
    }

    public ArrayList<FieldModel> getFreshFieldList(TranSegmentModel segmentModel) throws ModelException {
        Vector<Object> retVal = new Vector();
        retVal = segmentModel.getFieldList();
        return new ArrayList<FieldModel>(retVal);
    }

    public DBDConstants getOriginalDataType(String messageName, int segmentNumber, String fieldName) throws ModelException {
        return this.getFieldModel(messageName, segmentNumber, fieldName).getPhysicalDataType();
    }

    public FieldModel getFieldCloneForEdit(String messageName, int segmentNumber, String fieldName, int selectionIndex) throws ModelException {
        TranSegmentModel segmentModel = this.getSegmentNode(messageName, segmentNumber);
        ArrayList<FieldModel> fieldModels = this.getFreshFieldList(segmentModel);
        if (fieldModels.size() >= 0) {
            this.origFieldBeingEdited = fieldModels.get(selectionIndex);
        }
        return new FieldModel(this.origFieldBeingEdited);
    }

    public void replaceOrigFieldWithClone(String messageName, int segmentNumber, FieldModel clonedFieldModel) throws ModelException {
        TranSegmentModel segmentModel = this.getSegmentNode(messageName, segmentNumber);
        FieldModel parentField = clonedFieldModel.getParentField();
        if (parentField == null) {
            segmentModel.replaceTopLevelField(this.origFieldBeingEdited, clonedFieldModel);
        } else {
            segmentModel.addField(clonedFieldModel);
        }
        segmentModel.removeField(this.origFieldBeingEdited);
        this.hasBeenEdited = true;
    }

    public void removeFieldFromClonedSegmentModel(String messageName, int segmentNumber, FieldModel removeField) {
        TranSegmentModel segmentModel = this.getSegmentNode(messageName, segmentNumber);
        segmentModel.removeField(removeField);
    }

    public FieldModel createNewFieldModelForAdd() {
        this.origFieldBeingEdited = null;
        return new FieldModel(new FieldType());
    }

    public static boolean isFieldDynamicLength(FieldModel fld) {
        DBDConstants appDataType = fld.getAppDatatype();
        if (appDataType != null) {
            Integer minOccurs = fld.getMinOccurs();
            Integer maxOccurs = fld.getMaxOccurs();
            if (appDataType.equals((Object)DBDConstants.ARRAY) && minOccurs != null && maxOccurs != null && minOccurs.intValue() != maxOccurs.intValue()) {
                return true;
            }
            if ((appDataType.equals((Object)DBDConstants.STRUCT) || appDataType.equals((Object)DBDConstants.ARRAY)) && fld.getMaxBytes() > 0 && fld.getBytes() == 0) {
                return true;
            }
        }
        return false;
    }

    public void validateImsNameAndAliasInput(FieldModel clonedFieldModel, String origName, String origAlias, String messageName, int segmentNumber) throws InvalidInputException, ModelException {
        FieldModel parent = clonedFieldModel.getParentField();
        if (parent != null) {
            boolean isName = false;
            boolean isAlias = false;
            String clonedFieldName = clonedFieldModel.getOriginalName();
            String clonedFieldAlias = clonedFieldModel.getName();
            if (!clonedFieldName.equals(origName) && !clonedFieldAlias.equals(origAlias)) {
                isName = true;
                isAlias = true;
            } else if (!clonedFieldName.equals(origName)) {
                isName = true;
            } else if (!clonedFieldAlias.equals(origAlias)) {
                isAlias = true;
            }
            ArrayList<FieldModel> children = this.getFreshFieldList(messageName, segmentNumber);
            if (children != null) {
                Iterator<FieldModel> iter = children.iterator();
                int dupName = 0;
                int dupAlias = 0;
                while (iter.hasNext()) {
                    String currentAlias;
                    String currentName;
                    FieldModel currentField = iter.next();
                    if (isName && (currentName = currentField.getOriginalName()) != null && currentName.equals(clonedFieldName) && ++dupName > 0) {
                        Object[] inserts = new Object[]{TranMessages.getLabel().getString("WB010A"), currentName};
                        String[] attrs = new String[]{"ORIG_NAME"};
                        throw new InvalidInputException(TranMessages.getError().getString("GWEM_ALREADY_EXISTS", inserts), attrs);
                    }
                    if (!isAlias || (currentAlias = currentField.getName()) == null || clonedFieldAlias == null || !clonedFieldAlias.equals(currentAlias) || ++dupAlias <= 0) continue;
                    Object[] inserts = new Object[]{TranMessages.getLabel().getString("WB211"), currentAlias};
                    String[] attrs = new String[]{"ALIAS"};
                    throw new InvalidInputException(TranMessages.getError().getString("GWEM_ALREADY_EXISTS", inserts), attrs);
                }
            }
        }
    }

    public InvalidInputException validateFieldIsNotRedefined(FieldModel fieldModel, TranSegmentModel segmentModel) throws ModelException {
        InvalidInputException retVal = null;
        ArrayList<FieldModel> allFields = this.getFreshFieldList(segmentModel);
        List<List<FieldModel>> redefinesGroupList = this.buildRedefinesGroupList(allFields);
        if (redefinesGroupList != null) {
            FieldModel[] currRedefinesGrp = this.getRedefinesGroup(fieldModel.getName(), redefinesGroupList);
            boolean inQuestionIsRedefined = false;
            if (currRedefinesGrp != null) {
                String nameInQuestion = fieldModel.getName();
                int i = 0;
                while (i < currRedefinesGrp.length) {
                    FieldModel currFieldModel = currRedefinesGrp[i];
                    if (nameInQuestion.equals(currFieldModel.getRedefines())) {
                        inQuestionIsRedefined = true;
                        break;
                    }
                    ++i;
                }
                if (inQuestionIsRedefined) {
                    Object[] inserts = new Object[]{nameInQuestion};
                    retVal = new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_15", inserts));
                }
            }
        }
        return retVal;
    }

    private InvalidInputException validateFieldIsNotRedefined(String[] selectedFields, FieldModel fieldModel, TranSegmentModel segmentModel) throws ModelException {
        boolean allFieldsSelected;
        FieldModel[] currRedefinesGrp;
        InvalidInputException retVal = null;
        ArrayList<FieldModel> allFields = this.getFreshFieldList(segmentModel);
        List<List<FieldModel>> redefinesGroupList = this.buildRedefinesGroupList(allFields);
        if (redefinesGroupList != null && (currRedefinesGrp = this.getRedefinesGroup(fieldModel.getName(), redefinesGroupList)) != null && !(allFieldsSelected = this.allInGroupSelected(currRedefinesGrp, selectedFields))) {
            Object[] inserts = new Object[]{fieldModel.getName()};
            retVal = new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_15", inserts));
        }
        return retVal;
    }

    private boolean allInGroupSelected(FieldModel[] fields, String[] selectedFields) {
        int foundFields = 0;
        int i = 0;
        while (i < fields.length) {
            String fieldName = fields[i].getName();
            int j = 0;
            while (j < selectedFields.length) {
                if (fieldName.equals(selectedFields[j])) {
                    ++foundFields;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return foundFields == fields.length;
    }

    public List<List<FieldModel>> buildRedefinesGroupList(List<FieldModel> currPeerFields) {
        if (this.redefinesGrpList == null) {
            this.redefinesGrpList = new ArrayList<List<FieldModel>>();
            List<Object> currRedefinesGrp = new ArrayList();
            FieldModel prevField = null;
            FieldModel currField = null;
            int i = 0;
            while (i < currPeerFields.size()) {
                prevField = currField;
                currField = currPeerFields.get(i);
                String currFieldName = currField.getName();
                String redefinedFldName = currField.getRedefines();
                if (redefinedFldName != null && !redefinedFldName.isEmpty()) {
                    boolean found = false;
                    int j = 0;
                    while (j < this.redefinesGrpList.size() && !found) {
                        currRedefinesGrp = this.redefinesGrpList.get(j);
                        if (currRedefinesGrp != null) {
                            FieldModel[] fieldList = new FieldModel[currRedefinesGrp.size()];
                            if (this.isFieldInList(redefinedFldName, fieldList = currRedefinesGrp.toArray(fieldList))) {
                                found = true;
                                if (!this.isFieldInList(currFieldName, fieldList)) {
                                    currRedefinesGrp.add(currField);
                                }
                            }
                        }
                        ++j;
                    }
                    if (!found) {
                        ArrayList<FieldModel> newRedefinesGrp = new ArrayList<FieldModel>();
                        newRedefinesGrp.add(currField);
                        if (prevField != null && prevField.getName().equals(redefinedFldName)) {
                            newRedefinesGrp.add(prevField);
                        }
                        this.redefinesGrpList.add(newRedefinesGrp);
                    }
                }
                ++i;
            }
        }
        return this.redefinesGrpList;
    }

    public void clearRedefineGroups() {
        this.redefinesGrpList = null;
    }

    public FieldModel[] getRedefinesGroup(String selectedFieldAlias, List<List<FieldModel>> redefinesGroupList) {
        List<Object> currRedefinesGrp = new ArrayList();
        int i = 0;
        while (i < redefinesGroupList.size()) {
            currRedefinesGrp = redefinesGroupList.get(i);
            if (currRedefinesGrp != null) {
                FieldModel[] fieldList = new FieldModel[currRedefinesGrp.size()];
                if (selectedFieldAlias != null && this.isFieldInList(selectedFieldAlias, fieldList = currRedefinesGrp.toArray(fieldList))) {
                    return fieldList;
                }
            }
            ++i;
        }
        return null;
    }

    private boolean isFieldInList(String fieldName, FieldModel[] fieldList) {
        boolean found = false;
        int i = 0;
        while (i < fieldList.length && !found) {
            if (fieldName.equals(fieldList[i].getName())) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public InvalidInputException validateChangeArrayStructDatatype(FieldModel clonedFieldModel, EditFieldController efController, Object newValue) throws ModelException {
        InvalidInputException retVal = null;
        String appDataType = (String)newValue;
        if (!(clonedFieldModel.getFieldList() == null || clonedFieldModel.getFieldList().isEmpty() || appDataType.equals(DBDConstants.ARRAY.toString()) || appDataType.equals(DBDConstants.STRUCT.toString()))) {
            retVal = new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_28"));
        }
        return retVal;
    }

    public int getSize(FieldModel field) {
        if (field == null) {
            return -1;
        }
        return field.getBytes() > 0 ? field.getBytes() : field.getMaxBytes();
    }

    public void addNewField(String messageName, int segmentNumber, FieldModel newField) throws ModelException {
        TranSegmentModel segmentModel = this.getSegmentNode(messageName, segmentNumber);
        segmentModel.addField(newField);
        this.hasBeenEdited = true;
    }

    public boolean hasBeenEdited() {
        return this.hasBeenEdited;
    }

    public FieldModel getFieldModel(String messageName, int segmentNumber, String fieldName) throws ModelException {
        FieldModel retVal = null;
        ArrayList<FieldModel> fieldModels = this.getFreshFieldList(messageName, segmentNumber);
        int i = 0;
        while (i < fieldModels.size()) {
            FieldModel fieldModel = fieldModels.get(i);
            if (fieldModel.getName().equals(fieldName)) {
                retVal = fieldModel;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public FieldModel getFieldModel(String messageName, int segmentNumber, int index) throws ModelException {
        FieldModel retVal = null;
        ArrayList<FieldModel> fieldModels = this.getFreshFieldList(messageName, segmentNumber);
        if (fieldModels.size() >= 0) {
            retVal = fieldModels.get(index);
        }
        return retVal;
    }

    public String getLastChildOfField(String messageName, int segmentNumber, String fieldName) throws ModelException {
        ArrayList<FieldModel> fieldModels = this.getFreshFieldList(messageName, segmentNumber);
        int i = 0;
        while (i < fieldModels.size()) {
            Vector<FieldModel> childFields;
            FieldModel fieldModel = fieldModels.get(i);
            if (fieldModel.getName().equals(fieldName) && (childFields = fieldModel.getChildFields()) != null && childFields.size() > 0) {
                return childFields.get(childFields.size() - 1).getName();
            }
            ++i;
        }
        return null;
    }

    public void performFinish() throws ModelException {
        int i = 0;
        while (i < 2) {
            List<TranMessageModel> msgNodes = this.getMessageNodes(i);
            for (TranMessageModel msgNode : msgNodes) {
                TranSegmentsFolder segFolder = msgNode.getSegFolder();
                TranTreeObject[] tranTreeObjectArray = segFolder.getChildren();
                int n = tranTreeObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TranTreeObject segNode = tranTreeObjectArray[n2];
                    ((TranSegmentModel)segNode).updateSegmentStartValues();
                    ++n2;
                }
            }
            ++i;
        }
    }

    private boolean validateFields(ArrayList<FieldModel> fieldList) throws InvalidInputException {
        int i = 0;
        while (i < fieldList.size()) {
            FieldModel currField = fieldList.get(i);
            DBDConstants appDataType = currField.getAppDatatype();
            if (appDataType != null && (appDataType.equals((Object)DBDConstants.STRUCT) || appDataType.equals((Object)DBDConstants.ARRAY)) && (currField.getChildFields() == null || currField.getChildFields().isEmpty())) {
                Object[] inserts = new Object[2];
                inserts[0] = currField.getName();
                throw new InvalidInputException(TranMessages.getError().getString("MANAGEFIELDS_CNTRL_ERR0R01", inserts));
            }
            ++i;
        }
        return true;
    }

    private void validateDependsonPos(ArrayList<FieldModel> fieldList) throws InvalidInputException {
        int i = 0;
        while (i < fieldList.size()) {
            String dependedonFldName;
            FieldModel currField = fieldList.get(i);
            DBDConstants appDataType = currField.getAppDatatype();
            if (appDataType != null && appDataType.equals((Object)DBDConstants.ARRAY) && (dependedonFldName = currField.getDependsOn()) != null && !dependedonFldName.isEmpty()) {
                boolean found = false;
                String dArrayFieldName = currField.getName();
                int j = 0;
                while (j < fieldList.size() && !found) {
                    FieldModel checkingField = fieldList.get(j);
                    if (checkingField.getName().equals(dependedonFldName)) {
                        found = true;
                    } else if (checkingField.getName().equals(dArrayFieldName)) {
                        found = true;
                        Object[] inserts = new Object[]{dependedonFldName, currField.getName()};
                        String[] attrs = new String[]{"DEPENDSON"};
                        throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_18", inserts), attrs);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void semanticCheck(ArrayList<FieldModel> allFields) throws InvalidInputException {
        this.validateFields(allFields);
        this.validateDependsonPos(allFields);
    }
}

