/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.transaction.controller.editor;

import com.ibm.im.ims.metadata.message.overlay.InterfaceFieldType;
import com.ibm.im.ims.metadata.message.overlay.MessageInterfaceType;
import com.ibm.im.ims.metadata.message.overlay.ServiceInterfaceSegmentType;
import com.ibm.im.ims.metadata.message.overlay.YesnoType;
import com.ibm.im.ims.metadata.transaction.ApplicationDatatypeType;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.im.ims.transaction.controller.editor.FieldPathElement;
import com.ibm.im.ims.workbench.transaction.testcase.model.JsonFieldNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.JsonMessageNode;
import com.ibm.ims.transaction.messages.walkers.FieldPath;
import com.ibm.ims.transaction.messages.walkers.JSONConversionVisitor;
import com.ibm.ims.transaction.messages.walkers.MessageWalker;
import com.ibm.ims.transaction.messages.walkers.MessageWalkerException;
import com.ibm.ims.transaction.tools.TransactionToolsLogger;
import com.ibm.ims.transaction.tools.messages.MessageBundle;
import com.ibm.ims.transaction.tools.messages.MessageBundles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class JSONToUIVisitor
extends JSONConversionVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final TransactionToolsLogger logger = new TransactionToolsLogger();
    private HashMap<String, Object> rootCompositeNode;
    private HashMap<String, Object> currCompositeNode;
    private List<HashMap<String, Object>> currCompositeNodeList;
    private Stack<HashMap<String, Object>> compositeNodeStack;
    private MessageType message;
    private Stack<FieldType> prevFieldStack;
    private Stack<Integer> redefinesGroupFieldMaxSizeStack;
    private HashMap<String, FieldType> fieldPathToFieldType;
    private HashMap<Object, List<?>> nodeToNodeList;
    private JsonMessageNode msgNode;
    private Stack<FieldPathElement> pathElementStack;
    int byteOffset;
    int segmentStartOfs;
    int segmentEndOfs;
    int segmentCount;
    private InterfaceFieldType currParentInterfaceField;
    private Stack<InterfaceFieldType> parentInterfaceFieldStack;
    private Stack<Integer> interfaceFieldIxStack = new Stack();
    private MessageInterfaceType msgInterface;
    private ServiceInterfaceSegmentType currInterfaceSegment;
    private int segmentIx = -1;

    public JSONToUIVisitor(HashMap<String, Object> rootCompNode, MessageInterfaceType msgInterface, JsonMessageNode msgNode) throws MessageWalkerException {
        this.rootCompositeNode = rootCompNode;
        this.compositeNodeStack = new Stack();
        this.redefinesGroupFieldMaxSizeStack = new Stack();
        this.prevFieldStack = new Stack();
        this.msgInterface = msgInterface;
        this.fieldPathToFieldType = new HashMap();
        this.nodeToNodeList = new HashMap();
        this.parentInterfaceFieldStack = new Stack();
        this.pathElementStack = new Stack();
        this.msgNode = msgNode;
    }

    public boolean isExpandArrays() {
        return true;
    }

    public Object startOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        this.message = message;
        this.currCompositeNode = this.rootCompositeNode;
        this.segmentCount = message.getSegment().size();
        this.byteOffset = 0;
        this.interfaceFieldIxStack.clear();
        return state;
    }

    public Object startOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        this.segmentStartOfs = this.byteOffset;
        this.segmentEndOfs = this.byteOffset;
        this.redefinesGroupFieldMaxSizeStack.push(0);
        this.prevFieldStack.push(null);
        this.fieldPathToFieldType.clear();
        this.nodeToNodeList.clear();
        ++this.segmentIx;
        this.currInterfaceSegment = (ServiceInterfaceSegmentType)this.msgInterface.getSegment().get(this.segmentIx);
        this.interfaceFieldIxStack.push(-1);
        return state;
    }

    public Object leafField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        InterfaceFieldType currInterfaceField = null;
        currInterfaceField = this.parentInterfaceFieldStack.size() == 0 ? (InterfaceFieldType)this.currInterfaceSegment.getInterfaceField().get(fieldIx) : (InterfaceFieldType)this.currParentInterfaceField.getField().get(fieldIx);
        if (redefines) {
            int currFieldSize = field.getBytes();
            int redefinesGroupFieldMaxSize = this.redefinesGroupFieldMaxSizeStack.peek();
            if (redefinesGroupFieldMaxSize == 0) {
                redefinesGroupFieldMaxSize = this.prevFieldStack.peek().getBytes();
                this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, redefinesGroupFieldMaxSize);
            }
            this.byteOffset -= redefinesGroupFieldMaxSize;
            this.segmentEndOfs -= redefinesGroupFieldMaxSize;
            if (currFieldSize > redefinesGroupFieldMaxSize) {
                redefinesGroupFieldMaxSize = currFieldSize;
                this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, redefinesGroupFieldMaxSize);
            }
            this.byteOffset += redefinesGroupFieldMaxSize;
            this.segmentEndOfs += redefinesGroupFieldMaxSize;
        } else {
            this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, 0);
            Integer fieldBytes = field.getBytes();
            this.byteOffset += fieldBytes.intValue();
            this.segmentEndOfs += fieldBytes.intValue();
        }
        Object fullPathString = this.createFullPathString();
        fullPathString = (String)fullPathString + field.getName();
        String arrayIxString = this.createArrayIxString();
        currInterfaceField.setAssociatedFieldType(field);
        if (currInterfaceField.getIncluded() == YesnoType.Y) {
            JsonFieldNode newFieldNode = new JsonFieldNode(currInterfaceField, this.msgNode, this.currCompositeNode, (String)fullPathString);
            if (!arrayIxString.isEmpty()) {
                newFieldNode.setArrayIxStr(arrayIxString);
            }
            this.msgNode.addChild(newFieldNode);
        } else {
            this.currCompositeNode.remove(field.getName());
        }
        this.prevFieldStack.set(this.prevFieldStack.size() - 1, field);
        return state;
    }

    private String createFullPathString() {
        Object fullPathString = "";
        int i = 0;
        while (i < this.pathElementStack.size()) {
            FieldPathElement currPathElem = (FieldPathElement)this.pathElementStack.get(i);
            fullPathString = (String)fullPathString + currPathElem.fieldName;
            if (currPathElem.arrayIndex != null) {
                fullPathString = (String)fullPathString + "[" + (currPathElem.arrayIndex + 1) + "]";
            }
            fullPathString = (String)fullPathString + ".";
            ++i;
        }
        return fullPathString;
    }

    private String createArrayIxString() {
        Object arrayIxString = "";
        int i = 0;
        while (i < this.pathElementStack.size()) {
            FieldPathElement currPathElem = (FieldPathElement)this.pathElementStack.get(i);
            if (currPathElem.arrayIndex != null) {
                arrayIxString = (String)arrayIxString + "[" + (currPathElem.arrayIndex + 1) + "]";
            }
            ++i;
        }
        return arrayIxString;
    }

    public Object leafArrayField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        Object leafArrayNode = null;
        leafArrayNode = this.currCompositeNode.get(fieldPath.peek());
        FieldType parentField = fieldParents.peek();
        int maxOccurs = 0;
        maxOccurs = MessageWalker.isVariableLengthArray((FieldType)parentField) ? this.getVariableArrayOccurrenceCount(parentField) : parentField.getMaxOccurs().intValue();
        List<String> leafArrayList = new ArrayList();
        if (leafArrayNode != null) {
            if (!(leafArrayNode instanceof List)) {
                MessageWalkerException walkerException = MessageWalkerException.builder().message(MessageBundles.getMessage((MessageBundle)MessageBundles.MW.MW0010E)).messageCode((MessageBundle)MessageBundles.MW.MW0010E).args(new Object[]{fieldPath.getValue(), this.message.getName()}).build();
                logger.error(walkerException.getMessage());
                throw walkerException;
            }
            List list = (List)leafArrayNode;
            if (!list.isEmpty() && !(list.get(0) instanceof String)) {
                MessageWalkerException walkerException = MessageWalkerException.builder().message(MessageBundles.getMessage((MessageBundle)MessageBundles.MW.MW0010E)).messageCode((MessageBundle)MessageBundles.MW.MW0010E).args(new Object[]{fieldPath.getValue(), this.message.getName()}).build();
                logger.error(walkerException.getMessage());
                throw walkerException;
            }
            leafArrayList = list;
        }
        int currFieldCellSize = field.getBytes();
        int currFieldRowSize = currFieldCellSize * maxOccurs;
        int currFieldRowRemain = 0;
        if (redefines) {
            int redefinesGroupFieldMaxSize = this.redefinesGroupFieldMaxSizeStack.peek();
            if (redefinesGroupFieldMaxSize == 0) {
                redefinesGroupFieldMaxSize = this.prevFieldStack.peek().getBytes();
                this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, redefinesGroupFieldMaxSize);
            }
            this.byteOffset -= redefinesGroupFieldMaxSize;
            this.segmentEndOfs -= redefinesGroupFieldMaxSize;
            if (currFieldRowSize > redefinesGroupFieldMaxSize) {
                redefinesGroupFieldMaxSize = currFieldRowSize;
                this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, redefinesGroupFieldMaxSize);
            }
            currFieldRowRemain = redefinesGroupFieldMaxSize;
        } else {
            this.redefinesGroupFieldMaxSizeStack.set(this.redefinesGroupFieldMaxSizeStack.size() - 1, 0);
            currFieldRowRemain = currFieldRowSize;
        }
        int currListSize = leafArrayList.size();
        int intendedListSize = maxOccurs;
        int adjustmentSize = intendedListSize - currListSize;
        if (adjustmentSize > 0) {
            i = 0;
            while (i < adjustmentSize) {
                leafArrayList.add(new String(""));
                ++i;
            }
        } else if (adjustmentSize < 0) {
            i = adjustmentSize;
            while (i < 0) {
                leafArrayList.remove(leafArrayList.size() - 1);
                ++i;
            }
        }
        int index = 0;
        while (index < leafArrayList.size()) {
            this.byteOffset += currFieldCellSize;
            this.segmentEndOfs += currFieldCellSize;
            currFieldRowRemain -= currFieldCellSize;
            Object fullPathString = this.createFullPathString();
            fullPathString = (String)fullPathString + field.getName();
            String arrayIxString = this.createArrayIxString();
            InterfaceFieldType currInterfaceField = new InterfaceFieldType();
            FieldType leafArrayFieldType = new FieldType();
            leafArrayFieldType.setName(parentField.getName());
            ApplicationDatatypeType appDatatype = new ApplicationDatatypeType();
            appDatatype.setDatatype(field.getApplicationDatatype().getDatatype());
            leafArrayFieldType.setApplicationDatatype(appDatatype);
            leafArrayFieldType.setBytes(field.getBytes());
            currInterfaceField.setAssociatedFieldType(leafArrayFieldType);
            JsonFieldNode newFieldNode = new JsonFieldNode(currInterfaceField, this.msgNode, this.currCompositeNode, (String)fullPathString);
            newFieldNode.setLeafArrayIx(index);
            int displayIx = index + 1;
            newFieldNode.setArrayIxStr(arrayIxString + "[" + displayIx + "]");
            this.msgNode.addChild(newFieldNode);
            ++index;
        }
        this.byteOffset += currFieldRowRemain;
        this.segmentEndOfs += currFieldRowRemain;
        currFieldRowRemain = 0;
        this.prevFieldStack.set(this.prevFieldStack.size() - 1, field);
        return state;
    }

    public Object startOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        fieldIx = fieldIx + 1;
        this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        InterfaceFieldType currInterfaceField = null;
        currInterfaceField = this.parentInterfaceFieldStack.size() == 0 ? (InterfaceFieldType)this.currInterfaceSegment.getInterfaceField().get(fieldIx) : (InterfaceFieldType)this.currParentInterfaceField.getField().get(fieldIx);
        this.parentInterfaceFieldStack.push(currInterfaceField);
        this.currParentInterfaceField = currInterfaceField;
        this.interfaceFieldIxStack.push(-1);
        currInterfaceField.setAssociatedFieldType(field);
        FieldPathElement newPathElement = new FieldPathElement();
        newPathElement.fieldName = field.getName();
        newPathElement.arrayIndex = null;
        this.pathElementStack.push(newPathElement);
        Object compositeNode = this.currCompositeNode.get(field.getName());
        if (compositeNode != null && !(compositeNode instanceof HashMap)) {
            MessageWalkerException walkerException = MessageWalkerException.builder().messageCode((MessageBundle)MessageBundles.MW.MW0007E).message(MessageBundles.getMessage((MessageBundle)MessageBundles.MW.MW0007E)).args(new Object[]{fieldPath.getValue(), this.message.getName()}).build();
            throw walkerException;
        }
        if (compositeNode != null) {
            this.currCompositeNode = (HashMap)compositeNode;
        } else {
            HashMap newComposite = new HashMap();
            this.currCompositeNode.put(field.getName(), newComposite);
        }
        this.compositeNodeStack.push(this.currCompositeNode);
        int compositeFieldStackPos = this.redefinesGroupFieldMaxSizeStack.size() - 1;
        this.redefinesGroupFieldMaxSizeStack.push(0);
        this.prevFieldStack.push(null);
        if (redefines && compositeFieldStackPos > 0) {
            int currFieldSize = field.getBytes();
            int redefinesGroupFieldMaxSize = (Integer)this.redefinesGroupFieldMaxSizeStack.elementAt(compositeFieldStackPos);
            if (redefinesGroupFieldMaxSize == 0) {
                FieldType prevFld = (FieldType)this.prevFieldStack.elementAt(compositeFieldStackPos);
                redefinesGroupFieldMaxSize = prevFld.getBytes();
                this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, redefinesGroupFieldMaxSize);
            }
            this.byteOffset -= redefinesGroupFieldMaxSize;
            this.segmentEndOfs -= redefinesGroupFieldMaxSize;
            if (currFieldSize > redefinesGroupFieldMaxSize) {
                redefinesGroupFieldMaxSize = currFieldSize;
                this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, redefinesGroupFieldMaxSize);
            }
        } else {
            this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, 0);
        }
        this.prevFieldStack.set(compositeFieldStackPos, field);
        return state;
    }

    public Object startOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        ArrayList compositeNode = this.currCompositeNode.get(field.getName());
        if (compositeNode == null) {
            compositeNode = new ArrayList();
            this.currCompositeNode.put(field.getName(), compositeNode);
        }
        if (!(compositeNode instanceof List)) {
            MessageWalkerException walkerException = MessageWalkerException.builder().messageCode((MessageBundle)MessageBundles.MW.MW0008E).message(MessageBundles.getMessage((MessageBundle)MessageBundles.MW.MW0008E)).args(new Object[]{fieldPath.getValue(), this.message.getName()}).build();
            logger.error(walkerException.getMessage());
            throw walkerException;
        }
        this.currCompositeNodeList = compositeNode;
        int currListSize = this.currCompositeNodeList.size();
        int intendedListSize = MessageWalker.isFixedLengthArrayField((FieldType)field) ? field.getMaxOccurs().intValue() : this.getVariableArrayOccurrenceCount(field);
        int adjustmentSize = intendedListSize - currListSize;
        if (adjustmentSize > 0) {
            i = 0;
            while (i < adjustmentSize) {
                this.currCompositeNodeList.add(new HashMap());
                ++i;
            }
        } else if (adjustmentSize < 0) {
            i = adjustmentSize;
            while (i < 0) {
                this.currCompositeNodeList.remove(this.currCompositeNodeList.size() - 1);
                ++i;
            }
        }
        if (compositeNode instanceof List && ((List)compositeNode).size() > index && !(((List)compositeNode).get(index) instanceof HashMap)) {
            MessageWalkerException walkerException = MessageWalkerException.builder().messageCode((MessageBundle)MessageBundles.MW.MW0008E).message(MessageBundles.getMessage((MessageBundle)MessageBundles.MW.MW0008E)).args(new Object[]{fieldPath.getValue(), this.message.getName()}).build();
            logger.error(walkerException.getMessage());
            throw walkerException;
        }
        int maxOccurs = field.getMaxOccurs();
        if (index + 1 > maxOccurs) {
            MessageWalkerException walkerException = MessageWalkerException.builder().messageCode((MessageBundle)MessageBundles.MW.MW0012E).message(MessageBundles.getMessage((MessageBundle)MessageBundles.MW.MW0012E)).args(new Object[]{maxOccurs, fieldPath.getValue(), this.message.getName()}).build();
            logger.error(walkerException.getMessage());
            throw walkerException;
        }
        if (this.currCompositeNodeList.size() > index && ((List)compositeNode).get(index) instanceof HashMap) {
            this.currCompositeNode = this.currCompositeNodeList.get(index);
            this.compositeNodeStack.push(this.currCompositeNode);
        }
        int compositeFieldStackPos = this.redefinesGroupFieldMaxSizeStack.size() - 1;
        FieldType prevField = (FieldType)this.prevFieldStack.elementAt(compositeFieldStackPos);
        Integer fieldIx = this.interfaceFieldIxStack.peek();
        if (prevField != field) {
            fieldIx = fieldIx + 1;
            this.interfaceFieldIxStack.set(this.interfaceFieldIxStack.size() - 1, fieldIx);
        }
        InterfaceFieldType currInterfaceField = null;
        currInterfaceField = this.parentInterfaceFieldStack.size() == 0 ? (InterfaceFieldType)this.currInterfaceSegment.getInterfaceField().get(fieldIx) : (InterfaceFieldType)this.currParentInterfaceField.getField().get(fieldIx);
        this.parentInterfaceFieldStack.push(currInterfaceField);
        this.currParentInterfaceField = currInterfaceField;
        this.interfaceFieldIxStack.push(-1);
        this.redefinesGroupFieldMaxSizeStack.push(0);
        this.prevFieldStack.push(null);
        FieldPathElement newPathElement = new FieldPathElement();
        newPathElement.fieldName = field.getName();
        newPathElement.arrayIndex = index;
        if (index == 0) {
            this.pathElementStack.push(newPathElement);
        } else {
            this.pathElementStack.push(newPathElement);
        }
        if (redefines) {
            int currFieldSize = field.getBytes();
            int redefinesGroupFieldMaxSize = (Integer)this.redefinesGroupFieldMaxSizeStack.elementAt(compositeFieldStackPos);
            if (redefinesGroupFieldMaxSize == 0) {
                redefinesGroupFieldMaxSize = ((FieldType)this.prevFieldStack.elementAt(compositeFieldStackPos)).getBytes();
                this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, redefinesGroupFieldMaxSize);
            }
            this.byteOffset -= redefinesGroupFieldMaxSize;
            this.segmentEndOfs -= redefinesGroupFieldMaxSize;
            if (currFieldSize > redefinesGroupFieldMaxSize) {
                redefinesGroupFieldMaxSize = currFieldSize;
                this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, redefinesGroupFieldMaxSize);
            }
        } else {
            this.redefinesGroupFieldMaxSizeStack.set(compositeFieldStackPos, 0);
        }
        this.prevFieldStack.set(compositeFieldStackPos, field);
        return state;
    }

    public Object endOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.parentInterfaceFieldStack.pop();
        this.currParentInterfaceField = !this.parentInterfaceFieldStack.isEmpty() ? this.parentInterfaceFieldStack.peek() : null;
        this.interfaceFieldIxStack.pop();
        this.pathElementStack.pop();
        this.compositeNodeStack.pop();
        this.redefinesGroupFieldMaxSizeStack.pop();
        this.prevFieldStack.pop();
        if (redefines) {
            int currFieldSize = field.getBytes();
            int redefinesGroupFieldMaxSize = this.redefinesGroupFieldMaxSizeStack.peek();
            int difference = 0;
            if (currFieldSize < redefinesGroupFieldMaxSize) {
                difference = redefinesGroupFieldMaxSize - currFieldSize;
            }
            this.byteOffset += difference;
            this.segmentEndOfs += difference;
        }
        this.currCompositeNode = !this.compositeNodeStack.isEmpty() ? this.compositeNodeStack.peek() : this.rootCompositeNode;
        return state;
    }

    public Object endOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.parentInterfaceFieldStack.pop();
        this.currParentInterfaceField = !this.parentInterfaceFieldStack.isEmpty() ? this.parentInterfaceFieldStack.peek() : null;
        this.interfaceFieldIxStack.pop();
        this.pathElementStack.pop();
        this.compositeNodeStack.pop();
        this.redefinesGroupFieldMaxSizeStack.pop();
        this.prevFieldStack.pop();
        this.currCompositeNodeList = null;
        if (redefines) {
            int currFieldSize = field.getBytes();
            int redefinesGroupFieldMaxSize = this.redefinesGroupFieldMaxSizeStack.peek();
            int difference = 0;
            if (currFieldSize < redefinesGroupFieldMaxSize) {
                difference = redefinesGroupFieldMaxSize - currFieldSize;
            }
            this.byteOffset += difference;
            this.segmentEndOfs += difference;
        }
        if (!this.compositeNodeStack.isEmpty()) {
            this.currCompositeNode = this.compositeNodeStack.peek();
            List compositeList = (List)this.currCompositeNode.get(field.getName());
            boolean atLeastOnChildFieldExists = false;
            int i = 0;
            while (i < compositeList.size()) {
                HashMap currArrayElementComposite = (HashMap)compositeList.get(i);
                if (currArrayElementComposite.size() > 0) {
                    atLeastOnChildFieldExists = true;
                    break;
                }
                ++i;
            }
            if (!atLeastOnChildFieldExists) {
                this.currCompositeNode.remove(field.getName());
            }
        } else {
            this.currCompositeNode = this.rootCompositeNode;
        }
        return state;
    }

    public Object endOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        this.interfaceFieldIxStack.pop();
        this.segmentStartOfs = this.byteOffset;
        this.segmentEndOfs = this.byteOffset;
        this.redefinesGroupFieldMaxSizeStack.pop();
        this.prevFieldStack.pop();
        return state;
    }

    public Object endOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        this.currParentInterfaceField = null;
        return state;
    }

    public Integer getByteBufferOffset() {
        return this.byteOffset;
    }

    public int getVariableArrayOccurrenceCount(FieldType field) throws MessageWalkerException {
        String segment;
        String dependsOnPath = field.getDependsOnPath();
        if (dependsOnPath == null || dependsOnPath.isEmpty()) {
            return 0;
        }
        int count = 0;
        boolean countFound = false;
        Object currNode = this.rootCompositeNode;
        String[] stringArray = dependsOnPath.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            segment = stringArray[n2];
            if (currNode instanceof HashMap) {
                currNode = ((HashMap)currNode).get(segment);
            } else {
                boolean cfr_ignored_0 = currNode instanceof List;
            }
            ++n2;
        }
        if (currNode instanceof String) {
            try {
                count = Integer.parseInt((String)currNode);
                countFound = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!countFound) {
            currNode = this.rootCompositeNode;
            stringArray = field.getPath().split("\\.");
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                segment = stringArray[n2];
                if (currNode instanceof HashMap) {
                    currNode = ((HashMap)currNode).get(segment);
                }
                ++n2;
            }
            if (currNode instanceof List && !((List)currNode).isEmpty()) {
                List currNodeList = (List)currNode;
                if (MessageWalker.isLeafArrayField((FieldType)field) && currNodeList.get(0) instanceof HashMap) {
                    for (HashMap node : currNodeList) {
                        Object array = node.get(field.getName());
                        if (!(array instanceof List)) continue;
                        count = Math.max(count, ((List)array).size());
                    }
                } else {
                    count = ((List)currNode).size();
                }
            }
        }
        return count;
    }
}

