/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.transaction.controller.editor;

import com.ibm.im.ims.metadata.transaction.ApplicationDatatypeType;
import com.ibm.im.ims.metadata.transaction.DatatypeType;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MarshallerType;
import com.ibm.im.ims.metadata.transaction.PhysicalDatatypeType;
import com.ibm.im.ims.metadata.transaction.YesnoType;
import com.ibm.ims.dli.types.ByteConverter;
import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.DoubleConverter;
import com.ibm.ims.dli.types.FloatConverter;
import com.ibm.ims.dli.types.IntegerConverter;
import com.ibm.ims.dli.types.LongConverter;
import com.ibm.ims.dli.types.PackedDecimalConverter;
import com.ibm.ims.dli.types.ShortConverter;
import com.ibm.ims.dli.types.StringConverter;
import com.ibm.ims.dli.types.UByteConverter;
import com.ibm.ims.dli.types.UIntegerConverter;
import com.ibm.ims.dli.types.ULongConverter;
import com.ibm.ims.dli.types.UShortConverter;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import com.ibm.ims.dli.types.ZonedDecimalConverter;
import com.ibm.ims.transaction.messages.MessagePayloadManager;
import java.io.IOException;

public class FieldValueEditorController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String newFieldValue;
    private FieldType fieldType;
    private String origValue;
    private String encoding;
    private boolean isHex;

    public FieldValueEditorController(FieldType fieldType, String origValue, String encoding) {
        this.fieldType = fieldType;
        this.origValue = origValue;
        this.encoding = encoding;
    }

    public String getOrigFieldValue() {
        return this.origValue;
    }

    public String getNewFieldValue() {
        return this.newFieldValue;
    }

    public void setNewFieldValue(String newFieldValue) {
        this.newFieldValue = newFieldValue;
    }

    public boolean getIsHex() {
        return this.isHex;
    }

    public void setIsHex(boolean isHex) {
        this.isHex = isHex;
    }

    public String getDataType() {
        return this.fieldType.getApplicationDatatype().getDatatype().name();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFieldName() {
        return this.fieldType.getName();
    }

    public void validateFieldValue(String fieldValue) throws UnsupportedTypeConversion, IOException, ConversionException {
        DatatypeType dataType = this.fieldType.getApplicationDatatype().getDatatype();
        Integer size = this.fieldType.getBytes();
        byte[] ioarea = new byte[size.intValue()];
        if (dataType != null) {
            if (dataType == DatatypeType.CHAR) {
                int uninitializedChars;
                if (fieldValue == null) {
                    fieldValue = "";
                }
                if ((uninitializedChars = size - fieldValue.length()) > 0) {
                    fieldValue = MessagePayloadManager.stringPad((String)fieldValue, (char)' ', (int)size);
                }
                new StringConverter(this.encoding).writeObject(ioarea, 0, size.intValue(), (Object)fieldValue, null);
            } else if (dataType == DatatypeType.BYTE) {
                new ByteConverter().writeObject(ioarea, 0, size.intValue(), (Object)fieldValue, null);
            } else if (dataType == DatatypeType.SHORT) {
                new ShortConverter().writeObject(ioarea, 0, size.intValue(), (Object)fieldValue, null);
            } else if (dataType == DatatypeType.INT) {
                new IntegerConverter().writeObject(ioarea, 0, size.intValue(), (Object)fieldValue, null);
            } else if (dataType == DatatypeType.LONG) {
                new LongConverter().writeObject(ioarea, 0, size.intValue(), (Object)fieldValue, null);
            } else if (dataType == DatatypeType.UBYTE) {
                new UByteConverter().writeObject(ioarea, 0, size.intValue(), (Object)fieldValue, null);
            } else if (dataType == DatatypeType.USHORT) {
                new UShortConverter().writeObject(ioarea, 0, size.intValue(), (Object)fieldValue, null);
            } else if (dataType == DatatypeType.UINT) {
                new UIntegerConverter().writeObject(ioarea, 0, size.intValue(), (Object)fieldValue, null);
            } else if (dataType == DatatypeType.ULONG) {
                new ULongConverter().writeObject(ioarea, 0, size.intValue(), (Object)fieldValue, null);
            } else if (dataType == DatatypeType.FLOAT) {
                new FloatConverter().writeObject(ioarea, 0, size.intValue(), (Object)fieldValue, null);
            } else if (dataType == DatatypeType.DOUBLE) {
                new DoubleConverter().writeObject(ioarea, 0, size.intValue(), (Object)fieldValue, null);
            } else if (dataType == DatatypeType.DECIMAL) {
                MarshallerType marshaller = this.fieldType.getMarshaller();
                YesnoType ynType = marshaller.getIsSigned();
                boolean isSigned = ynType == YesnoType.Y;
                ApplicationDatatypeType adt = this.fieldType.getApplicationDatatype();
                Integer precision = adt.getPrecision();
                Integer scale = adt.getScale();
                PhysicalDatatypeType pdt = marshaller.getTypeConverter();
                if (pdt == PhysicalDatatypeType.PACKEDDECIMAL) {
                    new PackedDecimalConverter(scale, precision, isSigned).writeObject(ioarea, 0, size.intValue(), (Object)fieldValue, null);
                } else if (pdt == PhysicalDatatypeType.ZONEDDECIMAL) {
                    new ZonedDecimalConverter(scale, precision, isSigned).writeObject(ioarea, 0, size.intValue(), (Object)fieldValue, null);
                }
            }
        }
    }

    public void validateFieldValueHex(String fieldValue) throws UnsupportedTypeConversion, IOException, ConversionException {
        Integer size = this.fieldType.getBytes();
        int i = 0;
        while (i < fieldValue.length()) {
            if (fieldValue.charAt(i) != '0' && fieldValue.charAt(i) != '1' && fieldValue.charAt(i) != '2' && fieldValue.charAt(i) != '3' && fieldValue.charAt(i) != '4' && fieldValue.charAt(i) != '5' && fieldValue.charAt(i) != '6' && fieldValue.charAt(i) != '7' && fieldValue.charAt(i) != '8' && fieldValue.charAt(i) != '9' && fieldValue.charAt(i) != 'A' && fieldValue.charAt(i) != 'B' && fieldValue.charAt(i) != 'C' && fieldValue.charAt(i) != 'D' && fieldValue.charAt(i) != 'E' && fieldValue.charAt(i) != 'F') {
                throw new IOException("Field value must contain only hexadecimal characters ");
            }
            ++i;
        }
        if (fieldValue.length() < size * 2) {
            throw new IOException("ERROR: Need to add padding to have exactly a total of " + size * 2 + " characters");
        }
        if (fieldValue.length() > size * 2) {
            throw new IOException("ERROR: Field value is too long, reduce total size to be exactly " + size * 2 + " characters");
        }
    }
}

