/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.transaction.controller.editor;

import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.im.ims.transaction.controller.datastructure.DBDConstants;
import com.ibm.im.ims.transaction.controller.editor.IModelChangeListener;
import com.ibm.im.ims.transaction.controller.editor.InvalidInputException;
import com.ibm.im.ims.transaction.controller.editor.ManageFieldsController;
import com.ibm.im.ims.transaction.controller.editor.ModelChangeEvent;
import com.ibm.im.ims.transaction.model.utilities.ModelException;
import com.ibm.im.ims.transaction.model.utilities.Utility;
import com.ibm.im.ims.workbench.transaction.model.FieldModel;
import com.ibm.im.ims.workbench.transaction.model.TranMessageModel;
import com.ibm.im.ims.workbench.transaction.model.TranSegmentModel;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class EditFieldController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ManageFieldsController mfController;
    private String actionType;
    private FieldModel fieldModel;
    private String messageName;
    private int segmentNumber;
    private boolean hasBeenEdited = false;
    private String[] fieldNames;
    private String origFieldName;
    private String origFieldAlias;
    public static final String EDIT = "EDIT";
    public static final String ADD = "ADD";
    public static final String MOVE = "MOVE";
    public static final String NONE = "NONE";
    public static final String ALL = "ALL";
    public static final String PARENT = "PARENT";
    public static final String START = "START";
    public static final String ORIG_NAME = "ORIG_NAME";
    public static final String ALIAS = "ALIAS";
    public static final String LENGTH = "LENGTH";
    public static final String APP_DATATYPE = "APP_DATATYPE";
    public static final String PHY_DATATYPE = "PHY_DATATYPE";
    public static final String PATTERN = "PATTERN";
    public static final String PRECISION = "PRECISION";
    public static final String SCALE = "SCALE";
    public static final String IS_SIGNED = "IS_SIGNED";
    public static final String MIN_OCCURS = "MIN_OCCURS";
    public static final String MAX_OCCURS = "MAX_OCCURS";
    public static final String DEPENDSON = "DEPENDSON";
    public static final String OVERFLOW_SEGM = "OVERFLOW_SEGM";
    public static final String REDEFINES = "REDEFINES";
    public static final String REMARKS = "REMARKS";
    public static final String ENCODING = "ENCODING";
    public static final String DS_NAME = "DS_NAME";
    private List<IModelChangeListener> modelChangeListeners = new ArrayList<IModelChangeListener>();
    private HashMap<String, Integer> lengthMap = new HashMap();
    private int selectionIndex = 0;

    public EditFieldController(String fieldName, int selectionIndex, String messageName, String segmentName, ManageFieldsController mfController, String actionType) throws ModelException {
        this.mfController = mfController;
        this.messageName = messageName;
        this.segmentNumber = Integer.valueOf(segmentName.substring(segmentName.length() - 1));
        this.actionType = actionType;
        this.selectionIndex = selectionIndex;
        if (actionType.equals(ADD)) {
            this.fieldModel = mfController.createNewFieldModelForAdd();
            this.initStartInfo();
        } else {
            this.fieldModel = mfController.getFieldCloneForEdit(messageName, this.segmentNumber, fieldName, selectionIndex);
            this.origFieldName = this.fieldModel.getOriginalName();
            this.origFieldAlias = this.fieldModel.getName();
            this.initStartInfo();
            this.initLengthMap();
        }
    }

    public EditFieldController(String[] fieldAliasNames, String messageName, String segmentName, String fieldName, ManageFieldsController mfController) throws ModelException {
        this.mfController = mfController;
        this.actionType = MOVE;
        this.fieldNames = fieldAliasNames;
        this.messageName = messageName;
        this.segmentNumber = Integer.valueOf(segmentName.substring(segmentName.length() - 1));
        TranMessageModel messageNode = mfController.getMsgNodeByName(messageName);
        SegmentType segmentType = messageNode.getSegFolder().getSegments().get(this.segmentNumber);
        List fields = segmentType.getField();
        int i = 0;
        while (i < fields.size()) {
            FieldType field = (FieldType)fields.get(i);
            if (field.getName().equals(fieldName)) {
                this.fieldModel = new FieldModel(field);
            }
            ++i;
        }
        this.initStartInfo();
        this.initLengthMap();
    }

    private void initStartInfo() throws ModelException {
        FieldModel selectedField = null;
        if (this.selectionIndex > 0) {
            selectedField = this.mfController.getFieldModel(this.messageName, this.segmentNumber, this.selectionIndex);
        }
        if (this.actionType.equals(ADD)) {
            if (selectedField == null) {
                ArrayList<FieldModel> topLevelFields = this.mfController.getFreshFieldList(this.messageName, this.segmentNumber);
                if (topLevelFields.size() > 0) {
                    this.fieldModel.setStartAfter(topLevelFields.get(topLevelFields.size() - 1).getName());
                }
            } else {
                DBDConstants adt = selectedField.getAppDatatype();
                String selectedFieldName = selectedField.getName();
                if (adt == DBDConstants.ARRAY || adt == DBDConstants.STRUCT) {
                    this.fieldModel.setParentField(selectedField);
                    String lastChildStr = this.mfController.getLastChildOfField(this.messageName, this.segmentNumber, selectedFieldName);
                    if (lastChildStr == null) {
                        this.fieldModel.setStartAfter(NONE);
                    } else {
                        this.fieldModel.setStartAfter(lastChildStr);
                    }
                } else {
                    this.fieldModel.setStartAfter(selectedFieldName);
                    this.fieldModel.setParentField(selectedField.getParentField());
                }
            }
        } else {
            String redefinesStr = this.fieldModel.getRedefines();
            if (redefinesStr != null && !redefinesStr.isEmpty()) {
                this.fieldModel.setStartAfter(redefinesStr);
                this.fieldModel.setStartPos(0);
            } else {
                String startAfterName = this.getPrevFieldName();
                FieldModel parentField = this.fieldModel.getParentField();
                if (parentField != null) {
                    if (startAfterName == null || startAfterName.isEmpty()) {
                        startAfterName = NONE;
                    }
                    this.fieldModel.setStartAfter(startAfterName);
                }
            }
        }
    }

    public boolean hasBeenEdited() {
        return this.hasBeenEdited;
    }

    public boolean isInputNumeric(String inputString) throws InvalidInputException {
        try {
            Integer.parseInt(inputString);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public boolean isInputHasSpaces(String inputString) throws InvalidInputException {
        return inputString.indexOf(" ") > -1;
    }

    public String getStartPos() {
        return String.valueOf(this.fieldModel.getStartPos());
    }

    public String getPrevFieldName() throws ModelException {
        String retVal = "";
        ArrayList<FieldModel> fieldList = this.getFieldList();
        if (fieldList != null) {
            String fieldName = this.fieldModel.getName();
            String parentFieldName = this.getParentField();
            for (FieldModel currentFieldModel : fieldList) {
                FieldModel currentParentFieldModel = currentFieldModel.getParentField();
                String currentParentField = "";
                String currentFieldName = currentFieldModel.getName();
                if (currentParentFieldModel != null) {
                    currentParentField = currentParentFieldModel.getName();
                }
                if (currentParentField != parentFieldName) continue;
                if (currentFieldName.equals(fieldName)) break;
                retVal = currentFieldName;
            }
        }
        return retVal;
    }

    public String getRelativeStart() {
        return String.valueOf(this.fieldModel.getRelativeStart());
    }

    public String getStartAfter() {
        return this.fieldModel.getStartAfter();
    }

    public void setParentField(String parentFieldName) throws InvalidInputException, ModelException {
        FieldModel parentField;
        boolean valueChanged = false;
        FieldModel parent = this.fieldModel.getParentField();
        if (parentFieldName != null && (parent == null || parent != null && !parentFieldName.equals(parent.getName()))) {
            valueChanged = true;
        }
        if (parentFieldName != null && !parentFieldName.isEmpty()) {
            parentField = this.mfController.getFieldModel(this.messageName, this.segmentNumber, parentFieldName);
            if (parentField == null) {
                Object[] inserts = new String[]{TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_LOCATION_PARENT")};
                String[] attrs = new String[]{PARENT};
                throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_7", inserts), attrs);
            }
        } else {
            Object[] inserts = new String[]{TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_LOCATION_PARENT")};
            String[] attrs = new String[]{PARENT};
            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts), attrs);
        }
        this.fieldModel.setParentField(parentField);
        if (valueChanged) {
            this.fieldModel.setStartAfter("");
            this.fieldModel.setStartPos(0);
            String[] attrs = new String[]{PARENT, START, REDEFINES};
            this.notifyListeners(attrs);
        }
        this.hasBeenEdited = true;
    }

    public void setPattern(String datePattern) throws InvalidInputException {
        this.fieldModel.setPattern(datePattern);
        if (datePattern != null && !datePattern.isEmpty()) {
            try {
                new SimpleDateFormat(datePattern);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String[] attrs = new String[]{PATTERN};
                throw new InvalidInputException(TranMessages.getError().getString("EISRC50"), attrs);
            }
        }
        this.hasBeenEdited = true;
    }

    public void setIsSigned(String value) throws InvalidInputException {
        if (value != null && !value.isEmpty()) {
            if (!value.equalsIgnoreCase("YES") && !value.equalsIgnoreCase("NO")) {
                Object[] inserts = new Object[]{value, TranMessages.getLabel().getString("WB025A")};
                throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_34", inserts));
            }
            this.fieldModel.setIsSigned(value);
        }
        this.hasBeenEdited = true;
    }

    public String getParentField() {
        FieldModel parentFieldModel = this.fieldModel.getParentField();
        if (parentFieldModel != null) {
            return parentFieldModel.getName();
        }
        return "";
    }

    public String getPattern() {
        return this.fieldModel.getPattern();
    }

    public String getDependsOn() {
        return this.fieldModel.getDependsOn();
    }

    public void setDependsOn(String value) throws InvalidInputException, ModelException {
        if (value != null && !value.isEmpty()) {
            this.mfController.validateDependson(this.fieldModel);
            this.fieldModel.setDependsOn(value);
        } else {
            this.fieldModel.setDependsOn(null);
        }
        this.hasBeenEdited = true;
    }

    public Integer getMinOccurs() {
        return this.fieldModel.getMinOccurs();
    }

    public List<FieldModel> getDependsOnCandidates() throws ModelException {
        ArrayList<FieldModel> fieldList;
        ArrayList<FieldModel> depOnCandidates = new ArrayList<FieldModel>();
        String fieldName = this.fieldModel.getName();
        if (this.actionType.equals(ADD)) {
            fieldName = this.fieldModel.getStartAfter();
        }
        if ((fieldList = this.getFieldList()) != null) {
            boolean stopHere = false;
            for (FieldModel fm : fieldList) {
                if (fm.getName().equals(fieldName)) {
                    if (!this.actionType.equals(ADD)) break;
                    stopHere = true;
                }
                if ((fm.getAppDatatype() != null && ManageFieldsController.canFieldBeDependedOn(fm, fm.getAppDatatype()) || fm.getPhysicalDataType() != null && ManageFieldsController.canFieldBeDependedOn(fm, fm.getPhysicalDataType())) && fm.getParentField().getAppDatatype() != DBDConstants.ARRAY) {
                    depOnCandidates.add(fm);
                }
                if (stopHere) break;
            }
        }
        return depOnCandidates;
    }

    public void setMinOccurs(String minOccurs) throws InvalidInputException, ModelException {
        if (minOccurs != null && !minOccurs.isEmpty()) {
            try {
                int minOccursInt = Integer.parseInt(minOccurs);
                this.fieldModel.setMinOccurs(minOccursInt);
                if (minOccursInt < 0) {
                    Object[] inserts = new Object[]{TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_MIN_OCCURS")};
                    String[] attrs = new String[]{MIN_OCCURS};
                    throw new InvalidInputException(TranMessages.getError().getString("IPC_NUMERIC_ERROR", inserts), attrs);
                }
                this.setDependsOnIfNeeded();
                this.hasBeenEdited = true;
            }
            catch (NumberFormatException numberFormatException) {
                Object[] inserts = new Object[]{TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_MIN_OCCURS")};
                String[] attrs = new String[]{MIN_OCCURS};
                throw new InvalidInputException(TranMessages.getError().getString("IPC_NUMERIC_ERROR", inserts), attrs);
            }
        }
    }

    public void setMaxOccurs(String maxOccurs) throws InvalidInputException, ModelException {
        if (maxOccurs != null && !maxOccurs.isEmpty()) {
            try {
                int maxOccursInt = Integer.parseInt(maxOccurs);
                this.fieldModel.setMaxOccurs(maxOccursInt);
                if (maxOccursInt < 1) {
                    String[] attrs = new String[]{MAX_OCCURS};
                    throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_8"), attrs);
                }
                this.setDependsOnIfNeeded();
                this.hasBeenEdited = true;
            }
            catch (NumberFormatException numberFormatException) {
                String[] attrs = new String[]{MAX_OCCURS};
                throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_8"), attrs);
            }
        }
    }

    public Integer getMaxOccurs() {
        return this.fieldModel.getMaxOccurs();
    }

    public void setStartAfter(String startAfterStr) throws InvalidInputException, ModelException {
        boolean valueChanged = false;
        String currStartAfter = this.fieldModel.getStartAfter();
        if (currStartAfter != null && !currStartAfter.equals(startAfterStr)) {
            valueChanged = true;
        }
        if (startAfterStr != null && !startAfterStr.isEmpty()) {
            if (!startAfterStr.equals(NONE)) {
                this.fieldModel.setStartAfter(startAfterStr);
                if (this.isFieldExisted(startAfterStr) == null) {
                    Object[] inserts = new String[]{TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_POSITION_START_AFTER")};
                    String[] attrs = new String[]{START};
                    throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_7", inserts), attrs);
                }
            } else {
                this.fieldModel.setStartAfter(DBDConstants.NONE.toString());
            }
            this.fieldModel.setStartPos(0);
            this.fieldModel.setRelativeStart(0);
        } else {
            this.fieldModel.setStartAfter("");
        }
        if (valueChanged) {
            String[] attrs = new String[]{REDEFINES};
            this.notifyListeners(attrs);
        }
        this.hasBeenEdited = true;
    }

    private FieldModel isFieldExisted(String fieldName) throws ModelException {
        ArrayList<FieldModel> fieldList = this.getFieldList();
        if (fieldList != null) {
            for (FieldModel currentFieldModel : fieldList) {
                if (!currentFieldModel.getName().equals(fieldName)) continue;
                return currentFieldModel;
            }
        }
        return null;
    }

    public void setPrecision(String precisionStr) throws InvalidInputException {
        String[] attrs;
        boolean valueChanged;
        block6: {
            valueChanged = false;
            if (precisionStr != null && !precisionStr.isEmpty()) {
                attrs = new String[]{PRECISION};
                try {
                    int precisionInt = Integer.parseInt(precisionStr);
                    Integer currPrecisionInt = this.fieldModel.getPrecision();
                    if (currPrecisionInt == null || currPrecisionInt != precisionInt) {
                        valueChanged = true;
                    }
                    this.fieldModel.setPrecision(precisionStr);
                    if (precisionInt < 1) {
                        throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_34", (Object[])new String[]{TranMessages.getLabel().getString("WB023A"), precisionStr}), attrs);
                    }
                    break block6;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_34", (Object[])new String[]{TranMessages.getLabel().getString("WB023A"), precisionStr}), attrs);
                }
            }
            this.fieldModel.setPrecision("-1");
        }
        if (valueChanged) {
            this.fieldModel.setBytes(this.calculateLengthForDecimal(this.fieldModel.getPrecision()));
            attrs = new String[]{LENGTH};
            this.notifyListeners(attrs);
        }
        this.hasBeenEdited = true;
    }

    public void setScale(String scalseStr) throws InvalidInputException {
        block4: {
            if (scalseStr != null && !scalseStr.isEmpty()) {
                String[] attrs = new String[]{SCALE};
                try {
                    int scaleInt = Integer.parseInt(scalseStr);
                    this.fieldModel.setScale(scalseStr);
                    if (scaleInt < 0) {
                        throw new InvalidInputException(TranMessages.getError().getString("EISRC46"), attrs);
                    }
                    break block4;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidInputException(TranMessages.getError().getString("EISRC46"), attrs);
                }
            }
            this.fieldModel.setScale("-1");
        }
        this.hasBeenEdited = true;
    }

    private int calculateLengthForDecimal(int precisionInt) {
        DBDConstants adt;
        int retVal = precisionInt;
        DBDConstants pdt = this.fieldModel.getPhysicalDataType();
        if (pdt == DBDConstants.PACKEDDECIMAL) {
            retVal = (precisionInt + 2) / 2;
        } else if (pdt == DBDConstants.BINARY && (adt = this.fieldModel.getAppDatatype()) == DBDConstants.DECIMAL) {
            retVal = precisionInt < 5 ? 2 : (precisionInt > 4 && precisionInt < 10 ? 4 : 8);
        }
        return retVal;
    }

    public String getBytes() {
        return Integer.toString(this.fieldModel.getBytes());
    }

    public void setBytes(String lengthStr) throws InvalidInputException {
        if (lengthStr != null && !lengthStr.isEmpty()) {
            try {
                int lengthInt = Integer.parseInt(lengthStr);
                this.fieldModel.setBytes(lengthInt);
                this.checkDataTypeLength(lengthStr);
                DBDConstants appDatatype = this.fieldModel.getAppDatatype();
                if (appDatatype != null && appDatatype != DBDConstants.ARRAY && appDatatype != DBDConstants.STRUCT && appDatatype != DBDConstants.DECIMAL && lengthInt < 0) {
                    String[] attrs = new String[]{LENGTH};
                    Object[] inserts = new String[]{TranMessages.getLabel().getString("WB013A"), lengthStr};
                    throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_34", inserts), attrs);
                }
                this.hasBeenEdited = true;
            }
            catch (NumberFormatException numberFormatException) {
                String[] attrs = new String[]{LENGTH};
                Object[] inserts = new String[]{TranMessages.getLabel().getString("WB013A"), lengthStr};
                throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_34", inserts), attrs);
            }
        } else {
            this.fieldModel.setBytes(0);
        }
    }

    private void checkDataTypeLength(String fieldLength) throws InvalidInputException {
        DBDConstants dataType = this.fieldModel.getPhysicalDataType();
        boolean isPdt = true;
        if (dataType == null || dataType.value().isEmpty()) {
            dataType = this.fieldModel.getAppDatatype();
            isPdt = false;
        }
        if (dataType != null && !dataType.value().isEmpty()) {
            if (dataType.equals((Object)DBDConstants.BIT) || dataType.equals((Object)DBDConstants.BYTE)) {
                if (!fieldLength.equals("1")) {
                    Object[] inserts = new String[]{fieldLength, dataType.value(), "1"};
                    if (isPdt) {
                        String[] attrs = new String[]{LENGTH, PHY_DATATYPE};
                        throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_22", inserts), attrs);
                    }
                    String[] attrs = new String[]{LENGTH, APP_DATATYPE};
                    throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_21", inserts), attrs);
                }
            } else if (dataType.equals((Object)DBDConstants.SHORT)) {
                if (!fieldLength.equals("2")) {
                    Object[] inserts = new String[]{fieldLength, dataType.value(), "2"};
                    if (isPdt) {
                        String[] attrs = new String[]{LENGTH, PHY_DATATYPE};
                        throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_22", inserts), attrs);
                    }
                    String[] attrs = new String[]{LENGTH, APP_DATATYPE};
                    throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_21", inserts), attrs);
                }
            } else if (dataType.equals((Object)DBDConstants.FLOAT) || dataType.equals((Object)DBDConstants.INT)) {
                if (!fieldLength.equals("4")) {
                    Object[] inserts = new String[]{fieldLength, dataType.value(), "4"};
                    if (isPdt) {
                        String[] attrs = new String[]{LENGTH, PHY_DATATYPE};
                        throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_22", inserts), attrs);
                    }
                    String[] attrs = new String[]{LENGTH, APP_DATATYPE};
                    throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_21", inserts), attrs);
                }
            } else if ((dataType.equals((Object)DBDConstants.DOUBLE) || dataType.equals((Object)DBDConstants.LONG)) && !fieldLength.equals("8")) {
                Object[] inserts = new String[]{fieldLength, dataType.value(), "8"};
                if (isPdt) {
                    String[] attrs = new String[]{LENGTH, PHY_DATATYPE};
                    throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_22", inserts), attrs);
                }
                String[] attrs = new String[]{LENGTH, APP_DATATYPE};
                throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_21", inserts), attrs);
            }
        }
    }

    public boolean isDynamicArray() {
        return this.fieldModel.getAppDatatype() != null && this.fieldModel.getAppDatatype().equals((Object)DBDConstants.ARRAY) && this.fieldModel.getDependsOn() != null && !this.fieldModel.getDependsOn().isEmpty();
    }

    public void setOriginalName(String nameInputString) throws InvalidInputException {
        boolean valueChanged = false;
        String currName = this.fieldModel.getOriginalName();
        if (nameInputString != null && currName != null && !currName.equals(nameInputString)) {
            valueChanged = true;
        }
        this.fieldModel.setOriginalName(nameInputString);
        String[] attrs = new String[]{ORIG_NAME};
        if (nameInputString.isEmpty()) {
            this.fieldModel.setOriginalName(currName);
            Object[] inserts = new String[]{TranMessages.getLabel().getString("WB010A")};
            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts), attrs);
        }
        if (this.isInputHasSpaces(nameInputString)) {
            this.fieldModel.setOriginalName(currName);
            Object[] inserts = new String[]{TranMessages.getLabel().getString("WB010A")};
            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_3", inserts), attrs);
        }
        if (Utility.hasSpecialChar(nameInputString, true)) {
            this.fieldModel.setOriginalName(currName);
            Object[] inserts = new String[]{TranMessages.getLabel().getString("WB010A")};
            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_34", inserts), attrs);
        }
        this.hasBeenEdited = valueChanged;
    }

    public void setAlias(String aliasInputString) throws InvalidInputException {
        boolean valueChanged = false;
        String currName = this.fieldModel.getName();
        if (aliasInputString != null && currName != null && !currName.equals(aliasInputString)) {
            valueChanged = true;
        }
        this.fieldModel.setName(aliasInputString);
        String[] attrs = new String[]{ALIAS};
        if (aliasInputString.isEmpty()) {
            this.fieldModel.setName(currName);
            Object[] inserts = new String[]{TranMessages.getLabel().getString("WB211")};
            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts), attrs);
        }
        if (this.isInputHasSpaces(aliasInputString)) {
            this.fieldModel.setOriginalName(currName);
            Object[] inserts = new String[]{TranMessages.getLabel().getString("WB211")};
            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_3", inserts), attrs);
        }
        if (Utility.hasSpecialChar(aliasInputString, true)) {
            this.fieldModel.setOriginalName(currName);
            Object[] inserts = new String[]{TranMessages.getLabel().getString("WB211")};
            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_34", inserts), attrs);
        }
        this.hasBeenEdited = valueChanged;
    }

    public String getRemarks() {
        return this.fieldModel.getRemarks();
    }

    public void setAppDatatype(DBDConstants value) throws InvalidInputException, ModelException {
        try {
            if (this.fieldModel.getAppDatatype() == null || !this.fieldModel.getAppDatatype().equals((Object)value)) {
                this.fieldModel.setAppDatatype(value);
                this.updateModelForAppDataTypeChange();
                if (value != DBDConstants.ARRAY) {
                    this.fieldModel.setDependsOn("");
                    this.fieldModel.setMinOccurs(0);
                    this.fieldModel.setMaxOccurs(0);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] inserts = new Object[]{TranMessages.getLabel().getString("WB017A"), value.value()};
            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_34", inserts));
        }
        this.hasBeenEdited = true;
    }

    public void setRemarks(String value) throws InvalidInputException {
        this.fieldModel.setRemarks(value);
        String invalidCharacter = Utility.getInvalidRemarksCharacter(value);
        if (invalidCharacter != null) {
            Object[] inserts = new String[]{TranMessages.getLabel().getString("EMP_REMARKS"), invalidCharacter};
            String[] attrs = new String[]{REMARKS};
            Object errorMessage = TranMessages.getError().getString("EDIT_FIELD_WIZ_34", inserts);
            if (invalidCharacter.equals("'")) {
                errorMessage = (String)errorMessage + " " + TranMessages.getError().getString("EISRC11A");
            }
            throw new InvalidInputException((String)errorMessage, attrs);
        }
        this.hasBeenEdited = true;
    }

    public void setEncoding(String value) throws InvalidInputException {
        String dummyStr = "dummy";
        try {
            if (value != null && !value.isEmpty()) {
                this.fieldModel.setEncoding(value);
                dummyStr.getBytes(value);
            } else {
                this.fieldModel.setEncoding(null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Object[] attrs = new String[]{ENCODING, value};
            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_34", attrs));
        }
        this.hasBeenEdited = true;
    }

    public void setPhysicalDataType(DBDConstants value) throws InvalidInputException {
        boolean valueChanged = false;
        try {
            DBDConstants oldValue = this.fieldModel.getPhysicalDataType();
            if (oldValue == null || !oldValue.equals((Object)value)) {
                valueChanged = true;
                this.fieldModel.setPhysicalDataType(value);
                this.validatePhysicalDataType(value);
                if (oldValue != null && oldValue == DBDConstants.ARRAY) {
                    this.fieldModel.setDependsOn("");
                    this.fieldModel.setMinOccurs(0);
                    this.fieldModel.setMaxOccurs(0);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] inserts = new Object[]{TranMessages.getLabel().getString("WB018A"), value.value()};
            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_34", inserts));
        }
        if (valueChanged) {
            if (this.fieldModel.getPrecision() != null) {
                this.fieldModel.setBytes(this.calculateLengthForDecimal(this.fieldModel.getPrecision()));
            }
            String[] attrs = new String[]{LENGTH};
            this.notifyListeners(attrs);
        }
        this.hasBeenEdited = true;
    }

    private void validatePhysicalDataType(DBDConstants pdt) throws InvalidInputException {
        DBDConstants adt = this.fieldModel.getAppDatatype();
        String[] attrs = new String[]{PHY_DATATYPE};
        String[] notifyAttrs = new String[]{APP_DATATYPE};
        Object[] inserts = new String[5];
        if (pdt == null || pdt.value().isEmpty()) {
            if (adt.equals((Object)DBDConstants.DECIMAL) || adt.equals((Object)DBDConstants.OTHER) || adt.equals((Object)DBDConstants.XML)) {
                if (adt.equals((Object)DBDConstants.XML)) {
                    inserts[0] = DBDConstants.XML.value();
                    inserts[1] = DBDConstants.XML_CLOB.value();
                } else {
                    inserts[0] = DBDConstants.DECIMAL.value();
                    inserts[1] = DBDConstants.PACKEDDECIMAL.value() + ", " + DBDConstants.ZONEDDECIMAL.value() + ", or " + DBDConstants.BINARY.value();
                }
                inserts[2] = this.fieldModel.getName();
                inserts[3] = TranMessages.getLabel().getString("WB344");
                inserts[4] = TranMessages.getLabel().getString("WB342");
                throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_41", inserts), attrs);
            }
        } else {
            inserts[0] = pdt.value();
            if (pdt.equals((Object)DBDConstants.BLOB) || pdt.equals((Object)DBDConstants.CLOB)) {
                if (adt == null || !adt.equals((Object)DBDConstants.BINARY)) {
                    this.fieldModel.setAppDatatype(DBDConstants.BINARY);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.BINARY)) {
                if (adt == null || !adt.equals((Object)DBDConstants.BINARY) && !adt.equals((Object)DBDConstants.DECIMAL)) {
                    inserts[2] = this.fieldModel.getName();
                    inserts[1] = DBDConstants.BINARY.value() + " or " + DBDConstants.DECIMAL.value();
                    inserts[4] = TranMessages.getLabel().getString("WB344");
                    inserts[3] = TranMessages.getLabel().getString("WB342");
                    throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_41", inserts), attrs);
                }
            } else if (pdt.equals((Object)DBDConstants.BIT)) {
                if (adt == null || !adt.equals((Object)DBDConstants.BIT)) {
                    this.fieldModel.setAppDatatype(DBDConstants.BIT);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.BYTE)) {
                if (adt == null || !adt.equals((Object)DBDConstants.BYTE)) {
                    this.fieldModel.setAppDatatype(DBDConstants.BYTE);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.CHAR)) {
                if (adt == null) {
                    this.fieldModel.setAppDatatype(DBDConstants.CHAR);
                    this.notifyListeners(notifyAttrs);
                } else if (!(adt.equals((Object)DBDConstants.CHAR) || adt.equals((Object)DBDConstants.DATE) || adt.equals((Object)DBDConstants.TIME) || adt.equals((Object)DBDConstants.TIMESTAMP))) {
                    inserts[1] = DBDConstants.CHAR.value() + ", " + DBDConstants.DATE.value() + ", " + DBDConstants.TIME.value() + ", " + DBDConstants.TIMESTAMP.value();
                    inserts[2] = this.fieldModel.getName();
                    inserts[3] = TranMessages.getLabel().getString("WB342");
                    inserts[4] = TranMessages.getLabel().getString("WB344");
                    throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_41", inserts), attrs);
                }
            } else if (pdt.equals((Object)DBDConstants.DOUBLE)) {
                if (adt == null || !adt.equals((Object)DBDConstants.DOUBLE)) {
                    this.fieldModel.setAppDatatype(DBDConstants.DOUBLE);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.FLOAT)) {
                if (adt == null || !adt.equals((Object)DBDConstants.FLOAT)) {
                    this.fieldModel.setAppDatatype(DBDConstants.FLOAT);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.INT)) {
                if (adt == null || !adt.equals((Object)DBDConstants.INT)) {
                    this.fieldModel.setAppDatatype(DBDConstants.INT);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.LONG)) {
                if (adt == null) {
                    this.fieldModel.setAppDatatype(DBDConstants.LONG);
                    this.notifyListeners(notifyAttrs);
                } else if (!(adt.equals((Object)DBDConstants.LONG) || adt.equals((Object)DBDConstants.DATE) || adt.equals((Object)DBDConstants.TIME) || adt.equals((Object)DBDConstants.TIMESTAMP))) {
                    inserts[1] = DBDConstants.LONG.value() + ", " + DBDConstants.DATE.value() + ", " + DBDConstants.TIME.value() + ", " + DBDConstants.TIMESTAMP.value();
                    inserts[2] = this.fieldModel.getName();
                    inserts[3] = TranMessages.getLabel().getString("WB342");
                    inserts[4] = TranMessages.getLabel().getString("WB344");
                    throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_41", inserts), attrs);
                }
            } else if (pdt.equals((Object)DBDConstants.PACKEDDECIMAL) || pdt.equals((Object)DBDConstants.ZONEDDECIMAL)) {
                if (adt == null || !adt.equals((Object)DBDConstants.DECIMAL)) {
                    this.fieldModel.setAppDatatype(DBDConstants.DECIMAL);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.SHORT)) {
                if (adt == null || !adt.equals((Object)DBDConstants.SHORT)) {
                    this.fieldModel.setAppDatatype(DBDConstants.SHORT);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.USER)) {
                if (adt == null) {
                    this.fieldModel.setAppDatatype(DBDConstants.OTHER);
                    this.notifyListeners(notifyAttrs);
                }
            } else if (pdt.equals((Object)DBDConstants.XML_CLOB) && (adt == null || !adt.equals((Object)DBDConstants.XML))) {
                this.fieldModel.setAppDatatype(DBDConstants.XML);
                this.notifyListeners(notifyAttrs);
                this.updateModelForAppDataTypeChange();
            }
        }
        this.updateLengthValue();
    }

    public void clearPhysicalDataType() {
        this.fieldModel.setPhysicalDataType(null);
    }

    public void validateRequiredFields(String[] attrsToCheck) throws ModelException, InvalidInputException {
        int i = 0;
        while (i < attrsToCheck.length) {
            block21: {
                Object[] inserts;
                DBDConstants pdt;
                String currAttr;
                block32: {
                    Integer scale;
                    block31: {
                        Integer precision;
                        block30: {
                            int fieldLength;
                            String[] attrs;
                            Object[] inserts2;
                            DBDConstants adt;
                            block29: {
                                block28: {
                                    Integer maxOccurs;
                                    block27: {
                                        Integer minOccurs;
                                        block26: {
                                            String patternStr;
                                            block25: {
                                                String[] attrs2;
                                                block24: {
                                                    block23: {
                                                        block22: {
                                                            String fieldName;
                                                            block20: {
                                                                currAttr = attrsToCheck[i];
                                                                if (!currAttr.equals(ALL) && !currAttr.equals(ORIG_NAME) || !this.actionType.equals(ADD)) break block20;
                                                                fieldName = this.fieldModel.getOriginalName();
                                                                if (fieldName == null || fieldName.isEmpty()) {
                                                                    Object[] inserts3 = new String[]{TranMessages.getLabel().getString("WB010A")};
                                                                    attrs2 = new String[]{ORIG_NAME};
                                                                    throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts3), attrs2);
                                                                }
                                                                if (currAttr.equals(ORIG_NAME)) break block21;
                                                            }
                                                            if (!currAttr.equals(ALL) && !currAttr.equals(ALIAS) || !this.actionType.equals(ADD)) break block22;
                                                            fieldName = this.fieldModel.getName();
                                                            if (fieldName == null || fieldName.isEmpty()) {
                                                                Object[] inserts4 = new String[]{TranMessages.getLabel().getString("WB211")};
                                                                attrs2 = new String[]{ALIAS};
                                                                throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts4), attrs2);
                                                            }
                                                            if (currAttr.equals(ALIAS)) break block21;
                                                        }
                                                        if (!currAttr.equals(ALL) && !currAttr.equals(PARENT)) break block23;
                                                        FieldModel parent = this.fieldModel.getParentField();
                                                        if (parent == null || parent.getOriginalNameOrAlias().isEmpty()) {
                                                            Object[] inserts5 = new String[]{TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_LOCATION_PARENT")};
                                                            attrs2 = new String[]{PARENT};
                                                            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts5), attrs2);
                                                        }
                                                        if (currAttr.equals(PARENT)) break block21;
                                                    }
                                                    if (!currAttr.equals(ALL) && !currAttr.equals(START)) break block24;
                                                    String startAfter = this.fieldModel.getStartAfter();
                                                    if (startAfter == null || startAfter.isEmpty()) {
                                                        Object[] inserts6 = new String[]{TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_POSITION_START_AFTER")};
                                                        attrs2 = new String[]{START};
                                                        throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts6), attrs2);
                                                    }
                                                    if (currAttr.equals(START)) break block21;
                                                }
                                                if (!currAttr.equals(ALL) && !currAttr.equals(APP_DATATYPE)) break block25;
                                                adt = this.fieldModel.getAppDatatype();
                                                if (adt == null) {
                                                    Object[] inserts7 = new String[]{TranMessages.getLabel().getString("WB342")};
                                                    attrs2 = new String[]{APP_DATATYPE};
                                                    throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts7), attrs2);
                                                }
                                                if (currAttr.equals(APP_DATATYPE)) break block21;
                                            }
                                            if (!currAttr.equals(ALL) && !currAttr.equals(PATTERN)) break block26;
                                            adt = this.fieldModel.getAppDatatype();
                                            if (!(adt != DBDConstants.DATE && adt != DBDConstants.TIME && adt != DBDConstants.TIMESTAMP || (patternStr = this.fieldModel.getPattern()) != null && !patternStr.isEmpty())) {
                                                inserts2 = new String[]{TranMessages.getLabel().getString("WB022A")};
                                                attrs = new String[]{PATTERN};
                                                throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts2), attrs);
                                            }
                                            if (currAttr.equals(PATTERN)) break block21;
                                        }
                                        if (!currAttr.equals(ALL) && !currAttr.equals(MIN_OCCURS)) break block27;
                                        adt = this.fieldModel.getAppDatatype();
                                        if (adt == DBDConstants.ARRAY && ((minOccurs = this.fieldModel.getMinOccurs()) == null || minOccurs < 0)) {
                                            inserts2 = new String[]{TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_MIN_OCCURS")};
                                            attrs = new String[]{MIN_OCCURS};
                                            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts2), attrs);
                                        }
                                        if (currAttr.equals(MIN_OCCURS)) break block21;
                                    }
                                    if (!currAttr.equals(ALL) && !currAttr.equals(MAX_OCCURS)) break block28;
                                    adt = this.fieldModel.getAppDatatype();
                                    if (adt == DBDConstants.ARRAY && ((maxOccurs = this.fieldModel.getMaxOccurs()) == null || maxOccurs < 0)) {
                                        inserts2 = new String[]{TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_MAX_OCCURS")};
                                        attrs = new String[]{MAX_OCCURS};
                                        throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts2), attrs);
                                    }
                                    if (currAttr.equals(MAX_OCCURS)) break block21;
                                }
                                if (!currAttr.equals(ALL) && !currAttr.equals(DEPENDSON)) break block29;
                                adt = this.fieldModel.getAppDatatype();
                                if (adt == DBDConstants.ARRAY) {
                                    String dependsOn;
                                    Integer minOccurs = this.fieldModel.getMinOccurs();
                                    Integer maxOccurs = this.fieldModel.getMaxOccurs();
                                    if (minOccurs != null && maxOccurs != null && maxOccurs > minOccurs && ((dependsOn = this.fieldModel.getDependsOn()) == null || dependsOn.isEmpty())) {
                                        Object[] inserts8 = new String[]{TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_DEPENDS_ON")};
                                        String[] attrs3 = new String[]{DEPENDSON};
                                        throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts8), attrs3);
                                    }
                                }
                                if (currAttr.equals(DEPENDSON)) break block21;
                            }
                            if (!currAttr.equals(ALL) && !currAttr.equals(LENGTH)) break block30;
                            adt = this.fieldModel.getAppDatatype();
                            if (!(adt == null || adt.equals((Object)DBDConstants.ARRAY) || adt.equals((Object)DBDConstants.STRUCT) || adt == DBDConstants.XML && this.getStartPos().equals("0") || (fieldLength = this.fieldModel.getBytes()) > 0)) {
                                inserts2 = new String[]{TranMessages.getLabel().getString("WB013A"), String.valueOf(fieldLength)};
                                attrs = new String[]{LENGTH};
                                throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts2), attrs);
                            }
                            if (currAttr.equals(LENGTH)) break block21;
                        }
                        if (!currAttr.equals(ALL) && !currAttr.equals(PRECISION)) break block31;
                        pdt = this.fieldModel.getPhysicalDataType();
                        DBDConstants adt = this.fieldModel.getAppDatatype();
                        if ((pdt == DBDConstants.PACKEDDECIMAL || pdt == DBDConstants.ZONEDDECIMAL || adt == DBDConstants.DECIMAL && pdt == DBDConstants.BINARY) && ((precision = this.fieldModel.getPrecision()) == null || precision == -1)) {
                            inserts = new String[]{TranMessages.getLabel().getString("WB023A")};
                            String[] attrs = new String[]{PRECISION};
                            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts), attrs);
                        }
                        if (currAttr.equals(PRECISION)) break block21;
                    }
                    if (!currAttr.equals(ALL) && !currAttr.equals(SCALE)) break block32;
                    pdt = this.fieldModel.getPhysicalDataType();
                    DBDConstants adt = this.fieldModel.getAppDatatype();
                    if ((pdt == DBDConstants.PACKEDDECIMAL || pdt == DBDConstants.ZONEDDECIMAL || adt == DBDConstants.DECIMAL && pdt == DBDConstants.BINARY) && ((scale = this.fieldModel.getScale()) == null || scale == -1)) {
                        inserts = new String[]{TranMessages.getLabel().getString("WB024A")};
                        String[] attrs = new String[]{SCALE};
                        throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts), attrs);
                    }
                    if (currAttr.equals(SCALE)) break block21;
                }
                if (currAttr.equals(ALL) || currAttr.equals(IS_SIGNED)) {
                    DBDConstants isSigned;
                    pdt = this.fieldModel.getPhysicalDataType();
                    DBDConstants adt = this.fieldModel.getAppDatatype();
                    if ((pdt == DBDConstants.PACKEDDECIMAL || pdt == DBDConstants.ZONEDDECIMAL || adt == DBDConstants.DECIMAL && pdt == DBDConstants.BINARY) && (isSigned = this.fieldModel.getIsSigned()) == null) {
                        inserts = new String[]{TranMessages.getLabel().getString("WB025A")};
                        String[] attrs = new String[]{IS_SIGNED};
                        throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_4", inserts), attrs);
                    }
                    if (currAttr.equals(IS_SIGNED)) {
                        // empty if block
                    }
                }
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setRedefines(String redfefinesVal) throws ModelException, InvalidInputException {
        if (redfefinesVal != null && !redfefinesVal.isEmpty()) {
            FieldModel priorField = this.isFieldExisted(redfefinesVal);
            if (priorField == null) {
                Object[] inserts = new String[]{TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_POSITION_START_AFTER")};
                String[] attrs = new String[]{START};
                throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_7", inserts), attrs);
            }
            boolean dynamicArrayExist = ManageFieldsController.isFieldDynamicLength(priorField);
            if (dynamicArrayExist) {
                Object[] inserts = new Object[]{priorField.getName()};
                String[] attrs = new String[]{REDEFINES};
                throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_11", inserts), attrs);
            }
            this.fieldModel.setRedefines(redfefinesVal);
        } else {
            this.fieldModel.setRedefines(null);
        }
        this.hasBeenEdited = true;
    }

    public String getRedefines() {
        return this.fieldModel.getRedefines();
    }

    public FieldModel getFieldModel() {
        return this.fieldModel;
    }

    public Vector<FieldModel> getChildFields() {
        return this.fieldModel.getChildFields();
    }

    public String getMessageName() {
        return this.messageName;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public String getOriginalName() {
        return this.fieldModel.getOriginalName();
    }

    public String getName() {
        return this.fieldModel.getName();
    }

    public DBDConstants getAppDatatype() {
        return this.fieldModel.getAppDatatype();
    }

    public DBDConstants getPhysicalDataType() {
        return this.fieldModel.getPhysicalDataType();
    }

    public String getEncoding() {
        return this.fieldModel.getEncoding();
    }

    public Integer getPrecision() {
        return this.fieldModel.getPrecision();
    }

    public Integer getScale() {
        return this.fieldModel.getScale();
    }

    public DBDConstants getIsSigned() {
        return this.fieldModel.getIsSigned();
    }

    public void semanticCheck() throws InvalidInputException, ModelException {
        this.mfController.validateImsNameAndAliasInput(this.fieldModel, this.origFieldName, this.origFieldAlias, this.messageName, this.segmentNumber);
        this.validateMinMaxOccurs();
        this.validateStaticToDynamicArray();
        this.validateRedefines();
        this.mfController.validateDependson(this.fieldModel);
        this.validatePrecisionAndScale();
    }

    private void validatePrecisionAndScale() throws InvalidInputException {
        Integer precisionInt = this.fieldModel.getPrecision();
        Integer scaleInt = this.fieldModel.getScale();
        if (precisionInt != null && scaleInt != null && scaleInt > precisionInt) {
            String[] attrs = new String[]{PRECISION, SCALE};
            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_36"), attrs);
        }
    }

    public void validateRedefines() throws InvalidInputException, ModelException {
        String redefinedFieldStr = this.fieldModel.getRedefines();
        if (redefinedFieldStr != null && !redefinedFieldStr.isEmpty()) {
            if (ManageFieldsController.isFieldDynamicLength(this.fieldModel)) {
                String[] attrs = new String[]{REDEFINES, DEPENDSON};
                Object[] inserts = new Object[]{this.fieldModel.getName()};
                throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_20", inserts), attrs);
            }
            FieldModel redefinedField = this.mfController.getFieldModel(this.messageName, this.segmentNumber, redefinedFieldStr);
            if (redefinedField != null && redefinedField.getMaxBytes() > 0 && redefinedField.getBytes() == 0) {
                String[] attrs = new String[]{REDEFINES, DEPENDSON};
                Object[] inserts = new Object[]{redefinedField.getName()};
                throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_11", inserts), attrs);
            }
        }
    }

    private void validateStaticToDynamicArray() throws InvalidInputException, ModelException {
        Integer minOccurs = this.fieldModel.getMinOccurs();
        Integer maxOccurs = this.fieldModel.getMaxOccurs();
        if (minOccurs != null && maxOccurs != null && minOccurs.intValue() != maxOccurs.intValue() && this.fieldOrAncestorInRedefinesGroup(this.fieldModel)) {
            String[] attrs = new String[]{MIN_OCCURS, MAX_OCCURS, DEPENDSON};
            Object[] inserts = new Object[]{this.fieldModel.getName()};
            throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_50", inserts), attrs);
        }
    }

    private boolean fieldOrAncestorInRedefinesGroup(FieldModel field) throws ModelException {
        if (field != null) {
            if (this.fieldIsInRedefinesGroup(field)) {
                return true;
            }
            FieldModel parentField = field.getParentField();
            if (parentField != null && this.fieldOrAncestorInRedefinesGroup(parentField)) {
                return true;
            }
        }
        return false;
    }

    private boolean fieldIsInRedefinesGroup(FieldModel field) throws ModelException {
        FieldModel[] currRedefinesGrp;
        TranSegmentModel segment = this.mfController.getSegmentNode(this.messageName, this.segmentNumber);
        ArrayList<FieldModel> allFields = this.mfController.getFreshFieldList(segment);
        List<List<FieldModel>> redefinesGroupList = this.mfController.buildRedefinesGroupList(allFields);
        return redefinesGroupList != null && (currRedefinesGrp = this.mfController.getRedefinesGroup(field.getName(), redefinesGroupList)) != null;
    }

    public InvalidInputException validateAttrChangable(String attr, Object newValue) throws ModelException {
        InvalidInputException retVal = null;
        if (attr.equals(PARENT) || attr.equals(ALIAS) || attr.equals(REDEFINES) || attr.equals(START)) {
            String[] attrs = new String[]{};
            if (!this.actionType.equals(MOVE) && (retVal = this.mfController.validateFieldIsNotRedefined(this.fieldModel, this.mfController.getSegmentNode(this.messageName, this.segmentNumber))) != null) {
                attrs = new String[]{"", PARENT, START, ALIAS, REDEFINES};
            }
            if (retVal == null && attr.equals(PARENT) && (retVal = this.validateChangeXmlDataType(newValue, PARENT)) != null) {
                attrs = new String[]{PARENT};
            }
            if (retVal != null) {
                this.notifyListeners(attrs);
            }
        } else if (attr.equals(APP_DATATYPE)) {
            retVal = this.mfController.validateDependsOn(this.fieldModel, this, newValue, this.mfController.getSegmentNode(this.messageName, this.segmentNumber));
            if (retVal == null) {
                retVal = this.mfController.validateChangeArrayStructDatatype(this.fieldModel, this, newValue);
            }
            if (retVal == null) {
                retVal = this.validateChangeXmlDataType(newValue, APP_DATATYPE);
            }
            if (retVal != null) {
                this.notifyListeners(APP_DATATYPE);
            }
        } else if (attr.equals(PHY_DATATYPE)) {
            retVal = this.validateChangeXmlDataType(newValue, PHY_DATATYPE);
            if (retVal == null) {
                retVal = this.mfController.validateDependsOn(this.fieldModel, this, newValue, this.mfController.getSegmentNode(this.messageName, this.segmentNumber));
            }
            if (retVal != null) {
                this.notifyListeners(PHY_DATATYPE);
            }
        } else if (attr.equals(SCALE) && (retVal = this.mfController.validateDependsOnAndAppDataType(this.fieldModel, newValue, this.mfController.getSegmentNode(this.messageName, this.segmentNumber))) != null) {
            this.notifyListeners(SCALE);
        }
        return retVal;
    }

    private InvalidInputException validateChangeXmlDataType(Object newValue, String attr) throws ModelException {
        InvalidInputException retVal = null;
        if (attr.equals(APP_DATATYPE)) {
            String appDataType = (String)newValue;
            if (this.fieldModel.getParentField() != null && appDataType.equals(DBDConstants.XML.value())) {
                retVal = new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_32"));
            }
        } else if (attr.equals(PHY_DATATYPE)) {
            String phyDataType = (String)newValue;
            if (this.fieldModel.getParentField() != null && phyDataType.equals(DBDConstants.XML_CLOB.value())) {
                retVal = new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_32"));
            }
        } else if (attr.equals(PARENT)) {
            String parentName = (String)newValue;
            if ((this.fieldModel.getAppDatatype() != null && this.fieldModel.getAppDatatype().equals((Object)DBDConstants.XML) || this.fieldModel.getPhysicalDataType() != null && this.fieldModel.getPhysicalDataType().equals((Object)DBDConstants.XML_CLOB)) && parentName != null && !parentName.isEmpty()) {
                retVal = new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_32"));
            }
        }
        return retVal;
    }

    public String getOriginalParentName() throws ModelException {
        return this.mfController.getFieldModel(this.messageName, this.segmentNumber, this.origFieldName).getParentField().getName();
    }

    public String getOriginalFollowsField() throws ModelException {
        return this.mfController.getFieldModel(this.messageName, this.segmentNumber, this.origFieldName).getStartAfter();
    }

    public String getOriginalAlias() throws ModelException {
        if (this.actionType.equals(EDIT)) {
            return this.mfController.getFieldModel(this.messageName, this.segmentNumber, this.origFieldName).getName();
        }
        return "";
    }

    public DBDConstants getOriginalDataType() throws ModelException {
        return this.mfController.getFieldModel(this.messageName, this.segmentNumber, this.origFieldName).getAppDatatype();
    }

    private void validateMinMaxOccurs() throws InvalidInputException {
        Integer minOccurs = this.fieldModel.getMinOccurs();
        Integer maxOccurs = this.fieldModel.getMaxOccurs();
        if (minOccurs != null && maxOccurs != null) {
            if (minOccurs.equals(maxOccurs)) {
                this.fieldModel.setDependsOn(null);
            } else if (minOccurs > maxOccurs) {
                String[] attrs = new String[]{MIN_OCCURS, MAX_OCCURS};
                throw new InvalidInputException(TranMessages.getError().getString("EDIT_FIELD_WIZ_9"), attrs);
            }
        }
    }

    public ArrayList<FieldModel> getFieldList() throws ModelException {
        return this.mfController.getFreshFieldList(this.mfController.getSegmentNode(this.messageName, this.segmentNumber));
    }

    public String getMaxBytes() {
        return Integer.toString(this.fieldModel.getMaxBytes());
    }

    public boolean isFieldNameTaken(String fieldName) throws ModelException {
        ArrayList<FieldModel> fields = this.getFieldList();
        if (fields == null) {
            return true;
        }
        int i = 0;
        while (i < fields.size()) {
            FieldModel currField = (FieldModel)fields.get(i);
            if (this.fieldModel.getFieldType() != currField.getFieldType()) {
                String currIMSName = currField.getName();
                if (currIMSName == null) {
                    currIMSName = "";
                }
                if (currIMSName.equals(fieldName)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean isAliasTaken(String alias) throws ModelException {
        ArrayList<FieldModel> fields = this.getFieldList();
        if (fields == null) {
            return true;
        }
        int i = 0;
        while (i < fields.size()) {
            FieldModel currField = (FieldModel)fields.get(i);
            if (this.fieldModel.getFieldType() != currField.getFieldType()) {
                String currAlias = currField.getName();
                if (currAlias == null) {
                    currAlias = "";
                }
                if (currAlias.equals(alias)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void performFinish() throws ModelException {
        this.clearInvalidDatatypeAttrs();
        if (this.actionType.equals(ADD)) {
            this.mfController.addNewField(this.messageName, this.segmentNumber, this.fieldModel);
        } else {
            List<FieldModel> subsequentFields = null;
            if (this.actionType.equals(MOVE)) {
                subsequentFields = this.getSubsequentMoveFields();
            }
            this.mfController.replaceOrigFieldWithClone(this.messageName, this.segmentNumber, this.fieldModel);
            if (this.actionType.equals(MOVE)) {
                this.moveSubSequentFields(this.fieldModel, subsequentFields);
            }
        }
        this.mfController.clearRedefineGroups();
    }

    private List<FieldModel> getSubsequentMoveFields() throws ModelException {
        ArrayList<FieldModel> subsequentFields = new ArrayList<FieldModel>(this.fieldNames.length - 1);
        int i = 1;
        while (i < this.fieldNames.length) {
            String fieldName = this.fieldNames[i];
            subsequentFields.add(new FieldModel(this.mfController.getFieldModel(this.messageName, this.segmentNumber, fieldName)));
            ++i;
        }
        return subsequentFields;
    }

    private void moveSubSequentFields(FieldModel fieldModel, List<FieldModel> subsequentFields) throws ModelException {
        String prevFieldName = fieldModel.getName();
        int i = 0;
        while (i < subsequentFields.size()) {
            FieldModel currSubsequentField = subsequentFields.get(i);
            if (currSubsequentField != null && !this.isChildOfFieldModel(fieldModel, currSubsequentField.getName())) {
                currSubsequentField.setStartPos(0);
                currSubsequentField.setRelativeStart(0);
                currSubsequentField.setStartAfter(prevFieldName);
                currSubsequentField.setParentField(fieldModel.getParentField());
                this.mfController.removeFieldFromClonedSegmentModel(this.messageName, this.segmentNumber, currSubsequentField);
                this.mfController.addNewField(this.messageName, this.segmentNumber, currSubsequentField);
                fieldModel = currSubsequentField;
                prevFieldName = currSubsequentField.getName();
            }
            ++i;
        }
    }

    private boolean isChildOfFieldModel(FieldModel parentField, String fieldName) {
        boolean retVal = false;
        Vector<FieldModel> childFields = parentField.getChildFields();
        if (childFields != null) {
            for (FieldModel currentChild : childFields) {
                if (!currentChild.getName().equals(fieldName)) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    private void clearInvalidDatatypeAttrs() {
        DBDConstants physDT = this.fieldModel.getPhysicalDataType();
        DBDConstants appDT = this.fieldModel.getAppDatatype();
        if (physDT != DBDConstants.PACKEDDECIMAL && physDT != DBDConstants.ZONEDDECIMAL && (appDT != DBDConstants.DECIMAL || physDT != DBDConstants.BINARY)) {
            this.clearDecimalAttrs();
        }
        if (appDT != DBDConstants.DATE && appDT != DBDConstants.TIME && appDT != DBDConstants.TIMESTAMP) {
            this.fieldModel.setPattern(null);
        }
        this.fieldModel.removeMarshallerIfEmpty();
    }

    private void clearDecimalAttrs() {
        this.fieldModel.setIsSigned(null);
        this.fieldModel.setPrecision(null);
        this.fieldModel.setScale(null);
    }

    private void updateModelForAppDataTypeChange() throws InvalidInputException {
        DBDConstants newAppDT = this.fieldModel.getAppDatatype();
        DBDConstants pdt = this.fieldModel.getPhysicalDataType();
        String[] attrs = new String[]{PHY_DATATYPE};
        if (!newAppDT.equals((Object)pdt)) {
            if (pdt != null) {
                this.fieldModel.setPhysicalDataType(null);
            }
            attrs = new String[]{PHY_DATATYPE, LENGTH};
            this.notifyListeners(attrs);
        }
        this.updateLengthValue();
    }

    private void updateLengthValue() {
        DBDConstants newPhysDT = this.fieldModel.getPhysicalDataType();
        if (newPhysDT != null && !newPhysDT.value().isEmpty() && this.lengthMap.keySet().contains(newPhysDT.value())) {
            this.fieldModel.setBytes(this.lengthMap.get(newPhysDT.value()));
            this.notifyListeners(LENGTH);
        } else {
            DBDConstants newAppDT = this.fieldModel.getAppDatatype();
            if (newAppDT != null && this.lengthMap.keySet().contains(newAppDT.value()) && newPhysDT == null) {
                this.fieldModel.setBytes(this.lengthMap.get(newAppDT.value()));
                this.notifyListeners(LENGTH);
            }
        }
    }

    public void addModelChangeListener(IModelChangeListener listener) {
        this.modelChangeListeners.add(listener);
    }

    public void removeModelChangeListener(IModelChangeListener listener) {
        this.modelChangeListeners.remove(listener);
    }

    private void notifyListeners(ModelChangeEvent event) {
        for (IModelChangeListener listener : this.modelChangeListeners) {
            listener.handleModelChange(event);
        }
    }

    public void notifyListeners(String[] attrs) {
        ModelChangeEvent changeEvent = new ModelChangeEvent(attrs);
        this.notifyListeners(changeEvent);
    }

    public void notifyListeners(String attr) {
        String[] attrs = new String[]{attr};
        this.notifyListeners(attrs);
    }

    private void initLengthMap() {
        this.lengthMap.put("BIT", 1);
        this.lengthMap.put("BYTE", 1);
        this.lengthMap.put("DOUBLE", 8);
        this.lengthMap.put("FLOAT", 4);
        this.lengthMap.put("INT", 4);
        this.lengthMap.put("LONG", 8);
        this.lengthMap.put("SHORT", 2);
        this.lengthMap.put("DATE", 8);
        this.lengthMap.put("TIME", 8);
        this.lengthMap.put("TIMESTAMP", 8);
        this.lengthMap.put("UBYTE", 1);
        this.lengthMap.put("USHORT", 2);
        this.lengthMap.put("UINT", 4);
        this.lengthMap.put("ULONG", 8);
    }

    private void setDependsOnIfNeeded() throws InvalidInputException, ModelException {
        int maxVal;
        int minVal = this.fieldModel.getMinOccurs() == null ? 0 : this.fieldModel.getMinOccurs();
        int n = maxVal = this.fieldModel.getMaxOccurs() == null ? 0 : this.fieldModel.getMaxOccurs();
        if (minVal == maxVal) {
            this.setDependsOn(null);
            this.notifyListeners(DEPENDSON);
        }
    }

    public boolean isValidParent(FieldModel currentField) {
        FieldModel parentField;
        DBDConstants dataType;
        if (currentField != null && ((dataType = currentField.getAppDatatype()) == DBDConstants.STRUCT || dataType == DBDConstants.ARRAY) && (parentField = currentField.getParentField()) != null) {
            String parentName = parentField.getName();
            if (parentName.equals(this.fieldModel.getName())) {
                return false;
            }
            return this.isValidParent(parentField);
        }
        return true;
    }
}

