/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.transaction.controller.datastructure;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.zos.comm.IZOSConstants;
import com.ibm.cics.zos.model.DataEntry;
import com.ibm.cics.zos.model.Member;
import com.ibm.cics.zos.model.PartitionedDataSet;
import com.ibm.im.ims.metadata.transaction.AlignmentType;
import com.ibm.im.ims.metadata.transaction.ApplicationDatatypeType;
import com.ibm.im.ims.metadata.transaction.DatatypeType;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MarshallerType;
import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.PhysicalDatatypeType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.metadata.transaction.YesnoType;
import com.ibm.im.ims.transaction.controller.datastructure.CobolImportHelper;
import com.ibm.im.ims.transaction.controller.datastructure.DBDConstants;
import com.ibm.im.ims.transaction.controller.datastructure.DataStructureSegmentAssociation;
import com.ibm.im.ims.transaction.controller.datastructure.ImportParseException;
import com.ibm.im.ims.transaction.controller.datastructure.InformationException;
import com.ibm.im.ims.transaction.controller.datastructure.PliImportHelper;
import com.ibm.im.ims.transaction.controller.datastructure.TranDataStructureParser;
import com.ibm.im.ims.transaction.controller.editor.TranEditorController;
import com.ibm.im.ims.transaction.model.utilities.ModelException;
import com.ibm.im.ims.transaction.model.utilities.ParseException;
import com.ibm.im.ims.transaction.model.utilities.Utility;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;

public class TranDataStructureController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Transaction transaction = null;
    private String projectName;
    private Vector<FieldType> commonFieldList = null;
    private Vector<FieldType> topLevelFieldList = null;
    public static final String COBOL = "COBOL";
    public static final String PLI = "PL/I";
    public static final String COBOL_DS = TranMessages.getLabel().getString("IDSW_COBOL_DS");
    public static final String COBOL_PROG = TranMessages.getLabel().getString("IDSW_COBOL_FULL_PROGRAM");
    public static final String PLI_DS = TranMessages.getLabel().getString("IDSW_PLI_DS");
    public static final String PLI_PROG = TranMessages.getLabel().getString("IDSW_PLI_FULL_PROGRAM");
    public static final String[] sourceLanguages = new String[]{COBOL_DS, COBOL_PROG, PLI_DS, PLI_PROG};
    private boolean isLocalSource = true;
    private String importLanguage = sourceLanguages[0];
    private String lastDirectory = "";
    private String selectedMessageName;
    private String selectedSegmentName;
    private Map<String, ArrayList<FieldType>> fileNameToDataStructureMappings = new HashMap<String, ArrayList<FieldType>>();
    private Map<FieldType, Boolean> isStartAfterSelected = new HashMap<FieldType, Boolean>();
    public Vector<InformationException> parsingInformationExceptionList;
    private Vector<DataStructureSegmentAssociation> associations;
    private Vector<PartitionedDataSet> pdsList = new Vector();
    private HashMap<PartitionedDataSet, Vector<Member>> allPdsMembers = new HashMap();
    public static final String IN_MSG_SUFFIX = " **IN**";
    public static final String OUT_MSG_SUFFIX = " **OUT**";
    private boolean isCOBOLLanguage = true;
    private String tempFileName;
    private IFile tempFile;
    private ImportParseException importParseException;

    public TranDataStructureController(Transaction transaction, String projectName, boolean isLocalSource, String importLanguage, String lastDirectory, String selectedMessageName, String selectedSegmentName) {
        this.projectName = projectName;
        this.transaction = transaction;
        this.isLocalSource = isLocalSource;
        this.importLanguage = importLanguage;
        this.lastDirectory = lastDirectory;
        this.selectedMessageName = selectedMessageName;
        this.selectedSegmentName = selectedSegmentName;
        this.associations = new Vector();
    }

    public String getSelectedMessageName() {
        return this.selectedMessageName;
    }

    public String getSelectedSegmentName() {
        return this.selectedSegmentName;
    }

    public List<String> getInputMessageNames() {
        ArrayList<String> inMessages = new ArrayList<String>();
        for (MessageType mt : this.transaction.getInputMessage()) {
            inMessages.add(mt.getName() + IN_MSG_SUFFIX);
        }
        return inMessages;
    }

    public List<String> getOutputMessageNames() {
        ArrayList<String> outMessages = new ArrayList<String>();
        for (MessageType mt : this.transaction.getOutputMessage()) {
            outMessages.add(mt.getName() + OUT_MSG_SUFFIX);
        }
        return outMessages;
    }

    public MessageType getMessageType(String msgName) {
        MessageType retVal = null;
        int index = msgName.indexOf(IN_MSG_SUFFIX);
        boolean isInputMessage = false;
        if (index >= 0) {
            isInputMessage = true;
        }
        if (!isInputMessage) {
            index = msgName.indexOf(OUT_MSG_SUFFIX);
        }
        msgName = msgName.substring(0, index);
        if (isInputMessage) {
            for (MessageType mt : this.transaction.getInputMessage()) {
                if (!mt.getName().equals(msgName)) continue;
                retVal = mt;
                break;
            }
        } else {
            for (MessageType mt : this.transaction.getOutputMessage()) {
                if (!mt.getName().equals(msgName)) continue;
                retVal = mt;
                break;
            }
        }
        return retVal;
    }

    public List<String> getSegmentNames(MessageType mt) {
        ArrayList<String> segmentNames = new ArrayList<String>();
        int i = 0;
        while (i < mt.getSegment().size()) {
            segmentNames.add(TranMessages.getLabel().getString("TMME_SEGMENT") + " " + (i + 1));
            ++i;
        }
        return segmentNames;
    }

    public String getTempFileName() {
        return this.tempFileName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void parseApplicationSourceFile(String folderName, String fileName, String importLanguage) throws CoreException, IOException, ParseException, ModelException, ConnectionException {
        this.importParseException = null;
        String fullPathName = null;
        this.tempFileName = null;
        fullPathName = this.isLocalSource ? folderName + File.separator + fileName : folderName + "(" + fileName + ")";
        this.lastDirectory = fullPathName;
        ArrayList<FieldType> dataStructures = this.fileNameToDataStructureMappings.get(fullPathName);
        TranDataStructureParser parser = new TranDataStructureParser(this);
        if (dataStructures == null) {
            if (!this.isLocalSource) {
                Member de = this.getSelectedMember(folderName, fileName);
                this.tempFile = this.createTempDataEntryFile((DataEntry)de, importLanguage, fullPathName, fileName);
                this.tempFileName = this.tempFile.getLocation().toOSString();
                logger.info("Temp file for import: " + this.tempFile.getLocation().toOSString(), new Object[0]);
            } else if (!this.isCOBOLOrPLIFile(fileName)) {
                this.tempFile = TranDataStructureController.createTempFile(this.projectName, importLanguage, fullPathName, fileName);
                this.tempFileName = this.tempFile.getLocation().toOSString();
                logger.info("Temp file for import: " + this.tempFile.getLocation().toOSString(), new Object[0]);
            } else {
                this.tempFileName = fullPathName;
                this.importLanguage = TranDataStructureController.getFileType(fullPathName);
            }
            try {
                if (TranDataStructureController.isCOBOLFile(this.tempFileName)) {
                    dataStructures = TranDataStructureController.handleCOBOLFile(this.tempFileName, parser, this.projectName);
                    this.isCOBOLLanguage = true;
                } else {
                    dataStructures = TranDataStructureController.handlePLIFile(this.tempFileName, parser, this.projectName);
                    this.isCOBOLLanguage = false;
                }
                this.parsingInformationExceptionList = parser.getInformationExceptionList();
                this.updateFileNameToSegmentModelsTable(dataStructures);
            }
            catch (ImportParseException e) {
                this.importParseException = e;
            }
            Utility.deleteTempFile(this.tempFile);
        }
    }

    public void deleteTempFile() {
        Utility.deleteTempFile(this.tempFile);
    }

    public boolean isCOBOLLanguage() {
        return this.isCOBOLLanguage;
    }

    public void updateFileNameToSegmentModelsTable(ArrayList<FieldType> dataStructures) {
        this.fileNameToDataStructureMappings.put(this.lastDirectory, dataStructures);
    }

    public String[] getDataStructureNames() {
        String[] retVal = new String[]{};
        List dataStructures = this.fileNameToDataStructureMappings.get(this.lastDirectory);
        if (dataStructures != null) {
            int numDataStructures = dataStructures.size();
            retVal = new String[numDataStructures];
            int i = 0;
            while (i < numDataStructures) {
                FieldType currDataStructure = (FieldType)dataStructures.get(i);
                retVal[i] = currDataStructure.getName();
                ++i;
            }
        }
        return retVal;
    }

    public List<FieldType> getDataStructures() {
        return this.fileNameToDataStructureMappings.get(this.lastDirectory);
    }

    public String addAssociation(String dataStructureName, String messageName, String segmentName, String fileName) {
        int segIx = Integer.parseInt(segmentName.substring(segmentName.length() - 1, segmentName.length()));
        String realMessageName = null;
        boolean isInputMessage = true;
        if (messageName.endsWith(IN_MSG_SUFFIX)) {
            realMessageName = messageName.substring(0, messageName.length() - IN_MSG_SUFFIX.length());
        } else {
            realMessageName = messageName.substring(0, messageName.length() - OUT_MSG_SUFFIX.length());
            isInputMessage = false;
        }
        List dataStructures = this.fileNameToDataStructureMappings.get(this.lastDirectory);
        FieldType selectedDataStructure = null;
        int i = 0;
        while (i < dataStructures.size()) {
            FieldType currFieldType = (FieldType)dataStructures.get(i);
            if (currFieldType.getName().equals(dataStructureName)) {
                selectedDataStructure = currFieldType;
                break;
            }
            ++i;
        }
        BigInteger selectedMessageId = null;
        BigInteger selectedSegmentId = null;
        List messages = this.transaction.getInputMessage();
        if (!isInputMessage) {
            messages = this.transaction.getOutputMessage();
        }
        int i2 = 0;
        MessageType currMessage = null;
        SegmentType currSegment = null;
        boolean nameCollision = false;
        i2 = 0;
        while (i2 < messages.size()) {
            currMessage = (MessageType)messages.get(i2);
            if (currMessage.getName().equals(realMessageName)) {
                selectedMessageId = currMessage.getId();
                List segments = currMessage.getSegment();
                currSegment = (SegmentType)segments.get(segIx - 1);
                int j = 0;
                while (j < segments.size()) {
                    SegmentType seg = (SegmentType)segments.get(j);
                    if (this.checkDsNameCollision(seg, dataStructureName)) {
                        nameCollision = true;
                    }
                    if (nameCollision) break;
                    ++j;
                }
                selectedSegmentId = currSegment.getId();
                break;
            }
            ++i2;
        }
        boolean needToClone = false;
        i2 = 0;
        while (i2 < this.associations.size()) {
            DataStructureSegmentAssociation currAssociation = this.associations.get(i2);
            if (currAssociation.messageId.equals(selectedMessageId) && currAssociation.segmentId.equals(selectedSegmentId) && currAssociation.dataStructure == selectedDataStructure) {
                Object[] messageArguments = new Object[]{dataStructureName, messageName, segmentName};
                MessageFormat formatter = new MessageFormat(TranMessages.getError().getString("IDSW_ERR_02A"));
                formatter.setLocale(Locale.getDefault());
                return formatter.format(messageArguments);
            }
            if (currAssociation.dataStructure == selectedDataStructure) {
                needToClone = true;
            }
            ++i2;
        }
        if (needToClone) {
            selectedDataStructure = TranEditorController.cloneFieldType(selectedDataStructure);
        }
        DataStructureSegmentAssociation assoc = new DataStructureSegmentAssociation(selectedMessageId, selectedSegmentId, selectedDataStructure, fileName);
        assoc.messageName = messageName;
        assoc.segmentName = segmentName;
        assoc.nameCollision = nameCollision;
        this.associations.add(assoc);
        return null;
    }

    private boolean checkDsNameCollision(SegmentType segType, String dsName) {
        boolean retVal = false;
        int j = 0;
        while (j < segType.getField().size()) {
            FieldType fieldType = (FieldType)segType.getField().get(j);
            if (fieldType.getName() != null && fieldType.getName().equals(dsName)) {
                return true;
            }
            ++j;
        }
        return retVal;
    }

    public void removeAssociation(String dataStructureName, String messageName, String segmentName, String fileName) {
        int segIx = Integer.parseInt(segmentName.substring(segmentName.length() - 1, segmentName.length()));
        String realMessageName = null;
        realMessageName = messageName.endsWith(IN_MSG_SUFFIX) ? messageName.substring(0, messageName.length() - IN_MSG_SUFFIX.length()) : messageName.substring(0, messageName.length() - OUT_MSG_SUFFIX.length());
        Iterator<DataStructureSegmentAssociation> iter = this.associations.iterator();
        while (iter.hasNext()) {
            DataStructureSegmentAssociation currElem = iter.next();
            BigInteger selectedMessageId = null;
            BigInteger selectedSegmentId = null;
            ArrayList<MessageType> allMessages = new ArrayList<MessageType>();
            List messages = this.transaction.getInputMessage();
            for (MessageType messageType : messages) {
                allMessages.add(messageType);
            }
            messages = this.transaction.getOutputMessage();
            for (MessageType messageType : messages) {
                allMessages.add(messageType);
            }
            int i = 0;
            while (i < allMessages.size()) {
                MessageType currMessage = (MessageType)allMessages.get(i);
                if (currMessage.getName().equals(realMessageName)) {
                    selectedMessageId = currMessage.getId();
                    List segments = currMessage.getSegment();
                    selectedSegmentId = ((SegmentType)segments.get(segIx - 1)).getId();
                    break;
                }
                ++i;
            }
            if (selectedMessageId != currElem.messageId || selectedSegmentId != currElem.segmentId || !fileName.equals(currElem.importFile) || !dataStructureName.equals(currElem.dataStructure.getName())) continue;
            iter.remove();
        }
    }

    public Map<String, ArrayList<FieldType>> getSegmentModelsMap() {
        return this.fileNameToDataStructureMappings;
    }

    public void setName(FieldType field, String value) {
        field.setName(value);
    }

    public String getName(FieldType field) {
        String retVal = null;
        if (!(retVal != null && retVal.trim().length() != 0 || (retVal = field.getName()) != null && retVal.trim().length() != 0)) {
            retVal = null;
        }
        return retVal;
    }

    public void setAppDatatype(FieldType field, DBDConstants value) {
        ApplicationDatatypeType adt = field.getApplicationDatatype();
        if (adt == null) {
            adt = new ApplicationDatatypeType();
            field.setApplicationDatatype(adt);
        }
        adt.setDatatype(DatatypeType.valueOf((String)value.toString()));
    }

    public DBDConstants getAppDatatype(FieldType field) {
        ApplicationDatatypeType adt = field.getApplicationDatatype();
        if (adt == null) {
            return null;
        }
        DatatypeType dt = adt.getDatatype();
        if (dt == null) {
            return null;
        }
        return DBDConstants.valueOf(dt.toString());
    }

    public void setPrecision(FieldType fieldType, String value) {
        ApplicationDatatypeType adt = fieldType.getApplicationDatatype();
        if (adt == null) {
            adt = new ApplicationDatatypeType();
            fieldType.setApplicationDatatype(adt);
        }
        if (value == null) {
            adt.setPrecision(null);
        } else {
            adt.setPrecision(Integer.valueOf(value));
        }
    }

    public Integer getPrecision(FieldType fieldType) {
        ApplicationDatatypeType adt = fieldType.getApplicationDatatype();
        if (adt == null) {
            return null;
        }
        return adt.getPrecision();
    }

    public Integer getScale(FieldType fieldType) {
        ApplicationDatatypeType adt = fieldType.getApplicationDatatype();
        if (adt == null) {
            return null;
        }
        return adt.getScale();
    }

    public void setScale(FieldType fieldType, String value) {
        ApplicationDatatypeType adt = fieldType.getApplicationDatatype();
        if (adt == null) {
            adt = new ApplicationDatatypeType();
            fieldType.setApplicationDatatype(adt);
        }
        if (value == null) {
            adt.setScale(null);
        } else {
            adt.setScale(Integer.valueOf(value));
        }
    }

    public void setEncoding(FieldType fieldType, String value) {
        MarshallerType marshaller = fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            fieldType.setMarshaller(marshaller);
        }
        if (value == null) {
            marshaller.setEncoding(null);
        } else {
            marshaller.setEncoding(value);
        }
    }

    public void setIsSigned(FieldType fieldType, String value) {
        MarshallerType marshaller = fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            fieldType.setMarshaller(marshaller);
        }
        if (value == null) {
            marshaller.setIsSigned(null);
        } else {
            if (value.equalsIgnoreCase("YES")) {
                value = "Y";
            } else if (value.equalsIgnoreCase("NO")) {
                value = "N";
            }
            marshaller.setIsSigned(YesnoType.fromValue((String)value));
        }
    }

    public void setSignLeading(FieldType fieldType, String value) {
        MarshallerType marshaller = fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            fieldType.setMarshaller(marshaller);
        }
        if (value == null) {
            marshaller.setIsSignLeading(null);
        } else {
            if (value.equalsIgnoreCase("YES")) {
                value = "Y";
            } else if (value.equalsIgnoreCase("NO")) {
                value = "N";
            }
            marshaller.setIsSignLeading(YesnoType.fromValue((String)value));
        }
    }

    public void setSignSeparate(FieldType fieldType, String value) {
        MarshallerType marshaller = fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            fieldType.setMarshaller(marshaller);
        }
        if (value == null) {
            marshaller.setIsSignSeparate(null);
        } else {
            if (value.equalsIgnoreCase("YES")) {
                value = "Y";
            } else if (value.equalsIgnoreCase("NO")) {
                value = "N";
            }
            marshaller.setIsSignSeparate(YesnoType.fromValue((String)value));
        }
    }

    public void setIsWCHAROnly(FieldType fieldType, String value) {
        MarshallerType marshaller = fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            fieldType.setMarshaller(marshaller);
        }
        if (value == null) {
            marshaller.setIsSignSeparate(null);
        } else {
            if (value.equalsIgnoreCase("YES")) {
                value = "Y";
            } else if (value.equalsIgnoreCase("NO")) {
                value = "N";
            }
            marshaller.setIsWCHAROnly(YesnoType.fromValue((String)value));
        }
    }

    public void setAlignment(FieldType fieldType, AlignmentType value) {
        MarshallerType marshaller = fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            fieldType.setMarshaller(marshaller);
        }
        if (value == null) {
            marshaller.setAlignment(null);
        } else {
            marshaller.setAlignment(value);
        }
    }

    public void setIsDBCSOnly(FieldType fieldType, String value) {
        MarshallerType marshaller = fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            fieldType.setMarshaller(marshaller);
        }
        if (value == null) {
            marshaller.setIsDBCSOnly(null);
        } else {
            if (value.equalsIgnoreCase("YES")) {
                value = "Y";
            } else if (value.equalsIgnoreCase("NO")) {
                value = "N";
            }
            marshaller.setIsDBCSOnly(YesnoType.fromValue((String)value));
        }
    }

    public void setIsNativeInteger(FieldType fieldType, String value) {
        MarshallerType marshaller = fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            fieldType.setMarshaller(marshaller);
        }
        if (value == null) {
            marshaller.setIsNativeInteger(null);
        } else {
            if (value.equalsIgnoreCase("YES")) {
                value = "Y";
            } else if (value.equalsIgnoreCase("NO")) {
                value = "N";
            }
            marshaller.setIsNativeInteger(YesnoType.fromValue((String)value));
        }
    }

    public void setPhysicalDataType(FieldType fieldType, DBDConstants value) {
        MarshallerType marshaller = fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            fieldType.setMarshaller(marshaller);
        }
        if (value == DBDConstants.USER) {
            marshaller.setTypeConverter(null);
        } else if (value != null) {
            marshaller.setTypeConverter(PhysicalDatatypeType.fromValue((String)value.toString()));
        } else {
            marshaller.setTypeConverter(null);
        }
    }

    public DBDConstants getPhysicalDataType(FieldType fieldType) {
        PhysicalDatatypeType physDatatype;
        DBDConstants retVal = null;
        MarshallerType marshaller = fieldType.getMarshaller();
        if (marshaller != null && (physDatatype = marshaller.getTypeConverter()) != null) {
            retVal = DBDConstants.fromValue(physDatatype.toString());
        }
        return retVal;
    }

    public void setZoneddecimalSubparms(FieldType fieldType, String picString) {
        int scale = this.determineScale(fieldType, picString);
        ApplicationDatatypeType adt = fieldType.getApplicationDatatype();
        if (adt == null) {
            adt = new ApplicationDatatypeType();
            fieldType.setApplicationDatatype(adt);
        }
        adt.setScale(Integer.valueOf(scale));
    }

    private int determineScale(FieldType fieldType, String picString) {
        int scale = 0;
        int index = -1;
        String expandedString = this.expandStringAndGetNumDigits(fieldType, picString);
        index = expandedString.indexOf(86);
        if (index == -1) {
            index = expandedString.indexOf(118);
        }
        if (index != -1) {
            scale = expandedString.length() - index - 1;
            return scale;
        }
        return scale;
    }

    private String expandStringAndGetNumDigits(FieldType fieldType, String pictureString) {
        MarshallerType marshaller = fieldType.getMarshaller();
        StringBuffer expandedString = new StringBuffer();
        int startingIndex = -1;
        int index = 0;
        int expandCount = 0;
        char expandChar = '\u0000';
        if (pictureString.startsWith("S") || pictureString.startsWith("s")) {
            pictureString = pictureString.substring(1);
            marshaller.setIsSigned(YesnoType.Y);
        } else {
            marshaller.setIsSigned(YesnoType.N);
        }
        while ((index = pictureString.indexOf(40, startingIndex)) != -1) {
            expandedString.append(pictureString.substring(startingIndex + 1, index));
            startingIndex = pictureString.indexOf(41, index);
            expandChar = pictureString.charAt(index - 1);
            expandCount = Integer.parseInt(pictureString.substring(index + 1, startingIndex));
            int i = 0;
            while (i < expandCount - 1) {
                expandedString.append(expandChar);
                ++i;
            }
        }
        expandedString.append(pictureString.substring(startingIndex + 1, pictureString.length()));
        int count = 0;
        int length = expandedString.length();
        int i = 0;
        while (i < length) {
            if (String.valueOf(expandedString.charAt(i)).equals("9")) {
                ++count;
            }
            ++i;
        }
        ApplicationDatatypeType adt = fieldType.getApplicationDatatype();
        if (adt == null) {
            adt = new ApplicationDatatypeType();
            fieldType.setApplicationDatatype(adt);
        }
        adt.setPrecision(Integer.valueOf(count));
        return expandedString.toString();
    }

    public void setPackeddecimalSubparms(FieldType fieldType, String picString) {
        ApplicationDatatypeType adt;
        MarshallerType marshaller = fieldType.getMarshaller();
        if (marshaller == null) {
            marshaller = new MarshallerType();
            fieldType.setMarshaller(marshaller);
        }
        int scale = 0;
        int index = -1;
        String expandedString = this.expandStringAndGetNumDigits(fieldType, picString);
        index = expandedString.indexOf(86);
        if (index == -1) {
            index = expandedString.indexOf(118);
        }
        if (index != -1) {
            scale = expandedString.length() - index - 1;
        }
        if ((adt = fieldType.getApplicationDatatype()) == null) {
            adt = new ApplicationDatatypeType();
            fieldType.setApplicationDatatype(adt);
        }
        adt.setScale(Integer.valueOf(scale));
    }

    public void setMinOccurs(FieldType fieldType, Integer minOccurs) {
        fieldType.setMinOccurs(minOccurs);
    }

    public Integer getMinOccurs(FieldType fieldType) {
        return fieldType.getMinOccurs();
    }

    public void setMaxOccurs(FieldType fieldType, Integer maxOccurs) {
        fieldType.setMaxOccurs(maxOccurs);
    }

    public void setDependsOn(FieldType fieldType, String dependsOn) {
        fieldType.setDependsOn(dependsOn);
    }

    public String getDependsOn(FieldType fieldType) {
        return fieldType.getDependsOn();
    }

    public void setDependsOnPath(FieldType fieldType, String dependsOnPath) {
        fieldType.setDependsOnPath(dependsOnPath);
    }

    public String getDependsOnPath(FieldType fieldType) {
        return fieldType.getDependsOnPath();
    }

    public void setMaxBytes(FieldType fieldType, int maxBytes) {
        fieldType.setMaxBytes(Integer.valueOf(maxBytes));
    }

    public int getMaxBytes(FieldType fieldType) {
        Integer maxBytes = fieldType.getMaxBytes();
        if (maxBytes == null) {
            maxBytes = 0;
            fieldType.setMaxBytes(maxBytes);
        }
        return maxBytes;
    }

    public void setBytes(FieldType fieldType, int value) {
        fieldType.setBytes(Integer.valueOf(value));
        if (fieldType != null) {
            this.clearFieldList();
        }
    }

    public int getBytes(FieldType fieldType) {
        Integer bytes = fieldType.getBytes();
        if (bytes == null) {
            bytes = 0;
            fieldType.setBytes(bytes);
        }
        return bytes;
    }

    public void setRedefines(FieldType fieldType, String redefines) {
        fieldType.setRedefines(redefines);
    }

    public String getRedefines(FieldType fieldType) {
        return fieldType.getRedefines();
    }

    public boolean hasSubFields(FieldType fieldType) {
        boolean retVal = false;
        List fields = fieldType.getField();
        if (fields != null && !fields.isEmpty()) {
            retVal = true;
        }
        return retVal;
    }

    public void clearFieldList() {
        if (this.commonFieldList != null) {
            this.commonFieldList.removeAllElements();
        }
        if (this.topLevelFieldList != null) {
            this.topLevelFieldList.removeAllElements();
        }
        this.topLevelFieldList = null;
        this.commonFieldList = null;
    }

    public void addField(FieldType parentField, FieldType subField) {
        parentField.getField().add(subField);
    }

    public void clearFieldList(FieldType field) {
        field.getField().clear();
    }

    public void preconditionTopLevelFieldStartInfo(List<FieldType> fields) {
        FieldType prevField = fields.get(0);
        int i = 1;
        while (i < fields.size()) {
            int currStartPos;
            FieldType currField = fields.get(i);
            int n = currStartPos = currField.getStartPos() != null ? currField.getStartPos() : 0;
            if (currStartPos < 1) {
                currField.setStartAfter(prevField.getName());
                this.setStartAfterSelected(currField, true);
            }
            prevField = currField;
            ++i;
        }
    }

    public void setStartAfterSelected(FieldType field, boolean isStartAfter) {
        this.isStartAfterSelected.put(field, isStartAfter);
    }

    public static IFile createTempFile(String projectName, String fileType, String fullPath, String fileName) throws CoreException, IOException {
        IFile tempFile = TranDataStructureController.getTempFile(projectName, TranDataStructureController.getTempFileName(fileType, TranDataStructureController.massageFileName(fileName)));
        if (tempFile != null) {
            ByteArrayOutputStream out = TranDataStructureController.dupFile(fullPath);
            TranDataStructureController.putContentsInTempFile(tempFile, out);
            out.flush();
            out.close();
        }
        return tempFile;
    }

    public static void moveFile(String projectName, IFile srcFile, IFile targetFile) throws IOException, CoreException {
        ByteArrayOutputStream out = TranDataStructureController.dupFile(srcFile.getRawLocation().toOSString());
        TranDataStructureController.putContentsInTempFile(targetFile, out);
        out.flush();
        out.close();
        Utility.deleteTempFile(srcFile);
    }

    public static void putContentsInTempFile(IFile tempFile, ByteArrayOutputStream out) throws CoreException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(out.toByteArray());
        if (tempFile.exists()) {
            tempFile.setContents((InputStream)bais, true, false, null);
        } else {
            tempFile.create((InputStream)bais, 4096, null);
        }
        bais.close();
    }

    public static IFile getTempFile(String projectName, String tempFileName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFile tempFile = project.getFile(tempFileName);
        return tempFile;
    }

    public static boolean isFileInProjectDir(String projectName, String fileName) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFile tempFile = project.getFile(fileName);
        return tempFile.exists();
    }

    public static String massageFileName(String name) {
        String retVal = null;
        int marker = name.indexOf(".");
        retVal = marker > -1 ? name.substring(0, marker) : name;
        retVal = retVal.replace('-', '_');
        return retVal;
    }

    public static String getTempFileName(String fileType, String fileName) {
        if (fileType.equals(sourceLanguages[0])) {
            fileName = (String)fileName + ".cpy";
        } else if (fileType.equals(sourceLanguages[1])) {
            fileName = (String)fileName + ".cbl";
        } else if (fileType.equals(sourceLanguages[2])) {
            fileName = (String)fileName + ".inc";
        } else if (fileType.equals(sourceLanguages[3])) {
            fileName = (String)fileName + ".pli";
        }
        return fileName;
    }

    public static String getShortFileName(String fullPath) {
        String shortFileName = null;
        int index = fullPath.lastIndexOf(File.separator);
        if (index > 0) {
            shortFileName = fullPath.substring(index + 1);
        }
        return shortFileName;
    }

    private static ByteArrayOutputStream dupFile(String fileName) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        File inFile = new File(fileName);
        FileInputStream in = new FileInputStream(inFile);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.flush();
        out.close();
        return out;
    }

    public static boolean isCOBOLFile(String fileName) {
        boolean retVal = false;
        if ((fileName = fileName.toLowerCase()).indexOf(".cbl") > 0 || fileName.indexOf(".cpy") > 0 || fileName.indexOf(".ccp") > 0 || fileName.indexOf(".cob") > 0) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isPLIFile(String fileName) {
        boolean retVal = false;
        if ((fileName = fileName.toLowerCase()).indexOf(".pli") > 0 || fileName.indexOf(".inc") > 0 || fileName.indexOf(".mac") > 0) {
            retVal = true;
        }
        return retVal;
    }

    public static String getFileType(String fileName) {
        String retVal = null;
        String lowerCaseFileName = fileName.toLowerCase();
        if (lowerCaseFileName.indexOf(".cbl") > 0) {
            retVal = COBOL_PROG;
        } else if (lowerCaseFileName.indexOf(".cpy") > 0) {
            retVal = COBOL_DS;
        } else if (lowerCaseFileName.indexOf(".pli") > 0) {
            retVal = PLI_PROG;
        } else if (lowerCaseFileName.indexOf(".inc") > 0) {
            retVal = PLI_DS;
        }
        return retVal;
    }

    public boolean isCOBOLOrPLIFile(String fileName) {
        return TranDataStructureController.isCOBOLFile(fileName) || TranDataStructureController.isPLIFile(fileName);
    }

    public static ArrayList<FieldType> handleCOBOLFile(String fileName, TranDataStructureParser parser, String projectName) throws IOException, ParseException, ImportParseException, ModelException {
        CobolImportHelper cobolImporter = CobolImportHelper.getInstance();
        cobolImporter.setProjectName(projectName);
        cobolImporter.setWrapperFileName(null);
        cobolImporter.setTempOrigFilePath(null);
        Resource cobolResource = cobolImporter.importCobol(fileName);
        if (cobolImporter.is01WrapperFileCreated()) {
            TranDataStructureController.remove01File(cobolResource.getURI().toFileString());
        }
        return parser.parseCobolCopyBookModel(cobolResource);
    }

    public static ArrayList<FieldType> handlePLIFile(String fileName, TranDataStructureParser parser, String projectName) throws IOException, ParseException, ImportParseException, ModelException {
        PliImportHelper pliImporter = PliImportHelper.getInstance();
        pliImporter.setProjectName(projectName);
        pliImporter.setWrapperFileName(null);
        pliImporter.setTempOrigFilePath(null);
        Resource pliResource = pliImporter.importPLI(fileName);
        if (pliImporter.is01WrapperFileCreated()) {
            TranDataStructureController.remove01File(pliResource.getURI().toFileString());
        }
        return parser.parsePliIncludeModel(pliResource);
    }

    private static void remove01File(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            try {
                file.delete();
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean isLocalImport() {
        return this.isLocalSource;
    }

    public void setLocalImport(boolean isLocalSource) {
        this.isLocalSource = isLocalSource;
    }

    public String getImportLanguage() {
        return this.importLanguage;
    }

    public void setImportLanguage(String importLanguage) {
        this.importLanguage = importLanguage;
    }

    public String getLastDirectory() {
        return this.lastDirectory;
    }

    public void setLastDirectory(String lastDirectory) {
        this.lastDirectory = lastDirectory;
    }

    public Vector<DataStructureSegmentAssociation> getAssociations() {
        return this.associations;
    }

    private Member getSelectedMember(String deName, String mName) {
        PartitionedDataSet pds = null;
        Member member = null;
        for (PartitionedDataSet de : this.pdsList) {
            if (!de.getPath().equals(deName)) continue;
            pds = de;
            break;
        }
        if (pds != null) {
            Vector<Member> mbrs = this.allPdsMembers.get(pds);
            for (Member m : mbrs) {
                String currMemberName = m.getName();
                if (!currMemberName.equals(mName)) continue;
                member = m;
                break;
            }
        }
        return member;
    }

    public void addPds(PartitionedDataSet pds) {
        this.pdsList.add(pds);
    }

    public void addToAllPdsMembers(PartitionedDataSet pds, Vector<Member> pds_members) {
        this.allPdsMembers.put(pds, pds_members);
    }

    public boolean pdsAlreadyInList(PartitionedDataSet pds) {
        boolean retVal = false;
        int i = 0;
        while (i < this.pdsList.size()) {
            if (pds.equals((Object)this.pdsList.get(i))) {
                retVal = true;
                break;
            }
            ++i;
        }
        return retVal;
    }

    private IFile createTempDataEntryFile(DataEntry de, String importLanguage, String fullPathName, String fileName) throws ConnectionException, CoreException, IOException {
        IFile tempFile = TranDataStructureController.getTempFile(this.projectName, TranDataStructureController.getTempFileName(importLanguage, TranDataStructureController.massageFileName(fileName)));
        if (tempFile != null) {
            ByteArrayOutputStream out = de.getZOSConnectable().getContents(de, IZOSConstants.FileType.ASCII);
            TranDataStructureController.putContentsInTempFile(tempFile, out);
            out.flush();
            out.close();
        }
        return tempFile;
    }

    public String readFileToString(File file) {
        logger.entering(this.getClass().getName(), "readFileToString(File)", new Object[0]);
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String currentLine = null;
            while ((currentLine = br.readLine()) != null) {
                sb.append("\n" + currentLine);
            }
        }
        catch (IOException e) {
            logger.throwing(this.getClass().getName(), "readFileToString(File)", (Throwable)e);
            logger.error((Throwable)e);
        }
        logger.exiting(this.getClass().getName(), "readFileToString(File)", new Object[0]);
        return sb.toString();
    }

    public ImportParseException getImportParseException() {
        return this.importParseException;
    }

    public void doFinishModel() {
        HashMap<CallSite, ArrayList<String>> aliasListMap = new HashMap<CallSite, ArrayList<String>>();
        for (DataStructureSegmentAssociation association : this.associations) {
            ArrayList<String> existingAliasList = (ArrayList<String>)aliasListMap.get(association.messageId.toString() + "." + association.segmentId.toString());
            if (existingAliasList == null) {
                existingAliasList = new ArrayList<String>();
            }
            FieldType importedDS = association.dataStructure;
            Properties nameChanges = new Properties();
            if (!association.replace) {
                this.getExistingAliases(existingAliasList, association.messageId, association.segmentId);
            }
            this.nameCollisionCheck(existingAliasList, importedDS, nameChanges);
            aliasListMap.put((CallSite)((Object)(association.messageId.toString() + "." + association.segmentId.toString())), existingAliasList);
        }
    }

    private void getExistingAliases(List<String> existingAliasList, BigInteger messageId, BigInteger segmentId) {
        List inMessages = this.transaction.getInputMessage();
        for (MessageType inMessage : inMessages) {
            if (!inMessage.getId().equals(messageId)) continue;
            SegmentType currSegment = (SegmentType)inMessage.getSegment().get(segmentId.intValue() - 1);
            this.getExistingAliasesFromSegment(existingAliasList, currSegment);
        }
        List outMessages = this.transaction.getOutputMessage();
        for (MessageType outMessage : outMessages) {
            if (!outMessage.getId().equals(messageId)) continue;
            SegmentType currSegment = (SegmentType)outMessage.getSegment().get(segmentId.intValue() - 1);
            this.getExistingAliasesFromSegment(existingAliasList, currSegment);
        }
    }

    private void getExistingAliasesFromSegment(List<String> existingAliasList, SegmentType segment) {
        List topLevelFields = segment.getField();
        for (FieldType topLevelField : topLevelFields) {
            this.addToAliasList(existingAliasList, topLevelField);
        }
    }

    private void addToAliasList(List<String> aliasList, FieldType field) {
        List childFields = field.getField();
        for (FieldType childField : childFields) {
            aliasList.add(childField.getName());
            this.addToAliasList(aliasList, childField);
        }
    }

    private void nameCollisionCheck(List<String> aliasList, FieldType field, Properties nameChanges) {
        List childFields = field.getField();
        for (FieldType childField : childFields) {
            Object aliasName;
            Object newDependsonName;
            String currDependson;
            Object newRedefinedFieldName;
            String currRedefines = childField.getRedefines();
            if (currRedefines != null && !currRedefines.isEmpty() && (newRedefinedFieldName = nameChanges.get(currRedefines)) != null) {
                childField.setRedefines((String)newRedefinedFieldName);
            }
            if ((currDependson = childField.getDependsOn()) != null && !currDependson.isEmpty() && (newDependsonName = nameChanges.get(currDependson)) != null) {
                childField.setDependsOn((String)newDependsonName);
            }
            if (aliasList.contains(aliasName = childField.getName())) {
                int nameIndex = this.lastIndexOfFieldInList(aliasList, (String)aliasName);
                String aliasListName = aliasList.get(nameIndex);
                if (aliasListName.contains("_NEW")) {
                    int newIndex = aliasListName.indexOf("_NEW");
                    String iterString = aliasListName.substring(newIndex + 4);
                    int iteration = 1;
                    if (!iterString.isEmpty()) {
                        iteration = Integer.parseInt(iterString);
                    }
                    aliasName = (String)aliasName + "_NEW" + String.valueOf(iteration + 1);
                } else {
                    aliasName = (String)aliasName + "_NEW";
                }
                nameChanges.put(childField.getName(), aliasName);
                childField.setName((String)aliasName);
            }
            aliasList.add((String)aliasName);
            this.nameCollisionCheck(aliasList, childField, nameChanges);
        }
    }

    private int lastIndexOfFieldInList(List<String> aliasList, String aliasName) {
        int lastIndex = 0;
        for (String currName : aliasList) {
            if (!currName.contains(aliasName)) continue;
            lastIndex = aliasList.indexOf(currName);
        }
        return lastIndex;
    }
}

