/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.transaction.controller.datastructure;

import com.ibm.ccl.pli.importer.ErrorMessageInfo;
import com.ibm.ccl.pli.importer.PliException;
import com.ibm.ccl.pli.importer.PliSourceResourceWin;
import com.ibm.im.ims.transaction.controller.datastructure.TranDataStructureController;
import com.ibm.im.ims.transaction.model.utilities.ParseException;
import com.ibm.im.ims.transaction.model.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class PliImportHelper {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static PliImportHelper fieldInstance;
    private String wrapperFilePath;
    private String tempOrigFilePath;
    private String projectName;

    public static synchronized PliImportHelper getInstance() {
        if (fieldInstance == null) {
            fieldInstance = new PliImportHelper();
        }
        return fieldInstance;
    }

    /*
     * Unable to fully structure code
     */
    public Resource importPLI(String fullPath) throws IOException, ParseException {
        block11: {
            fullProgram = false;
            fileType = TranDataStructureController.getFileType(fullPath);
            if (fileType.equals(TranDataStructureController.COBOL_PROG) || fileType.equals(TranDataStructureController.PLI_PROG)) {
                fullProgram = true;
            }
            rf = Resource.Factory.Registry.INSTANCE.getFactory(URI.createFileURI((String)fullPath));
            importerResource = rf.createResource(URI.createFileURI((String)fullPath));
            try {
                importerResource.load(null);
            }
            catch (PliException e) {
                errorMessages = "";
                wrapperFileNeeded = false;
                iter = e.getErrorMessagesVector().iterator();
                ** while (iter.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                currentErrorMessage = ((ErrorMessageInfo)iter.next()).getMessageString();
                isMissing01 = this.isMissing01Error(currentErrorMessage, fullPath);
                isMissingDeclare = this.isMissingDeclareError(currentErrorMessage);
                isMissingInclude = this.isMissingIncludeError(currentErrorMessage);
                if (!fullProgram && this.wrapperFilePath == null) {
                    errorMessages = (String)errorMessages + currentErrorMessage + "\n";
                    if (!isMissing01 && !isMissingDeclare && !isMissingInclude) continue;
                    wrapperFileNeeded = true;
                    this.create01WrapperFile(fullPath, isMissingDeclare);
                    importerResource = this.importPLI(this.wrapperFilePath);
                    break;
                }
                if (this.wrapperFilePath != null) {
                    Utility.deleteTempFile(this.getFile(this.wrapperFilePath));
                    if (this.tempOrigFilePath != null) {
                        Utility.deleteTempFile(this.getFile(this.tempOrigFilePath));
                    }
                }
                errorMessages = (String)errorMessages + currentErrorMessage + "\n";
                while (iter.hasNext()) {
                    currentErrorMessage = ((ErrorMessageInfo)iter.next()).getMessageString();
                    errorMessages = (String)errorMessages + currentErrorMessage + "\n";
                }
                throw new ParseException((String)errorMessages);
            }
lbl36:
            // 2 sources

            if (!wrapperFileNeeded) {
                throw new ParseException((String)errorMessages);
            }
            break block11;
            catch (Throwable t) {
                PliImportHelper.logger.error(t);
            }
        }
        if (importerResource instanceof PliSourceResourceWin && (psr = (PliSourceResourceWin)importerResource).getErrors().size() > 0) {
            throw new ParseException("PLIImporterHelper#importPLI() UnsupportedTypes: " + psr.getErrors().toString());
        }
        return importerResource;
    }

    private IFile getFile(String filePath) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(this.projectName);
        int index = filePath.lastIndexOf(File.separator) + 1;
        if (index == 0) {
            index = filePath.lastIndexOf("/") + 1;
        }
        String fileName = filePath.substring(index);
        return project.getFile((IPath)new Path(fileName));
    }

    private boolean isMissing01Error(String errorMessage, String fullPath) {
        boolean retVal = false;
        if (fullPath.indexOf(".pli") < 0 && errorMessage.indexOf("IBM1345I E Initial level number in a structure is not 1.") == 0) {
            retVal = true;
        }
        return retVal;
    }

    private boolean isMissingDeclareError(String errorMessage) {
        int index;
        boolean retVal = false;
        if (errorMessage.indexOf("IBM1352I E The statement element ") == 0 && (index = (errorMessage = errorMessage.substring(33)).indexOf(" ")) >= 0) {
            retVal = Utility.isStringNumeric(errorMessage.substring(0, index));
        }
        return retVal;
    }

    private boolean isMissingIncludeError(String errorMessage) {
        boolean retVal = false;
        if (errorMessage.indexOf("IBM1618I S Syntax of the %INCLUDE statement is incorrect.") == 0) {
            retVal = true;
        }
        return retVal;
    }

    private void create01WrapperFile(String fileName, boolean isDCLNeeded) throws ParseException {
        try {
            int index = fileName.lastIndexOf(File.separator) + 1;
            if (index == 0) {
                index = fileName.lastIndexOf("/") + 1;
            }
            String originalFileName = fileName.substring(index);
            IFile origIFile = null;
            if (!TranDataStructureController.isFileInProjectDir(this.projectName, originalFileName)) {
                File origFile = new File(fileName);
                FileInputStream fis = new FileInputStream(origFile);
                origIFile = TranDataStructureController.getTempFile(this.projectName, originalFileName);
                if (origIFile.exists()) {
                    origIFile.setContents((InputStream)fis, 1, null);
                } else {
                    origIFile.create((InputStream)fis, true, null);
                }
            }
            String newFileName = originalFileName.substring(0, originalFileName.length() - 4);
            Object declareString = "";
            if (isDCLNeeded) {
                declareString = " DCL 1 " + newFileName + ",";
            }
            String wrapper = " dummy: proc;\n" + (String)declareString + " %INCLUDE " + newFileName + ";\n end;\n";
            String wrapperFileName = "01_" + newFileName + ".pli";
            IFile wrapperFile = TranDataStructureController.getTempFile(this.projectName, wrapperFileName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(wrapper.getBytes());
            TranDataStructureController.putContentsInTempFile(wrapperFile, baos);
            this.wrapperFilePath = wrapperFile.getRawLocation().toOSString();
            if (origIFile != null) {
                this.tempOrigFilePath = origIFile.getRawLocation().toOSString();
            }
        }
        catch (Exception ex) {
            throw new ParseException(ex.getMessage());
        }
    }

    public boolean is01WrapperFileCreated() {
        return this.wrapperFilePath != null;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setWrapperFileName(String wrapperFilePath) {
        this.wrapperFilePath = wrapperFilePath;
    }

    public void setTempOrigFilePath(String tempOrigFilePath) {
        this.tempOrigFilePath = tempOrigFilePath;
    }
}

