/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.transaction.controller.datastructure;

import com.ibm.etools.cobol.importer.CobolException;
import com.ibm.etools.cobol.importer.CobolSourceResource;
import com.ibm.etools.cobol.importer.ErrorMessageInfo;
import com.ibm.im.ims.transaction.controller.datastructure.TranDataStructureController;
import com.ibm.im.ims.transaction.model.utilities.ParseException;
import com.ibm.im.ims.transaction.model.utilities.Utility;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class CobolImportHelper {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static CobolImportHelper fieldInstance;
    private String wrapperFilePath;
    private String tempOrigFilePath;
    private String projectName;

    public static synchronized CobolImportHelper getInstance() {
        if (fieldInstance == null) {
            fieldInstance = new CobolImportHelper();
        }
        return fieldInstance;
    }

    /*
     * Unable to fully structure code
     */
    public Resource importCobol(String fullPath) throws IOException, ParseException {
        block10: {
            fullProgram = false;
            fileType = TranDataStructureController.getFileType(fullPath);
            if (fileType.equals(TranDataStructureController.COBOL_PROG) || fileType.equals(TranDataStructureController.PLI_PROG)) {
                fullProgram = true;
            }
            rf = Resource.Factory.Registry.INSTANCE.getFactory(URI.createFileURI((String)fullPath));
            importerResource = rf.createResource(URI.createFileURI((String)fullPath));
            try {
                importerResource.load(null);
                break block10;
            }
            catch (CobolException e) {
                errorMessages = "";
                wrapperFileNeeded = false;
                iter = e.getErrorMessagesVector().iterator();
                ** while (iter.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                currentErrorMessage = ((ErrorMessageInfo)iter.next()).getMessageString();
                if (!fullProgram && this.wrapperFilePath == null) {
                    errorMessages = (String)errorMessages + currentErrorMessage + "\n";
                    if (currentErrorMessage.indexOf("IGYDS1176-E") < 0) continue;
                    wrapperFileNeeded = true;
                    this.create01WrapperFile(fullPath);
                    importerResource = this.importCobol(this.wrapperFilePath);
                    break;
                }
                if (this.wrapperFilePath != null) {
                    Utility.deleteTempFile(this.getFile(this.wrapperFilePath));
                    if (this.tempOrigFilePath != null) {
                        Utility.deleteTempFile(this.getFile(this.tempOrigFilePath));
                    }
                }
                errorMessages = (String)errorMessages + currentErrorMessage + "\n";
                while (iter.hasNext()) {
                    currentErrorMessage = ((ErrorMessageInfo)iter.next()).getMessageString();
                    errorMessages = (String)errorMessages + currentErrorMessage + "\n";
                }
                throw new ParseException((String)errorMessages);
            }
lbl33:
            // 2 sources

            if (!wrapperFileNeeded) {
                throw new ParseException((String)errorMessages);
            }
        }
        if (importerResource instanceof CobolSourceResource && (csr = (CobolSourceResource)importerResource).getErrors().size() > 0) {
            throw new ParseException("CobolImporterHelper#importCobol() UnsupportedTypes: " + csr.getErrors().toString());
        }
        return importerResource;
    }

    private IFile getFile(String filePath) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(this.projectName);
        int index = filePath.lastIndexOf(File.separator) + 1;
        if (index == 0) {
            index = filePath.lastIndexOf("/") + 1;
        }
        String fileName = filePath.substring(index);
        return project.getFile((IPath)new Path(fileName));
    }

    private void create01WrapperFile(String fileName) throws ParseException {
        try {
            int index = fileName.lastIndexOf(File.separator) + 1;
            if (index == 0) {
                index = fileName.lastIndexOf("/") + 1;
            }
            String originalFileName = fileName.substring(index);
            IFile origIFile = null;
            if (!TranDataStructureController.isFileInProjectDir(this.projectName, originalFileName)) {
                File origFile = new File(fileName);
                FileInputStream fis = new FileInputStream(origFile);
                origIFile = TranDataStructureController.getTempFile(this.projectName, originalFileName);
                if (origIFile.exists()) {
                    origIFile.setContents((InputStream)fis, 1, null);
                } else {
                    origIFile.create((InputStream)fis, true, null);
                }
            }
            String newFileName = originalFileName.substring(0, originalFileName.length() - 4);
            String addTopLevel = "         01 " + newFileName + ".\n           COPY " + newFileName + ".\n";
            String wrapperFileName = "01_" + newFileName + ".cpy";
            IFile wrapperFile = TranDataStructureController.getTempFile(this.projectName, wrapperFileName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(addTopLevel.getBytes());
            TranDataStructureController.putContentsInTempFile(wrapperFile, baos);
            this.wrapperFilePath = wrapperFile.getRawLocation().toOSString();
            if (origIFile != null) {
                this.tempOrigFilePath = origIFile.getRawLocation().toOSString();
            }
        }
        catch (Exception ex) {
            throw new ParseException(ex.getMessage());
        }
    }

    public boolean is01WrapperFileCreated() {
        return this.wrapperFilePath != null;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setWrapperFileName(String wrapperFilePath) {
        this.wrapperFilePath = wrapperFilePath;
    }

    public void setTempOrigFilePath(String tempOrigFilePath) {
        this.tempOrigFilePath = tempOrigFilePath;
    }
}

