/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.result;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.im.ims.workbench.imsdb.connections.exceptions.ImsDbConnectionException;
import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.ims.datatools.sqltools.core.DatabaseIdentifier;
import com.ibm.ims.datatools.sqltools.core.SQLToolsFacade;
import com.ibm.ims.datatools.sqltools.editor.core.connection.IConnectionTracker;
import com.ibm.ims.datatools.sqltools.editor.core.result.ResultSupportRunnable;
import com.ibm.ims.datatools.sqltools.result.OperationCommand;
import com.ibm.ims.datatools.sqltools.sql.util.SQLUtil;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;

public class SimpleSQLResultRunnable
extends ResultSupportRunnable {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    protected static final int SQL_SHORT_DESC_LENGTH = 40;
    protected IConnection _connection;
    protected String _sql;
    protected boolean _closeCon;
    protected int _connid;
    protected IConnectionTracker _tracker;
    protected boolean _promptVar = false;
    protected ILaunchConfiguration _configuration;

    public SimpleSQLResultRunnable(IConnection con, String sql, boolean closeCon, IConnectionTracker tracker, IProgressMonitor parentMonitor, DatabaseIdentifier databaseIdentifier, ILaunchConfiguration configuration) {
        super(SQLUtil.describeSQL((String)sql, (int)40), parentMonitor, databaseIdentifier);
        this._connection = con;
        this._sql = sql;
        this._closeCon = closeCon;
        this._tracker = tracker;
        this._configuration = configuration;
        this._connid = SQLToolsFacade.getConnectionId((DatabaseIdentifier)databaseIdentifier, null);
    }

    protected IConnection getConnection() {
        if (this._databaseIdentifier != null && this._databaseIdentifier.getProfileName() != null) {
            this._connection = ImsDbUtils.getConnectionById((String)this._databaseIdentifier.getProfileName(), (boolean)true);
        }
        return this._connection;
    }

    protected void setConnection(IConnection conn) {
        this._connection = conn;
    }

    protected OperationCommand createDefaultOperationCommand() {
        return new OperationCommand(this.getActionType(), this._sql, this.getConsumerName(), this._databaseIdentifier.getProfileName(), this._databaseIdentifier.getDBname());
    }

    protected Statement prepareStatement(IConnection connection) throws Exception {
        Statement stmt = null;
        if (connection instanceof IImsDbConnection) {
            IImsDbConnection imsConn = (IImsDbConnection)connection;
            Connection sqlConn = imsConn.getSqlConnection();
            stmt = sqlConn.createStatement();
        }
        return stmt;
    }

    protected boolean runStatement(Statement stmt) throws Exception {
        return stmt.execute(this._sql);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus retVal;
        block16: {
            retVal = Status.OK_STATUS;
            IConnection connection = this.getConnection();
            if (connection instanceof IImsDbConnection) {
                IImsDbConnection imsConn = (IImsDbConnection)connection;
                boolean lockAcquired = false;
                try {
                    try {
                        lockAcquired = imsConn.acquireLock();
                        if (!lockAcquired) break block16;
                        try {
                            imsConn.ping(false, true);
                        }
                        catch (ImsDbConnectionException e) {
                            this._connectionError = e.getCause() instanceof SQLException ? e.getCause() : e;
                        }
                        retVal = super.run(monitor);
                    }
                    catch (Throwable t) {
                        logger.error(t);
                        try {
                            if (lockAcquired) {
                                imsConn.releaseLock();
                            }
                        }
                        catch (Throwable t2) {
                            logger.error(t2);
                        }
                    }
                }
                finally {
                    try {
                        if (lockAcquired) {
                            imsConn.releaseLock();
                        }
                    }
                    catch (Throwable t) {
                        logger.error(t);
                    }
                }
            }
        }
        return retVal;
    }

    protected void handleEnd(Connection connection, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public ILaunchConfiguration getConfiguration() {
        return this._configuration;
    }
}

