/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.utils;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class SQLWordFinder {
    public static IRegion findWord(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        start = SQLWordFinder.getWordStartOffset(document.get(), offset);
        end = SQLWordFinder.getWordEndOffset(document.get(), offset);
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public static int getWordStartOffset(String text, int startIndex) {
        if (text == null || startIndex >= text.length()) {
            return -1;
        }
        int offset = startIndex;
        while (offset >= 0) {
            char c = text.charAt(offset);
            if (SQLWordFinder.isWhiteSpace(c)) {
                return offset;
            }
            --offset;
        }
        return -1;
    }

    public static int getWordEndOffset(String text, int startIndex) {
        int pos = startIndex;
        int length = text.length();
        while (pos < length) {
            char c = text.charAt(pos);
            if (SQLWordFinder.isWhiteSpace(c)) break;
            ++pos;
        }
        return pos;
    }

    public static boolean isWhiteSpace(char c) {
        return Character.isWhitespace(c) || c == '(' || c == ')' || c == ',' || c == ';' || c == '\n' || c == '\r' || c == '=' || c == '>' || c == '<' || c == '+' || c == '-' || c == '*' || c == '/' || c == '%' || c == '^' || c == '|' || c == '&';
    }
}

