/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.utils;

import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.ims.datatools.sqltools.core.DatabaseIdentifier;
import com.ibm.ims.datatools.sqltools.core.profile.ProfileUtil;
import com.ibm.ims.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SQLDBUtils {
    protected static int PROPOSAL_TYPE_INVALID = -1;
    protected static int PROPOSAL_TYPE_TABLES = 1;
    protected static int PROPOSAL_TYPE_COLUMNS = 2;

    public static ResultSet executeSQL(Connection conn, String sql) throws SQLException {
        ResultSet result = null;
        Statement statement = null;
        try {
            statement = conn.createStatement();
            result = statement.executeQuery(sql);
        }
        catch (SQLException ex) {
            if (statement != null) {
                statement.close();
            }
            throw ex;
        }
        return result;
    }

    public static boolean isConnected(ISQLEditorConnectionInfo connInfo) {
        boolean connected = false;
        if (connInfo != null && connInfo.getDatabase() != null) {
            connected = true;
        }
        return connected;
    }

    public static boolean isDefaultUser(ISQLEditorConnectionInfo connInfo) {
        String username = null;
        String password = null;
        if (connInfo != null) {
            ConnectionProfile profile = connInfo.getConnectionProfile();
            CredentialsConfiguration credentials = ImsDbUtils.getCredentialsConfiguration((ConnectionProfile)profile);
            username = credentials.getUserID();
            password = String.valueOf(credentials.getPasswordAsCharArray());
        }
        return username != null && username.length() == 0 && password != null && password.length() == 0;
    }

    public static boolean isPromptNeeded(ISQLEditorConnectionInfo connInfo) {
        String username = null;
        String password = null;
        if (connInfo != null) {
            ConnectionProfile profile = connInfo.getConnectionProfile();
            CredentialsConfiguration credentials = ImsDbUtils.getCredentialsConfiguration((ConnectionProfile)profile);
            username = credentials.getUserID();
            password = String.valueOf(credentials.getPasswordAsCharArray());
        }
        return (username == null || username.length() == 0 || password == null || password.length() == 0) && !SQLDBUtils.isDefaultUser(connInfo);
    }

    public static String getDefaultSchemaName(ISQLEditorConnectionInfo connInfo) {
        DatabaseIdentifier dbid = new DatabaseIdentifier(connInfo.getConnectionProfileId());
        String defaultSchemaName = ProfileUtil.getProfileUserName((DatabaseIdentifier)dbid, (boolean)false);
        return defaultSchemaName;
    }
}

