/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.utils;

import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.utils.Messages;
import com.ibm.ims.datatools.sqltools.sqleditor.preferences.SyntaxItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SQLColorProvider {
    public static final RGB SQL_COMMENT_COLOR = new RGB(64, 128, 128);
    public static final RGB SQL_MULTILINE_COMMENT_COLOR = new RGB(64, 128, 128);
    public static final RGB SQL_QUOTED_LITERAL_COLOR = new RGB(0, 0, 255);
    public static final RGB SQL_KEYWORD_COLOR = new RGB(127, 0, 85);
    public static final RGB SQL_TYPE_COLOR = new RGB(64, 0, 200);
    public static final RGB SQL_IDENTIFIER_COLOR = new RGB(0, 0, 128);
    public static final RGB SQL_DELIMITED_IDENTIFIER_COLOR = new RGB(0, 128, 0);
    public static final RGB SQL_DEFAULT_COLOR = new RGB(0, 0, 0);
    public static final RGB SQL_HC_COMMENT_COLOR = new RGB(255, 0, 0);
    public static final RGB SQL_HC_MULTILINE_COMMENT_COLOR = new RGB(0, 0, 255);
    public static final RGB SQL_HC_QUOTED_LITERAL_COLOR = new RGB(0, 255, 0);
    public static final RGB SQL_HC_KEYWORD_COLOR = new RGB(255, 255, 0);
    public static final RGB SQL_HC_TYPE_COLOR = new RGB(64, 0, 200);
    public static final RGB SQL_HC_IDENTIFIER_COLOR = new RGB(0, 0, 255);
    public static final RGB SQL_HC_DELIMITED_IDENTIFIER_COLOR = new RGB(255, 0, 0);
    public static final RGB SQL_HC_DEFAULT_COLOR = new RGB(255, 255, 255);
    public static final String SQL_COMMENT = Messages.SyntaxColoring_Comment;
    public static final String SQL_MULTILINE_COMMENT = Messages.SyntaxColoring_MultilineComment;
    public static final String SQL_QUOTED_LITERAL = Messages.SyntaxColoring_QuotedLiteral;
    public static final String SQL_DELIMITED_IDENTIFIER = Messages.SyntaxColoring_DelimitedIdentifier;
    public static final String SQL_KEYWORD = Messages.SyntaxColoring_Keyword;
    public static final String SQL_TYPE = Messages.SyntaxColoring_Type;
    public static final String SQL_IDENTIFIER = Messages.SyntaxColoring_Identifier;
    public static final String SQL_DEFAULT = Messages.SyntaxColoring_Default;
    protected Map fColorTable = new HashMap(10);

    public void dispose() {
        Iterator e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            ((Color)e.next()).dispose();
        }
    }

    public Color getColor(RGB rgb) {
        Color color = (Color)this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public IToken createToken(String syntax) {
        TextAttribute ta = this.createTextAttribute(syntax);
        if (ta != null) {
            return new Token((Object)ta);
        }
        return null;
    }

    public TextAttribute createTextAttribute(String syntax) {
        SyntaxItem si;
        IPreferenceStore store = SQLEditorPlugin.getDefault().getPreferenceStore();
        if (!store.getString(syntax).equals("") && (si = new SyntaxItem(store.getString(syntax))) != null) {
            int style = 0;
            if (si.isBold()) {
                style |= 1;
            }
            if (si.isItalic()) {
                style |= 2;
            }
            if (si.isStrikethrough()) {
                style |= 0x20000000;
            }
            if (si.isUnderline()) {
                style |= 0x40000000;
            }
            return new TextAttribute(this.getColor(si.getColor()), null, style);
        }
        if (syntax.equals(SQL_COMMENT)) {
            return new TextAttribute(this.getColor(SQL_COMMENT_COLOR));
        }
        if (syntax.equals(SQL_MULTILINE_COMMENT)) {
            return new TextAttribute(this.getColor(SQL_MULTILINE_COMMENT_COLOR));
        }
        if (syntax.equals(SQL_QUOTED_LITERAL)) {
            return new TextAttribute(this.getColor(SQL_QUOTED_LITERAL_COLOR));
        }
        if (syntax.equals(SQL_KEYWORD)) {
            return new TextAttribute(this.getColor(SQL_KEYWORD_COLOR), null, 1);
        }
        if (syntax.equals(SQL_TYPE)) {
            return new TextAttribute(this.getColor(SQL_TYPE_COLOR), null, 1);
        }
        if (syntax.equals(SQL_IDENTIFIER)) {
            return new TextAttribute(this.getColor(SQL_IDENTIFIER_COLOR));
        }
        if (syntax.equals(SQL_DELIMITED_IDENTIFIER)) {
            return new TextAttribute(this.getColor(SQL_DELIMITED_IDENTIFIER_COLOR));
        }
        return new TextAttribute(this.getColor(SQL_DEFAULT_COLOR));
    }
}

