/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.sql;

import com.ibm.im.ims.workbench.imsdb.connections.types.IImsDbConnection;
import com.ibm.im.ims.workbench.imsdb.connections.utils.ImsDbUtils;
import com.ibm.ims.datatools.modelbase.sql.constraints.Index;
import com.ibm.ims.datatools.modelbase.sql.routines.Function;
import com.ibm.ims.datatools.modelbase.sql.routines.Procedure;
import com.ibm.ims.datatools.modelbase.sql.schema.Catalog;
import com.ibm.ims.datatools.modelbase.sql.schema.Database;
import com.ibm.ims.datatools.modelbase.sql.schema.Event;
import com.ibm.ims.datatools.modelbase.sql.schema.Schema;
import com.ibm.ims.datatools.modelbase.sql.tables.Column;
import com.ibm.ims.datatools.modelbase.sql.tables.Table;
import com.ibm.ims.datatools.modelbase.sql.tables.Trigger;
import com.ibm.ims.datatools.modelbase.sql.tables.ViewTable;
import com.ibm.ims.datatools.sqltools.core.DatabaseIdentifier;
import com.ibm.ims.datatools.sqltools.editor.contentassist.ISQLDBProposalsService;
import com.ibm.ims.datatools.sqltools.editor.contentassist.SQLDBProposalsRequest;
import com.ibm.ims.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import com.ibm.ims.datatools.sqltools.sql.reference.ITable;
import com.ibm.ims.datatools.sqltools.sql.util.ModelUtil;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.sql.SQLDBProposal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class SQLDBProposalsService
implements ISQLDBProposalsService {
    private ISQLEditorConnectionInfo fConnInfo;
    private List fDBProposalList;
    private SQLDBProposalsRequest fRequest;

    public SQLDBProposalsService(ISQLEditorConnectionInfo connInfo) {
        this.fConnInfo = connInfo;
        this.fDBProposalList = new ArrayList();
        this.fRequest = null;
    }

    public ISQLEditorConnectionInfo getConnectionInfo() {
        return this.fConnInfo;
    }

    public List getDBProposals() {
        return this.fDBProposalList;
    }

    protected Schema getSchema(Database database, String catalogName, String schemaName) {
        EList schemaList = ModelUtil.getSchemas((Database)database, (String)catalogName);
        Schema schema = null;
        int i = 0;
        while (i < schemaList.size()) {
            Schema thisSchema = (Schema)schemaList.get(i);
            if (thisSchema.getName().equalsIgnoreCase(schemaName)) {
                schema = thisSchema;
                break;
            }
            ++i;
        }
        return schema;
    }

    protected void loadSchemas(Database database, String catalogName, boolean clear) {
        if (clear) {
            this.fDBProposalList.clear();
        }
        EList schemaList = ModelUtil.getSchemas((Database)database, (String)catalogName);
        int i = 0;
        while (i < schemaList.size()) {
            Schema thisSchema = (Schema)schemaList.get(i);
            this.fDBProposalList.add(new SQLDBProposal((EObject)thisSchema));
            ++i;
        }
    }

    protected void loadCatalogs(Database database, boolean clear) {
        if (clear) {
            this.fDBProposalList.clear();
        }
        EList catalogsList = database.getCatalogs();
        int i = 0;
        while (i < catalogsList.size()) {
            Catalog thisCatalog = (Catalog)catalogsList.get(i);
            this.fDBProposalList.add(new SQLDBProposal((EObject)thisCatalog));
            ++i;
        }
    }

    public SQLDBProposalsRequest getSQLDBProposalRequest() {
        return this.fRequest;
    }

    protected void loadColumns(Table table) {
        this.loadColumns(table, true, table.getName());
    }

    protected void loadColumns(Table table, boolean clear, String alias) {
        if (table != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList columns = table.getColumns();
            int j = 0;
            while (j < columns.size()) {
                Column column = (Column)columns.get(j);
                this.fDBProposalList.add(new SQLDBProposal((EObject)column, alias));
                ++j;
            }
        }
    }

    protected void loadDBProposals(SQLDBProposalsRequest request) {
        block23: {
            this.fDBProposalList.clear();
            Database database = this.fConnInfo.getDatabase();
            this.fConnInfo.getDefaultSchemaName();
            if (database == null) break block23;
            int proposalsType = request.getScope();
            if ((proposalsType & 2) == 2) {
                this.loadCatalogs(database, false);
                return;
            }
            if ((proposalsType & 4) == 4) {
                this.loadSchemas(database, request.getDatabase(), false);
                return;
            }
            if ((proposalsType & 0x800) == 2048) {
                this.loadEvents(database, false);
                return;
            }
            Schema schema = this.getSchema(database, this.fConnInfo.getDatabaseName(), request.getSchema());
            if (request.getDatabase() != null) {
                schema = this.getSchema(database, request.getDatabase(), request.getSchema());
            }
            if ((proposalsType & 8) == 8) {
                this.loadTables(schema, false);
                this.createAliasTableProposals(request, false);
            }
            if ((proposalsType & 0x200) == 512) {
                this.loadFunctions(schema, false);
            }
            if ((proposalsType & 0x100) == 256) {
                this.loadProcedures(schema, false);
            }
            if ((proposalsType & 0x400) == 1024) {
                this.loadTriggers(schema, false);
            }
            if ((proposalsType & 0x10) == 16) {
                this.loadViews(schema, false);
            }
            if ((proposalsType & 0x40) == 64) {
                this.loadIndexes(schema, false);
            }
            if ((proposalsType & 0x8000) == 32768) {
                this.loadSegments(schema, false);
            }
            if ((proposalsType & 0x20) == 32 || (proposalsType & 0x4000) == 16384) {
                String realTableName = request.getRealTable();
                if (realTableName != null && realTableName.trim().length() > 0) {
                    Table table = null;
                    if (schema == null) {
                        return;
                    }
                    EList tables = schema.getTables();
                    int i = 0;
                    while (i < tables.size()) {
                        table = (Table)tables.get(i);
                        if (table.getName().equals(realTableName)) {
                            this.loadColumns(table, false, request.getTable());
                            break;
                        }
                        ++i;
                    }
                } else {
                    List ctxTables = request.getContextTables();
                    if (!ctxTables.isEmpty()) {
                        block1: for (ITable ref : ctxTables) {
                            Schema ctxSchema = schema;
                            if (ref.getOwner() != null) {
                                ctxSchema = this.getSchema(database, this.fConnInfo.getDatabaseName(), ref.getOwner());
                                if (ctxSchema == null) continue;
                                EList tables = ctxSchema.getTables();
                                int i = 0;
                                while (i < tables.size()) {
                                    Table table = (Table)tables.get(i);
                                    if (table.getName().equals(ref.getName())) {
                                        this.loadColumns(table, false, ref.getAliasName());
                                        continue block1;
                                    }
                                    ++i;
                                }
                                continue;
                            }
                            DatabaseIdentifier databaseIdentifier = new DatabaseIdentifier(this.fConnInfo.getConnectionProfileId(), this.fConnInfo.getDatabaseName());
                            Table table = ModelUtil.findTableObject((DatabaseIdentifier)databaseIdentifier, (String)this.fConnInfo.getDatabaseName(), (String)ctxSchema.getName(), (String)ref.getName(), (boolean)false, (boolean)true, (boolean)false);
                            if (table == null) {
                                table = ModelUtil.findTableInAllSchemas((DatabaseIdentifier)databaseIdentifier, (String)this.fConnInfo.getDatabaseName(), (String)ref.getName(), (boolean)true, (boolean)false);
                            }
                            if (table == null) continue;
                            this.loadColumns(table, false, ref.getAliasName());
                        }
                    }
                }
            }
        }
    }

    protected void loadTables(Schema schema) {
        this.loadTables(schema, true);
    }

    protected void loadTables(Schema schema, boolean clear) {
        if (schema != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList tables = schema.getTables();
            int i = 0;
            while (i < tables.size()) {
                Table table = (Table)tables.get(i);
                this.fDBProposalList.add(new SQLDBProposal((EObject)table));
                ++i;
            }
        }
    }

    protected void createAliasTableProposals(SQLDBProposalsRequest request, boolean clear) {
        if (clear) {
            this.fDBProposalList.clear();
        }
        List tables = request.getContextTables();
        int i = 0;
        while (i < tables.size()) {
            ITable table = (ITable)tables.get(i);
            this.fDBProposalList.add(new SQLDBProposal(table.getAliasName()));
            ++i;
        }
    }

    protected void loadProcedures(Schema schema, boolean clear) {
        if (schema != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList procedures = schema.getProcedures();
            int i = 0;
            while (i < procedures.size()) {
                Procedure proc = (Procedure)procedures.get(i);
                this.fDBProposalList.add(new SQLDBProposal((EObject)proc));
                ++i;
            }
        }
    }

    protected void loadFunctions(Schema schema, boolean clear) {
        if (schema != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList funcs = schema.getUDFs();
            int i = 0;
            while (i < funcs.size()) {
                Function func = (Function)funcs.get(i);
                this.fDBProposalList.add(new SQLDBProposal((EObject)func));
                ++i;
            }
        }
    }

    protected void loadTriggers(Schema schema, boolean clear) {
        if (schema != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList triggers = schema.getTriggers();
            int i = 0;
            while (i < triggers.size()) {
                Trigger trigger = (Trigger)triggers.get(i);
                this.fDBProposalList.add(new SQLDBProposal((EObject)trigger));
                ++i;
            }
        }
    }

    protected void loadEvents(Database database, boolean clear) {
        if (database != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList events = database.getEvents();
            int i = 0;
            while (i < events.size()) {
                Event event = (Event)events.get(i);
                this.fDBProposalList.add(new SQLDBProposal((EObject)event));
                ++i;
            }
        }
    }

    public boolean populate(SQLDBProposalsRequest request) {
        boolean loaded = false;
        if (request != null) {
            boolean connected = false;
            ISQLEditorConnectionInfo connInfo = this.getConnectionInfo();
            IImsDbConnection connection = ImsDbUtils.getConnectionById((String)connInfo.getConnectionProfileId(), (boolean)true);
            if (connection != null) {
                connected = true;
            }
            if (connected) {
                loaded = true;
                this.loadDBProposals(request);
            }
        }
        return loaded;
    }

    protected void loadViews(Schema schema, boolean clear) {
        if (schema != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList tables = schema.getTables();
            int i = 0;
            while (i < tables.size()) {
                Table table = (Table)tables.get(i);
                if (table instanceof ViewTable) {
                    this.fDBProposalList.add(new SQLDBProposal((EObject)table));
                }
                ++i;
            }
        }
    }

    protected void loadIndexes(Schema schema, boolean clear) {
        if (schema != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList indexes = schema.getIndices();
            int i = 0;
            while (i < indexes.size()) {
                Index index = (Index)indexes.get(i);
                this.fDBProposalList.add(new SQLDBProposal((EObject)index));
                ++i;
            }
        }
    }

    protected void loadSegments(Schema schema, boolean clear) {
    }

    public ISQLEditorConnectionInfo getSQLEditorConnectionInfo() {
        return this.fConnInfo;
    }

    public void setSQLEditorConnectionInfo(ISQLEditorConnectionInfo connectionInfo) {
        this.fConnInfo = connectionInfo;
    }
}

