/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.sql;

import com.ibm.ims.datatools.sqltools.editor.contentassist.ISQLDBProposalsService;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.sql.ISQLCompletionEngine;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.sql.SQLCompletionProposalComparator;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.sql.SQLParserCompletionEngine;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.sql.SQLValidator;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Point;

public class SQLCompletionProcessor
implements IContentAssistProcessor {
    protected IContextInformationValidator fValidator = new SQLValidator();
    private ISQLCompletionEngine fParserCompletionEngine;
    private Comparator fComparator = new SQLCompletionProposalComparator();
    private ISQLDBProposalsService fDBProposalsService = null;

    public SQLCompletionProcessor() {
        this.fParserCompletionEngine = new SQLParserCompletionEngine();
        this.fComparator = new SQLCompletionProposalComparator();
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator = order ? new SQLCompletionProposalComparator() : null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ICompletionProposal[] result = null;
        try {
            IDocument doc = viewer.getDocument();
            ITypedRegion partition = null;
            partition = documentOffset > 0 ? (doc.getChar(documentOffset - 1) == ';' ? viewer.getDocument().getPartition(documentOffset) : viewer.getDocument().getPartition(documentOffset - 1)) : viewer.getDocument().getPartition(documentOffset);
            Point selection = viewer.getSelectedRange();
            result = this.fParserCompletionEngine.computeProposals(doc, partition, documentOffset, selection);
        }
        catch (BadLocationException badLocationException) {}
        if (result != null) {
            result = this.order(result);
        }
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        IContextInformation[] result = null;
        try {
            IDocument doc = viewer.getDocument();
            ITypedRegion partition = null;
            partition = documentOffset > 0 ? (doc.getChar(documentOffset - 1) == ';' ? viewer.getDocument().getPartition(documentOffset) : viewer.getDocument().getPartition(documentOffset - 1)) : viewer.getDocument().getPartition(documentOffset);
            Point selection = viewer.getSelectedRange();
            result = this.fParserCompletionEngine.computeContextInformation(doc, partition, documentOffset, selection);
        }
        catch (BadLocationException badLocationException) {}
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        IPreferenceStore store = SQLEditorPlugin.getDefault().getPreferenceStore();
        String autoChars = store.getString("auto.activation.trigger");
        return autoChars.toCharArray();
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'#'};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public ISQLDBProposalsService getDBProposalService() {
        return this.fDBProposalsService;
    }

    public String getErrorMessage() {
        return null;
    }

    public void setDBProposalsService(ISQLDBProposalsService dbProposalsService) {
        this.fDBProposalsService = dbProposalsService;
        ((SQLParserCompletionEngine)this.fParserCompletionEngine).setDBProposalsService(this.fDBProposalsService);
    }

    private ICompletionProposal[] order(ICompletionProposal[] proposals) {
        if (this.fComparator != null) {
            Arrays.sort(proposals, this.fComparator);
        }
        return proposals;
    }
}

