/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.sql;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.ims.datatools.sqltools.editor.contentassist.ISQLDBProposalsService;
import com.ibm.ims.datatools.sqltools.editor.contentassist.SQLDBProposalsRequest;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.sql.ISQLCompletionEngine;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.sql.SQLCompletionProposal;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.sql.SQLCompletionProposalFactory;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.sql.SQLDBProposal;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class SQLCompletionEngine
implements ISQLCompletionEngine {
    private SQLCompletionProposalFactory fProposalFactory = new SQLCompletionProposalFactory();
    private ISQLDBProposalsService fDBProposalsService = null;

    @Override
    public ICompletionProposal[] computeProposals(IDocument doc, ITypedRegion partition, int documentOffset, Point selection) {
        ICompletionProposal[] result = null;
        if (doc != null && partition != null && documentOffset >= 0) {
            List proposalList = null;
            Object replacementStr = null;
            String displayStr = null;
            String sortingString = null;
            int offset = this.getPartitionOffset(doc, partition, documentOffset, partition.getOffset());
            try {
                sortingString = doc.get(offset, documentOffset - offset);
                char docOffsetChar = doc.getChar(documentOffset - 1);
                if (docOffsetChar == '.') {
                    StringTokenizer tokenizer = new StringTokenizer(sortingString, ".");
                    ArrayList<String> tokenList = new ArrayList<String>();
                    while (tokenizer.hasMoreTokens()) {
                        tokenList.add(tokenizer.nextToken());
                    }
                    SQLDBProposalsRequest request = new SQLDBProposalsRequest(sortingString, 1, null, null);
                    proposalList = this.fProposalFactory.getDBObjectProposals(request);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposalList, sortingString, false);
            result = new ICompletionProposal[pList.size()];
            int resultIdx = 0;
            int i = 0;
            while (i < pList.size()) {
                displayStr = pList.get(i).toString();
                replacementStr = displayStr;
                Image image = null;
                String additionalInfo = null;
                int relevance = 2;
                if (pList.get(i) instanceof SQLDBProposal) {
                    SQLDBProposal dbProposal = (SQLDBProposal)pList.get(i);
                    String parentNameUC = dbProposal.getParentName().toUpperCase();
                    String sortingStringUC = sortingString.toUpperCase();
                    StringTokenizer strTokens = new StringTokenizer(parentNameUC, ".");
                    if (strTokens.countTokens() > 1 && parentNameUC.startsWith(sortingStringUC)) {
                        String preceedingNames = parentNameUC.replaceFirst(sortingStringUC, "");
                        replacementStr = preceedingNames + "." + dbProposal.toString();
                    }
                    image = ((SQLDBProposal)pList.get(i)).getImage();
                    additionalInfo = ((SQLDBProposal)pList.get(i)).getParentName() + "." + ((SQLDBProposal)pList.get(i)).getName();
                    relevance = this.getRelevance(dbProposal.getType());
                }
                if (pList.size() <= proposalList.size() && replacementStr != null && documentOffset >= 0) {
                    result[resultIdx] = new SQLCompletionProposal((String)replacementStr, documentOffset, 0, ((String)replacementStr).length(), image, displayStr, null, additionalInfo, relevance);
                    ++resultIdx;
                }
                ++i;
            }
        }
        return result;
    }

    private int getRelevance(int dbObjectType) {
        switch (dbObjectType) {
            case 1: {
                return 2;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 9;
            }
        }
        return 2;
    }

    public int getPartitionOffset(IDocument doc, ITypedRegion partition, int documentOffset, int offset) {
        boolean loop = true;
        int offset1 = documentOffset - 1;
        try {
            while (loop && offset <= offset1) {
                switch (doc.getChar(offset1)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        loop = false;
                        break;
                    }
                    default: {
                        --offset1;
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        offset = offset1 + 1;
        return offset;
    }

    public int getPartitionOffset(IDocument doc, ITypedRegion partition, int documentOffset, String leadingString, int position) {
        int offset = partition.getOffset() + leadingString.length();
        if (documentOffset <= offset) {
            return offset;
        }
        switch (position) {
            case 0: {
                break;
            }
            default: {
                boolean loop = true;
                int offset1 = documentOffset - 1;
                try {
                    while (loop && offset <= offset1) {
                        switch (doc.getChar(offset1)) {
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': {
                                loop = false;
                                break;
                            }
                            default: {
                                --offset1;
                            }
                        }
                    }
                }
                catch (BadLocationException badLocationException) {}
                offset = offset1 + 1;
            }
        }
        return this.getPartitionOffset(doc, partition, documentOffset, offset);
    }

    public Vector sortProposals(List proposals, String sortingString, boolean showAll) {
        Vector aList = new Vector();
        if (proposals == null) {
            return aList;
        }
        if (sortingString != null && sortingString.length() > 0) {
            char triggerChar = sortingString.charAt(sortingString.length() - 1);
            String precedingName = null;
            if (triggerChar == '.') {
                precedingName = sortingString.substring(0, sortingString.length() - 1);
                if (!precedingName.equals("")) {
                    ListIterator listIterator = proposals.listIterator();
                    while (listIterator.hasNext()) {
                        String precedingNameUC;
                        String parentNameUC;
                        Object proposal = listIterator.next();
                        if (!(proposal instanceof SQLDBProposal) || !(parentNameUC = ((SQLDBProposal)proposal).getParentName().toUpperCase()).endsWith(precedingNameUC = precedingName.toUpperCase())) continue;
                        aList.add(proposal);
                    }
                }
            } else {
                int i = 0;
                while (i < proposals.size()) {
                    if (!(proposals.get(i) instanceof SQLDBProposal) && proposals.get(i).toString().toUpperCase().trim().indexOf(sortingString.toUpperCase()) == 0) {
                        aList.add(proposals.get(i));
                    }
                    ++i;
                }
            }
        }
        if (showAll && aList.size() == 0) {
            aList.addAll(proposals);
        }
        return aList;
    }

    public void setDBProposalsService(ISQLDBProposalsService dbProposalsService) {
        this.fDBProposalsService = dbProposalsService;
        this.fProposalFactory.setFactoryDBContext(dbProposalsService);
    }

    public ISQLDBProposalsService getDBProposalsService() {
        return this.fDBProposalsService;
    }

    @Override
    public IContextInformation[] computeContextInformation(IDocument doc, ITypedRegion partition, int documentOffset, Point selection) {
        return null;
    }
}

