/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.sql;

import com.ibm.ims.datatools.sqltools.sql.ISQLSyntax;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.sql.NestedMultiLineRule;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.utils.SQLColorProvider;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.utils.SQLWordDetector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.widgets.Display;

public class SQLCodeScanner
extends RuleBasedScanner {
    private IToken commentToken;
    private IToken stringToken;
    private IToken keywordToken;
    private IToken datatypeToken;
    private IToken functionToken;
    private IToken delimitedIdentifierToken;
    private IToken otherToken;
    private IToken multilineCommentToken;
    private List rules;

    public SQLCodeScanner(SQLColorProvider colorProvider) {
        if (Display.getDefault().getHighContrast()) {
            this.commentToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_HC_COMMENT_COLOR)));
            this.multilineCommentToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_HC_MULTILINE_COMMENT_COLOR)));
            this.stringToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_HC_QUOTED_LITERAL_COLOR)));
            this.keywordToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_HC_KEYWORD_COLOR), null, 1));
            this.datatypeToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_HC_TYPE_COLOR), null, 1));
            this.functionToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_HC_IDENTIFIER_COLOR)));
            this.delimitedIdentifierToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_HC_DELIMITED_IDENTIFIER_COLOR)));
            this.otherToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_HC_DEFAULT_COLOR)));
        } else {
            this.commentToken = colorProvider.createToken(SQLColorProvider.SQL_COMMENT);
            this.multilineCommentToken = colorProvider.createToken(SQLColorProvider.SQL_MULTILINE_COMMENT);
            this.stringToken = colorProvider.createToken(SQLColorProvider.SQL_QUOTED_LITERAL);
            this.keywordToken = colorProvider.createToken(SQLColorProvider.SQL_KEYWORD);
            this.datatypeToken = colorProvider.createToken(SQLColorProvider.SQL_TYPE);
            this.functionToken = colorProvider.createToken(SQLColorProvider.SQL_IDENTIFIER);
            this.delimitedIdentifierToken = colorProvider.createToken(SQLColorProvider.SQL_DELIMITED_IDENTIFIER);
            this.otherToken = colorProvider.createToken(SQLColorProvider.SQL_DEFAULT);
        }
        this.setDefaultReturnToken(this.otherToken);
        this.rules = new ArrayList();
        this.rules.add(new EndOfLineRule("--", this.commentToken));
        this.rules.add(new SingleLineRule("'", "'", this.stringToken, '\u0000'));
        this.rules.add(new SingleLineRule("\"", "\"", this.delimitedIdentifierToken, '\u0000'));
        this.rules.add(new NestedMultiLineRule("/*", "*/", this.multilineCommentToken, '\u0000', true));
        this.rules.add(new WhitespaceRule((IWhitespaceDetector)new SQLWhiteSpaceDetector()));
        IRule[] result = new IRule[this.rules.size()];
        this.rules.toArray(result);
        this.setRules(result);
    }

    public void setSQLSyntax(ISQLSyntax sqlSyntax) {
        if (sqlSyntax == null) {
            return;
        }
        ArrayList<WordRule> sqlRules = new ArrayList<WordRule>();
        WordRule wordRule = new WordRule((IWordDetector)new SQLWordDetector(), this.otherToken);
        String[] reservedWords = sqlSyntax.getReservedwords();
        int i = 0;
        while (i < reservedWords.length) {
            wordRule.addWord(reservedWords[i].toLowerCase(), this.keywordToken);
            wordRule.addWord(reservedWords[i].toUpperCase(), this.keywordToken);
            ++i;
        }
        String[] unreservedWords = sqlSyntax.getUnreservedwords();
        int i2 = 0;
        while (i2 < unreservedWords.length) {
            wordRule.addWord(unreservedWords[i2].toLowerCase(), this.keywordToken);
            wordRule.addWord(unreservedWords[i2].toUpperCase(), this.keywordToken);
            ++i2;
        }
        String[] datatypes = sqlSyntax.getTypes();
        int i3 = 0;
        while (i3 < datatypes.length) {
            wordRule.addWord(datatypes[i3].toLowerCase(), this.datatypeToken);
            wordRule.addWord(datatypes[i3].toUpperCase(), this.datatypeToken);
            ++i3;
        }
        String[] functions = sqlSyntax.getFunctions();
        int i4 = 0;
        while (i4 < functions.length) {
            wordRule.addWord(functions[i4].toLowerCase(), this.functionToken);
            wordRule.addWord(functions[i4].toUpperCase(), this.functionToken);
            ++i4;
        }
        String[] constants = sqlSyntax.getConstants();
        int i5 = 0;
        while (i5 < constants.length) {
            wordRule.addWord(constants[i5].toLowerCase(), this.datatypeToken);
            wordRule.addWord(constants[i5].toUpperCase(), this.datatypeToken);
            ++i5;
        }
        sqlRules.addAll(this.rules);
        sqlRules.add(wordRule);
        IRule[] result = new IRule[sqlRules.size()];
        sqlRules.toArray(result);
        this.setRules(result);
    }

    public class SQLWhiteSpaceDetector
    implements IWhitespaceDetector {
        public boolean isWhitespace(char c) {
            return Character.isWhitespace(c);
        }
    }
}

