/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.matching;

import com.ibm.ims.datatools.sqltools.sqleditor.internal.matching.AbstractMatchingPairs;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.matching.GeneralMatchingPairs;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class GenericSQLMatchingPairs
extends AbstractMatchingPairs {
    private static GenericSQLMatchingPairs INSTANCE;
    protected String _lc_begin = "begin";
    protected String _uc_begin = "BEGIN";
    protected String _lc_end = "end";
    protected String _uc_end = "END";
    protected String _beginMatchingPattern = "end|END";
    protected String _endMatchingPattern = "begin|BEGIN";
    protected volatile boolean _closureInitial = false;

    public static GenericSQLMatchingPairs getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GenericSQLMatchingPairs();
        }
        return INSTANCE;
    }

    protected GenericSQLMatchingPairs() {
        this._pairs.put(this._lc_begin, this._beginMatchingPattern);
        this._pairs.put(this._uc_begin, this._beginMatchingPattern);
        this._pairs.put(this._lc_end, this._endMatchingPattern);
        this._pairs.put(this._uc_end, this._endMatchingPattern);
        this._leftSet.add(this._lc_begin);
        this._leftSet.add(this._uc_begin);
        this.buildClosure();
    }

    @Override
    public String getMatchingPatternClosure(String token) {
        if (this._closureMap.containsKey(token)) {
            return this._closureMap.get(token).toString();
        }
        return null;
    }

    @Override
    public boolean isLeftToken(String token) {
        if (this._pairs.containsKey(token)) {
            return super.isLeftToken(token);
        }
        if (GeneralMatchingPairs.getInstance().isLeftToken(token)) {
            return GeneralMatchingPairs.getInstance().isLeftToken(token);
        }
        return false;
    }

    @Override
    public boolean isSupportedToken(String token) {
        if (this._pairs.containsKey(token)) {
            return true;
        }
        return GeneralMatchingPairs.getInstance().isSupportedToken(token);
    }

    private void addToClosure(Set closureSet, String token) {
        if (!closureSet.contains(token)) {
            closureSet.add(token);
            String[] mts = this._pairs.get(token).toString().split("\\|");
            int i = 0;
            while (i < mts.length) {
                this.addToClosure(closureSet, mts[i]);
                ++i;
            }
        }
    }

    protected void buildClosure() {
        HashMap<Object, Object> closureMap = new HashMap<Object, Object>();
        Object[] keys = this._pairs.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            HashSet set = new HashSet();
            this.addToClosure(set, keys[i].toString());
            closureMap.put(keys[i], set);
            ++i;
        }
        i = 0;
        while (i < keys.length) {
            Object[] tks = ((Set)closureMap.get(keys[i])).toArray();
            StringBuffer sb = new StringBuffer();
            Arrays.sort(tks, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1.toString().length() == o2.toString().length()) {
                        return 0;
                    }
                    return o1.toString().length() < o2.toString().length() ? 1 : -1;
                }
            });
            int j = 0;
            while (j < tks.length) {
                sb.append(tks[j].toString() + "|");
                ++j;
            }
            String s = sb.substring(0, sb.length() - 1);
            closureMap.put(keys[i], s);
            ++i;
        }
        this._closureMap = closureMap;
    }
}

