/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.indent;

import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.indent.SQLHeuristicScanner;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class SQLIndenter {
    private IDocument _document;
    private int _indent;
    private int _align;
    private int _position;
    private int _previousPos;
    private int _token;
    private int _line;
    private SQLHeuristicScanner _scanner;

    public SQLIndenter(IDocument document, SQLHeuristicScanner scanner) {
        Assert.isNotNull((Object)document);
        Assert.isNotNull((Object)scanner);
        this._document = document;
        this._scanner = scanner;
    }

    public StringBuffer getReferenceIndentation(int offset) {
        int unit = this.findReferencePosition(offset);
        if (unit == -1) {
            return null;
        }
        return this.getLeadingWhitespace(unit);
    }

    public StringBuffer computeIndentation(int offset) {
        return this.computeIndentation(offset, false);
    }

    public StringBuffer computeIndentation(int offset, boolean assumeOpening) {
        this._indent = 1;
        StringBuffer indent = this.createIndent(this._indent);
        if (this._indent < 0) {
            this.unindent(indent);
        }
        if (indent == null) {
            return null;
        }
        indent.append(this.getReferenceIndentation(offset));
        return indent;
    }

    private StringBuffer getLeadingWhitespace(int offset) {
        StringBuffer indent = new StringBuffer();
        try {
            IRegion line = this._document.getLineInformationOfOffset(offset);
            int lineOffset = line.getOffset();
            int nonWS = this._scanner.findNonWhitespaceForwardInAnyPartition(lineOffset, lineOffset + line.getLength());
            indent.append(this._document.get(lineOffset, nonWS - lineOffset));
            return indent;
        }
        catch (BadLocationException badLocationException) {
            return indent;
        }
    }

    private void unindent(StringBuffer indent) {
        StringBuffer oneIndent = this.createIndent();
        int i = indent.lastIndexOf(oneIndent.toString());
        if (i != -1) {
            indent.delete(i, i + oneIndent.length());
        }
    }

    /*
     * Unable to fully structure code
     */
    private StringBuffer createIndent(int start, int indent) {
        block9: {
            tabLen = this.prefTabLength();
            ret = new StringBuffer();
            try {
                spaces = 0;
                while (start < indent) {
                    ch = this._document.getChar(start);
                    if (ch == '\t') {
                        ret.append('\t');
                        spaces = 0;
                    } else if (tabLen == -1) {
                        ret.append(' ');
                    } else if (++spaces == tabLen) {
                        ret.append('\t');
                        spaces = 0;
                    }
                    ++start;
                }
                if (spaces != tabLen) ** GOTO lbl28
                ret.append('\t');
                break block9;
lbl-1000:
                // 1 sources

                {
                    ret.append(' ');
lbl28:
                    // 2 sources

                    ** while (spaces-- > 0)
                }
lbl29:
                // 1 sources

            }
            catch (BadLocationException v0) {}
        }
        return ret;
    }

    private StringBuffer createIndent(int indent) {
        StringBuffer oneIndent = this.createIndent();
        StringBuffer ret = new StringBuffer();
        while (indent-- > 0) {
            ret.append(oneIndent);
        }
        return ret;
    }

    private StringBuffer createIndent() {
        StringBuffer oneIndent = new StringBuffer();
        oneIndent.append('\t');
        return oneIndent;
    }

    public int findReferencePosition(int offset) {
        this._indent = 0;
        this._align = -1;
        this._position = offset;
        this.nextToken();
        int ref = this.skipToPreviousListItemOrListStart();
        return ref;
    }

    private int peekChar(int offset) {
        if (offset < this._document.getLength()) {
            try {
                IRegion line = this._document.getLineInformationOfOffset(offset);
                int lineOffset = line.getOffset();
                int next = this._scanner.nextToken(offset, lineOffset + line.getLength());
                return next;
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    private int skipToPreviousListItemOrListStart() {
        int startLine = this._line;
        int startPosition = this._position;
        while (true) {
            this.nextToken();
            if (this._line < startLine) {
                try {
                    int lineOffset = this._document.getLineOffset(startLine);
                    int bound = Math.min(this._document.getLength(), startPosition + 1);
                    this._align = this._scanner.findNonWhitespaceForwardInAnyPartition(lineOffset, bound);
                }
                catch (BadLocationException badLocationException) {}
                return startPosition;
            }
            switch (this._token) {
                case -1: {
                    return 0;
                }
            }
        }
    }

    private int setFirstElementAlignment(int scopeIntroducerOffset, int bound) {
        int firstPossible = scopeIntroducerOffset + 1;
        this._align = this._scanner.findNonWhitespaceForwardInAnyPartition(firstPossible, bound);
        if (this._align == -1) {
            this._align = firstPossible;
        }
        return this._align;
    }

    private void nextToken() {
        this.nextToken(this._position);
    }

    public void nextToken(int start) {
        this._token = this._scanner.previousToken(start - 1, -2);
        this._previousPos = start;
        this._position = this._scanner.getPosition() + 1;
        try {
            this._line = this._document.getLineOfOffset(this._position);
        }
        catch (BadLocationException badLocationException) {
            this._line = -1;
        }
    }

    private boolean skipScope(int openToken, int closeToken) {
        int depth = 1;
        while (true) {
            this.nextToken();
            if (this._token == closeToken) {
                ++depth;
                continue;
            }
            if (this._token == openToken) {
                if (--depth != 0) continue;
                return true;
            }
            if (this._token == -1) break;
        }
        return false;
    }

    private int prefTabLength() {
        SQLEditorPlugin plugin = SQLEditorPlugin.getDefault();
        int tabLen = plugin.getPreferenceStore().getInt("tabWidth");
        return tabLen;
    }
}

