/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.indent;

import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import java.text.BreakIterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;

public class SQLCommentAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private String _partitioning;

    public SQLCommentAutoIndentStrategy(String partitioning) {
        this._partitioning = partitioning;
    }

    private static String getLineDelimiter(IDocument document) {
        try {
            if (document.getNumberOfLines() > 1) {
                return document.getLineDelimiter(0);
            }
        }
        catch (BadLocationException badLocationException) {}
        return System.getProperty("line.separator");
    }

    private void commentIndentAfterNewLine(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            IRegion info = d.getLineInformationOfOffset(p);
            int start = info.getOffset();
            int end = this.findEndOfWhiteSpace(d, start, c.offset);
            StringBuffer buf = new StringBuffer(c.text);
            if (end >= start) {
                String indentation = this.commentExtractLinePrefix(d, d.getLineOfOffset(c.offset));
                buf.append(indentation);
                if (end < c.offset && d.getChar(end) == '/' && d.getChar(end + 1) != '/') {
                    buf.append(" * ");
                    if (SQLEditorPlugin.getDefault().getPreferenceStore().getBoolean("SQLEditor.closeComments") && SQLCommentAutoIndentStrategy.isNewComment(d, c.offset, this._partitioning)) {
                        String lineDelimiter = SQLCommentAutoIndentStrategy.getLineDelimiter(d);
                        String endTag = lineDelimiter + indentation + " */";
                        d.replace(c.offset, 0, endTag);
                    }
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    protected void commentIndentForCommentEnd(IDocument d, DocumentCommand c) {
        if (c.offset < 2 || d.getLength() == 0) {
            return;
        }
        try {
            if ("* ".equals(d.get(c.offset - 2, 2))) {
                ++c.length;
                --c.offset;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private static boolean isNewComment(IDocument document, int commandOffset, String partitioning) {
        ITypedRegion partition;
        block7: {
            int partitionEnd;
            block6: {
                int lineIndex;
                block5: {
                    try {
                        lineIndex = document.getLineOfOffset(commandOffset) + 1;
                        if (lineIndex < document.getNumberOfLines()) break block5;
                        return true;
                    }
                    catch (BadLocationException badLocationException) {
                        return false;
                    }
                }
                IRegion line = document.getLineInformation(lineIndex);
                partition = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)commandOffset, (boolean)false);
                partitionEnd = partition.getOffset() + partition.getLength();
                if (line.getOffset() < partitionEnd) break block6;
                return false;
            }
            if (document.getLength() != partitionEnd) break block7;
            return true;
        }
        String comment = document.get(partition.getOffset(), partition.getLength());
        return comment.indexOf("/*", 2) != -1;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        try {
            String[] lineDelimiters;
            int index;
            if (command.text != null && command.length == 0 && (index = TextUtilities.endsWith((String[])(lineDelimiters = document.getLegalLineDelimiters()), (String)command.text)) > -1) {
                if (lineDelimiters[index].equals(command.text)) {
                    this.commentIndentAfterNewLine(document, command);
                }
                return;
            }
            if (command.text != null && command.text.equals("/")) {
                this.commentIndentForCommentEnd(document, command);
                return;
            }
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this._partitioning, (int)command.offset, (boolean)true);
            int partitionStart = partition.getOffset();
            int partitionEnd = partition.getLength() + partitionStart;
            String text = command.text;
            int offset = command.offset;
            int length = command.length;
            int PREFIX_LENGTH = "/*".length();
            int POSTFIX_LENGTH = "*/".length();
            if (offset < partitionStart + PREFIX_LENGTH || offset + length > partitionEnd - POSTFIX_LENGTH || text != null && text.length() >= 2 && (text.indexOf("*/") != -1 || document.getChar(offset) == '*' && text.startsWith("/"))) {
                return;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void flushCommand(IDocument document, DocumentCommand command) throws BadLocationException {
        if (!command.doit) {
            return;
        }
        document.replace(command.offset, command.length, command.text);
        command.doit = false;
        if (command.text != null) {
            command.offset += command.text.length();
        }
        command.length = 0;
        command.text = null;
    }

    protected void commentWrapParagraphOnInsert(IDocument document, DocumentCommand command) throws BadLocationException {
        int line = document.getLineOfOffset(command.offset);
        IRegion region = document.getLineInformation(line);
        int lineOffset = region.getOffset();
        int lineLength = region.getLength();
        String lineContents = document.get(lineOffset, lineLength);
        StringBuffer buffer = new StringBuffer(lineContents);
        int start = command.offset - lineOffset;
        int end = command.length + start;
        buffer.replace(start, end, command.text);
        if (command.text != null && command.text.length() != 0 && command.text.trim().length() == 0) {
            String endOfLine = document.get(command.offset, lineOffset + lineLength - command.offset);
            if (endOfLine.length() == 0) {
                this.flushCommand(document, command);
                if (this.isLineTooShort(document, line)) {
                    int[] caretOffset = new int[]{command.offset};
                    this.commentWrapParagraphFromLine(document, line, caretOffset, false);
                    command.offset = caretOffset[0];
                    return;
                }
                if (line < document.getNumberOfLines() - 1 && this.isCommentLine(document, line + 1)) {
                    String lineDelimiter = document.getLineDelimiter(line);
                    String nextLinePrefix = this.commentExtractLinePrefix(document, line + 1);
                    command.offset += lineDelimiter.length() + nextLinePrefix.length();
                }
                return;
            }
            if (endOfLine.trim().length() == 0) {
                return;
            }
        }
        String prefix = this.commentExtractLinePrefix(document, line);
        boolean wrapAlways = command.offset >= lineOffset && command.offset <= lineOffset + prefix.length();
        this.flushCommand(document, command);
        if (wrapAlways || SQLCommentAutoIndentStrategy.calculateDisplayedWidth(buffer.toString()) > SQLCommentAutoIndentStrategy.getMargin() || this.isLineTooShort(document, line)) {
            int[] caretOffset = new int[]{command.offset};
            this.commentWrapParagraphFromLine(document, line, caretOffset, wrapAlways);
            if (!wrapAlways) {
                command.offset = caretOffset[0];
            }
        }
    }

    private void commentWrapParagraphFromLine(IDocument document, int line, int[] caretOffset, boolean always) throws BadLocationException {
        String indent = this.commentExtractLinePrefix(document, line);
        if (!always) {
            if (!indent.trim().startsWith("*")) {
                return;
            }
            if (indent.trim().startsWith("*/")) {
                return;
            }
            if (!this.isLineTooLong(document, line) && !this.isLineTooShort(document, line)) {
                return;
            }
        }
        boolean caretRelativeToParagraphOffset = false;
        int caret = caretOffset[0];
        int caretLine = document.getLineOfOffset(caret);
        int lineOffset = document.getLineOffset(line);
        int paragraphOffset = lineOffset + indent.length();
        if (paragraphOffset < caret) {
            caret -= paragraphOffset;
            caretRelativeToParagraphOffset = true;
        } else {
            caret -= lineOffset;
        }
        StringBuffer buffer = new StringBuffer();
        int currentLine = line;
        while (line == currentLine || this.isCommentLine(document, currentLine)) {
            if (buffer.length() != 0 && !Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
                buffer.append(' ');
                if (currentLine <= caretLine) {
                    ++caret;
                }
            }
            String string = this.getLineContents(document, currentLine);
            buffer.append(string);
            ++currentLine;
        }
        String paragraph = buffer.toString();
        if (paragraph.trim().length() == 0) {
            return;
        }
        caretOffset[0] = caretRelativeToParagraphOffset ? caret : 0;
        String delimiter = document.getLineDelimiter(0);
        String wrapped = SQLCommentAutoIndentStrategy.formatParagraph(paragraph, caretOffset, indent, delimiter, SQLCommentAutoIndentStrategy.getMargin());
        int beginning = document.getLineOffset(line);
        int end = document.getLineOffset(currentLine);
        document.replace(beginning, end - beginning, wrapped.toString());
        caretOffset[0] = caretRelativeToParagraphOffset ? caretOffset[0] + beginning : caret + beginning;
    }

    private static String formatParagraph(String paragraph, int[] offset, String prefix, String lineDelimiter, int margin) {
        LineBreakIterator iterator = new LineBreakIterator(paragraph);
        StringBuffer paragraphBuffer = new StringBuffer();
        StringBuffer lineBuffer = new StringBuffer();
        StringBuffer whiteSpaceBuffer = new StringBuffer();
        int index = offset[0];
        int indexBuffer = -1;
        if (lineDelimiter == null) {
            lineDelimiter = "";
        }
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = paragraph.substring(start, end);
            if (word.trim().length() == 0) {
                whiteSpaceBuffer.append(word);
            } else if (lineBuffer.length() == 0) {
                lineBuffer.append(prefix);
                lineBuffer.append(whiteSpaceBuffer.toString());
                lineBuffer.append(word);
            } else {
                String line = lineBuffer.toString() + whiteSpaceBuffer.toString() + word.toString();
                if (SQLCommentAutoIndentStrategy.calculateDisplayedWidth(line) > margin) {
                    paragraphBuffer.append(lineBuffer.toString());
                    paragraphBuffer.append(lineDelimiter);
                    lineBuffer.setLength(0);
                    lineBuffer.append(prefix);
                    lineBuffer.append(word);
                    if (indexBuffer != -1) {
                        offset[0] = indexBuffer;
                        if (whiteSpaceBuffer.length() != 0 && index < start && index >= start - whiteSpaceBuffer.length()) {
                            offset[0] = offset[0] - (index - (start - whiteSpaceBuffer.length()));
                        }
                        indexBuffer = -1;
                    }
                    whiteSpaceBuffer.setLength(0);
                } else {
                    lineBuffer.append(whiteSpaceBuffer.toString());
                    lineBuffer.append(word);
                    whiteSpaceBuffer.setLength(0);
                }
            }
            if (index >= start && index < end) {
                indexBuffer = paragraphBuffer.length() + lineBuffer.length() + (index - start);
                if (word.trim().length() != 0) {
                    indexBuffer -= word.length();
                }
            }
            start = end;
            end = iterator.next();
        }
        paragraphBuffer.append(lineBuffer.toString());
        paragraphBuffer.append(lineDelimiter);
        if (indexBuffer != -1) {
            offset[0] = indexBuffer;
        } else if (offset[0] == paragraph.length()) {
            offset[0] = paragraphBuffer.length() - lineDelimiter.length();
        }
        return paragraphBuffer.toString();
    }

    private static IPreferenceStore getPreferenceStore() {
        return SQLEditorPlugin.getDefault().getPreferenceStore();
    }

    private static int calculateDisplayedWidth(String string) {
        int tabWidth = SQLCommentAutoIndentStrategy.getPreferenceStore().getInt("tabWidth");
        int column = 0;
        int i = 0;
        while (i < string.length()) {
            column = '\t' == string.charAt(i) ? (column += tabWidth - column % tabWidth) : ++column;
            ++i;
        }
        return column;
    }

    private String commentExtractLinePrefix(IDocument d, int line) throws BadLocationException {
        IRegion region = d.getLineInformation(line);
        int lineOffset = region.getOffset();
        int index = this.findEndOfWhiteSpace(d, lineOffset, lineOffset + d.getLineLength(line));
        if (d.getChar(index) == '*' && ++index != lineOffset + region.getLength() && d.getChar(index) == ' ') {
            ++index;
        }
        return d.get(lineOffset, index - lineOffset);
    }

    private String getLineContents(IDocument d, int line) throws BadLocationException {
        int offset = d.getLineOffset(line);
        int length = d.getLineLength(line);
        String lineDelimiter = d.getLineDelimiter(line);
        if (lineDelimiter != null) {
            length -= lineDelimiter.length();
        }
        String lineContents = d.get(offset, length);
        int trim = this.commentExtractLinePrefix(d, line).length();
        return lineContents.substring(trim);
    }

    private static String getLine(IDocument document, int line) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        return document.get(region.getOffset(), region.getLength());
    }

    private boolean isLineTooShort(IDocument document, int line) throws BadLocationException {
        if (!this.isCommentLine(document, line + 1)) {
            return false;
        }
        String nextLine = this.getLineContents(document, line + 1);
        return nextLine.trim().length() != 0;
    }

    private boolean isLineTooLong(IDocument document, int line) throws BadLocationException {
        String lineContents = SQLCommentAutoIndentStrategy.getLine(document, line);
        return SQLCommentAutoIndentStrategy.calculateDisplayedWidth(lineContents) > SQLCommentAutoIndentStrategy.getMargin();
    }

    private static int getMargin() {
        return SQLCommentAutoIndentStrategy.getPreferenceStore().getInt("printMarginColumn");
    }

    private boolean isCommentLine(IDocument document, int line) throws BadLocationException {
        if (document.getNumberOfLines() < line) {
            return false;
        }
        int offset = document.getLineOffset(line);
        int length = document.getLineLength(line);
        int firstChar = this.findEndOfWhiteSpace(document, offset, offset + length);
        String lineContents = document.get(firstChar, length -= firstChar - offset);
        String prefix = lineContents.trim();
        if (!prefix.startsWith("*") || prefix.startsWith("*/")) {
            return false;
        }
        lineContents = lineContents.substring(1).trim().toLowerCase();
        return true;
    }

    protected void commentHandleBackspaceDelete(IDocument document, DocumentCommand c) {
        try {
            String text = document.get(c.offset, c.length);
            int line = document.getLineOfOffset(c.offset);
            int lineOffset = document.getLineOffset(line);
            String lineDelimiter = document.getLineDelimiter(line);
            if (lineDelimiter != null && lineDelimiter.equals(text)) {
                String prefix = this.commentExtractLinePrefix(document, line + 1);
                if (prefix.length() > 0) {
                    int length = document.getLineDelimiter(line).length() + prefix.length();
                    document.replace(c.offset, length, null);
                    c.doit = false;
                    c.length = 0;
                    return;
                }
            } else {
                if (document.getChar(c.offset - 1) == '*' && this.commentExtractLinePrefix(document, line).length() - 1 >= c.offset - lineOffset) {
                    lineDelimiter = document.getLineDelimiter(line - 1);
                    String prefix = this.commentExtractLinePrefix(document, line);
                    int length = (lineDelimiter != null ? lineDelimiter.length() : 0) + prefix.length();
                    document.replace(c.offset - length + 1, length, null);
                    c.doit = false;
                    c.offset -= length - 1;
                    c.length = 0;
                    return;
                }
                document.replace(c.offset, c.length, null);
                c.doit = false;
                c.length = 0;
            }
        }
        catch (BadLocationException badLocationException) {}
        try {
            int line = document.getLineOfOffset(c.offset);
            int lineOffset = document.getLineOffset(line);
            String prefix = this.commentExtractLinePrefix(document, line);
            boolean always = c.offset > lineOffset && c.offset <= lineOffset + prefix.length();
            int[] caretOffset = new int[]{c.offset};
            this.commentWrapParagraphFromLine(document, document.getLineOfOffset(c.offset), caretOffset, always);
            c.offset = caretOffset[0];
        }
        catch (BadLocationException badLocationException) {}
    }

    private static class LineBreakIterator {
        private final String _string;
        private final BreakIterator _iterator = BreakIterator.getLineInstance();
        private int _start;
        private int _end;
        private int _bufferedEnd;

        public LineBreakIterator(String string) {
            this._string = string;
            this._iterator.setText(string);
        }

        public int first() {
            this._bufferedEnd = -1;
            this._start = this._iterator.first();
            return this._start;
        }

        public int next() {
            if (this._bufferedEnd != -1) {
                this._start = this._end;
                this._end = this._bufferedEnd;
                this._bufferedEnd = -1;
                return this._end;
            }
            this._start = this._end;
            this._end = this._iterator.next();
            if (this._end == -1) {
                return this._end;
            }
            String string = this._string.substring(this._start, this._end);
            if (string.trim().length() == 0) {
                return this._end;
            }
            String word = string.trim();
            if (word.length() == string.length()) {
                return this._end;
            }
            this._bufferedEnd = this._end;
            return this._start + word.length();
        }
    }
}

