/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.editor;

import com.ibm.ims.datatools.sqltools.common.ui.util.ImageDescriptorRegistry;
import com.ibm.ims.datatools.sqltools.common.ui.util.ImageImageDescriptor;
import com.ibm.ims.datatools.sqltools.sql.parser.ast.Node;
import com.ibm.ims.datatools.sqltools.sqleditor.SQLEditor;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.editor.SQLImageDescriptor;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class SQLMarkerLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private ImageDescriptorRegistry _fRegistry;
    private SQLEditor _editor;

    public SQLMarkerLabelDecorator(SQLEditor editor) {
        this._editor = editor;
    }

    public Image decorateImage(Image image, Object element) {
        if (!(element instanceof Node)) {
            return image;
        }
        int[] adornmentFlags = this.computeAdornmentFlags((Node)element);
        Object baseImage = new ImageImageDescriptor(image);
        int i = 0;
        while (i < adornmentFlags.length) {
            if (adornmentFlags[i] != 0) {
                Rectangle bounds = image.getBounds();
                baseImage = new SQLImageDescriptor((ImageDescriptor)baseImage, adornmentFlags[i], new Point(bounds.width, bounds.height));
            }
            ++i;
        }
        return this.getRegistry().get((ImageDescriptor)baseImage);
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
    }

    private int[] computeAdornmentFlags(Node node) {
        int[] info = new int[2];
        try {
            IAnnotationModel model = this._editor.getDocumentProvider().getAnnotationModel((Object)this._editor.getEditorInput());
            IDocument document = node.getDocument();
            if (model != null) {
                info[0] = this.getErrorTicksFromNode(node, model, document);
                info[1] = this.getPortableFlagFromNode(node, model, document);
            }
        }
        catch (Exception e) {
            SQLEditorPlugin.getDefault().log("SQLMarkerLabelDecorator.failed.to.compute.adornment.flags", e);
        }
        return info;
    }

    private int getPortableFlagFromNode(Node node, IAnnotationModel model, IDocument document) throws CoreException {
        int info = 0;
        if (model != null) {
            Iterator iter = model.getAnnotationIterator();
            while (info != 4 && iter.hasNext()) {
                Annotation curr = (Annotation)iter.next();
                IMarker marker = this.isAnnotationInRange(model, curr, node, document, "org.eclipse.core.resources.taskmarker");
                if (marker == null) continue;
                info = 4;
            }
        }
        return info;
    }

    private int getErrorTicksFromNode(Node node, IAnnotationModel model, IDocument document) throws CoreException {
        int info = 0;
        if (model != null) {
            Iterator iter = model.getAnnotationIterator();
            while (info != 2 && iter.hasNext()) {
                Annotation curr = (Annotation)iter.next();
                IMarker marker = this.isAnnotationInRange(model, curr, node, document, "org.eclipse.core.resources.problemmarker");
                if (marker == null) continue;
                int priority = marker.getAttribute("severity", -1);
                if (priority == 1) {
                    info = 1;
                    continue;
                }
                if (priority != 2) continue;
                info = 2;
            }
        }
        return info;
    }

    private IMarker isAnnotationInRange(IAnnotationModel model, Annotation annot, Node node, IDocument document, String markerType) throws CoreException {
        Position pos;
        IMarker marker;
        if (annot instanceof MarkerAnnotation && (marker = ((MarkerAnnotation)annot).getMarker()).exists() && marker.isSubtypeOf(markerType) && (pos = model.getPosition(annot)) != null && (node == null || this.isInside(pos.getOffset(), node, document))) {
            return marker;
        }
        return null;
    }

    protected boolean isInside(int pos, Node node, IDocument document) throws CoreException {
        return node.getStartOffset() <= pos && node.getGreatestEndOffset() >= pos;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this._fRegistry == null) {
            this._fRegistry = new ImageDescriptorRegistry();
        }
        return this._fRegistry;
    }
}

