/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.editor;

import com.ibm.ims.datatools.sqltools.sql.parser.ast.IASTDeployable;
import com.ibm.ims.datatools.sqltools.sql.parser.ast.IASTSQLParam;
import com.ibm.ims.datatools.sqltools.sql.parser.ast.IASTSQLParamDefList;
import com.ibm.ims.datatools.sqltools.sql.parser.ast.IASTSQLStatement;
import com.ibm.ims.datatools.sqltools.sql.parser.ast.Node;
import com.ibm.ims.datatools.sqltools.sql.parser.ast.SimpleNode;
import com.ibm.ims.datatools.sqltools.sql.ui.SQLImageService;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

class SQLLabelProvider
extends LabelProvider {
    private ArrayList _fLabelDecorators;

    SQLLabelProvider() {
    }

    public Image getBaseImage(Object element) {
        if (!(element instanceof SimpleNode)) {
            return null;
        }
        if (element instanceof IASTSQLStatement || element instanceof IASTDeployable) {
            return SQLImageService.INSTANCE.getNodeImage((Node)element);
        }
        if (element instanceof IASTSQLParam) {
            return SQLEditorResources.getImage("datatype");
        }
        if (element instanceof IASTSQLParamDefList) {
            return SQLEditorResources.getImage("parameter");
        }
        return null;
    }

    public String getBaseText(Object element) {
        if (element instanceof SimpleNode) {
            return ((SimpleNode)element).toString();
        }
        return super.getText(element);
    }

    public void addLabelDecorator(ILabelDecorator decorator) {
        if (this._fLabelDecorators == null) {
            this._fLabelDecorators = new ArrayList(2);
        }
        this._fLabelDecorators.add(decorator);
    }

    protected Image decorateImage(Image image, Object element) {
        if (this._fLabelDecorators != null && image != null) {
            int i = 0;
            while (i < this._fLabelDecorators.size()) {
                ILabelDecorator decorator = (ILabelDecorator)this._fLabelDecorators.get(i);
                image = decorator.decorateImage(image, element);
                ++i;
            }
        }
        return image;
    }

    public Image getImage(Object element) {
        return this.decorateImage(this.getBaseImage(element), element);
    }

    protected String decorateText(String text, Object element) {
        if (this._fLabelDecorators != null && text.length() > 0) {
            int i = 0;
            while (i < this._fLabelDecorators.size()) {
                ILabelDecorator decorator = (ILabelDecorator)this._fLabelDecorators.get(i);
                text = decorator.decorateText(text, element);
                ++i;
            }
        }
        return text;
    }

    public String getText(Object element) {
        return this.decorateText(this.getBaseText(element), element);
    }

    public void dispose() {
        if (this._fLabelDecorators != null) {
            int i = 0;
            while (i < this._fLabelDecorators.size()) {
                ILabelDecorator decorator = (ILabelDecorator)this._fLabelDecorators.get(i);
                decorator.dispose();
                ++i;
            }
            this._fLabelDecorators = null;
        }
    }

    public void addListener(ILabelProviderListener listener) {
        if (this._fLabelDecorators != null) {
            int i = 0;
            while (i < this._fLabelDecorators.size()) {
                ILabelDecorator decorator = (ILabelDecorator)this._fLabelDecorators.get(i);
                decorator.addListener(listener);
                ++i;
            }
        }
        super.addListener(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this._fLabelDecorators != null) {
            int i = 0;
            while (i < this._fLabelDecorators.size()) {
                ILabelDecorator decorator = (ILabelDecorator)this._fLabelDecorators.get(i);
                decorator.removeListener(listener);
                ++i;
            }
        }
        super.removeListener(listener);
    }

    public static ILabelDecorator[] getDecorators(boolean errortick, ILabelDecorator extra) {
        if (errortick) {
            if (extra == null) {
                return new ILabelDecorator[0];
            }
            return new ILabelDecorator[]{extra};
        }
        if (extra != null) {
            return new ILabelDecorator[]{extra};
        }
        return null;
    }
}

