/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.selection;

import com.ibm.ims.datatools.sqltools.sqleditor.SQLEditor;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.selection.BlankLineSelection;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.selection.CurrentLineSelection;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.selection.DelimeterSelection;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.selection.ISQLSelection;
import org.eclipse.jface.preference.IPreferenceStore;

public class SQLSelectionFactory {
    protected SQLSelectionFactory() {
    }

    public static SQLSelectionFactory getInstance() {
        return FactoryHolder._instance;
    }

    public ISQLSelection getSQLSelection(SQLEditor editor) {
        IPreferenceStore store = SQLEditorPlugin.getDefault().getPreferenceStore();
        String executedPolicy = store.getString("SQLEditor.executeSelectedSQL");
        if (executedPolicy.equalsIgnoreCase("SQLEditor.executeSelectedSQL.betweenDelimiter")) {
            String[] terminators = new String[]{store.getString("SQLEditor.executeSelectedSQL.betweenDelimiter.delimiterType")};
            return new DelimeterSelection(editor, terminators);
        }
        if (executedPolicy.equalsIgnoreCase("SQLEditor.executeSelectedSQL.currentLine")) {
            return new CurrentLineSelection(editor);
        }
        return new BlankLineSelection(editor);
    }

    private static class FactoryHolder {
        public static SQLSelectionFactory _instance = new SQLSelectionFactory();

        private FactoryHolder() {
        }
    }
}

