/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.selection;

import com.ibm.ims.datatools.sqltools.sqleditor.SQLEditor;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.selection.ISQLSelection;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextSelection;

public class DelimeterSelection
implements ISQLSelection {
    private SQLEditor _sqlEditor;
    private String[] _terminators;

    public DelimeterSelection(SQLEditor editor, String[] terminators) {
        this._sqlEditor = editor;
        this._terminators = terminators;
    }

    @Override
    public String getStatements() {
        IDocument doc = this._sqlEditor.getDocumentProvider().getDocument((Object)this._sqlEditor.getEditorInput());
        String text = doc.get();
        ITextSelection selection = (ITextSelection)this._sqlEditor.getSelectionProvider().getSelection();
        int curOffset = selection.getOffset();
        if (curOffset > 0 && curOffset == doc.getLength()) {
            --curOffset;
        }
        int startOffset = curOffset;
        int endOffset = curOffset;
        int usedTerminatorIndex = -1;
        try {
            int i = 0;
            while (i < this._terminators.length) {
                startOffset = curOffset;
                endOffset = curOffset;
                if (this.terminatorNeedTakeUpWholeWord(this._terminators[i])) {
                    while (startOffset >= 0 && startOffset < text.length() && this.isCode(startOffset) && !this.isWordDelimiter(text.charAt(startOffset))) {
                        --startOffset;
                    }
                    if (startOffset < 0) {
                        startOffset = 0;
                    }
                }
                if (text.substring(startOffset = this.getOffsetStepByWord(text, startOffset, false, new String[]{this._terminators[i]}), endOffset = this.getOffsetStepByWord(text, endOffset, true, new String[]{this._terminators[i]})).length() > 0) {
                    usedTerminatorIndex = i;
                    break;
                }
                ++i;
            }
            if (usedTerminatorIndex >= 0 && usedTerminatorIndex < this._terminators.length) {
                endOffset = this.removeTerminator(text, startOffset, endOffset, usedTerminatorIndex);
            }
            return text.substring(startOffset, endOffset).trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int removeTerminator(String text, int startOffset, int lastOffset, int usedTerminatorIndex) {
        int[] lastWordOffset;
        int endOffset = lastOffset;
        boolean isRemoved = false;
        if (endOffset == text.length()) {
            --endOffset;
        }
        int lastStart = (lastWordOffset = this.getNextWord(endOffset, false))[0] < startOffset ? startOffset : lastWordOffset[0];
        String lastWord = text.substring(lastStart, lastWordOffset[0] + lastWordOffset[1]);
        String term = this._terminators[usedTerminatorIndex];
        if (this.terminatorNeedTakeUpWholeWord(term)) {
            if (lastWord.equalsIgnoreCase(term.toLowerCase()) || lastWord.equalsIgnoreCase(term.toUpperCase())) {
                isRemoved = true;
                endOffset = lastStart;
            }
        } else if (lastWord.contains(term.toLowerCase())) {
            endOffset = lastStart + lastWord.indexOf(term.toLowerCase());
            isRemoved = true;
        } else if (lastWord.contains(term.toUpperCase())) {
            endOffset = lastStart + lastWord.indexOf(term.toUpperCase());
            isRemoved = true;
        }
        if (isRemoved) {
            return endOffset;
        }
        return lastOffset;
    }

    private boolean terminatorNeedTakeUpWholeWord(String terminator) {
        return terminator.matches("\\w.*") || terminator.matches(".*\\w");
    }

    private int getOffsetStepByWord(String text, int offset, boolean forward, String[] terminators) {
        boolean findTerm = false;
        while (offset >= 0 && offset < text.length() && !findTerm) {
            int[] next = this.getNextWord(offset, forward);
            String nextWord = text.substring(next[0], next[0] + next[1]);
            int i = 0;
            while (i < terminators.length) {
                if (this.terminatorNeedTakeUpWholeWord(terminators[i])) {
                    if (terminators[i].toUpperCase().equals(nextWord) || terminators[i].toLowerCase().equals(nextWord)) {
                        findTerm = true;
                        offset = next[0] + next[1];
                        break;
                    }
                } else {
                    int off;
                    int curOffset = ((ITextSelection)this._sqlEditor.getSelectionProvider().getSelection()).getOffset();
                    int delta = 0;
                    if (next[0] <= curOffset && next[0] + next[1] > curOffset) {
                        if (!forward) {
                            nextWord = text.substring(next[0], curOffset);
                        } else {
                            nextWord = text.substring(curOffset, next[0] + next[1]);
                            delta = curOffset - next[0];
                        }
                    }
                    if (nextWord.contains(terminators[i].toLowerCase())) {
                        off = !forward ? nextWord.lastIndexOf(terminators[i].toLowerCase()) : nextWord.indexOf(terminators[i].toLowerCase());
                        offset = next[0] + delta + off + terminators[i].length();
                        findTerm = true;
                        break;
                    }
                    if (nextWord.contains(terminators[i].toUpperCase())) {
                        off = !forward ? nextWord.lastIndexOf(terminators[i].toUpperCase()) : nextWord.indexOf(terminators[i].toUpperCase());
                        offset = next[0] + delta + off + terminators[i].length();
                        findTerm = true;
                        break;
                    }
                }
                ++i;
            }
            if (findTerm) continue;
            offset = !forward ? next[0] - 1 : next[0] + next[1];
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset > text.length()) {
            offset = text.length();
        }
        return offset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isCode(int offset) {
        char c;
        if (offset > 0 && ((c = this._sqlEditor.getSV().getDocument().get().charAt(offset - 1)) == '[' || c == ']' || c == '(' || c == ')')) {
            return true;
        }
        if (this.isInSquareBracket(this._sqlEditor.getSV().getDocument().get(), offset)) {
            return false;
        }
        String contentType = null;
        IDocument document = this._sqlEditor.getSV().getDocument();
        try {
            boolean notCodeFlag = true;
            int tempOffset = offset - 1;
            while (tempOffset <= offset) {
                if (tempOffset >= 0 && tempOffset < document.get().length()) {
                    contentType = ((IDocumentExtension3)document).getContentType("___sql_partitioning", tempOffset, false);
                    if (contentType == null) {
                        return false;
                    }
                    if (!(contentType.equals("sql_comment") || contentType.equals("sql_multiline_comment") || contentType.equals("sql_double_quotes_identifier") || contentType.equals("sql_character"))) {
                        notCodeFlag = false;
                    }
                }
                ++tempOffset;
            }
            return !notCodeFlag;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        catch (BadPartitioningException badPartitioningException) {
            return false;
        }
    }

    private boolean isInSquareBracket(String text, int offset) {
        int next = offset;
        int begin = offset;
        int end = offset;
        while (next > 0 && next < text.length() && text.charAt(next) != '[') {
            --next;
        }
        begin = next == text.length() && next != 0 ? next - 1 : next;
        next = offset;
        while (next < text.length() && text.charAt(next) != ']') {
            ++next;
        }
        end = next == text.length() ? next : next + 1;
        String s = text.substring(begin, end);
        String pattern = "\\[(.)*\\]";
        return Pattern.compile(pattern).matcher(s).matches();
    }

    protected boolean isWordDelimiter(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    private int[] getNextWord(int offset, boolean forward) {
        IDocument doc = this._sqlEditor.getDocumentProvider().getDocument((Object)this._sqlEditor.getEditorInput());
        String text = doc.get();
        int step = forward ? 1 : -1;
        while (offset >= 0 && offset < text.length() && (!this.isCode(offset) || this.isWordDelimiter(text.charAt(offset)))) {
            offset += step;
        }
        boolean move = false;
        while (offset >= 0 && offset < text.length() && this.isCode(offset) && !this.isWordDelimiter(text.charAt(offset))) {
            offset += step;
            move = true;
        }
        int pos1 = offset >= 0 ? offset : 0;
        offset = move ? offset - step : offset;
        while (offset >= 0 && offset < text.length() && this.isCode(offset) && !this.isWordDelimiter(text.charAt(offset))) {
            offset -= step;
        }
        int pos2 = offset >= 0 ? offset : 0;
        int[] result = new int[2];
        if (pos1 > pos2) {
            if (this.isWordDelimiter(text.charAt(pos2))) {
                // empty if block
            }
            result[0] = ++pos2;
            result[1] = pos1 - pos2;
        } else if (pos2 > pos1) {
            if (this.isWordDelimiter(text.charAt(pos1))) {
                // empty if block
            }
            result[0] = ++pos1;
            result[1] = pos2 - pos1;
        } else {
            result[0] = pos1;
            result[1] = 0;
        }
        return result;
    }
}

