/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.actions;

import com.ibm.ims.datatools.help.HelpUtil;
import com.ibm.ims.datatools.sqltools.core.DatabaseIdentifier;
import com.ibm.ims.datatools.sqltools.core.SQLToolsFacade;
import com.ibm.ims.datatools.sqltools.sql.parser.ParsingResult;
import com.ibm.ims.datatools.sqltools.sqleditor.IPageUpdate;
import com.ibm.ims.datatools.sqltools.sqleditor.SQLEditor;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.BaseExecuteAction;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.Messages;
import java.util.HashMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ExecuteSQLAsOneStatementAction
extends BaseExecuteAction
implements ISelectionChangedListener,
IPageUpdate {
    private SQLEditor _sqlEditor;
    private ITextSelection _selection;
    private boolean _isSourcePage = true;

    public ExecuteSQLAsOneStatementAction(SQLEditor targetEditor) {
        this.setText(Messages.ExecuteSQLAsOneStatement_label);
        this.setToolTipText(Messages.ExecuteSQLAsOneStatement_tooltip);
        this.setActionDefinitionId("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteAsOneStatementAction");
        this.setId("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteAsOneStatementAction");
        this.setActiveEditor(targetEditor);
        targetEditor.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.update();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, HelpUtil.getContextId((String)"execute_selected_as_one_statement_action", (String)SQLEditorPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public void setActiveEditor(SQLEditor targetEditor) {
        this._sqlEditor = targetEditor;
    }

    @Override
    public void run() {
        super.run();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this._sqlEditor);
    }

    public void update() {
        this.setEnabled(this._isSourcePage && this._sqlEditor != null && this._sqlEditor.getSelectedText() != null);
    }

    @Override
    public String getSQLStatements() {
        if (this._sqlEditor == null) {
            return null;
        }
        String selectedText = SQLToolsFacade.getDBHelper((DatabaseIdentifier)this.getDatabaseIdentifier()).preprocessSQLScript(this._sqlEditor.getSelectedText());
        return selectedText;
    }

    @Override
    public Runnable getPostRun() {
        Runnable postRun = new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)ExecuteSQLAsOneStatementAction.this._sqlEditor);
            }
        };
        return postRun;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof ITextSelection) {
            this._selection = (ITextSelection)event.getSelection();
            this.update();
        }
    }

    @Override
    protected boolean promptVariable() {
        return true;
    }

    @Override
    protected HashMap getVariableDeclarations() {
        int start = 0;
        int length = 0;
        if (this._selection == null) {
            this._selection = (ITextSelection)this._sqlEditor.getSelectionProvider().getSelection();
        }
        if (this._selection != null && !this._selection.isEmpty()) {
            start = this._selection.getOffset();
            length = this._selection.getLength();
            if (length < 0) {
                length = -length;
                start -= length;
            }
        }
        int offset = length > 0 ? start + 1 : start;
        IDocument document = this._sqlEditor.getDocumentProvider().getDocument((Object)this._sqlEditor.getEditorInput());
        ParsingResult result = this._sqlEditor.getParsingResult();
        HashMap variables = null;
        if (result != null) {
            variables = result.getVariables(document, offset);
            HashMap sp_params = result.getParameters(document, offset);
            variables.putAll(sp_params);
        }
        return variables;
    }

    @Override
    protected SQLEditor getEditor() {
        return this._sqlEditor;
    }

    @Override
    public DatabaseIdentifier getDatabaseIdentifier() {
        if (this._sqlEditor != null) {
            String profileName = this._sqlEditor.getConnectionInfo().getConnectionProfileId();
            String dbName = this._sqlEditor.getConnectionInfo().getDatabaseName();
            return new DatabaseIdentifier(profileName, dbName);
        }
        return null;
    }

    @Override
    public void update(boolean isSQLEditorPage) {
        this._isSourcePage = isSQLEditorPage;
        this.update();
    }

    @Override
    protected boolean isSplitByDefault() {
        return false;
    }
}

