/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.actions;

import com.ibm.ims.datatools.help.HelpUtil;
import com.ibm.ims.datatools.sqltools.core.DatabaseIdentifier;
import com.ibm.ims.datatools.sqltools.core.SQLToolsFacade;
import com.ibm.ims.datatools.sqltools.sqleditor.IPageUpdate;
import com.ibm.ims.datatools.sqltools.sqleditor.SQLEditor;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.BaseExecuteAction;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.Messages;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.selection.ISQLSelection;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.selection.SQLSelectionFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ExecuteCurrentSQLAction
extends BaseExecuteAction
implements ISelectionChangedListener,
IPageUpdate {
    private SQLEditor _sqlEditor;
    private boolean _isSourcePage = true;

    public ExecuteCurrentSQLAction(SQLEditor targetEditor) {
        this.setText(Messages.ExecuteCurrentSQLAction_label);
        this.setToolTipText(Messages.ExecuteCurrentSQLAction_tooltip);
        this.setActionDefinitionId("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteCurrentAction");
        this.setId("com.ibm.ims.datatools.sqltools.sqleditor.ExecuteCurrentAction");
        this.setActiveEditor(targetEditor);
        targetEditor.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.update();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, HelpUtil.getContextId((String)"execute_current_sql_action", (String)SQLEditorPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public void setActiveEditor(SQLEditor targetEditor) {
        this._sqlEditor = targetEditor;
    }

    @Override
    public void run() {
        super.run();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this._sqlEditor);
    }

    @Override
    public DatabaseIdentifier getDatabaseIdentifier() {
        if (this._sqlEditor != null) {
            String profileName = this._sqlEditor.getConnectionInfo().getConnectionProfileId();
            String dbName = this._sqlEditor.getConnectionInfo().getDatabaseName();
            return new DatabaseIdentifier(profileName, dbName);
        }
        return null;
    }

    @Override
    public Runnable getPostRun() {
        Runnable postRun = new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)ExecuteCurrentSQLAction.this._sqlEditor);
            }
        };
        return postRun;
    }

    @Override
    public String getSQLStatements() {
        if (this._sqlEditor == null) {
            return null;
        }
        IDocument doc = this._sqlEditor.getDocumentProvider().getDocument((Object)this._sqlEditor.getEditorInput());
        if (doc == null) {
            return null;
        }
        return this.getCurrentStatements(doc);
    }

    private String getCurrentStatements(IDocument doc) {
        String selectedText = null;
        ISQLSelection selectionPolicy = SQLSelectionFactory.getInstance().getSQLSelection(this._sqlEditor);
        selectedText = selectionPolicy.getStatements();
        return SQLToolsFacade.getDBHelper((DatabaseIdentifier)this.getDatabaseIdentifier()).preprocessSQLScript(selectedText);
    }

    public void update() {
        this.setEnabled(this._isSourcePage && this._sqlEditor != null && this._sqlEditor.getSelectedText() == null);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof ITextSelection) {
            this.update();
        }
    }

    @Override
    public void update(boolean isSQLEditorPage) {
        this._isSourcePage = isSQLEditorPage;
        this.update();
    }

    @Override
    public SQLEditor getEditor() {
        return this._sqlEditor;
    }
}

