/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.actions;

import com.ibm.ims.datatools.sqltools.sql.parser.Token;
import com.ibm.ims.datatools.sqltools.sql.parser.ast.IASTDeclareComma;
import com.ibm.ims.datatools.sqltools.sql.parser.ast.IASTDeclareKeyword;
import com.ibm.ims.datatools.sqltools.sql.parser.ast.IASTSQLParam;
import com.ibm.ims.datatools.sqltools.sql.parser.ast.Node;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.Messages;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.SelectionDispatchAction;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;

public class DeleteAction
extends SelectionDispatchAction {
    public DeleteAction(IWorkbenchSite site) {
        super(site);
        this.setText(Messages.DeleteAction_label);
        this.setToolTipText(Messages.DeleteAction_tooltip);
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IAbstractTextEditorHelpContextIds.DELETE_ACTION);
        this.update(this.getSelection());
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(IStructuredSelection selection) {
        return selection.size() == 1;
    }

    private static void removeSQLParam(Node currentNode) {
        IDocument document = currentNode.getDocument();
        Node pnode = currentNode.getPreviousNode();
        Token nextToken = currentNode.getLastToken().next;
        int offset = 0;
        int length = 0;
        String text = "";
        if (nextToken.image.equals(",")) {
            offset = currentNode.getStartOffset();
            length = currentNode.getNextTokenOffset() - currentNode.getStartOffset();
        } else {
            offset = pnode instanceof IASTDeclareComma || pnode instanceof IASTDeclareKeyword ? pnode.getStartOffset() : currentNode.getStartOffset();
            length = nextToken.image.equals(";") ? currentNode.getNextTokenOffset() - offset : currentNode.getEndOffset() - offset;
        }
        try {
            document.replace(offset, length, text);
        }
        catch (BadLocationException e) {
            SQLEditorPlugin.getDefault().log(Messages.DeleteAction_0, e);
        }
    }

    public static void removeNode(Node node) {
        IDocument document = node.getDocument();
        try {
            if (node instanceof IASTSQLParam) {
                DeleteAction.removeSQLParam(node);
            } else if (node.getLastToken().next.image.equals(";")) {
                document.replace(node.getStartOffset(), node.getNextTokenOffset() - node.getStartOffset(), "");
            } else {
                document.replace(node.getStartOffset(), node.getEndOffset() - node.getStartOffset(), "");
            }
        }
        catch (BadLocationException e) {
            SQLEditorPlugin.getDefault().log(Messages.DeleteAction_0, e);
        }
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (selection.size() <= 0 || selection.size() > 1) {
            return;
        }
        List nodes = selection.toList();
        int i = 0;
        while (i < nodes.size()) {
            Object obj = nodes.get(i);
            if (obj instanceof Node) {
                Node node = (Node)obj;
                if (this.confirm() == 64) {
                    DeleteAction.removeNode(node);
                }
            }
            ++i;
        }
    }

    private int confirm() {
        MessageBox messageBox = new MessageBox(this.getShell(), 196);
        messageBox.setText(Messages.DeleteAction_confirm_title);
        messageBox.setMessage(Messages.DeleteAction_confirm_message);
        return messageBox.open();
    }
}

