/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal.actions;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.ims.datatools.sqltools.core.DatabaseIdentifier;
import com.ibm.ims.datatools.sqltools.core.SQLDevToolsConfiguration;
import com.ibm.ims.datatools.sqltools.core.SQLToolsFacade;
import com.ibm.ims.datatools.sqltools.core.services.SQLService;
import com.ibm.ims.datatools.sqltools.sqleditor.SQLEditor;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.actions.Messages;
import com.ibm.ims.datatools.sqltools.sqleditor.result.GroupSQLResultRunnable;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class BaseExecuteAction
extends Action
implements IUpdate {
    protected Job _job;

    public abstract DatabaseIdentifier getDatabaseIdentifier();

    public abstract String getSQLStatements();

    public abstract Runnable getPostRun();

    public void run() {
        String sql = this.getSQLStatements();
        DatabaseIdentifier databaseIdentifier = this.getDatabaseIdentifier();
        if (databaseIdentifier == null || sql == null) {
            return;
        }
        try {
            SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByProfileName((String)databaseIdentifier.getProfileName());
            String[] groups = new String[]{sql};
            SQLService sqlService = f.getSQLService();
            if (sqlService != null) {
                groups = sqlService.splitSQL(sql, this.isSplitByDefault());
            }
            this._job = new GroupSQLResultRunnable(this.getExecutionConnection(), groups, null, this.getPostRun(), databaseIdentifier, this.promptVariable(), this.getVariableDeclarations(), Messages.BaseExecuteAction_group_exec_title, "SQL Editor");
            this._job.setName(Messages.BaseExecuteAction_job_title);
            this._job.setUser(true);
            this._job.schedule();
            Runnable parallelRunnable = f.getExecutionService().createExecuteParallelRunnable(this.getSQLStatements(), databaseIdentifier);
            if (parallelRunnable != null) {
                new Thread(parallelRunnable).start();
            }
        }
        catch (Exception e) {
            this.processError(Messages.ExecuteSQLActionDelegate_error_execute, e, null);
        }
    }

    protected IConnection getExecutionConnection() {
        return null;
    }

    protected boolean promptVariable() {
        return false;
    }

    protected HashMap getVariableDeclarations() {
        return null;
    }

    protected void processError(final String msg, final Exception error, final IStatus status) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IStatus stat = status;
                if (stat == null) {
                    stat = new Status(4, "com.ibm.ims.datatools.sqltools.sqleditor", 0, error.getMessage() == null ? "" : error.getMessage(), (Throwable)error);
                }
                String title = Messages.common_error;
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)msg, (IStatus)stat);
            }
        });
        SQLEditorPlugin.getDefault().log(msg, error);
    }

    protected SQLEditor getEditor() {
        return null;
    }

    protected boolean isSplitByDefault() {
        return true;
    }
}

