/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.datatools.sqltools.sqleditor.internal;

import com.ibm.ims.datatools.sqltools.core.profile.ISQLToolsProfileListener;
import com.ibm.ims.datatools.sqltools.core.profile.SQLToolsProfileListenersManager;
import com.ibm.ims.datatools.sqltools.editor.core.connection.ISQLToolsConnectListener;
import com.ibm.ims.datatools.sqltools.editor.core.connection.SQLToolsConnectListenersManager;
import com.ibm.ims.datatools.sqltools.editor.template.GenericSQLContextType;
import com.ibm.ims.datatools.sqltools.editor.ui.core.SQLDevToolsUIConfiguration;
import com.ibm.ims.datatools.sqltools.editor.ui.core.SQLToolsUIFacade;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorContributorExtensionRegistry;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.profile.SQLEditorProfileListener;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.sql.SQLCodeScanner;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.sql.SQLPartitionScanner;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.templates.SQLContributionTemplateStore;
import com.ibm.ims.datatools.sqltools.sqleditor.internal.utils.SQLColorProvider;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SQLEditorPlugin
extends AbstractUIPlugin {
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private static final int INTERNAL_ERROR = 0;
    public static final String PLUGIN_ID = "com.ibm.ims.datatools.sqltools.sqleditor";
    private static SQLEditorPlugin fgInstance;
    private SQLPartitionScanner fPartitionScanner;
    private SQLColorProvider fColorProvider;
    private SQLCodeScanner fCodeScanner;
    private SQLContributionTemplateStore _store;
    private ContributionContextTypeRegistry _registry;
    private Properties _properties;
    private URL _pluginBase;
    private static final String PROPERTIES = "default.properties";
    private static final String CUSTOM_TEMPLATES_KEY = "com.sybase.stf.dmp.ui.sqleditor.template.customtemplates";
    private SQLEditorProfileListener _sqlEditorProfileListener = null;

    public SQLEditorPlugin() {
        fgInstance = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.init();
        this._sqlEditorProfileListener = new SQLEditorProfileListener();
        SQLToolsProfileListenersManager pManager = SQLToolsProfileListenersManager.getInstance();
        pManager.addProfileListener((ISQLToolsProfileListener)this._sqlEditorProfileListener);
        SQLToolsConnectListenersManager cManager = SQLToolsConnectListenersManager.getInstance();
        cManager.addConnectListener((ISQLToolsConnectListener)this._sqlEditorProfileListener);
    }

    public void stop(BundleContext context) throws Exception {
        SQLToolsProfileListenersManager pManager = SQLToolsProfileListenersManager.getInstance();
        pManager.removeProfileListener((ISQLToolsProfileListener)this._sqlEditorProfileListener);
        SQLToolsConnectListenersManager cManager = SQLToolsConnectListenersManager.getInstance();
        cManager.removeConnectListener((ISQLToolsConnectListener)this._sqlEditorProfileListener);
        super.stop(context);
    }

    public static SQLEditorPlugin getDefault() {
        return fgInstance;
    }

    public SQLPartitionScanner getSQLPartitionScanner() {
        if (this.fPartitionScanner == null) {
            this.fPartitionScanner = new SQLPartitionScanner();
        }
        return this.fPartitionScanner;
    }

    public RuleBasedScanner getSQLCodeScanner() {
        if (this.fCodeScanner == null) {
            this.fCodeScanner = new SQLCodeScanner(this.getSQLColorProvider());
        }
        return this.fCodeScanner;
    }

    public SQLColorProvider getSQLColorProvider() {
        if (this.fColorProvider == null) {
            this.fColorProvider = new SQLColorProvider();
        }
        return this.fColorProvider;
    }

    public void log(IStatus status) {
        int severity = status.getSeverity();
        switch (severity) {
            case 0: {
                logger.fine(status.getMessage());
                break;
            }
            case 4: {
                logger.error(status.getMessage(), status.getException(), new Object[0]);
                break;
            }
            case 2: {
                logger.warn(status.getMessage(), status.getException(), new Object[0]);
                break;
            }
            default: {
                logger.info(status.getMessage(), status.getException(), new Object[0]);
            }
        }
    }

    public void log(String message) {
        this.log(this.createErrorStatus(message));
    }

    public void log(String message, Throwable e) {
        this.log(this.createErrorStatus(message, e));
    }

    public void log(Throwable e) {
        this.log(this.createErrorStatus(e));
    }

    public IStatus createErrorStatus(String message) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, message, null);
    }

    public IStatus createErrorStatus(Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, SQLEditorResources.plugin_internal_error, e);
    }

    public IStatus createErrorStatus(String message, Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, message, e);
    }

    public SQLContributionTemplateStore getTemplateStore() {
        if (this._store == null) {
            this._store = new SQLContributionTemplateStore(this.getTemplateContextTypeRegistry(), SQLEditorPlugin.getDefault().getPreferenceStore(), CUSTOM_TEMPLATES_KEY);
            try {
                this._store.load();
            }
            catch (IOException e) {
                SQLEditorPlugin.getDefault().log((IStatus)new Status(4, "com.sybase.stf.dmp.debugger", 0, "", (Throwable)e));
            }
        }
        return this._store;
    }

    public ContextTypeRegistry getTemplateContextTypeRegistry() {
        if (this._registry == null) {
            this._registry = new ContributionContextTypeRegistry();
            this._registry.addContextType("com.ibm.ims.datatools.sqltools.editor.template.sql.generic");
            Collection c = SQLToolsUIFacade.getConfigurations();
            ArrayList<GenericSQLContextType> ctxTypes = new ArrayList<GenericSQLContextType>();
            for (SQLDevToolsUIConfiguration config : c) {
                ctxTypes.add(config.getSQLUIService().getSQLContextType());
            }
            Iterator i = ctxTypes.iterator();
            while (i.hasNext()) {
                this._registry.addContextType(((GenericSQLContextType)i.next()).getSQLContextId());
            }
        }
        return this._registry;
    }

    private void init() {
        block14: {
            this._properties = new Properties();
            InputStream input = null;
            this._pluginBase = this.getBundle().getEntry("/");
            try {
                try {
                    input = new URL(this._pluginBase, PROPERTIES).openStream();
                    if (input != null) {
                        this._properties.load(input);
                        break block14;
                    }
                    this.log("Input is null");
                }
                catch (IOException ee) {
                    this.log(ee);
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException ee2) {
                        this.log(ee2);
                    }
                }
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException ee) {
                    this.log(ee);
                }
            }
        }
    }

    public Properties getProperties() {
        return this._properties;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchPage workbenchPage = SQLEditorPlugin.getActiveWorkbenchWindow().getActivePage();
        if (workbenchPage != null) {
            return workbenchPage;
        }
        IWorkbenchPage[] workbenchPages = SQLEditorPlugin.getActiveWorkbenchWindow().getPages();
        if (workbenchPages.length > 0) {
            return workbenchPages[0];
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow window = SQLEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window;
        }
        IWorkbenchWindow[] windows = SQLEditorPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0];
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = SQLEditorPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        IWorkbenchWindow[] windows = SQLEditorPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0].getShell();
        }
        return null;
    }

    public static Display getDisplay() {
        Shell shell = SQLEditorPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        return Display.getDefault();
    }

    public static IEditorPart getActiveEditor() {
        return SQLEditorPlugin.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    }

    public static Collection getSQLEditorActionContributorExtension() {
        return SQLEditorContributorExtensionRegistry.getInstance().getActionExtensions();
    }
}

